/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client.batch;

import Freenet.Params;
import Freenet.client.ClientFactory;
import Freenet.client.FreenetURI;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import relentless.gj.client.InsertSlave;
import relentless.gj.client.InsertSlaveListener;
import relentless.gj.client.InsertStatusEvent;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.SlaveRestartedEvent;
import relentless.gj.client.batch.BatchBase;
import relentless.gj.client.batch.BatchInsertFailedEvent;
import relentless.gj.client.batch.BatchInsertRestartedEvent;
import relentless.gj.client.batch.BatchInsertStatusEvent;
import relentless.gj.client.batch.BatchInsertSucceededEvent;
import relentless.gj.client.batch.BatchInserterListener;
import relentless.gj.client.batch.InsertTask;
import relentless.gj.util.EventDispatcher;
import relentless.gj.util.EventFirer;

public class BatchInserter
extends BatchBase {
    public static final int STARTING = 1;
    public static final int CHK_INSERT = 2;
    public static final int INSERTING = 3;
    public static final int KEY_COLLISION = 4;
    public static final int REQUEUED = 5;
    private InsertSlaveListenerImpl slaveListener = new InsertSlaveListenerImpl();
    InsertSlave[] slaves = null;

    public BatchInserter(ClientFactory clientFactory, Params params, int n) {
        this.slaveCount = n;
        this.slaves = new InsertSlave[n];
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            this.slaves[n2] = new InsertSlave(clientFactory, params);
            this.slaves[n2].addInsertSlaveListener(this.slaveListener);
            this.availableSlaves.addElement(this.slaves[n2]);
            ++n2;
        }
        this.dispatcher = new EventDispatcher(new EventFirerImpl());
    }

    public void queue(InsertTask insertTask) {
        super.queue(insertTask);
    }

    public void abortAll() {
        throw new RuntimeException("Not implemented :-( ");
    }

    public synchronized void start() {
        super.start();
    }

    public synchronized void stop() {
        super.stop();
    }

    public synchronized void flush() {
        super.flush();
    }

    public synchronized boolean isRunning() {
        return super.isRunning();
    }

    public final void addBatchInserterListener(BatchInserterListener batchInserterListener) {
        this.dispatcher.addListener(batchInserterListener);
    }

    public final void removeBatchInserterListener(BatchInserterListener batchInserterListener) {
        this.dispatcher.removeListener(batchInserterListener);
    }

    public static synchronized void createTmpDir(String string) throws IOException {
        BatchBase.createTmpDir(string);
        SlaveBase.setTmpDir(BatchBase.tmpDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForTask(BatchInserter batchInserter, InsertTask insertTask, boolean bl) {
        if (!bl && !batchInserter.isRunning()) {
            throw new RuntimeException("The BatchInserter isn't running!");
        }
        if (bl) {
            if (batchInserter.isRunning()) {
                throw new RuntimeException("The BatchInserter is already running!");
            }
            batchInserter.flush();
            batchInserter.start();
        }
        DoneListener doneListener = new DoneListener(insertTask);
        batchInserter.addBatchInserterListener(doneListener);
        batchInserter.queue(insertTask);
        DoneListener doneListener2 = doneListener;
        synchronized (doneListener2) {
            while (doneListener.isWorking()) {
                try {
                    doneListener.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        batchInserter.removeBatchInserterListener(doneListener);
        if (!bl) return doneListener.getSucceeded();
        batchInserter.stop();
        BatchInserter batchInserter2 = batchInserter;
        synchronized (batchInserter2) {
            while (batchInserter.isRunning()) {
                try {
                    batchInserter.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return doneListener.getSucceeded();
        }
    }

    protected boolean startTask(Object object, BatchBase.TaskInfo taskInfo) {
        InsertSlave insertSlave = (InsertSlave)taskInfo.slave;
        InsertTask insertTask = (InsertTask)taskInfo.task;
        FileBucket fileBucket = null;
        FileBucket fileBucket2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (insertTask.getSourceDataType() == 3) {
                if (insertTask.getSourceMetaDataType() != 1) {
                    throw new IllegalArgumentException("getSourceMetaDataType() != TYPE_NONE for redirect!");
                }
                insertSlave.startRedirectInsert(insertTask.getURI(), insertTask.getSourceData(), insertTask.getHtl(), taskInfo);
            } else {
                switch (insertTask.getSourceDataType()) {
                    case 2: {
                        fileBucket = new FileBucket(new File(insertTask.getSourceData()));
                        break;
                    }
                    case 4: {
                        fileBucket = new FileBucket(InsertSlave.dumpToFile(insertTask.getSourceData(), null, false));
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (insertTask.getSourceMetaDataType() != 1) break;
                        throw new IllegalArgumentException("SourceData and SourceMetaData both of TYPE_NONE!");
                    }
                }
                switch (insertTask.getSourceMetaDataType()) {
                    case 2: {
                        fileBucket2 = new FileBucket(new File(insertTask.getSourceMetaData()));
                        break;
                    }
                    case 4: {
                        fileBucket2 = new FileBucket(InsertSlave.dumpToFile(insertTask.getSourceMetaData(), null, true));
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        if (insertTask.getSourceDataType() != 1) break;
                        throw new IllegalArgumentException("SourceData and SourceMetaData both of TYPE_NONE!");
                    }
                }
            }
            insertSlave.startInsert(insertTask.getURI(), insertTask.getHtl(), (Bucket)fileBucket, bl, (Bucket)fileBucket2, bl2, insertTask.getAutoRedirect(), taskInfo);
            this.dispatcher.fire(new BatchInsertStatusEvent(this, 1, insertTask));
        }
        catch (Exception exception) {
            System.err.println("BatchInserter.startTask -- FAILED: " + exception.toString());
            if (fileBucket != null && bl && fileBucket instanceof FileBucket) {
                fileBucket.getFile().delete();
            }
            if (fileBucket2 != null && bl2 && fileBucket2 instanceof FileBucket) {
                fileBucket2.getFile().delete();
            }
            this.dispatcher.fire(new BatchInsertStatusEvent(this, 1, insertTask));
            this.dispatcher.fire(new BatchInsertFailedEvent(this, insertTask, new Exception[0]));
            return false;
        }
        return true;
    }

    static class DoneListener
    implements BatchInserterListener {
        private boolean working = true;
        private boolean succeeded = false;
        private InsertTask targetTask = null;

        protected DoneListener(InsertTask insertTask) {
            this.targetTask = insertTask;
        }

        public synchronized void succeeded(BatchInsertSucceededEvent batchInsertSucceededEvent) {
            if (batchInsertSucceededEvent.getTask() != this.targetTask) {
                return;
            }
            this.working = false;
            this.succeeded = true;
            this.notify();
        }

        public synchronized void failed(BatchInsertFailedEvent batchInsertFailedEvent) {
            if (batchInsertFailedEvent.getTask() != this.targetTask) {
                return;
            }
            this.working = false;
            this.succeeded = false;
            this.notify();
        }

        public void insertStatus(BatchInsertStatusEvent batchInsertStatusEvent) {
        }

        public void restarted(BatchInsertRestartedEvent batchInsertRestartedEvent) {
        }

        public boolean isWorking() {
            return this.working;
        }

        public boolean getSucceeded() {
            return this.succeeded;
        }
    }

    class InsertSlaveListenerImpl
    implements InsertSlaveListener {
        InsertSlaveListenerImpl() {
        }

        public void insertStatus(InsertStatusEvent insertStatusEvent) {
            block28: {
                BatchBase.TaskInfo taskInfo = (BatchBase.TaskInfo)insertStatusEvent.getExtraData();
                InsertSlave insertSlave = (InsertSlave)taskInfo.slave;
                InsertTask insertTask = (InsertTask)taskInfo.task;
                if (insertStatusEvent.getInsertSlaveExitStatus() != 1) {
                    BatchInsertStatusEvent batchInsertStatusEvent;
                    EventObject eventObject;
                    block27: {
                        Vector vector;
                        eventObject = null;
                        batchInsertStatusEvent = null;
                        boolean bl = false;
                        try {
                            if (insertStatusEvent.getInsertSlaveExitStatus() == 3) {
                                if (insertSlave.getURIExisted()) {
                                    batchInsertStatusEvent = new BatchInsertStatusEvent(this, 4, insertTask);
                                }
                                BatchInserter batchInserter = BatchInserter.this;
                                synchronized (batchInserter) {
                                    if (BatchInserter.this.executor != null && taskInfo.retries++ < insertTask.getRetries() && !insertSlave.getURIExisted()) {
                                        eventObject = new BatchInsertStatusEvent(this, 5, insertTask);
                                        bl = true;
                                    } else {
                                        Exception[] exceptionArray = insertSlave.getExceptions();
                                        if (exceptionArray == null) {
                                            exceptionArray = new Exception[]{};
                                        }
                                        eventObject = new BatchInsertFailedEvent(this, insertTask, exceptionArray);
                                    }
                                }
                            } else {
                                String string = null;
                                String string2 = null;
                                FreenetURI freenetURI = insertSlave.getFullURI();
                                string = freenetURI.toString();
                                if (freenetURI.getKeyType().equals("CHK")) {
                                    string2 = freenetURI.toString();
                                } else if (insertSlave.getRedirectCHK() != null) {
                                    string2 = insertSlave.getRedirectCHK().toString();
                                } else {
                                    System.err.println("hmmm... can't get redirect CHK...");
                                }
                                eventObject = new BatchInsertSucceededEvent(this, insertTask, string, string2);
                            }
                            Object var12_14 = null;
                            taskInfo.slave = null;
                            BatchInserter.this.releaseSlave(insertSlave);
                            if (!bl) break block27;
                            vector = BatchInserter.this.taskQueue;
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            taskInfo.slave = null;
                            BatchInserter.this.releaseSlave(insertSlave);
                            if (bl) {
                                Vector vector2 = BatchInserter.this.taskQueue;
                                synchronized (vector2) {
                                    BatchInserter.this.taskQueue.addElement(taskInfo);
                                    BatchInserter.this.taskQueue.notifyAll();
                                }
                            }
                            BatchInserter.this.dispatcher.fire(batchInsertStatusEvent);
                            BatchInserter.this.dispatcher.fire(eventObject);
                            throw throwable;
                        }
                        synchronized (vector) {
                            BatchInserter.this.taskQueue.addElement(taskInfo);
                            BatchInserter.this.taskQueue.notifyAll();
                        }
                    }
                    BatchInserter.this.dispatcher.fire(batchInsertStatusEvent);
                    BatchInserter.this.dispatcher.fire(eventObject);
                    {
                        break block28;
                    }
                }
                if (insertStatusEvent.getInsertSlaveState() == 2) {
                    BatchInserter.this.dispatcher.fire(new BatchInsertStatusEvent(this, 2, insertTask));
                } else if (insertStatusEvent.getInsertSlaveState() == 3) {
                    BatchInserter.this.dispatcher.fire(new BatchInsertStatusEvent(this, 3, insertTask));
                } else if (insertStatusEvent.getInsertSlaveState() == 6) {
                    BatchInserter.this.dispatcher.fire(new BatchInsertStatusEvent(this, 4, insertTask));
                }
            }
        }

        public void restarted(SlaveRestartedEvent slaveRestartedEvent) {
            InsertTask insertTask = (InsertTask)((BatchBase.TaskInfo)slaveRestartedEvent.getExtraData()).task;
            BatchInserter.this.dispatcher.fire(new BatchInsertRestartedEvent(this, slaveRestartedEvent.getWaitTimeSecs(), insertTask));
        }
    }

    static class EventFirerImpl
    implements EventFirer {
        EventFirerImpl() {
        }

        public final boolean fireEvent(EventListener eventListener, EventObject eventObject) {
            if (eventObject instanceof BatchInsertStatusEvent) {
                ((BatchInserterListener)eventListener).insertStatus((BatchInsertStatusEvent)eventObject);
            } else if (eventObject instanceof BatchInsertRestartedEvent) {
                ((BatchInserterListener)eventListener).restarted((BatchInsertRestartedEvent)eventObject);
            } else if (eventObject instanceof BatchInsertSucceededEvent) {
                ((BatchInserterListener)eventListener).succeeded((BatchInsertSucceededEvent)eventObject);
            } else if (eventObject instanceof BatchInsertFailedEvent) {
                ((BatchInserterListener)eventListener).failed((BatchInsertFailedEvent)eventObject);
            } else {
                return false;
            }
            return true;
        }
    }
}

