/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client.batch;

import Freenet.Params;
import Freenet.client.ClientFactory;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import relentless.gj.client.RequestSlave;
import relentless.gj.client.RequestSlaveAdapter;
import relentless.gj.client.RequestStatusEvent;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.SlaveRestartedEvent;
import relentless.gj.client.batch.BatchBase;
import relentless.gj.client.batch.BatchRequestFailedEvent;
import relentless.gj.client.batch.BatchRequestRestartedEvent;
import relentless.gj.client.batch.BatchRequestStatusEvent;
import relentless.gj.client.batch.BatchRequestSucceededEvent;
import relentless.gj.client.batch.BatchRequesterListener;
import relentless.gj.client.batch.RequestTask;
import relentless.gj.util.EventDispatcher;
import relentless.gj.util.EventFirer;

public class BatchRequester
extends BatchBase {
    public static final int STARTING = 1;
    public static final int TRANSFERRING = 2;
    public static final int REDIRECTED = 3;
    public static final int REQUEUED = 5;
    public static final int MAXBYTESEXCEEDED = 6;
    private RequestSlaveListenerImpl slaveListener = new RequestSlaveListenerImpl();
    private static final int MAX_HTL = 100;

    public BatchRequester(ClientFactory clientFactory, Params params, int n) {
        this.slaveCount = n;
        RequestSlave[] requestSlaveArray = new RequestSlave[n];
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            requestSlaveArray[n2] = new RequestSlave(clientFactory, params);
            requestSlaveArray[n2].addRequestSlaveListener(this.slaveListener);
            this.availableSlaves.addElement(requestSlaveArray[n2]);
            ++n2;
        }
        this.dispatcher = new EventDispatcher(new EventFirerImpl());
    }

    public void queue(RequestTask requestTask) {
        BatchRequester.checkDestinationType(requestTask.getDataDestination());
        BatchRequester.checkDestinationType(requestTask.getMetaDataDestination());
        super.queue(requestTask);
    }

    public void abortAll() {
        throw new RuntimeException("Not implemented :-( ");
    }

    public synchronized void start() {
        super.start();
    }

    public synchronized void stop() {
        super.stop();
    }

    public synchronized void flush() {
        super.flush();
    }

    public synchronized boolean isRunning() {
        return super.isRunning();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForTask(BatchRequester batchRequester, RequestTask requestTask, boolean bl) {
        if (!bl && !batchRequester.isRunning()) {
            throw new RuntimeException("The BatchRequester isn't running!");
        }
        if (bl) {
            if (batchRequester.isRunning()) {
                throw new RuntimeException("The BatchRequester is already running!");
            }
            batchRequester.flush();
            batchRequester.start();
        }
        DoneListener doneListener = new DoneListener(requestTask);
        batchRequester.addBatchRequesterListener(doneListener);
        batchRequester.queue(requestTask);
        DoneListener doneListener2 = doneListener;
        synchronized (doneListener2) {
            while (doneListener.isWorking()) {
                try {
                    doneListener.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        batchRequester.removeBatchRequesterListener(doneListener);
        if (!bl) return doneListener.getSucceeded();
        batchRequester.stop();
        BatchRequester batchRequester2 = batchRequester;
        synchronized (batchRequester2) {
            while (batchRequester.isRunning()) {
                try {
                    batchRequester.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return doneListener.getSucceeded();
        }
    }

    public final void addBatchRequesterListener(BatchRequesterListener batchRequesterListener) {
        this.dispatcher.addListener(batchRequesterListener);
    }

    public final void removeBatchRequesterListener(BatchRequesterListener batchRequesterListener) {
        this.dispatcher.removeListener(batchRequesterListener);
    }

    public static synchronized void createTmpDir(String string) throws IOException {
        BatchBase.createTmpDir(string);
        SlaveBase.setTmpDir(BatchBase.tmpDir);
    }

    public static RequestTask makeTask(Object object, Object object2, String string, int n, int n2, int n3, boolean bl, boolean bl2, long l) {
        BatchRequester.checkDestinationType(object);
        BatchRequester.checkDestinationType(object2);
        return new RequestTaskImpl(object, object2, string, n, n2, n3, bl, bl2, l);
    }

    protected boolean startTask(Object object, BatchBase.TaskInfo taskInfo) {
        RequestTaskInfo requestTaskInfo = (RequestTaskInfo)taskInfo;
        RequestSlave requestSlave = (RequestSlave)taskInfo.slave;
        RequestTask requestTask = (RequestTask)taskInfo.task;
        try {
            String string;
            if (requestTask.getDataDestination() != null) {
                if (requestTask.getDataDestination() instanceof Bucket) {
                    requestTaskInfo.data = (Bucket)requestTask.getDataDestination();
                } else if (requestTask.getDataDestination() instanceof File) {
                    requestTaskInfo.data = new FileBucket((File)requestTask.getDataDestination());
                } else if (requestTask.getDataDestination() instanceof String) {
                    string = (String)requestTask.getDataDestination();
                    requestTaskInfo.data = new FileBucket(new File(string));
                } else {
                    throw new IllegalArgumentException("Illegal type: RequestInfo.getMetaDataDestination().");
                }
            }
            if (requestTask.getMetaDataDestination() != null) {
                if (requestTask.getMetaDataDestination() instanceof Bucket) {
                    requestTaskInfo.metaData = (Bucket)requestTask.getMetaDataDestination();
                } else if (requestTask.getMetaDataDestination() instanceof File) {
                    requestTaskInfo.metaData = new FileBucket((File)requestTask.getMetaDataDestination());
                } else if (requestTask.getMetaDataDestination() instanceof String) {
                    string = (String)requestTask.getMetaDataDestination();
                    requestTaskInfo.metaData = new FileBucket(new File(string));
                } else {
                    throw new IllegalArgumentException("Illegal type: RequestInfo.getMetaDataDestination().");
                }
            }
            requestSlave.setAutoRedirect(requestTask.getAutoRedirect());
            requestSlave.setAbortAfterFinalRedirect(requestTask.getAbortAfterFinalRedirect());
            requestSlave.startRequest(requestTask.getURI(), requestTaskInfo.htl, requestTaskInfo.data, requestTaskInfo.metaData, requestTaskInfo);
            this.dispatcher.fire(new BatchRequestStatusEvent(this, 1, 0, 0, 0, requestTaskInfo.htl, requestTask));
        }
        catch (Exception exception) {
            System.err.println("BatchRequester.startTask -- FAILED: " + exception.toString());
            this.cleanUpFileBucket(requestTaskInfo.data);
            this.cleanUpFileBucket(requestTaskInfo.metaData);
            this.dispatcher.fire(new BatchRequestStatusEvent(this, 1, 0, 0, 0, requestTaskInfo.htl, requestTask));
            this.dispatcher.fire(new BatchRequestFailedEvent(this, requestTask, new Exception[0], requestTaskInfo.htl));
            return false;
        }
        return true;
    }

    private void cleanUpFileBucket(Bucket bucket) {
        if (bucket == null) {
            return;
        }
        if (!(bucket instanceof FileBucket)) {
            return;
        }
        FileBucket fileBucket = (FileBucket)bucket;
        if (fileBucket.getFile().exists() && !fileBucket.getFile().delete()) {
            System.err.println("BatchRequester.cleanUpFileBucket -- Couldn't remove tmp file: " + fileBucket.getFile().getAbsolutePath());
        }
    }

    protected BatchBase.TaskInfo makeTaskInfo(Object object) {
        RequestTaskInfo requestTaskInfo = new RequestTaskInfo();
        requestTaskInfo.task = object;
        requestTaskInfo.htl = ((RequestTask)object).getHtl();
        return requestTaskInfo;
    }

    private static final void checkDestinationType(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            return;
        }
        if (object instanceof Bucket) {
            return;
        }
        if (object instanceof File) {
            return;
        }
        throw new IllegalArgumentException("Illegal type.");
    }

    static class DoneListener
    implements BatchRequesterListener {
        private boolean working = true;
        private boolean succeeded = false;
        private RequestTask targetTask = null;

        protected DoneListener(RequestTask requestTask) {
            this.targetTask = requestTask;
        }

        public synchronized void succeeded(BatchRequestSucceededEvent batchRequestSucceededEvent) {
            if (batchRequestSucceededEvent.getTask() != this.targetTask) {
                return;
            }
            this.working = false;
            this.succeeded = true;
            this.notify();
        }

        public synchronized void failed(BatchRequestFailedEvent batchRequestFailedEvent) {
            if (batchRequestFailedEvent.getTask() != this.targetTask) {
                return;
            }
            this.working = false;
            this.succeeded = false;
            this.notify();
        }

        public void requestStatus(BatchRequestStatusEvent batchRequestStatusEvent) {
        }

        public void restarted(BatchRequestRestartedEvent batchRequestRestartedEvent) {
        }

        public boolean isWorking() {
            return this.working;
        }

        public boolean getSucceeded() {
            return this.succeeded;
        }
    }

    static class RequestTaskImpl
    implements RequestTask {
        private Object dataDestination = null;
        private Object metaDataDestination = null;
        private String uri = null;
        private int htl = -1;
        private int retries = -1;
        private int retryHtlIncrement = -1;
        private boolean autoRedirect = true;
        private boolean abortAfterFinalRedirect = false;
        private long maxBytes = 0L;

        protected RequestTaskImpl(Object object, Object object2, String string, int n, int n2, int n3, boolean bl, boolean bl2, long l) {
            this.dataDestination = object;
            this.metaDataDestination = object2;
            this.uri = string;
            this.htl = n;
            this.retries = n2;
            this.retryHtlIncrement = n3;
            this.autoRedirect = bl;
            this.abortAfterFinalRedirect = bl2;
            this.maxBytes = l;
        }

        public final Object getDataDestination() {
            return this.dataDestination;
        }

        public final Object getMetaDataDestination() {
            return this.metaDataDestination;
        }

        public final String getURI() {
            return this.uri;
        }

        public final int getHtl() {
            return this.htl;
        }

        public final int getRetryHtlIncrement() {
            return this.retryHtlIncrement;
        }

        public final int getRetries() {
            return this.retries;
        }

        public final boolean getAutoRedirect() {
            return this.autoRedirect;
        }

        public final boolean getAbortAfterFinalRedirect() {
            return this.abortAfterFinalRedirect;
        }

        public final long getMaxBytes() {
            return this.maxBytes;
        }
    }

    protected static class RequestTaskInfo
    extends BatchBase.TaskInfo {
        protected Bucket data = null;
        protected Bucket metaData = null;
        protected int htl = -1;

        protected RequestTaskInfo() {
        }
    }

    class RequestSlaveListenerImpl
    extends RequestSlaveAdapter {
        RequestSlaveListenerImpl() {
        }

        public void requestStatus(RequestStatusEvent requestStatusEvent) {
            block23: {
                RequestTaskInfo requestTaskInfo = (RequestTaskInfo)requestStatusEvent.getExtraData();
                RequestSlave requestSlave = (RequestSlave)requestTaskInfo.slave;
                RequestTask requestTask = (RequestTask)requestTaskInfo.task;
                if (requestStatusEvent.getRequestSlaveExitStatus() != 1) {
                    EventObject eventObject;
                    block22: {
                        Vector vector;
                        BatchRequestStatusEvent batchRequestStatusEvent = null;
                        eventObject = null;
                        boolean bl = false;
                        try {
                            if (requestStatusEvent.getRequestSlaveExitStatus() == 3) {
                                BatchRequester batchRequester = BatchRequester.this;
                                synchronized (batchRequester) {
                                    if (BatchRequester.this.executor != null && !requestSlave.getMaxBytesExceeded() && requestTaskInfo.retries++ < requestTask.getRetries()) {
                                        requestTaskInfo.htl += requestTask.getRetryHtlIncrement();
                                        if (requestTaskInfo.htl > 100) {
                                            requestTaskInfo.htl = 100;
                                        }
                                        eventObject = new BatchRequestStatusEvent(this, 5, 0, 0, 0, requestTaskInfo.htl, requestTask);
                                        bl = true;
                                    } else {
                                        Exception[] exceptionArray = requestSlave.getExceptions();
                                        if (exceptionArray == null) {
                                            exceptionArray = new Exception[]{};
                                        }
                                        BatchRequester.this.cleanUpFileBucket(requestTaskInfo.data);
                                        BatchRequester.this.cleanUpFileBucket(requestTaskInfo.metaData);
                                        if (requestSlave.getMaxBytesExceeded()) {
                                            batchRequestStatusEvent = new BatchRequestStatusEvent(this, 6, 0, 0, 0, requestTaskInfo.htl, requestTask);
                                        }
                                        eventObject = new BatchRequestFailedEvent(this, requestTask, exceptionArray, requestTaskInfo.htl);
                                    }
                                }
                            } else {
                                eventObject = new BatchRequestSucceededEvent(this, requestTask, requestSlave.getRedirectCHK(), requestTaskInfo.htl);
                            }
                            Object var12_11 = null;
                            requestTaskInfo.slave = null;
                            BatchRequester.this.releaseSlave(requestSlave);
                            if (!bl) break block22;
                            vector = BatchRequester.this.taskQueue;
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            requestTaskInfo.slave = null;
                            BatchRequester.this.releaseSlave(requestSlave);
                            if (bl) {
                                Vector vector2 = BatchRequester.this.taskQueue;
                                synchronized (vector2) {
                                    BatchRequester.this.taskQueue.addElement(requestTaskInfo);
                                    BatchRequester.this.taskQueue.notifyAll();
                                }
                            }
                            BatchRequester.this.dispatcher.fire(eventObject);
                            throw throwable;
                        }
                        synchronized (vector) {
                            BatchRequester.this.taskQueue.addElement(requestTaskInfo);
                            BatchRequester.this.taskQueue.notifyAll();
                        }
                    }
                    BatchRequester.this.dispatcher.fire(eventObject);
                    {
                        break block23;
                    }
                }
                if (requestStatusEvent.getRequestSlaveState() == 13) {
                    BatchRequester.this.dispatcher.fire(new BatchRequestStatusEvent(this, 2, (int)requestStatusEvent.getBytesTotal(), (int)requestStatusEvent.getBytesTransferred(), requestStatusEvent.getBytesPerSecond(), requestTaskInfo.htl, requestTask));
                } else if (requestStatusEvent.getRequestSlaveState() == 18) {
                    BatchRequester.this.dispatcher.fire(new BatchRequestStatusEvent(this, 3, 0, 0, 0, requestTaskInfo.htl, requestTask));
                }
            }
        }

        public void restarted(SlaveRestartedEvent slaveRestartedEvent) {
            RequestTask requestTask = (RequestTask)((RequestTaskInfo)slaveRestartedEvent.getExtraData()).task;
            BatchRequester.this.dispatcher.fire(new BatchRequestRestartedEvent(this, slaveRestartedEvent.getWaitTimeSecs(), requestTask));
        }
    }

    static class EventFirerImpl
    implements EventFirer {
        EventFirerImpl() {
        }

        public final boolean fireEvent(EventListener eventListener, EventObject eventObject) {
            if (eventObject instanceof BatchRequestSucceededEvent) {
                ((BatchRequesterListener)eventListener).succeeded((BatchRequestSucceededEvent)eventObject);
            } else if (eventObject instanceof BatchRequestFailedEvent) {
                ((BatchRequesterListener)eventListener).failed((BatchRequestFailedEvent)eventObject);
            } else if (eventObject instanceof BatchRequestStatusEvent) {
                ((BatchRequesterListener)eventListener).requestStatus((BatchRequestStatusEvent)eventObject);
            } else if (eventObject instanceof BatchRequestRestartedEvent) {
                ((BatchRequesterListener)eventListener).restarted((BatchRequestRestartedEvent)eventObject);
            } else {
                return false;
            }
            return true;
        }
    }
}

