/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.util;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import relentless.gj.util.EventFirer;

public class EventDispatcher {
    protected EventFirer firerDelegate = null;
    protected Vector eventListeners = new Vector();

    public EventDispatcher() {
        this.firerDelegate = null;
    }

    public EventDispatcher(EventFirer eventFirer) {
        this.firerDelegate = eventFirer;
    }

    public void addListener(EventListener eventListener) {
        Vector vector = this.eventListeners;
        synchronized (vector) {
            if (!this.eventListeners.contains(eventListener)) {
                this.eventListeners.addElement(eventListener);
            }
        }
    }

    public void removeListener(EventListener eventListener) {
        Vector vector = this.eventListeners;
        synchronized (vector) {
            if (this.eventListeners.contains(eventListener)) {
                this.eventListeners.removeElement(eventListener);
            }
        }
    }

    public final void setFirer(EventFirer eventFirer) {
        this.firerDelegate = eventFirer;
    }

    public final EventFirer getFirer() {
        return this.firerDelegate;
    }

    public void fire(EventObject eventObject) {
        if (eventObject == null) {
            return;
        }
        Vector vector = null;
        Vector vector2 = this.eventListeners;
        synchronized (vector2) {
            vector = (Vector)this.eventListeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                if (this.firerDelegate.fireEvent((EventListener)enumeration.nextElement(), eventObject)) continue;
                System.err.println("EventDispatcher.fire -- UNKNOWN EVENT TYPE!, " + eventObject.toString());
            }
            catch (RuntimeException runtimeException) {
                System.err.println("EventDispatcher.fire -- EXCEPTION in client event handler:");
                System.err.println("EventDispatcher.fire -- " + runtimeException);
                runtimeException.printStackTrace();
            }
        }
    }
}

