/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.util;

import Freenet.client.FreenetURI;
import de.ueberdosis.mp3info.ExtendedID3Tag;
import de.ueberdosis.mp3info.ID3Reader;
import de.ueberdosis.mp3info.ID3Tag;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import relentless.gj.util.Sort;
import relentless.gj.util.TokenList;
import relentless.gj.util.TokenTree;
import relentless.gj.util.TokenTreeNodeTask;

public class Mp3FileUtils {
    public static final FilenameFilter FILTER_ANY_FILE = new FilenameFilter(){

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isFile() && file2.length() > 0L;
        }
    };
    public static final String EXTENSION_MP3 = ".mp3";
    private static final String ARTIST_UNKNOWN = "Artist Unknown";
    private static final String ALBUM_UNKNOWN = "Album Unknown";
    private static final String TITLE_UNKNOWN = "Title Unknown";
    private static final String SEPARATOR_DEFAULT = "-";

    public static final String makeMp3Name(ID3Tag iD3Tag, String string) {
        String string2 = iD3Tag.getArtist();
        String string3 = iD3Tag.getAlbum();
        String string4 = iD3Tag.getTitle();
        return Mp3FileUtils.makeMp3Name(string2, string3, string4, string);
    }

    public static final String makeMp3Name(String string, String string2, String string3, String string4) {
        String string5;
        String string6 = Mp3FileUtils.cleanName(string, "Artist_Unknown") + string4 + Mp3FileUtils.cleanName(string2, "Album_Unknown") + string4 + Mp3FileUtils.cleanName(string3, "Title_Unknown");
        if (string6.equals(string5 = "Artist_Unknown" + string4 + "Album_Unknown" + string4 + "Title_Unknown")) {
            return null;
        }
        return string6;
    }

    public static final void getMp3s(File file, FilenameFilter filenameFilter, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws InterruptedException {
        Object object;
        int n;
        String[] stringArray;
        if (filenameFilter == null) {
            filenameFilter = FILTER_ANY_FILE;
        }
        if ((stringArray = file.list(filenameFilter)) != null) {
            n = 0;
            while (n < stringArray.length) {
                block14: {
                    object = new File(file, stringArray[n]);
                    String string = null;
                    ExtendedID3Tag extendedID3Tag = null;
                    try {
                        Thread.sleep(0L);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        ID3Reader iD3Reader = new ID3Reader(((File)object).getAbsolutePath());
                        extendedID3Tag = iD3Reader.getExtendedID3Tag();
                        String string2 = extendedID3Tag.getArtist();
                        String string3 = extendedID3Tag.getAlbum();
                        String string4 = extendedID3Tag.getTitle();
                        string = Mp3FileUtils.makeMp3Name(string2, string3, string4, SEPARATOR_DEFAULT);
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception exception) {
                        System.err.println("IGNORED: " + ((File)object).getAbsolutePath());
                        if (vector3 != null) {
                            vector3.addElement(object);
                        }
                        break block14;
                    }
                    if (string != null) {
                        vector.addElement(extendedID3Tag);
                        vector2.addElement(object);
                    } else {
                        System.err.println("IGNORED BAD MP3 Name:" + ((File)object).getAbsolutePath());
                        if (vector4 != null) {
                            vector4.addElement(object);
                        }
                    }
                }
                ++n;
            }
        }
        if (bl) {
            object = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    System.err.println("examined: " + file2.getAbsolutePath());
                    return file2.isDirectory();
                }
            });
            if (object == null) {
                return;
            }
            n = 0;
            while (n < ((String[])object).length) {
                Mp3FileUtils.getMp3s(new File(file, object[n]), filenameFilter, true, vector, vector2, vector3, vector4);
                ++n;
            }
        }
    }

    public static final File makeMp3PlayList(String[] stringArray, int n, String string) throws IOException {
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(string);
            printWriter = new PrintWriter(new FileWriter(file));
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = new FreenetURI(stringArray[n2]).toURI();
                printWriter.println("http://localhost:" + n + "/" + string2);
                ++n2;
            }
            printWriter.close();
            printWriter = null;
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        return file;
    }

    public static final TokenTree makeID3TagTree(Vector vector, boolean bl) {
        TokenTree tokenTree = new TokenTree();
        int n = 0;
        while (n < vector.size()) {
            tokenTree.insert(new ID3Name((ID3Tag)vector.elementAt(n)));
            ++n;
        }
        if (bl) {
            tokenTree.traverse(new FieldSorter());
        }
        return tokenTree;
    }

    public static final File makeHTMLIndex(TokenTree tokenTree, String string, boolean bl, int n, String string2, Vector vector, Vector vector2) throws IOException {
        vector.removeAllElements();
        vector2.removeAllElements();
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(string2);
            printWriter = new PrintWriter(new FileWriter(file));
            if (string == null) {
                string = "Untitled mp3 Collection";
            }
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<title>");
            printWriter.println(string);
            printWriter.println("</title>");
            printWriter.println("</head>");
            printWriter.println("<body bgcolor=\"#ffffff\">");
            printWriter.println("<h1>");
            printWriter.println(string);
            printWriter.println("</h1>");
            printWriter.println("<ul>");
            int n2 = 0;
            while (n2 < tokenTree.getRoot().children.length) {
                TokenTree.TokenTreeNode tokenTreeNode = tokenTree.getRoot().children[n2];
                printWriter.println("   <li> " + Mp3FileUtils.htmlEscape((String)tokenTreeNode.token));
                printWriter.println("      <ul>");
                int n3 = 0;
                while (n3 < tokenTreeNode.children.length) {
                    TokenTree.TokenTreeNode tokenTreeNode2 = tokenTreeNode.children[n3];
                    printWriter.println("         <li> " + Mp3FileUtils.htmlEscape((String)tokenTreeNode2.token));
                    printWriter.println("             <ul>");
                    int n4 = 0;
                    while (n4 < tokenTreeNode2.children.length) {
                        TokenTree.TokenTreeNode tokenTreeNode3 = tokenTreeNode2.children[n4];
                        int n5 = 0;
                        while (n5 < tokenTreeNode3.leaves.length) {
                            ID3Tag iD3Tag = (ID3Tag)tokenTreeNode3.leaves[n5];
                            if (vector2.contains(iD3Tag)) {
                                throw new IllegalArgumentException("Duplicate ID3Tag values not allowed!");
                            }
                            String string3 = "";
                            if (n5 != 0) {
                                string3 = "_" + n5;
                            }
                            String string4 = Mp3FileUtils.makeMp3Name(iD3Tag, SEPARATOR_DEFAULT) + string3 + EXTENSION_MP3;
                            int n6 = n5;
                            while (vector.contains(string4)) {
                                string4 = Mp3FileUtils.makeMp3Name(iD3Tag, SEPARATOR_DEFAULT) + "_" + ++n6 + EXTENSION_MP3;
                            }
                            String string5 = "<a href=\"" + string4 + "\"> " + Mp3FileUtils.htmlEscape((String)tokenTreeNode3.token) + " </a><br>";
                            printWriter.println("               <li> " + string5);
                            vector.addElement(string4);
                            vector2.addElement(iD3Tag);
                            ++n5;
                        }
                        ++n4;
                    }
                    printWriter.println("             <p>");
                    printWriter.println("             </ul>");
                    ++n3;
                }
                printWriter.println("    </ul>");
                ++n2;
            }
            printWriter.println("</ul>");
            if (bl) {
                printWriter.println("<p>");
                printWriter.println("<hr>");
                printWriter.println("<a href=\"playlist.m3u\">m3u playlist</a>");
                printWriter.println("to play these files directly out of Freenet. <p>");
                printWriter.println("<em>Note: This list hard codes fproxy to " + n + ".</em>");
                printWriter.println("<hr>");
            }
            printWriter.println("</body>");
            printWriter.println("</html>");
            printWriter.close();
            printWriter = null;
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        return file;
    }

    public static final File makeHTMLIndex(String[] stringArray, String string, boolean bl, int n, String string2) throws IOException {
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(string2);
            printWriter = new PrintWriter(new FileWriter(file));
            if (string == null) {
                string = "Untitled mp3 Collection";
            }
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<title>");
            printWriter.println(string);
            printWriter.println("</title>");
            printWriter.println("</head>");
            printWriter.println("<body bgcolor=\"#ffffff\">");
            printWriter.println("<h1>");
            printWriter.println(string);
            printWriter.println("</h1>");
            int n2 = 0;
            while (n2 < stringArray.length) {
                printWriter.println("<a href = \"" + stringArray[n2] + "\">");
                printWriter.println(" " + stringArray[n2] + "</a><br>");
                ++n2;
            }
            if (bl) {
                printWriter.println("<p>");
                printWriter.println("<hr>");
                printWriter.println("<a href=\"playlist.m3u\">m3u playlist</a>");
                printWriter.println("to play these files directly out of Freenet. <p>");
                printWriter.println("<em>Note: This list hard codes fproxy to " + n + ".</em>");
                printWriter.println("<hr>");
            }
            printWriter.println("</body>");
            printWriter.println("</html>");
            printWriter.close();
            printWriter = null;
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        return file;
    }

    public static final String cleanName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if ((string = string.trim()).equals("")) {
            return string2;
        }
        String string3 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            string3 = Character.isLetter(c) || Character.isDigit(c) ? string3 + c : string3 + "_";
            ++n;
        }
        return string3;
    }

    private static final String htmlEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '<': {
                    stringBuffer.append(" &lt ");
                    break;
                }
                case '>': {
                    stringBuffer.append(" &gt ");
                    break;
                }
                case '&': {
                    stringBuffer.append(" & ");
                    break;
                }
                case '\"': {
                    stringBuffer.append(" \" ");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static class ID3Name
    implements TokenList {
        private ID3Tag tag = null;

        public ID3Name(ID3Tag iD3Tag) {
            this.tag = iD3Tag;
        }

        public int length() {
            return 3;
        }

        public Object getToken(int n) {
            switch (n) {
                case 0: {
                    String string = this.tag.getArtist();
                    if (string == null) {
                        return Mp3FileUtils.ARTIST_UNKNOWN;
                    }
                    if (string.trim().equals("")) {
                        return Mp3FileUtils.ARTIST_UNKNOWN;
                    }
                    return string;
                }
                case 1: {
                    String string = this.tag.getAlbum();
                    if (string == null) {
                        return Mp3FileUtils.ALBUM_UNKNOWN;
                    }
                    if (string.trim().equals("")) {
                        return Mp3FileUtils.ALBUM_UNKNOWN;
                    }
                    return string;
                }
                case 2: {
                    String string = this.tag.getTitle();
                    if (string == null) {
                        return Mp3FileUtils.TITLE_UNKNOWN;
                    }
                    if (string.trim().equals("")) {
                        return Mp3FileUtils.TITLE_UNKNOWN;
                    }
                    return string;
                }
            }
            throw new IllegalArgumentException("index == " + n);
        }

        public Object getModel() {
            return this.tag;
        }
    }

    static class FieldSorter
    implements TokenTreeNodeTask {
        private StringNodeComparator comp = new StringNodeComparator();

        FieldSorter() {
        }

        public boolean processNode(TokenTree.TokenTreeNode tokenTreeNode) {
            Sort.sort(tokenTreeNode.children, this.comp);
            return true;
        }
    }

    static class StringNodeComparator
    implements Sort.Comparator {
        StringNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            TokenTree.TokenTreeNode tokenTreeNode = (TokenTree.TokenTreeNode)object;
            TokenTree.TokenTreeNode tokenTreeNode2 = (TokenTree.TokenTreeNode)object2;
            return Sort.COMPARATOR_STRING.compare((String)tokenTreeNode.token, (String)tokenTreeNode2.token);
        }
    }
}

