/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.cli;

import Freenet.Params;
import Freenet.client.ClientUtil;
import Freenet.client.FreenetURI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.EventObject;
import java.util.Vector;
import relentless.gj.cli.CLIBase;
import relentless.gj.cli.ManifestFile;
import relentless.gj.cli.ManifestFileRecord;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.batch.BatchRequestFailedEvent;
import relentless.gj.client.batch.BatchRequestRestartedEvent;
import relentless.gj.client.batch.BatchRequestStatusEvent;
import relentless.gj.client.batch.BatchRequestSucceededEvent;
import relentless.gj.client.batch.BatchRequester;
import relentless.gj.client.batch.BatchRequesterListener;
import relentless.gj.client.batch.RequestTask;
import relentless.gj.util.Mp3FileUtils;

public class GetFiles
extends CLIBase {
    private String rootDir = null;
    private String[] chkList = null;
    private int[] htlList = null;
    private volatile int taskCount = 0;
    private BatchRequester requester = null;
    private RequestInfo[] requestList_ = null;
    private Vector runningTasks = new Vector();
    private final int MAX_STATUSLIST = 5;
    private static boolean overwrite = true;

    public GetFiles(Params params) throws IOException {
        super(params);
        int n = params.getint("simRequests", 1);
        if (n < 1) {
            n = 1;
        }
        this.requester = new BatchRequester(this.clientFactory, params, n);
        this.requester.addBatchRequesterListener(new BatchRequesterListenerImpl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ManifestFile fetchAll(String string, ManifestFile manifestFile, String[] stringArray, int[] nArray) throws MalformedURLException {
        if (this.requester.isRunning()) {
            throw new RuntimeException("Previous requests still being processed!");
        }
        ManifestFileRecord[] manifestFileRecordArray = manifestFile.getRecords();
        if (manifestFileRecordArray.length < 1) {
            return null;
        }
        this.chkList = stringArray;
        this.htlList = nArray;
        this.rootDir = string;
        this.queueRequests(manifestFile.getRecords());
        this.taskCount = this.requester.queued();
        this.requester.start();
        BatchRequester batchRequester = this.requester;
        synchronized (batchRequester) {
            while (this.taskCount > 0) {
                try {
                    this.requester.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.requester.stop();
            while (this.requester.isRunning()) {
                try {
                    this.requester.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.requester.flush();
            return this.getFailures(manifestFile);
        }
    }

    private void queueRequests(ManifestFileRecord[] manifestFileRecordArray) {
        this.requestList_ = new RequestInfo[manifestFileRecordArray.length];
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            File file;
            this.requestList_[n] = new RequestInfo(manifestFileRecordArray[n], this.htl, this.defaultRetries, this.retryHtlIncrement, n);
            if (!overwrite && (file = new File((String)this.requestList_[n].getDataDestination())).exists()) {
                this.requestList_[n].setSucceeded(true);
                System.err.println("SKIPPED EXISTING FILE:\n" + file.getAbsolutePath());
            } else {
                this.requester.queue(this.requestList_[n]);
            }
            ++n;
        }
    }

    private ManifestFile getFailures(ManifestFile manifestFile) {
        ManifestFileRecord[] manifestFileRecordArray = manifestFile.getRawRecords();
        Vector<ManifestFileRecord> vector = new Vector<ManifestFileRecord>();
        int n = 0;
        while (n < this.requestList_.length) {
            if (!this.requestList_[n].getSucceeded()) {
                vector.addElement(manifestFileRecordArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new ManifestFileRecord[vector.size()];
        vector.copyInto(objectArray);
        return manifestFile.copy((ManifestFileRecord[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ManifestFile getManifestFromURI(String string, boolean bl) throws MalformedURLException, IOException {
        ManifestFile manifestFile;
        File file;
        File file2;
        block15: {
            ManifestFile manifestFile2;
            block14: {
                ManifestFile manifestFile3;
                block13: {
                    ManifestFile manifestFile4;
                    block12: {
                        if (string == null) {
                            return null;
                        }
                        if (!(string = string.trim()).toLowerCase().startsWith("freenet:")) {
                            return null;
                        }
                        file2 = null;
                        file = null;
                        try {
                            file2 = SlaveBase.makeTempFile();
                            file = SlaveBase.makeTempFile();
                            RequestTask requestTask = BatchRequester.makeTask(file2, file, string, this.htl, this.defaultRetries, this.retryHtlIncrement, true, false, 0L);
                            if (!BatchRequester.waitForTask(this.requester, requestTask, true)) {
                                manifestFile4 = null;
                                Object var8_10 = null;
                                if (file2 != null) {
                                    file2.delete();
                                }
                                break block12;
                            }
                            if (file2.length() > 0L) {
                                manifestFile3 = ManifestFile.read(file2.getAbsolutePath());
                                break block13;
                            }
                            if (file.length() > 0L) {
                                manifestFile2 = ManifestFile.readFromMapFile(file.getAbsolutePath(), string, bl);
                                break block14;
                            }
                            manifestFile = null;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            if (file2 != null) {
                                file2.delete();
                            }
                            if (file == null) throw throwable;
                            file.delete();
                            throw throwable;
                        }
                    }
                    if (file == null) return manifestFile4;
                    file.delete();
                    return manifestFile4;
                }
                Object var8_11 = null;
                if (file2 != null) {
                    file2.delete();
                }
                if (file == null) return manifestFile3;
                file.delete();
                return manifestFile3;
            }
            Object var8_12 = null;
            if (file2 != null) {
                file2.delete();
            }
            if (file == null) return manifestFile2;
            file.delete();
            return manifestFile2;
        }
        Object var8_13 = null;
        if (file2 != null) {
            file2.delete();
        }
        if (file == null) return manifestFile;
        file.delete();
        return manifestFile;
    }

    private static ManifestFile loadManifest(GetFiles getFiles, String string, boolean bl, Params params) throws IOException {
        ManifestFile manifestFile = null;
        if (string.toLowerCase().startsWith("freenet:")) {
            System.out.println("------------------------------------------------------------");
            string = GetFiles.handleDBROffset(params, string);
            System.out.println("Reading manifest file from Freenet URI: " + string);
            manifestFile = getFiles.getManifestFromURI(string, bl);
            System.out.println("------------------------------------------------------------");
            if (manifestFile == null) {
                System.out.println("Couldn't read manifest file from Freenet URI: " + string);
                System.out.println("Sorry :-(.  Exiting...");
                System.exit(-1);
            }
        } else {
            manifestFile = ManifestFile.read(string);
        }
        if (manifestFile.getRawRecords().length < 1) {
            System.out.println("The manifest: " + string);
            System.out.println("Doesn't have any records! Exiting...");
            System.exit(-1);
        }
        return manifestFile;
    }

    private static final String handleDBROffset(Params params, String string) throws MalformedURLException {
        boolean bl = params.getlong("future", -1L) == 0L || params.getlong("past", -1L) == 0L;
        String string2 = params.getParam("baseline");
        long l = params.getlong("increment", 0L);
        long l2 = params.getlong("future", -params.getlong("past", 0L));
        boolean bl2 = params.getboolean("update", string2 != null || l != 0L || l2 != 0L || bl);
        if (!bl2) {
            return string;
        }
        if (string2 == null) {
            string2 = "20000101000000";
        }
        if (l == 0L) {
            l = 86400L;
        }
        FreenetURI freenetURI = ClientUtil.dateURI((FreenetURI)new FreenetURI(string), (String)string2, (long)l, (long)l2);
        return freenetURI.toString();
    }

    private void saveMSKToFile(ManifestFile manifestFile, String string) throws IOException {
        if (manifestFile.getMSKURI() != null) {
            String string2 = manifestFile.getMSKURI();
            if (string2.toLowerCase().startsWith("freenet:")) {
                if (string2.length() > 8) {
                    string2 = "MSK_FILE--" + string2.substring(8);
                }
                string2 = Mp3FileUtils.cleanName(string2, "");
                File file = new File(string, string2);
                RequestTask requestTask = BatchRequester.makeTask(null, file, manifestFile.getMSKURI(), this.htl, this.defaultRetries, this.retryHtlIncrement, true, false, 0L);
                System.out.println("Reading MSK from: " + manifestFile.getMSKURI());
                System.out.println("This could take a while, please be patient...");
                if (!BatchRequester.waitForTask(this.requester, requestTask, true)) {
                    System.out.println("Couldn't get the MSK: " + manifestFile.getMSKURI());
                    file.delete();
                } else {
                    System.out.println("Dumped MSK to: " + new File(string, string2).getAbsolutePath());
                }
            } else {
                System.out.println("Couldn't get the MSK, Bad URI: " + manifestFile.getMSKURI());
            }
        }
    }

    private static final String cleanUpURI(String string) {
        if (string.toLowerCase().startsWith("chk@") || string.toLowerCase().startsWith("ssk@") || string.toLowerCase().startsWith("ksk@") || string.toLowerCase().startsWith("msk@")) {
            string = "freenet:" + string;
        }
        if (string.toLowerCase().startsWith("freenet:msk@") && string.endsWith("//") && string.length() >= 15) {
            string = string.substring(12);
            string = "freenet:" + string.substring(0, string.length() - 2);
            System.err.println("");
            System.err.println("WARNING: Extracted map file URI from MSK file reference.");
            System.err.println("         I hope that's what you wanted me to do.");
            System.err.println("");
        }
        if (string.toLowerCase().startsWith("freenet:ksk@") && string.endsWith("//") && string.length() >= 15) {
            string = string.substring(12);
            string = "freenet:" + string.substring(0, string.length() - 2);
            System.err.println("");
            System.err.println("WARNING: Extracted map file URI from MSK file reference.");
            System.err.println("         I hope that's what you wanted me to do.");
            System.err.println("");
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static final String guessableKeyPrefix(String var0, int var1_1) throws MalformedURLException {
        block5: {
            if (!var0.toLowerCase().startsWith("freenet:") || (var3_3 = (var2_2 = new FreenetURI(var0)).getGuessableKey()) == null) break block5;
            var3_3 = var3_3.trim();
            var3_3 = var3_3.replace(File.separatorChar, '/');
            while (var3_3.length() > 0 && var3_3.charAt(0) == '/') {
                var3_3 = var3_3.substring(1);
                var3_3 = var3_3.trim();
            }
            while (var3_3.length() > 0 && var3_3.charAt(var3_3.length() - 1) == '/') {
                var3_3 = var3_3.substring(0, var3_3.length() - 1);
                var3_3 = var3_3.trim();
            }
            if (!var3_3.equals("")) ** GOTO lbl20
            return "";
lbl-1000:
            // 1 sources

            {
                var4_4 = var3_3.indexOf("/");
                if (var4_4 == -1 || var4_4 == var3_3.length() - 1) {
                    return "";
                }
                if ((var3_3 = var3_3.substring(var4_4 + 1).trim()).equals("")) {
                    return "";
                }
                --var1_1;
lbl20:
                // 2 sources

                ** while (var1_1 > 0)
            }
lbl21:
            // 1 sources

            return var3_3;
        }
        return "";
    }

    private static void printUsage() {
        System.out.println("GetFiles version: 0.17a");
        System.out.println("");
        System.out.println("usage:");
        System.out.println("java relentless.gj.cli.GetFiles manifest_file");
        System.out.println("");
        System.out.println("  -rootDir         The directory to copy the subdirectory ");
        System.out.println("                   hierarchy specified by the manifest file");
        System.out.println("                   into.  Default is the current directory.");
        System.out.println("");
        System.out.println("  -simRequests n   Maximum number of simultaneous requests.");
        System.out.println("                   Default is 1.");
        System.out.println("                  ");
        System.out.println("  -failedFile      A file to dump the manifest entries of");
        System.out.println("                   failed requests into.");
        System.out.println("");
        System.out.println("  -retries n       The number of times to retry failed ");
        System.out.println("                   requests. Default is 2.");
        System.out.println("");
        System.out.println("  -retryHtlIncrement n ");
        System.out.println("                   The amount to increase the HTL by");
        System.out.println("                   every time a request is retried. ");
        System.out.println("                   The default is 5.");
        System.out.println("  ");
        System.out.println("  -skipFields n    The number of leading fields to skip in the");
        System.out.println("                   guessable part of the map file URI when constructing");
        System.out.println("                   local file names for files downloaded from an MSK");
        System.out.println("                   map file. The default is 0.");
        System.out.println("");
        System.out.println("  -throughMSK yes/no  If yes, files downloaded from an map file URI are");
        System.out.println("                   referenced through the MSK. The default is no.");
        System.out.println("");
        System.out.println("  -overwrite yes/no  If no, downloads of existing files are skipped.");
        System.out.println("                  The default is yes.");
        System.out.println("");
        System.out.println("note: The \"standard\" options may also be used to set ");
        System.out.println("      Freenet parameters. e.g. -listenPort, -htl, -future, -past, ");
        System.out.println("      -update, -offset etc.");
        System.out.println("");
        System.out.println("note: If manifest_file starts with \"freenet:\" the manifest file");
        System.out.println("      will be read from the specified Freenet URI instead of from");
        System.out.println("      a local file. If manifest_file is the URI of an MSK map file");
        System.out.println("      every file listed in the map file is be downloaded.");
        System.out.println("");
        System.out.println("example:");
        System.out.println("java relentless.gj.cli.GetFiles -simRequests 5 -rootDir /tmp/ foo.txt");
        System.out.println("");
        System.out.println("See the README file for information on the manifest file format.");
        System.out.println("");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] var0) {
        try {
            block18: {
                var1_1 = CLIBase.getParams("mftools.ini", var0);
                if (var1_1.getNumArgs() >= 1) break block18;
                GetFiles.printUsage();
                var19_3 = null;
                ** GOTO lbl79
            }
            var2_11 = GetFiles.cleanUpURI(var1_1.getArg(0).trim());
            var3_12 = var1_1.getParam("rootDir", "");
            var4_13 = var1_1.getParam("failedFile", null);
            var5_14 = var1_1.getint("simRequests", 1);
            var6_15 = var1_1.getint("skipFields", 0);
            var7_16 = var1_1.getboolean("throughMSK", false);
            GetFiles.overwrite = var1_1.getboolean("overwrite", true);
            var8_17 = var1_1.getboolean("fetchMSK", false);
            var9_18 = new File(var3_12);
            if ((var3_12 = var9_18.getAbsolutePath()).charAt(var3_12.length() - 1) != File.separatorChar) {
                var3_12 = var3_12 + File.separatorChar;
            }
            System.out.println("Fetching files from manifest: " + var2_11);
            System.out.println("Writing to : " + var3_12);
            System.out.println("Simultaneous Requests : " + var5_14);
            var10_19 = new GetFiles(var1_1);
            var11_20 = GetFiles.loadManifest(var10_19, var2_11, var7_16, var1_1);
            var12_21 = GetFiles.guessableKeyPrefix(var2_11, var6_15);
            if (!var12_21.equals("")) {
                var3_12 = var3_12 + var12_21.replace('/', File.separatorChar) + File.separatorChar;
            }
            var13_22 = ManifestFile.parseVariables(var1_1, 1, null, false);
            var11_20.overrideVars(var13_22);
            ManifestFile.dumpManifest(var11_20.getRecords());
            var11_20.doParanoidPathChecks(var3_12);
            ManifestFile.createSubdirs(var3_12, var11_20.getRecords());
            CLIBase.createTmpDir(var3_12);
            if (var8_17) {
                var10_19.saveMSKToFile(var11_20, var3_12);
            }
            if ((var15_24 = var10_19.fetchAll(var3_12, var11_20, var14_23 = new String[var11_20.getRecords().length], null)) == null) {
                System.out.println("");
                System.out.println("All files were downloaded successfully.");
                System.out.println("");
                if (var11_20.getConcatinationFileName() != null) {
                    System.out.println("Concatinating segments to: " + var11_20.getConcatinationFileName());
                    ManifestFile.concatinateTo(var3_12, var11_20.getRecords(), var11_20.getConcatinationFileName(), true);
                    System.out.println("Done.");
                }
            } else {
                var16_25 = var15_24.getRecords();
                var17_26 = " these files";
                if (var16_25.length == 1) {
                    var17_26 = " this file:";
                }
                System.out.println("");
                System.out.println("Couldn't download" + var17_26);
                ManifestFile.dumpManifest(var16_25);
                System.out.println("");
                if (var4_13 != null) {
                    var15_24.write(var4_13);
                }
            }
            ** GOTO lbl86
        }
        catch (Exception var1_2) {
            System.err.println("GetFiles FAILED:");
            var1_2.printStackTrace();
            var19_5 = null;
            try {
                CLIBase.removeTmpDir();
                return;
            }
            catch (Exception var20_9) {
                System.err.println("GetFiles Exception during cleanup:");
                var20_9.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var18_27) {
                var19_6 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 588->594)] { 
lbl73:
                // 1 sources

                CLIBase.removeTmpDir();
                throw var18_27;
lbl75:
                // 1 sources

                catch (Exception var20_10) {
                    System.err.println("GetFiles Exception during cleanup:");
                    var20_10.printStackTrace();
                }
                throw var18_27;
            }
lbl79:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 588->594)] { 
lbl80:
            // 1 sources

            CLIBase.removeTmpDir();
            return;
lbl82:
            // 1 sources

            catch (Exception var20_7) {
                System.err.println("GetFiles Exception during cleanup:");
                var20_7.printStackTrace();
            }
            return;
lbl86:
            // 2 sources

            var19_4 = null;
            try {}
            catch (Exception var20_8) {}
            System.err.println("GetFiles Exception during cleanup:");
            var20_8.printStackTrace();
            return;
            CLIBase.removeTmpDir();
            return;
        }
    }

    private void writeExitMsg(EventObject eventObject) {
        if (eventObject instanceof BatchRequestSucceededEvent) {
            System.out.println("SUCCEEDED: " + GetFiles.getDisplayName(((BatchRequestSucceededEvent)eventObject).getTask()));
        } else {
            System.out.println("FAILED: " + GetFiles.getDisplayName(((BatchRequestFailedEvent)eventObject).getTask()));
            Exception[] exceptionArray = ((BatchRequestFailedEvent)eventObject).getExceptions();
            if (exceptionArray != null) {
                int n = 0;
                while (n < exceptionArray.length) {
                    System.out.println("   " + exceptionArray[n].toString());
                    System.out.println("----------------------------------------");
                    exceptionArray[n].printStackTrace();
                    System.out.println("----------------------------------------");
                    ++n;
                }
            }
        }
    }

    private String formatByteCount(long l) {
        String string = "";
        double d = 0.0;
        if (l >= 0x100000L) {
            d = (double)l / 1048576.0;
            string = "M";
        } else if (l >= 1024L) {
            d = (double)l / 1024.0;
            string = "K";
        } else {
            d = l;
            string = "bytes";
        }
        String string2 = Double.toString(d);
        int n = string2.indexOf(".");
        if (n != -1 && n < string2.length() - 2) {
            string2 = string2.substring(0, n + 2);
        }
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2 + string;
    }

    private void handleRequestInfoSuccess(BatchRequestSucceededEvent batchRequestSucceededEvent) {
        if (!(batchRequestSucceededEvent.getTask() instanceof RequestInfo)) {
            return;
        }
        RequestInfo requestInfo = (RequestInfo)batchRequestSucceededEvent.getTask();
        if (this.chkList != null) {
            try {
                this.chkList[requestInfo.getRecordIndex()] = null;
                String string = null;
                if (!ClientUtil.isMSK((String)requestInfo.getURI())) {
                    FreenetURI freenetURI = new FreenetURI(requestInfo.getURI());
                    if (freenetURI.getKeyType().equals("CHK")) {
                        string = freenetURI.toString();
                    } else if (batchRequestSucceededEvent.getRedirectCHK() != null) {
                        string = new FreenetURI(batchRequestSucceededEvent.getRedirectCHK()).toString();
                    }
                } else if (batchRequestSucceededEvent.getRedirectCHK() != null) {
                    string = new FreenetURI(batchRequestSucceededEvent.getRedirectCHK()).toString();
                }
                this.chkList[requestInfo.getRecordIndex()] = string;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ignored: " + malformedURLException);
            }
        }
        if (this.htlList != null) {
            this.htlList[requestInfo.getRecordIndex()] = batchRequestSucceededEvent.getHtl();
        }
        requestInfo.setSucceeded(true);
    }

    private String getStatusMsg() {
        String string = "";
        int n = 0;
        while (n < this.runningTasks.size()) {
            RequestTask requestTask = (RequestTask)this.runningTasks.elementAt(n);
            if (this.runningTasks.size() <= 5) {
                string = string + "STILL WORKING: " + GetFiles.getDisplayName(requestTask) + "\n";
            }
            ++n;
        }
        if (this.runningTasks.size() <= 5) {
            return "STATUS: " + this.runningTasks.size() + " working, " + this.requester.queued() + " queued.\n" + string;
        }
        return "STATUS: " + this.runningTasks.size() + " working, " + this.requester.queued() + " queued.";
    }

    private static final Object getDisplayName(RequestTask requestTask) {
        if (requestTask instanceof RequestInfo) {
            return ((RequestInfo)requestTask).getRecord().getFileName();
        }
        return "[MSK map file]";
    }

    class BatchRequesterListenerImpl
    implements BatchRequesterListener {
        BatchRequesterListenerImpl() {
        }

        public void succeeded(BatchRequestSucceededEvent batchRequestSucceededEvent) {
            GetFiles.this.handleRequestInfoSuccess(batchRequestSucceededEvent);
            GetFiles.this.writeExitMsg(batchRequestSucceededEvent);
            GetFiles.this.taskCount--;
            Vector vector = GetFiles.this.runningTasks;
            synchronized (vector) {
                if (GetFiles.this.runningTasks.contains(batchRequestSucceededEvent.getTask())) {
                    GetFiles.this.runningTasks.removeElement(batchRequestSucceededEvent.getTask());
                    System.out.println(GetFiles.this.getStatusMsg());
                }
            }
            BatchRequester batchRequester = GetFiles.this.requester;
            synchronized (batchRequester) {
                GetFiles.this.requester.notifyAll();
            }
        }

        public void failed(BatchRequestFailedEvent batchRequestFailedEvent) {
            GetFiles.this.writeExitMsg(batchRequestFailedEvent);
            GetFiles.this.taskCount--;
            Vector vector = GetFiles.this.runningTasks;
            synchronized (vector) {
                if (GetFiles.this.runningTasks.contains(batchRequestFailedEvent.getTask())) {
                    GetFiles.this.runningTasks.removeElement(batchRequestFailedEvent.getTask());
                }
                System.out.println(GetFiles.this.getStatusMsg());
            }
            BatchRequester batchRequester = GetFiles.this.requester;
            synchronized (batchRequester) {
                GetFiles.this.requester.notifyAll();
            }
        }

        public void requestStatus(BatchRequestStatusEvent batchRequestStatusEvent) {
            RequestTask requestTask = batchRequestStatusEvent.getTask();
            switch (batchRequestStatusEvent.getState()) {
                case 1: {
                    System.out.println("STARTING: " + requestTask.getURI() + " htl=" + batchRequestStatusEvent.getHtl() + '\n' + "          " + GetFiles.getDisplayName(requestTask));
                    GetFiles.this.runningTasks.addElement(requestTask);
                    break;
                }
                case 2: {
                    if (batchRequestStatusEvent.getBytesTotal() < 1L) {
                        System.out.println("TRANSFER STARTED:\n   " + GetFiles.getDisplayName(requestTask));
                        return;
                    }
                    long l = batchRequestStatusEvent.getBytesTransferred() * 100L / batchRequestStatusEvent.getBytesTotal();
                    String string = "";
                    if (batchRequestStatusEvent.getBytesTransferred() > 65536L) {
                        string = " at " + GetFiles.this.formatByteCount(batchRequestStatusEvent.getBytesPerSecond()) + "/sec";
                    }
                    System.out.println("TRANSFERRED: " + l + "% of " + GetFiles.this.formatByteCount(batchRequestStatusEvent.getBytesTotal()) + string + "\n   " + GetFiles.getDisplayName(requestTask));
                    break;
                }
                case 3: {
                    System.out.println("REDIRECTING : " + GetFiles.getDisplayName(requestTask));
                    break;
                }
                case 5: {
                    System.out.println("FAILED, REQUEUING : " + GetFiles.getDisplayName(requestTask) + " at htl=" + batchRequestStatusEvent.getHtl());
                    Vector vector = GetFiles.this.runningTasks;
                    synchronized (vector) {
                        if (GetFiles.this.runningTasks.contains(requestTask)) {
                            GetFiles.this.runningTasks.removeElement(requestTask);
                        }
                        System.out.println(GetFiles.this.getStatusMsg());
                        break;
                    }
                }
                default: {
                    System.err.println("GetFiles.BatchRequesterListenerImpl.requestStatus -- BAD STATE: " + batchRequestStatusEvent.getState());
                }
            }
        }

        public void restarted(BatchRequestRestartedEvent batchRequestRestartedEvent) {
            System.out.println("RESTARTED: Waiting up to " + batchRequestRestartedEvent.getWaitTimeSecs() + " seconds before timeout." + "\n   " + GetFiles.getDisplayName(batchRequestRestartedEvent.getTask()));
        }
    }

    class RequestInfo
    extends CLIBase.InfoBase
    implements RequestTask {
        private int retryHtlIncrement = -1;
        private int recordIndex = -1;

        RequestInfo(ManifestFileRecord manifestFileRecord, int n, int n2, int n3, int n4) {
            super(manifestFileRecord, n, n2);
            this.retryHtlIncrement = n3;
            this.recordIndex = n4;
        }

        public final Object getDataDestination() {
            File file = new File(GetFiles.this.rootDir, this.getRecord().getFileName());
            return file.getAbsolutePath();
        }

        public final Object getMetaDataDestination() {
            return null;
        }

        public final String getURI() {
            return this.getRecord().getFreenetURI();
        }

        public final int getRetryHtlIncrement() {
            return this.retryHtlIncrement;
        }

        public final boolean getAutoRedirect() {
            return true;
        }

        public final boolean getAbortAfterFinalRedirect() {
            return false;
        }

        public final long getMaxBytes() {
            return 0L;
        }

        public final void setRetryHtlIncrement(int n) {
            this.retryHtlIncrement = n;
        }

        public final int getRecordIndex() {
            return this.recordIndex;
        }
    }
}

