/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client;

import Freenet.Core;
import Freenet.Params;
import Freenet.client.ClientEventListener;
import Freenet.client.ClientFactory;
import Freenet.client.Request;
import Freenet.support.Bucket;
import Freenet.support.Fields;
import java.io.File;
import java.util.EventObject;
import java.util.Stack;
import relentless.gj.util.EventDispatcher;

public abstract class SlaveBase {
    public static final int WORKING = 1;
    public static final int SUCCEEDED = 2;
    public static final int FAILED = 3;
    ClientFactory clientFactory = null;
    Params params = null;
    ClientEventListener clientEventListener = null;
    Runnable task = null;
    Thread slaveThread = null;
    Stack exceptions = new Stack();
    int state = -1;
    Request requestToken = null;
    int htl = -1;
    Bucket data = null;
    Bucket metaData = null;
    boolean clientLibraryFinished = false;
    Object extraData = null;
    EventDispatcher dispatcher = null;
    static File tmpDir = null;

    public abstract int getExitStatus();

    public final synchronized void waitUntilDone() {
        while (this.getExitStatus() == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized Exception[] getExceptions() {
        if (this.exceptions.empty()) {
            return null;
        }
        Object[] objectArray = new Exception[this.exceptions.size()];
        this.exceptions.copyInto(objectArray);
        return objectArray;
    }

    public abstract void abort();

    public final int getHtl() {
        return this.htl;
    }

    public final Object getExtraData() {
        return this.extraData;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        eventDispatcher.setFirer(this.dispatcher.getFirer());
        this.dispatcher = eventDispatcher;
    }

    public static final void setTmpDir(File file) {
        tmpDir = file;
    }

    public static File makeTempFile() {
        if (tmpDir == null) {
            return new File("t" + Fields.longToString((long)Math.abs(Core.randSource.nextInt())));
        }
        return new File(tmpDir, "t" + Fields.longToString((long)Math.abs(Core.randSource.nextInt())));
    }

    SlaveBase(ClientFactory clientFactory, Params params) {
        this.clientFactory = clientFactory;
        this.params = params;
    }

    final EventObject setState(int n) {
        EventObject eventObject = null;
        SlaveBase slaveBase = this;
        synchronized (slaveBase) {
            this.state = n;
            eventObject = this.makeStatusEvent();
            this.notifyAll();
        }
        return eventObject;
    }

    final synchronized void waitForClientLibraryFinished() {
        while (!this.clientLibraryFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    final synchronized void signalClientLibraryFinished() {
        this.clientLibraryFinished = true;
        this.notifyAll();
    }

    abstract EventObject makeStatusEvent();

    protected final void fire(EventObject eventObject) {
        this.dispatcher.fire(eventObject);
    }
}

