/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.gui.share;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import relentless.gj.gui.share.Share;
import relentless.gj.gui.share.ShareConfiguration;

class ConfigurationDialog
extends JDialog {
    private static final String LABEL_CONFIGURATION = "Configuration";
    private static final String LABEL_PORT = "Local Node Port:";
    private static final String LABEL_HTL = "Htl:";
    private static final String LABEL_RETRIES = "Retries:";
    private static final String LABEL_SIMREQUESTS = "Concurrent Tasks:";
    private static final String LABEL_PRIVATEKEYFILE = "Private Key File";
    private static final String LABEL_KEYSERVER = "Key Server:";
    private static final String LABEL_KEYSERVERPREFIX = "Key Server Prefix:";
    private static final String LABEL_KEYSERVERPORT = "Key Server Port:";
    private static final String LABEL_CHOOSE = "Choose...";
    private static final String LABEL_GENERATE = "Generate...";
    private static final String LABEL_CANCEL = "Cancel";
    private static final String LABEL_DONE = "Done";
    private static final String LABEL_DEFAULTS = "Restore Defaults";
    private static final String LABEL_ILLEGAL_VALUE = "Illegal value";
    private static final String LABEL_SELECTKEYFILE = "Select Private Key File";
    private static final String LABEL_SELECT = "Select";
    private static final String LABEL_GENERATEKEY = "Generate";
    private static final String LABEL_GENERATEKEYFILE = "Generate Private Key File";
    private static final String MSG_PORT = "The port value must be greater than or equal to 0.";
    private static final String MSG_HTL = "The htl value must be between 1 and 100.";
    private static final String MSG_RETRIES = "Retries must be between 0 and 10.";
    private static final String MSG_SIMREQUESTS = "Concurrent tasks must be between 0 and 50.";
    private static final String MSG_KEYSERVERPORT = "The Key Server Port must be greater than or equal to 0.";
    private static final String MSG_KEY = "Can't read the private key file!";
    private static final String FILE_KEYFILE = "defaultkey.txt";
    private static final String MSG_OVERWRITEFILE = "Do you want to overwrite it?";
    private static final String LABEL_OVERWRITEFILE = "File already exists";
    private static final String MSG_GENERATEFAILED = "Couldn't generate Key file:\n\n";
    private static final String LABEL_GENERATEFAILED = "Key generation failed";
    private ShareConfiguration configuration = null;
    private JTextField txfPort = null;
    private JTextField txfHtl = null;
    private JTextField txfRetries = null;
    private JTextField txfKeyFile = null;
    private JTextField txfSimRequests = null;
    private JTextField txfKeyServer = null;
    private JTextField txfKeyServerPrefix = null;
    private JTextField txfKeyServerPort = null;
    private JFileChooser fchChooser = null;
    private JFrame parent = null;
    private String tmpDir = "";

    public ConfigurationDialog(JFrame jFrame, JFileChooser jFileChooser) {
        super(jFrame, LABEL_CONFIGURATION, true);
        this.parent = jFrame;
        this.fchChooser = jFileChooser;
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.txfPort = new JTextField(10);
        this.txfHtl = new JTextField(10);
        this.txfRetries = new JTextField(10);
        this.txfSimRequests = new JTextField(10);
        this.txfKeyServer = new JTextField(20);
        this.txfKeyServerPrefix = new JTextField(20);
        this.txfKeyServerPort = new JTextField(20);
        this.txfKeyFile = new JTextField(30);
        this.txfKeyFile.setAlignmentX(0.0f);
        JButton jButton = new JButton(LABEL_CHOOSE);
        JButton jButton2 = new JButton(LABEL_GENERATE);
        JButton jButton3 = new JButton(LABEL_CANCEL);
        JButton jButton4 = new JButton(LABEL_DONE);
        JButton jButton5 = new JButton(LABEL_DEFAULTS);
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_PORT), this.txfPort));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_HTL), this.txfHtl));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_RETRIES), this.txfRetries));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_SIMREQUESTS), this.txfSimRequests));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_KEYSERVER), this.txfKeyServer));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_KEYSERVERPREFIX), this.txfKeyServerPrefix));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(ConfigurationDialog.makeHorizontalPair(new JLabel(LABEL_KEYSERVERPORT), this.txfKeyServerPort));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LABEL_PRIVATEKEYFILE);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, border);
        jPanel2.setBorder(compoundBorder);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(jButton2);
        jPanel2.add(this.txfKeyFile);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(jButton4);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jButton5);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jButton3);
        jPanel.add(jPanel4);
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(jButton4);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.setConfiguration(new ShareConfiguration());
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.onCancel();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.onDone();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.onChoose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.onGenerate();
            }
        });
    }

    ShareConfiguration waitUntilDone(ShareConfiguration shareConfiguration) {
        this.configuration = null;
        this.setConfiguration(shareConfiguration);
        ((Component)this).setVisible(true);
        return this.configuration;
    }

    private final void onCancel() {
        ((Component)this).setVisible(false);
    }

    private final void onDone() {
        try {
            this.configuration = this.readConfiguration();
        }
        catch (RuntimeException runtimeException) {
            JOptionPane.showMessageDialog(this, runtimeException.getMessage(), LABEL_ILLEGAL_VALUE, 2);
            return;
        }
        ((Component)this).setVisible(false);
    }

    private final void onChoose() {
        this.fchChooser.setFileSelectionMode(0);
        this.fchChooser.setDialogTitle(LABEL_SELECTKEYFILE);
        int n = this.fchChooser.showDialog(this, LABEL_SELECT);
        if (n == 0 && this.fchChooser.getSelectedFile() != null) {
            this.txfKeyFile.setText(this.fchChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private final void onGenerate() {
        this.fchChooser.setFileSelectionMode(0);
        this.fchChooser.setDialogTitle(LABEL_GENERATEKEYFILE);
        this.fchChooser.setSelectedFile(new File(System.getProperty("user.home"), FILE_KEYFILE));
        int n = this.fchChooser.showDialog(this, LABEL_GENERATEKEY);
        if (n == 0 && this.fchChooser.getSelectedFile() != null) {
            int n2;
            if (this.fchChooser.getSelectedFile().exists() && (n2 = JOptionPane.showConfirmDialog(this.parent, MSG_OVERWRITEFILE, LABEL_OVERWRITEFILE, 2)) != 0) {
                return;
            }
            if (Share.generateKeyFile(this.fchChooser.getSelectedFile())) {
                this.txfKeyFile.setText(this.fchChooser.getSelectedFile().getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, MSG_GENERATEFAILED + this.fchChooser.getSelectedFile().getAbsolutePath(), LABEL_GENERATEFAILED, 2);
            }
        }
    }

    private ShareConfiguration readConfiguration() {
        ShareConfiguration shareConfiguration = new ShareConfiguration();
        File file = new File(this.txfKeyFile.getText());
        if (!(file.exists() && file.canRead() && file.isFile())) {
            throw new RuntimeException(MSG_KEY);
        }
        shareConfiguration.keyFile = this.txfKeyFile.getText();
        shareConfiguration.port = ConfigurationDialog.readIntValue(this.txfPort.getText(), MSG_PORT, 0, Integer.MAX_VALUE);
        shareConfiguration.htl = ConfigurationDialog.readIntValue(this.txfHtl.getText(), MSG_HTL, 1, 100);
        shareConfiguration.retries = ConfigurationDialog.readIntValue(this.txfRetries.getText(), MSG_RETRIES, 0, 10);
        shareConfiguration.nTasks = ConfigurationDialog.readIntValue(this.txfSimRequests.getText(), MSG_SIMREQUESTS, 0, 50);
        shareConfiguration.keyServer = this.txfKeyServer.getText();
        shareConfiguration.keyServerPrefix = this.txfKeyServerPrefix.getText();
        shareConfiguration.keyServerPort = ConfigurationDialog.readIntValue(this.txfKeyServerPort.getText(), MSG_KEYSERVERPORT, 0, Integer.MAX_VALUE);
        shareConfiguration.tmpDir = this.tmpDir;
        return shareConfiguration;
    }

    private void setConfiguration(ShareConfiguration shareConfiguration) {
        this.txfPort.setText(Integer.toString(shareConfiguration.port));
        this.txfHtl.setText(Integer.toString(shareConfiguration.htl));
        this.txfRetries.setText(Integer.toString(shareConfiguration.retries));
        this.txfSimRequests.setText(Integer.toString(shareConfiguration.nTasks));
        this.txfKeyFile.setText(shareConfiguration.keyFile);
        this.txfKeyServer.setText(shareConfiguration.keyServer);
        this.txfKeyServerPrefix.setText(shareConfiguration.keyServerPrefix);
        this.txfKeyServerPort.setText(Integer.toString(shareConfiguration.keyServerPort));
        this.tmpDir = shareConfiguration.tmpDir;
    }

    static final JPanel makeHorizontalPair(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jComponent.setMaximumSize(jComponent.getPreferredSize());
        jComponent2.setMaximumSize(jComponent2.getPreferredSize());
        jPanel.add(jComponent);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jComponent2);
        return jPanel;
    }

    static int readIntValue(String string, String string2, int n, int n2) {
        try {
            int n3 = Integer.parseInt(string);
            if (n3 > n2 || n3 < n) {
                throw new RuntimeException(string2);
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string2);
        }
    }
}

