/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.gui.share;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;

class KeyIndexWriter
extends Thread {
    public static final int WORKING = 1;
    public static final int SUCCEEDED = 2;
    public static final int FAILED = 3;
    private Socket socket = null;
    private String server = null;
    private int portNo = -1;
    private String prefix = null;
    private String key = null;
    private int exitStatus = 1;
    private boolean run = true;
    private static final String SUCCESS_STRING = "Key added";

    public KeyIndexWriter(String string, int n, String string2, String string3) {
        super("KeyIndexWriter -- http://" + string + ':' + n + '/' + string2 + string3);
        this.server = string;
        this.portNo = n;
        this.prefix = string2;
        this.key = string3;
    }

    public final synchronized int getExitStatus() {
        return this.exitStatus;
    }

    public final synchronized void abort() {
        this.run = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                System.err.println("KeyIndexWriter.abort -- ignored Excepion: " + iOException.toString());
            }
            this.socket = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        KeyIndexWriter keyIndexWriter;
        try {
            try {
                Socket socket = new Socket(this.server, this.portNo);
                KeyIndexWriter keyIndexWriter2 = this;
                synchronized (keyIndexWriter2) {
                    if (!this.run) {
                        try {
                            socket.close();
                            throw new InterruptedException();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new InterruptedException();
                    }
                    this.socket = socket;
                }
                OutputStream outputStream = this.socket.getOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "latin1");
                InputStream inputStream = this.socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "latin1"));
                outputStreamWriter.write("GET " + this.prefix + this.key + " HTTP/1.0\r\n\n");
                ((Writer)outputStreamWriter).flush();
                String string = "";
                String string2 = bufferedReader.readLine();
                while (true) {
                    if (string2 == null) {
                        System.err.println("response:");
                        System.err.println(string);
                        this.exitStatus = string.indexOf(SUCCESS_STRING) != -1 ? 2 : 3;
                    }
                    string = string + string2;
                    string2 = bufferedReader.readLine();
                }
                KeyIndexWriter keyIndexWriter3 = this;
                synchronized (keyIndexWriter3) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                this.exitStatus = 3;
                System.err.println("KeyIndexWriter.run -- FAILED on Exception: " + exception.toString());
                Object var12_13 = null;
                KeyIndexWriter keyIndexWriter4 = this;
                synchronized (keyIndexWriter4) {
                    this.abort();
                    this.notifyAll();
                    return;
                }
            }
            Object var12_12 = null;
            keyIndexWriter = this;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            KeyIndexWriter keyIndexWriter5 = this;
            synchronized (keyIndexWriter5) {
                this.abort();
                this.notifyAll();
                throw throwable;
            }
        }
        synchronized (keyIndexWriter) {
            this.abort();
            this.notifyAll();
            return;
        }
    }

    public static final void main(String[] stringArray) {
        KeyIndexWriter keyIndexWriter = new KeyIndexWriter(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3]);
        System.out.println(keyIndexWriter.getName());
        System.out.println("Starting...");
        KeyIndexWriter keyIndexWriter2 = keyIndexWriter;
        synchronized (keyIndexWriter2) {
            keyIndexWriter.start();
            while (keyIndexWriter.getExitStatus() == 1) {
                try {
                    keyIndexWriter.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        switch (keyIndexWriter.getExitStatus()) {
            case 1: {
                System.out.println("Working !!!");
                break;
            }
            case 2: {
                System.out.println("Succeeded.");
                break;
            }
            case 3: {
                System.out.println("Failed.");
            }
        }
    }
}

