/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.util;

import relentless.gj.util.TokenList;
import relentless.gj.util.TokenTreeNodeTask;

public class TokenTree {
    private TokenTreeNode rootNode = new TokenTreeNode();

    public TokenTree() {
        this.rootNode.depth = -1;
        this.rootNode.token = "[root]";
    }

    public void insert(TokenList tokenList) {
        TokenTreeNode tokenTreeNode = this.lookup(tokenList);
        if (tokenTreeNode.depth == tokenList.length() - 1 && TokenTree.hasLeaf(tokenTreeNode, tokenList.getModel())) {
            return;
        }
        if (tokenTreeNode.depth == tokenList.length() - 1) {
            tokenTreeNode.leaves = TokenTree.addToLeafList(tokenTreeNode.leaves, tokenList.getModel());
            return;
        }
        tokenTreeNode.children = TokenTree.addToNodeList(tokenTreeNode.children, TokenTree.createNode(tokenList, tokenTreeNode.depth + 1));
    }

    public TokenTreeNode lookup(TokenList tokenList) {
        Object[] objectArray = new Object[tokenList.length()];
        int n = 0;
        while (n < tokenList.length()) {
            objectArray[n] = tokenList.getToken(n);
            ++n;
        }
        return this.lookup(objectArray);
    }

    public TokenTreeNode lookup(Object[] objectArray) {
        TokenTreeNode tokenTreeNode = this.rootNode;
        block0: for (int i = 0; i < objectArray.length; ++i) {
            int n = 0;
            while (n < tokenTreeNode.children.length) {
                TokenTreeNode tokenTreeNode2 = tokenTreeNode.children[n];
                if (objectArray[i].equals(tokenTreeNode2.token)) {
                    tokenTreeNode = tokenTreeNode2;
                    continue block0;
                }
                ++n;
            }
            break block0;
        }
        return tokenTreeNode;
    }

    public void traverse(TokenTreeNodeTask tokenTreeNodeTask) {
        this.traverse(tokenTreeNodeTask, this.rootNode);
    }

    public void traverse(TokenTreeNodeTask tokenTreeNodeTask, TokenTreeNode tokenTreeNode) {
        if (tokenTreeNodeTask.processNode(tokenTreeNode)) {
            int n = 0;
            while (n < tokenTreeNode.children.length) {
                this.traverse(tokenTreeNodeTask, tokenTreeNode.children[n]);
                ++n;
            }
        }
    }

    public final TokenTreeNode getRoot() {
        return this.rootNode;
    }

    private static final TokenTreeNode createNode(TokenList tokenList, int n) {
        System.err.println("TokenTree.createNode -- offset: " + n + " token: " + tokenList.getToken(n));
        System.err.println("TokenTree.createNode -- list.length: " + tokenList.length());
        TokenTreeNode tokenTreeNode = new TokenTreeNode();
        tokenTreeNode.token = tokenList.getToken(n);
        tokenTreeNode.depth = n;
        if (n == tokenList.length() - 1) {
            tokenTreeNode.leaves = TokenTree.addToLeafList(tokenTreeNode.leaves, tokenList.getModel());
        } else {
            tokenTreeNode.children = TokenTree.addToNodeList(tokenTreeNode.children, TokenTree.createNode(tokenList, n + 1));
        }
        return tokenTreeNode;
    }

    private static final boolean hasLeaf(TokenTreeNode tokenTreeNode, Object object) {
        int n = 0;
        while (n < tokenTreeNode.leaves.length) {
            if (tokenTreeNode.leaves[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final TokenTreeNode[] addToNodeList(TokenTreeNode[] tokenTreeNodeArray, TokenTreeNode tokenTreeNode) {
        TokenTreeNode[] tokenTreeNodeArray2 = new TokenTreeNode[tokenTreeNodeArray.length + 1];
        System.arraycopy(tokenTreeNodeArray, 0, tokenTreeNodeArray2, 0, tokenTreeNodeArray.length);
        tokenTreeNodeArray2[tokenTreeNodeArray.length] = tokenTreeNode;
        return tokenTreeNodeArray2;
    }

    private static final Object[] addToLeafList(Object[] objectArray, Object object) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public static class TokenTreeNode {
        public int depth;
        public Object token;
        public TokenTreeNode[] children = new TokenTreeNode[0];
        public Object[] leaves = new Object[0];
    }
}

