#!/usr/bin/env python

# Version 0.0.3

"""

snarf /snarf/ vt.

 1. To grab, esp. to grab a large document or file for the purpose of using it with
 or without the author's permission. See also BLT. 2. [in the Unix community] To fetch
 a file or set of files across a network. See also blast. This term was mainstream in the
 late 1960s, meaning `to eat piggishly'. It may still have this connotation in context. "He's
 in the snarfing phase of hacking -- FTPing megs of stuff a day." 3. To acquire, with little
 concern for legal forms or politesse (but not quite by stealing). "They were giving away samples,
 so I snarfed a bunch of them." 4. Syn. for slurp. "This program starts by snarfing the entire
 database into core, then...." 5. [GEnie] To spray food or programming fluids due to laughing at
 the wrong moment. "I was drinking coffee, and when I read your post I snarfed all over my desk."
 "If I keep reading this topic, I think I'll have to snarf-proof my computer with a keyboard condom."
 [This sense appears to be widespread among mundane teenagers --ESR]

 Note: In "Palm Sunday", Kurt Vonnegut wrote that back in the 1940s, a snarf was a person
       who sniffed women's bicycle saddles.

"""


# Python, wxPython stuff:
from wxPython.wx import *
from wxPython.lib.filebrowsebutton import FileBrowseButton
from wxPython.html import *


import os, os.path, string, shutil, time, sys, urllib, UserDict, regex, posix



# expat is on python.org, but doesn't come with all installations, make a check and warning for it:
# Not included on Mandrake 7.0

py2 = sys.version[0] == '2'

try:
    if py2:
        from xml.parsers import expat
        parsermodule = expat
    else:
        from xml.parsers import pyexpat
        parsermodule = pyexpat
    haveXML = true
except ImportError:
    haveXML = false


if not haveXML:
    print "This demo requires the XML package.  \n" \
          "See http://www.python.org/sigs/xml-sig/ \n " \
          "You can still use the demo, just don't try to create a music catalog"


# Snarfzilla stuff:
import config, jaxml, Help
from ID3Tag import *
from mp3 import mp3info

# Allow gif, jpg, bmp, png handling for wxHtml

wxInitAllImageHandlers()

# Change this to the location of your web browser if you'd like to use Fairtunes:
# (Note: We'll soon have fairtunes integrated, no need for an external browser)

browserloc = "/opt/netscape/netscape"

# The .freenetrc parser is borken. Here's your backup:

if os.path.exists("../.freenetrcbak"):
    pass
else:
    shutil.copyfile("../.freenetrc", "../.freenetrcbak")

#Kludge for browser cache:
os.system("echo '' > ./htdocs/cache/last.url")

class FreenetRunning:
    def status(self, listenPort):
        port = string.atoi(listenPort)
        #out = os.popen("netstat -n -l -p 2> /dev/null|grep java | grep %s " % listenPort).read()
        open = 0
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.bind(("127.0.0.1", port))
            s.listen(1)
            s.close()
        except:
            open = 1
        if open == 0:
            pass
        else:
            return 1


class FproxyRunning:
    def status(self, fproxyPort):
        #out = os.popen("netstat -n -l -p  2> /dev/null|grep java | grep %s" % fproxyPort).read()
        port = string.atoi(fproxyPort)
        open = 0
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.bind(("127.0.0.1", port))
            s.listen(1)
            s.close()
        except:
            open = 1
        if open == 0:
            pass
        else:
            return 1


RC = ' _global_'
DefaultOpt = ' _values_'
Comments = ' _comments_'

class RcFile(UserDict.UserDict):

    _section = regex.compile('^\[\(.+\)\]')
    _option        = regex.compile('^\([^ \t]+\)[ \t]*=[ \t]*\(.*\)$')
    def __init__(self, fn):
        self.filename = fn
        self.data = {}

        # Parse the .freenetrc file
        try:
            f = open(fn)
            lines = filter(None, f.readlines())
            f.close()
        except:
            lines = []

        sect = RC
        self.data[sect] = {}
        opt = None

        for line in lines:

            line = string.rstrip(line)
            if line == '':
                opt = None
                continue

            if self._section.match(line) >= 0:
                sect = self._section.group(1)
                if not self.data.has_key(sect):
                    self.data[sect] = {}
                opt = None
                continue

            if self._option.match(line) >= 0:
                opt, val = self._option.group(1, 2)
                self.data[sect][opt] = val
                continue

            if opt and line[0] == '\t':
                self.data[sect][opt] = '%s %s' \
                    % (self.data[sect][opt], string.lstrip(line))
                continue

            if not self.data[sect].has_key(DefaultOpt):
                self.data[sect][DefaultOpt] = []
            self.data[sect][DefaultOpt].append(line)
            opt = None

        if not self.data[RC]:
            del self.data[RC]

    def write(self):

        """ Write the data back to the file """
        f = open(self.filename, "w")
        sections = self.data.keys()
        sections.sort()
        for section in sections:
            if section is not RC:
                f.write('\n[%s]\n' % section)
            data = self.data[section]
            names = data.keys()
            names.sort()
            for name in names:
                value = data[name]
                if name in (Comments, DefaultOpt):
                    #f.write('%s\n' % string.join(value, '\n'))
                    pass
                else:
                    f.write('%s = %s\n' % (name, value))
        f.close()

class optionFrame(wxFrame):
    def __init__(self, parent, id, title):
        wxFrame.__init__(self,parent, -1, title,wxDefaultPosition, wxSize(450,360))
        panel = wxPanel(self, -1,style=wxTAB_TRAVERSAL)
        buttonok = wxButton(panel, 1002, "Ok")
        buttonok.SetPosition(wxPoint(105, 270))

        button = wxButton(panel, 1003, "Cancel")
        button.SetPosition(wxPoint(255, 270))

        EVT_BUTTON(self, 1002, self.OnOK)
        EVT_BUTTON(self, 1003, self.OnCloseMe)
        EVT_CLOSE(self, self.OnCloseWindow)

        """ Here's the .freenetrc params we'll work on for now:

         transient=yes
         listenPort=19114
         diskCache=500000000
         dataStoreSize=1000
         informRead=yes
         informWrite=yes
         bandwidthLimit=50000
         services.fproxy.port=8081

         Note: The parser blows. Fix so it doesn't remove comments.

        """

        row = 20
        col = 150
        width = 90

        wxStaticText(panel, -1, "transient (yes/no)", wxPoint(25, row), wxSize(125, 20))
        self.transient = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row), wxSize(width, 20))
        self.transient.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Yes if dial-up", wxPoint(col + 105, row), wxSize(175, 20))

        wxStaticText(panel, -1, "listenPort", wxPoint(25, row + 30), wxSize(125, 20))
        self.listenPort = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 30), wxSize(width, 20))
        self.listenPort.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Default 19114", wxPoint(col + 105, row + 30), wxSize(175, 20))

        wxStaticText(panel, -1, "fproxyPort", wxPoint(25, row + 60), wxSize(125, 20))
        self.fproxyPort = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 60), wxSize(width, 20))
        self.fproxyPort.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Default 8081", wxPoint(col + 105, row + 60), wxSize(175, 20))

        wxStaticText(panel, -1, "diskCache", wxPoint(25, row + 90), wxSize(125, 20))
        self.diskCache = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 90), wxSize(width, 20))
        self.diskCache.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Disk space max in bytes", wxPoint(col + 105, row + 90), wxSize(175, 20))

        wxStaticText(panel, -1, "dataStoreSize", wxPoint(25, row + 120), wxSize(125, 20))
        self.dataStoreSize = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 120), wxSize(width, 20))
        self.dataStoreSize.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Max # of files to store", wxPoint(col + 105, row + 120), wxSize(175, 20))

        wxStaticText(panel, -1, "informRead (yes/no)", wxPoint(25, row + 150), wxSize(125, 20))
        self.informRead = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 150), wxSize(width, 20))
        self.informRead.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Yes if dial-up", wxPoint(col + 105, row + 150), wxSize(175, 20))

        wxStaticText(panel, -1, "informWrite (yes/no)", wxPoint(25, row + 180), wxSize(125, 20))
        self.informWrite = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 180), wxSize(width, 20))
        self.informWrite.SetInsertionPoint(0)
        wxStaticText(panel, -1, "No if dial-up", wxPoint(col + 105, row + 180), wxSize(175, 20))

        wxStaticText(panel, -1, "bandwidthLimit", wxPoint(25, row + 210), wxSize(125, 20))
        self.bandwidthLimit = wxTextCtrl(panel, wxNewId(), "", wxPoint(col, row + 210), wxSize(width, 20))
        self.bandwidthLimit.SetInsertionPoint(0)
        wxStaticText(panel, -1, "Speed limit bytes per second", wxPoint(col + 105, row + 210), wxSize(175, 20))

        i = RcFile("../.freenetrc")
        self.transient.SetValue(i.data[RC]['transient'])
        self.listenPort.SetValue(i.data[RC]['listenPort'])
        self.fproxyPort.SetValue(i.data[RC]['services.fproxy.port'])
        self.diskCache.SetValue(i.data[RC]['diskCache'])
        self.dataStoreSize.SetValue(i.data[RC]['dataStoreSize'])
        self.informRead.SetValue(i.data[RC]['informRead'])
        self.informWrite.SetValue(i.data[RC]['informWrite'])
        self.bandwidthLimit.SetValue(i.data[RC]['bandwidthLimit'])

    def OnOK(self, event):
        i = RcFile("../.freenetrc")
        i.data[RC]['transient'] = self.transient.GetValue()
        i.data[RC]['listenPort']= self.listenPort.GetValue()
        i.data[RC]['services.fproxy.port'] = self.fproxyPort.GetValue()
        i.data[RC]['diskCache'] = self.diskCache.GetValue()
        i.data[RC]['dataStoreSize'] = self.dataStoreSize.GetValue()
        i.data[RC]['informRead'] = self.informRead.GetValue()
        i.data[RC]['informWrite'] = self.informWrite.GetValue()
        i.data[RC]['bandwidthLimit'] = self.bandwidthLimit.GetValue()
        i.write()
        #parent.SetStatusText("Transient: %s" % self.transient.GetValue(), 3)
        self.Close(true)

    def OnCloseMe(self, event):
        self.Close(true)

    def OnCloseWindow(self, event):
        self.Destroy()


class MyFrame(wxFrame):
    def __init__(self, parent, id, title):
        wxFrame.__init__(self, parent, -1, title,size=wxSize(700,600))
        self.SetAutoLayout(true)

#--------------------------------------------------------------------------------
# Create main wxNotebook that all the panels reside in
#--------------------------------------------------------------------------------
        self.nb = wxNotebook(self, -1)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 0)
        lc.left.SameAs(self, wxLeft, 0)
        lc.bottom.SameAs(self, wxBottom, 0)
        lc.right.SameAs(self, wxRight, 0)
        self.nb.SetConstraints(lc)
        self.sb = self.CreateStatusBar(1, wxST_SIZEGRIP)
        self.sb.SetFieldsCount(3)
        self.sb.SetStatusText("Welcome to Snarfzilla.", 1)


        self.panlog=panellog(self.nb)
        self.pankeyring=panelkeyring(self.nb)
        self.pandownload=paneldownload(self.nb, self.panlog, self.pankeyring)
        self.panupload=panelupload(self.nb, self.panlog, self.pankeyring)
        self.pancreate=panelcreate(self.nb)
        self.pankeybrowser=panelkeybrowser(self.nb, self.pandownload)
        self.panbrowser=panelbrowser(self.nb)

#--------------------------------------------------------------------------------
# Setup notebook tabs
#--------------------------------------------------------------------------------

        self.nb.AddPage(self.panbrowser, "Freenet Browser")
        self.nb.AddPage(self.pandownload, "Freenet Download")
        self.nb.AddPage(self.panupload, "Freenet Upload")
        self.nb.AddPage(self.pankeybrowser, "Browse Keys")
        self.nb.AddPage(self.pancreate, "Create Catalog")
        self.nb.AddPage(self.pankeyring, "Keyring")
        self.nb.AddPage(self.panlog, "Log")

#--------------------------------------------------------------------------------
# Menu bar
#--------------------------------------------------------------------------------

        menu_file = wxMenu()
        mnustartID=NewId()
        mnustopID=NewId()
        mnuexitID=NewId()
        menu_file.Append(mnustartID, "Start Freenet")
        menu_file.Append(mnustopID,"Stop Freenet")
        menu_file.AppendSeparator()
        menu_file.Append(mnuexitID, "E&xit")
        menubar = wxMenuBar()
        menubar.Append(menu_file, "&File")

        menu_options = wxMenu()
        mnuprefID = NewId()
        menu_options.Append(mnuprefID, "Preferences")
        menubar.Append(menu_options, "&Options")

        menu_help = wxMenu()
        mnuhelpID=NewId()
        mnuaboutID=NewId()
        menu_help.Append(mnuhelpID,"Help")
        menu_help.Append(mnuaboutID,"About")
        menubar.Append(menu_help,"&Help")
        self.SetMenuBar(menubar)
        EVT_MENU(self, mnustartID, self.OnMnuStart)
        EVT_MENU(self, mnustopID, self.OnMnuStop)
        EVT_MENU(self, mnuexitID, self.OnMnuExit)
        EVT_MENU(self, mnuprefID, self.OnMnuPref)
        EVT_MENU(self, mnuaboutID, self.OnMnuAbout)
        EVT_MENU(self, mnuhelpID, self.OnMnuHelp)

        #--------------------------------------------------------------------------------
        # Keyboard accelerators
        #--------------------------------------------------------------------------------

        aTable = wxAcceleratorTable([(wxACCEL_ALT,  ord('X'), mnuexitID)])
        self.SetAcceleratorTable(aTable)

    def OnMnuStart(self,event):
        #sys.path.append('../')
        #os.system("java -cp '../freenet.jar' Freenet.node.Node &")
        os.system("./start.sh")
        self.SetStatusText("Freenet is running", 1)

    def OnMnuStop(self,event):
        self.SetStatusText("Shutting down Freenet...", 1)
        os.system("../freenet_server_stop")
        self.SetStatusText("Freenet Server stopped.", 1)


    def OnMnuHelp(self, event):
        Help.showHelp(self, Help.BoaHelpFrame, 'index.html') #./snarfzilla.0.0.3/Docs/index.html


    def OnMnuExit(self,event):
        self.Close()

    def OnMnuPref(self, event):
        a = optionFrame(None, -1, "Preferences")
        a.Show(true)

    def OnMnuAbout(self,event):
        dlg = wxMessageDialog(self, 'Snarfzilla is a Python and wxPython Freenet application\n written by Rob Cakebread released under the GPL license.\n\n',
                              'About Snarfzilla', wxOK | wxICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def OnCloseWindow(self, event):
        self.Destroy()

    def OnSize(self, event):
        w,h = self.GetClientSizeTuple()

class panellog(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)
        self.log= wxListCtrl(self, -1, size=wxDefaultSize,style=wxLC_REPORT)
        self.log.InsertColumn(0,"Log Info")
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 10)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 50)
        lc.right.SameAs(self, wxRight, 10)
        self.log.SetConstraints(lc)

        butID=NewId()
        but=wxButton(self,butID,"Clear")
        EVT_BUTTON(self,butID,self.OnClear)
        lc = wxLayoutConstraints()
        lc.bottom.SameAs(self, wxBottom, 15)
        lc.left.SameAs(self, wxLeft, 15)
        lc.height.AsIs()
        lc.width.AsIs()
        but.SetConstraints(lc);

    def add(self,txt):
        pos=self.log.GetItemCount()
        self.log.InsertStringItem(pos,txt)
        self.log.SetColumnWidth(0, wxLIST_AUTOSIZE)
        self.log.EnsureVisible(pos)
    def OnClear(self,event):
        self.log.ClearAll()
    def DeleteAllItems(self):
        self.log.DeleteAllItems()


class panelkeybrowser(wxPanel):
    def __init__(self, parent, list):
        wxPanel.__init__(self, parent, -1)
        self.list = list
        self.parent=parent
        self.process = None
        # Make the controls

        #----------------------------------------------------------------------------------
        # "list" wxListCtrl log window (Box 2)
        #----------------------------------------------------------------------------------
        klistID = wxNewId()
        self.klist= wxListCtrl(self, klistID, size=wxDefaultSize,style=wxLC_REPORT|wxSUNKEN_BORDER)
        self.klist.InsertColumn(0,"Key")
        self.klist.InsertColumn(1,"Index Server")
        self.klist.SetColumnWidth(0, 580)
        self.klist.SetColumnWidth(1, 90)

        box2 = wxBoxSizer(wxHORIZONTAL)
        box2.Add(self.klist, 1, wxEXPAND|wxALL,0)
        #Events:

        # for wxMSW
        EVT_COMMAND_RIGHT_CLICK(self.klist, klistID, self.OnRightClick)

        # for wxGTK
        #EVT_RIGHT_UP(self.klist, self.OnRightClick)
        #        EVT_RIGHT_DOWN(self.klist, self.OnRightDown)
        EVT_LIST_ITEM_SELECTED(self, klistID, self.OnItemSelected)
        EVT_LIST_ITEM_ACTIVATED(self, klistID, self.OnDoubleClick) # Double-click or Enter pressed
        #Put everything into a sizer

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(box2, 1, wxEXPAND|wxALL, 0)
        self.SetSizer(sizer)
        self.SetAutoLayout(true)
        file = open('./keyserverdb/mp3keys.txt', 'r')
        pos = 0
        l = file.readline()
        self.klist.InsertStringItem(pos, l)
        self.klist.SetStringItem(pos, 1, "Thalassocracy")
        pos = pos + 1
        while l:
            l = file.readline()
            self.klist.InsertStringItem(pos, l)
            self.klist.SetStringItem(pos, 1, "Thalassocracy")
            pos = pos + 1

    def OnItemSelected(self, event):
        self.currentItem = event.m_itemIndex
        #print self.currentItem

    def OnRightClick(self, event):
        n = self.klist.GetItemText(self.currentItem)
        #print n

    def OnDoubleClick(self, event):
        n = self.klist.GetItemText(self.currentItem)
        n = n[:-1]
        self.list.add(n) # Send it to the download tab to be queued!

class paneldownload(wxPanel):
    def __init__(self, parent, log, keylist):
        wxPanel.__init__(self, parent, -1)
        self.log=log
        self.keylist=keylist
        self.parent=parent
        self.process = None
        self.keylist.add("KSK")
        #EVT_IDLE(self, self.OnIdle)
        EVT_END_PROCESS(self, -1, self.OnProcessEnded)

        # Make the controls

        #----------------------------------------------------------------------------------
        # Options at top (Box 1)
        #----------------------------------------------------------------------------------

        box1 = wxBoxSizer(wxHORIZONTAL)
        detailid = wxNewId()
        smartnid = wxNewId()
        self.detail = wxCheckBox(self, detailid, "Verbose", style=wxNO_BORDER)
        self.smartnames = wxCheckBox(self, smartnid, "Smart Filenames", style=wxNO_BORDER)
        box1.Add(self.detail, 1, wxALIGN_LEFT, 0)
        box1.Add(self.smartnames, 1, wxALIGN_LEFT, 0)
        self.smartnames.SetValue(true)
        self.detail.SetValue(true)
        EVT_CHECKBOX(self, smartnid, self.OnSmartNames)
        #----------------------------------------------------------------------------------
        # Output wxTextCtrl (self.out)
        #----------------------------------------------------------------------------------

        self.out = wxTextCtrl(self, -1, '', style=wxTE_MULTILINE|wxTE_READONLY)

        #----------------------------------------------------------------------------------
        # "list" wxListCtrl log window (Box 2)
        #----------------------------------------------------------------------------------
        listID = wxNewId()
        self.list= wxListCtrl(self, listID, size=wxDefaultSize,style=wxLC_REPORT|wxSUNKEN_BORDER)
        self.list.InsertColumn(0,"Key")
        self.list.InsertColumn(1,"Status")
        self.list.InsertColumn(2,"Size")
        self.list.SetColumnWidth(0, 540)
        self.list.SetColumnWidth(1, 70)
        self.list.SetColumnWidth(2, 70)

        box2 = wxBoxSizer(wxHORIZONTAL)
        box2.Add(self.list, 1, wxEXPAND|wxALL,0)
        #Events:

        # for wxMSW
        EVT_COMMAND_RIGHT_CLICK(self.list, listID, self.OnRightClick)

        # for wxGTK
        EVT_RIGHT_UP(self.list, self.OnRightClick)
        EVT_RIGHT_DOWN(self.list, self.OnRightDown)

        self.lblRequesting = wxStaticText(self, -1, 'Saving as: ') # Placeholder for "Saving as: "
        self.inpRequesting = wxStaticText(self, -1, '')
        box3top = wxBoxSizer(wxHORIZONTAL)
        box3top.Add(self.lblRequesting, 0, wxLEFT)
        box3top.Add(self.inpRequesting, 1, wxEXPAND|wxALL)
        self.lblRequesting.SetLabel('')

        #----------------------------------------------------------------------------------
        # Filename input  box  wxListCtrl (Box 3)
        #----------------------------------------------------------------------------------
        self.lblFilename = wxStaticText(self, -1, 'Filename   ')
        self.inpFilename = wxTextCtrl(self, -1, "")

        box3 = wxBoxSizer(wxHORIZONTAL)
        box3.Add(self.lblFilename, 0, wxLEFT)
        box3.Add(self.inpFilename, 1, wxEXPAND|wxALL)

        #--------------------------------------------------------------------------------
        #Bottom input boxes, buttons (Box4)
        #---------------------------------------------------------------------------------
        self.inp = wxTextCtrl(self, -1, '', style=wxTE_PROCESS_ENTER)
        self.txt = wxStaticText(self, -1, 'Key Name ')
        self.sndBtn = wxButton(self, -1, 'Request')

        #--------------------------------------------------------------------
        # Leaving off the Cancel button until we're sure it works
        #--------------------------------------------------------------------

        # self.termBtn = wxButton(self, -1, 'Cancel')
        self.inpFilename.Enable(false) # smartnames checked by default, don't let them enter filename on startup
        self.lblFilename.Enable(false)
        self.inp.Enable(true)
        self.sndBtn.Enable(true)
        #self.termBtn.Enable(false)

        # Hook up the events
        EVT_BUTTON(self, self.sndBtn.GetId(), self.OnSendText)
        #EVT_BUTTON(self, self.termBtn.GetId(), self.OnCloseStream)
        EVT_TEXT_ENTER(self, self.inp.GetId(), self.OnSendText)
        EVT_LIST_ITEM_SELECTED(self, listID, self.OnItemSelected)
        box4 = wxBoxSizer(wxHORIZONTAL)
        box4.Add(self.txt, 0, wxALIGN_CENTER)
        box4.Add(self.inp, 1, wxALIGN_CENTER)
        box4.Add(self.sndBtn, 0, wxLEFT, 5)
        #box4.Add(self.termBtn, 0, wxLEFT, 5)


        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(box1, 0, wxEXPAND|wxALL, 0)
        sizer.Add(self.out, 1, wxEXPAND|wxALL, 0)
        sizer.Add(box2, 1, wxEXPAND|wxALL, 0)
        sizer.Add(box3top, 0, wxEXPAND|wxALL, 5)
        sizer.Add(box3, 0, wxEXPAND|wxALL, 5)
        sizer.Add(box4, 0, wxEXPAND|wxALL, 5)
        self.SetSizer(sizer)
        self.SetAutoLayout(true)
        self.inp.SetFocus()

        # This starts a timer that checks for output from download.py
        # It will also check the que to see if downloads are finished and start
        # the next file download etc.
        self.timer = wxPyTimer(self.Pull)
        self.timer.Start(4000) #4 seconds
        self.Pull()

    def Pull(self):
        #Check to see if there are no downloads in progress, if so start next queued key downloading
        """nbr = self.list.GetItemCount() - 1
        busy = 0
        while nbr > -1:
            item = self.list.GetItem(nbr, 1)
            col1 = item.GetText()
            nbr = nbr -1
            if col1 == "Requesting" or col1 == "Done":
                pass
            else:
                if col1 == "Queued":
                    item = self.list.GetItem(nbr, 1)
                    n = self.list.GetItemText(nbr)
                    self.inp.SetValue(n)
        #print item.m_text, item.m_itemId , self.list.GetItemData(self.currentItem)
        #print item.m_data
        #print self.list.GetItemText(self.currentItem)

                    self.list.DeleteItem(nbr) #Delete the item we're on because it gets added again in OnSendText
                    self.OnSendText(self) # Send to download tab, start downloading or be queued
                    nbr = -1 # Exit while loop"""

        #Check to see if there is any text output from download.py to display in out window
        if self.process is not None:
            stream = self.process.GetInputStream()
            if not stream.eof():
                text = stream.read()
                self.out.AppendText(text)

    def OnSmartNames(self, event):
        # Smart Names Checkbox check or uncheck
        n = self.smartnames.GetValue()
        if n == 1:
            self.inpFilename.Enable(false)
            self.lblFilename.Enable(false)
        else:
            self.inpFilename.Enable(true)
            self.lblFilename.Enable(true)

    def OnItemSelected(self, event):
        self.currentItem = event.m_itemIndex

    def OnRightDown(self, event):
        self.x = event.GetX()
        self.y = event.GetY()
        self.log.add("x, y = %s\n" % str((self.x, self.y)))
        event.Skip()

    def OnRightClick(self, event):
        self.x = event.GetX()
        self.y = event.GetY() + 250

        #self.log.add("OnRightClick %s\n" % self.list.GetItemText(self.currentItem))
        menu = wxMenu()
        tPopupID1 = 0
        tPopupID2 = 1
        menu.Append(tPopupID1, "Force download")
        #menu.Append(tPopupID2, 'Launch (MP3s w/ XMMS)') # Whoa funky bug prints \ instead of /
        menu.Append(tPopupID2, 'Launch (MP3s with XMMS)')
        EVT_MENU(self, tPopupID1, self.OnForceDownload)
        EVT_MENU(self, tPopupID2, self.OnLaunch)
        self.PopupMenu(menu, wxPoint(self.x, self.y))
        menu.Destroy()
        event.Skip()

    def OnForceDownload(self, event):
        nbr = self.list.GetItemCount() - 1
        busy = 0
        while nbr > -1:
            item = self.list.GetItem(nbr, 1)
            col1 = item.GetText()
            nbr = nbr -1
            if col1 == "Requesting":
                dlg = wxMessageDialog(self, 'Only one download at a time.' ,
                              'Please be patient', wxOK | wxICON_INFORMATION)
                dlg.ShowModal()
                dlg.Destroy()

        n = self.list.GetItemText(self.currentItem)
        self.inp.SetValue(n)
        i = self.currentItem

        #print item.m_text, item.m_itemId , self.list.GetItemData(self.currentItem)
        #print item.m_data
        #print self.list.GetItemText(self.currentItem)

        self.list.DeleteItem(i) #Delete the item we're on because it gets added again in OnSendText
        self.OnSendText(self) # Send to download tab, start downloading or be queued

    def OnLaunch(self, event):
        keyname = self.list.GetItemText(self.currentItem)
        if string.find(keyname, '/') != -1:
                dirname, filename = os.path.split(keyname)
                os.system("nohup xmms ./download/%s &" % filename)

    def __del__(self):
        if self.process is not None:
            self.process.Detach()
            self.process.CloseOutput()
            self.process = None

    def OnSendText(self, evt):
        keyname = self.inp.GetValue()
        self.lblRequesting.SetLabel('Saving as: ')
        #If there are zero keys, start download right away, else mark Queued
        nbr = self.list.GetItemCount() - 1
        busy = 0
        while nbr > -1:
            item = self.list.GetItem(nbr, 1)
            col1 = item.GetText()
            nbr = nbr -1
            if col1 == "Requesting":
                busy = 1

        pos=self.list.GetItemCount()
        if busy == 0: # Not requesting, so start downloading, only one at a time though for now

            self.list.InsertStringItem(pos, keyname)
            self.list.SetStringItem(pos, 1, "Requesting")

            cmd = "python download.py"
            self.process = wxProcess(self)
            self.process.Redirect();
            pid = wxExecute(cmd, false, self.process)
            self.log.add('Starting download.py as pid %s\n' % (pid))

            filename = self.inpFilename.GetValue()

            v = self.detail.GetValue()
            verbose = ('%s' % v)
            s = self.smartnames.GetValue()
            # If smartnames checked, make filename from key like KSK@mp3/britney/iloverob.mp3 to iloverob.mp3
            if s == 1:
                if string.find(keyname, '/') != -1:
                    dirname, filename = os.path.split(keyname)
                else:
                    filename = keyname # plain kay like 'test'
            self.inpRequesting.SetLabel("./download/%s" % filename)

            self.process.GetOutputStream().write(verbose + '\n')
            self.process.GetOutputStream().write(filename + '\n')
            self.process.GetOutputStream().write(keyname + '\n')
            #print verbose, filename, keyname
            self.out.AppendText("Requesting key: \n %s \n\n" % keyname)
            self.out.AppendText("Saving as file: \n %s \n" % filename)
            self.inp.SetValue('')
            #self.inp.Enable(true)
            #self.inpFilename.Enable(true)
            #self.sndBtn.Enable(true)
            #self.termBtn.Enable(true)
        else:
            self.list.InsertStringItem(pos, keyname)
            self.list.SetStringItem(pos, 1, "Queued")
            self.inp.SetValue('')
            self.inpFilename.SetValue('')

    def add(self, txt):
        pos=self.list.GetItemCount()
        self.list.InsertStringItem(pos, txt)
        self.list.SetStringItem(pos, 1, "Queued")

    def OnCloseStream(self, evt):
        print "onclosestream"
        self.process.CloseOutput()
        self.process = wxProcess(self)
        self.process.Redirect();
        pid = wxExecute(cmd, false, self.process)
        self.inp.SetFocus()
        self.log.add('OnCloseStream')

# OnIdle used to update the GUI with the download.py output
# but it only worked when you moved the mouse or hit a key
# def Pull has replaced this and is a 2 second timer

#       def OnIdle(self, evt):
#        if self.process is not None:
#            stream = self.process.GetInputStream()
#            if not stream.eof():
#                text = stream.read()
#                self.out.AppendText(text)

    #----------------------------------------------------------------
    # Download complete
    #----------------------------------------------------------------

    def OnProcessEnded(self, evt):

        stream = self.process.GetInputStream()
        if not stream.eof():
            text = stream.read()
            self.process.Destroy()
            self.process = None

            filename = self.inpRequesting.GetLabel()
            self.inp.SetFocus()
            self.sndBtn.Enable(true)
            #self.inp.SetValue('')
            #self.inpFilename.SetValue('')
            pos=self.list.GetItemCount()
            nbr_items = pos - 1
            #self.list.SetColumnWidth(0, wxLIST_AUTOSIZE)
            #self.list.EnsureVisible(pos) ### This makes it hang.
            #print "Snarfie"
            #print text
            #print len(text)
            #print string.find(text, "asdfas")
            if text[-1] == '*':
                failed = 1
            else:
                failed = 0
            if failed:
                status = "Failed"
            else:
                status = "Done"

            try:
                a = os.stat("%s" % filename)
                f = a[6]
            except:
                f = 0
                if status != "Failed":
                    status = "Error"

            self.list.SetStringItem(nbr_items, 1, status)
            filesize = ("%s" % f)
            self.list.SetStringItem(nbr_items, 2, filesize)
            self.out.AppendText(text)
            self.out.AppendText("\n")
            self.inpRequesting.SetLabel("")
            self.lblRequesting.SetLabel("")

#------------------------------------------------------------------------------------------
# Upload Panel
#------------------------------------------------------------------------------------------


class panelupload(wxPanel):
    def __init__(self, parent, log, keylist):
        wxPanel.__init__(self, parent, -1)
        self.log=log
        self.keylist=keylist
        self.parent=parent
        self.process = None

#                EVT_IDLE(self, self.OnIdle)
        EVT_END_PROCESS(self, -1, self.OnProcessEnded)


        #----------------------------------------------------------------------------------
        # Options at top (Box 1)
        #----------------------------------------------------------------------------------

        box1 = wxBoxSizer(wxHORIZONTAL)
        cid = NewId()
        self.detail = wxCheckBox(self, cid, "Send to Key Index", style=wxNO_BORDER)
        self.addtokeyring = wxCheckBox(self, cid + 1, "Add to Keyring", style=wxNO_BORDER)
        box1.Add(self.detail, 1, wxALIGN_LEFT, 0)
        box1.Add(self.addtokeyring, 1, wxALIGN_LEFT, 0)
        self.addtokeyring.SetValue(true) #Checkbox marked on startup

        #----------------------------------------------------------------------------------
        # Output wxTextCtrl (self.out)
        #----------------------------------------------------------------------------------

        self.out = wxTextCtrl(self, -1, '', style=wxTE_MULTILINE|wxTE_READONLY)

        #----------------------------------------------------------------------------------
        # "list" wxListCtrl log window (Box 2)
        #----------------------------------------------------------------------------------
        listID = wxNewId()
        self.list= wxListCtrl(self, listID, size=wxDefaultSize,style=wxLC_REPORT|wxSUNKEN_BORDER)
        self.list.InsertColumn(0,"Key")
        self.list.InsertColumn(1,"Status")
        self.list.InsertColumn(2,"Size")
        self.list.SetColumnWidth(0, 500)
        self.list.SetColumnWidth(1, 70)
        self.list.SetColumnWidth(2, 70)

        box2 = wxBoxSizer(wxHORIZONTAL)
        box2.Add(self.list, 1, wxEXPAND|wxALL,0)

        #Events:

        # for wxMSW
        EVT_COMMAND_RIGHT_CLICK(self.list, listID, self.OnRightClick)

        # for wxGTK
        EVT_RIGHT_UP(self.list, self.OnRightClick)
        EVT_RIGHT_DOWN(self.list, self.OnRightDown)

        #--------------------------------------------------------------------------------
        #Bottom input boxes, buttons (Box 3)
        #---------------------------------------------------------------------------------
        self.inp = wxTextCtrl(self, -1, '', style=wxTE_PROCESS_ENTER)
        self.fileLabel = wxStaticText(self, -1, 'Filename: ')
        self.fileName = wxStaticText(self, -1, '')
        self.txt = wxStaticText(self, -1, 'Enter Key ')
        self.sndBtn = wxButton(self, -1, 'Insert')
        self.fileBtn = wxButton(self, -1, 'Select File')


#--------------------------------------------------------------------
# Leaving off the Cancel button until we're sure it works
#--------------------------------------------------------------------

        # self.termBtn = wxButton(self, -1, 'Cancel')

        self.inp.Enable(true)
        self.sndBtn.Enable(true)
        self.fileBtn.Enable(true)

        #self.termBtn.Enable(false)

        # Hook up the events
        EVT_BUTTON(self, self.sndBtn.GetId(), self.OnSendText)
        EVT_BUTTON(self, self.fileBtn.GetId(), self.OnFileSelect)
        #EVT_BUTTON(self, self.termBtn.GetId(), self.OnCloseStream)
        EVT_TEXT_ENTER(self, self.inp.GetId(), self.OnSendText)
        EVT_LIST_ITEM_SELECTED(self, listID, self.OnItemSelected)
        box3 = wxBoxSizer(wxHORIZONTAL)
        box3.Add(self.fileLabel, 0 , wxLEFT)
        box3.Add(self.fileName, 0 , wxLEFT)
        box4 = wxBoxSizer(wxHORIZONTAL)
        box4.Add(self.txt, 0, wxALIGN_CENTER)
        box4.Add(self.inp, 1, wxALIGN_CENTER)
        box4.Add(self.sndBtn, 0, wxLEFT, 10)
        box4.Add(self.fileBtn, 0, wxLEFT, 10)
        #box3.Add(self.termBtn, 0, wxLEFT, 5)

        #Put everything into a sizer

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(box1, 0, wxEXPAND|wxALL, 0)
        sizer.Add(self.out, 1, wxEXPAND|wxALL, 0)
        sizer.Add(box2, 1, wxEXPAND|wxALL, 0)
        sizer.Add(box3, 0, wxEXPAND|wxALL, 5)
        sizer.Add(box4, 0, wxEXPAND|wxALL, 5)

        self.SetSizer(sizer)
        self.SetAutoLayout(true)
        self.inp.SetFocus()

        self.timer = wxPyTimer(self.Pull)
        self.timer.Start(2000)
        self.Pull()

    def Pull(self):
        if self.process is not None:
            stream = self.process.GetInputStream()
            if not stream.eof():
                text = stream.read()
                self.out.AppendText(text)


    def OnItemSelected(self, event):
        self.currentItem = event.m_itemIndex

    def OnRightDown(self, event):
        self.x = event.GetX()
        self.y = event.GetY()
        #self.log.add("x, y = %s\n" % str((self.x, self.y)))
        event.Skip()

    def OnRightClick(self, event):
        #self.log.add("OnRightClick %s\n" % self.list.GetItemText(self.currentItem))
        menu = wxMenu()
        tPopupID1 = 0
        tPopupID2 = 1
        tPopupID3 = 2
        tPopupID4 = 3
        tPopupID5 = 5
        menu.Append(tPopupID1, "One")
        menu.Append(tPopupID2, "Two")
        menu.Append(tPopupID3, "Three")
        menu.Append(tPopupID4, "DeleteAllItems")
        menu.Append(tPopupID5, "GetItem")
        EVT_MENU(self, tPopupID1, self.OnPopupOne)
        EVT_MENU(self, tPopupID2, self.OnPopupTwo)
        EVT_MENU(self, tPopupID3, self.OnPopupThree)
        EVT_MENU(self, tPopupID4, self.OnPopupFour)
        EVT_MENU(self, tPopupID5, self.OnPopupFive)
        self.PopupMenu(menu, wxPoint(self.x, self.y))
        menu.Destroy()
        event.Skip()

    def OnPopupOne(self, event):
        self.log.add("Popup one\n")

    def OnPopupTwo(self, event):
        self.log.add("Popup two\n")

    def OnPopupThree(self, event):
        self.log.add("Popup three\n")

    def OnPopupFour(self, event):
        self.list.DeleteAllItems()

    def OnPopupFive(self, event):
        self.log.add("Popup five\n")
        #item = self.list.GetItem(self.currentItem)
        print item.m_text, item.m_itemId # , self.list.GetItemData(self.currentItem)

    def __del__(self):
        if self.process is not None:
            self.process.Detach()
            self.process.CloseOutput()
            self.process = None

    def OnSendText(self, evt):
        cmd = "python upload.py"

        self.process = wxProcess(self)
        self.process.Redirect();

        pid = wxExecute(cmd, false, self.process)
        self.inp.SetFocus()
        self.log.add('Starting upload.py as pid %s\n' % (pid))

        keyname = self.inp.GetValue()
        keyname = "freenet:KSK@" + keyname
        print keyname
        filename = self.fileName.GetLabel()
        print filename
        self.process.GetOutputStream().write(keyname + '\n')
        self.process.GetOutputStream().write(filename + '\n')
        self.out.AppendText("Attempting to insert %s \n" % keyname)
        self.inp.SetFocus()
        self.inp.Enable(false)
        self.sndBtn.Enable(false)
        #self.termBtn.Enable(true)
        pos=self.list.GetItemCount()
        self.list.InsertStringItem(pos, keyname)
        self.list.SetStringItem(pos, 1, "Inserting")

    def OnCloseStream(self, evt):
        print "onclosestream"
        self.process.CloseOutput()
        self.process = wxProcess(self)
        self.process.Redirect();
        pid = wxExecute(cmd, false, self.process)
        self.inp.SetFocus()
        self.log.add('OnCloseStream')


    def OnIdle(self, evt):
        if self.process is not None:
            stream = self.process.GetInputStream()
            if not stream.eof():
                text = stream.read()
                self.out.AppendText(text)


    def OnProcessEnded(self, evt):

        # There is something funky going on here. Hats off to whoever figures it out.
        # You can't send anything to other tabs -  self.log.add("foo") makes it hang

        stream = self.process.GetInputStream()
        if not stream.eof():
            text = stream.read()
            self.process.Destroy()
            self.process = None

            filename = self.inp.GetValue()


            self.inp.Enable(true)
            self.inp.SetFocus()
            self.sndBtn.Enable(true)
            #self.termBtn.Enable(false)
            self.inp.SetValue('')

            pos=self.list.GetItemCount()
            nbr_items = pos - 1
            #self.list.SetColumnWidth(0, wxLIST_AUTOSIZE)
            #self.list.EnsureVisible(pos) ### This makes it hang.

            if text[-1] == '*':
                failed = 1
            else:
                failed = 0
            if failed:
                status = "Failed"
            else:
                status = "Done"

            try:
                a = os.stat("./download/%s" % filename)
                f = a[6]
            except:
                f = 0
                if status != "Failed":
                    status = "Error"

            self.list.SetStringItem(nbr_items, 1, status)
            filesize = ("%s" % f)
            self.list.SetStringItem(nbr_items, 2, filesize)
            self.out.AppendText(text)
            self.out.AppendText("\n")


    def OnFileSelect(self, event):
        dlg = wxFileDialog(self, "Choose a file", ".", "", "", wxOPEN|wxMULTIPLE)
        if dlg.ShowModal() == wxID_OK:
            for path in dlg.GetPaths():
                self.fileName.SetLabel(path)
                dlg.Destroy()


class panelbrowser(wxPanel):
    def __init__(self, parent):
        wxPanel.__init__(self, parent, -1)
        #self.SetAutoLayout(true)
        #EVT_SCROLLWIN( self, self.OnScroll )
        self.html = MyHtmlWindow(self)
        self.box = wxBoxSizer(wxVERTICAL)
        self.box.Add(self.html, 1, wxGROW)

        subbox = wxBoxSizer(wxHORIZONTAL)

        btn = wxButton(self, 1202, "Load File")
        EVT_BUTTON(self, 1202, self.OnLoadFile)
        subbox.Add(btn, 1, wxGROW | wxALL, 2)

        btn = wxButton(self, 1204, "Back")
        EVT_BUTTON(self, 1204, self.OnBack)
        subbox.Add(btn, 1, wxGROW | wxALL, 2)

        btn = wxButton(self, 1205, "Forward")
        EVT_BUTTON(self, 1205, self.OnForward)
        subbox.Add(btn, 1, wxGROW | wxALL, 2)

        btn = wxButton(self, 1206, "View Source")
        EVT_BUTTON(self, 1206, self.OnViewSource)
        subbox.Add(btn, 1, wxGROW | wxALL, 2)

        self.box.Add(subbox, 0, wxGROW)
        self.SetSizer(self.box)
        self.SetAutoLayout(true)

        self.OnShowDefault(None)


    def OnShowDefault(self, event):
        #name = os.path.join(self.cwd, '/index.html')
        name = './htdocs/index.html'
        self.html.LoadPage(name)


    def OnLoadFile(self, event):
        dlg = wxFileDialog(self, wildcard = '*.htm*', style=wxOPEN)
        if dlg.ShowModal():
            path = dlg.GetPath()
            self.html.LoadPage(path)
        dlg.Destroy()

    def OnBack(self, event):
        if not self.html.HistoryBack():
            wxMessageBox("No more items in history!")


    def OnForward(self, event):
        if not self.html.HistoryForward():
            wxMessageBox("No more items in history!")


    def OnViewSource(self, event):
        from wxPython.lib.dialogs import wxScrolledMessageDialog
        source = self.html.GetParser().GetSource()
        dlg = wxScrolledMessageDialog(self, source, 'HTML Source')
        dlg.ShowModal()
        dlg.Destroy()


class MyHtmlWindow(wxHtmlWindow):
    def __init__(self, parent):
        wxHtmlWindow.__init__(self, parent)
        EVT_SCROLLWIN( self, self.OnScroll )

    def OnScroll( self, event ):
        event.Skip()


    def OnLinkClicked(self, linkinfo):
        url = linkinfo.GetHref()
        #self.base_OnLinkClicked(linkinfo)


        print ('Clicked: %s\n' % url)
        try:
            f = urllib.urlopen(url)
            #wxYield() # hmmm
            fileout = f.read()
            fileout = string.replace(fileout, "href = ", "href=")
            fileout = string.replace(fileout, "href= ", "href=")
            fileout = string.replace(fileout, "href =", "href=")
            fileout = string.replace(fileout, 'img src="', 'img src="%s' % url)
            fileout = string.replace(fileout, 'img SRC="', 'img src="%s' % url)
            urlcache = string.replace(url, "/", "X")
            urlcache = string.replace(urlcache, ":", "Y")
            urlcache = urlcache + ".html"
            print urlcache
            output = open('./htdocs/cache/%s' % urlcache, 'w')

            output.write(fileout)
            output.close()
            lastout = open('./htdocs/cache/last.url', 'w')
            lastout.write(url)
            lastout.close()
            self.LoadPage('./htdocs/cache/%s' % urlcache)
        except:
            print "Making full URL..."
            inurl = open('./htdocs/cache/last.url', 'r')
            lasturl = inurl.read()
            fullurl = lasturl + url
            print fullurl
            f = urllib.urlopen(fullurl)
            fileout = f.read()
            fileout = string.replace(fileout, "href = ", "href=")
            fileout = string.replace(fileout, "href= ", "href=")
            fileout = string.replace(fileout, "href =", "href=")
            fileout = string.replace(fileout, 'img src="', 'img src="%s' % fullurl)
            fileout = string.replace(fileout, 'img SRC="', 'img src="%s' % fullurl)

            urlcache = string.replace(url, "/", "X")
            urlcache = string.replace(urlcache, ":", "Y")
            urlcache = string.replace(urlcache, "@", "Z")
            urlcache = urlcache + ".html"
            print urlcache

            output = open('./htdocs/cache/%s' % urlcache, 'w')
            output.write(fileout)
            output.close()
            self.LoadPage('./htdocs/cache/%s' % urlcache)


    def OnSetTitle(self, title):
        #self.log.add('OnSetTitle: %s\n' % title)
        self.base_OnSetTitle(title)

class panelcreate(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)

        # Ok, so maybe this was my first window and I didn't know about wxSizers...
        row = 25
        col = 90
        width = 225

        #self.rembutID=NewId()
        self.rembut = wxButton(self, 1500, "Select MP3    ", wxPoint(330, row))
        self.id3but = wxButton(self, 1501, "Write ID3 Tags", wxPoint(330, row+30))
        self.id3msg = wxStaticText(self, -1, "", wxPoint(430, 55), wxSize(75, 20))
        self.addbut = wxButton(self, 1502, "Add to Catalog", wxPoint(330, row+60))
        self.fairtunesbut = wxButton(self, 1504, "Fairtunes", wxPoint(330, row+90))

        EVT_BUTTON(self, 1500, self.fileSelect)
        EVT_BUTTON(self, 1501, self.writeID3)
        EVT_BUTTON(self, 1502, self.addCatalog)
        EVT_BUTTON(self, 1504, self.fairtunes)

        wxStaticText(self, -1, "Filename", wxPoint(5, row), wxSize(75, 20))
        self.inpFilename = wxTextCtrl(self, 5, "", wxPoint(col, row), wxSize(width, 20))
        self.inpFilename.SetInsertionPoint(0)

        wxStaticText(self, -1, "Artist", wxPoint(5, row+30), wxSize(75, 20))
        self.inpArtist = wxTextCtrl(self, 10, "", wxPoint(col, row+30), wxSize(width, 20))
        self.inpArtist.SetInsertionPoint(0)

        wxStaticText(self, -1, "Song Title", wxPoint(5, row+60), wxSize(75, 20))
        self.inpTitle = wxTextCtrl(self, 20, "", wxPoint(col, row+60), wxSize(width, 20))
        self.inpTitle.SetInsertionPoint(0)

        wxStaticText(self, -1, "Album", wxPoint(5, row+90), wxSize(75, 20))
        self.inpAlbum = wxTextCtrl(self, 30, "", wxPoint(col, row+90), wxSize(width, 20))
        self.inpAlbum.SetInsertionPoint(0)

        wxStaticText(self, -1, "Comment", wxPoint(5, row+120), wxSize(75, 20))
        self.inpComment = wxTextCtrl(self, 40, "", wxPoint(col, row+120), wxSize(width, 20))
        self.inpComment.SetInsertionPoint(0)

        wxStaticText(self, -1, "Genre", wxPoint(5, row+150), wxSize(75, 20))
        self.inpGenre = wxTextCtrl(self, 50, "", wxPoint(col, row+150), wxSize(width, 20))
        self.inpGenre.SetInsertionPoint(0)

        wxStaticText(self, -1, "Year", wxPoint(5, row+180), wxSize(75, 20))
        self.inpYear = wxTextCtrl(self, 60, "", wxPoint(col, row+180), wxSize(width, 20))
        self.inpYear.SetInsertionPoint(0)

        self.header = wxStaticText(self, -1, "", wxPoint(col, row+210), wxSize(width, 20))
        self.insbut = wxButton(self, 1505, "Upload Catalog to Freenet", wxPoint(90, row+250))
        EVT_BUTTON(self, 1505, self.insCatalog)

        wxStaticText(self, -1, "Catalog Name", wxPoint(5, row+280), wxSize(80, 20))
        self.inpCatalogName = wxTextCtrl(self, 90, "", wxPoint(col, row+280), wxSize(width, 20))
        self.inpCatalogName.SetInsertionPoint(0)

        self.catListID=wxNewId()
        self.catList = wxListCtrl(self, self.catListID, wxPoint(10,330), wxDefaultSize,wxLC_REPORT|wxSUNKEN_BORDER)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 330)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 10)
        lc.right.SameAs(self, wxRight, 10)

        self.catList.SetConstraints(lc)
        self.catList.InsertColumn(0, "Artist")
        self.catList.InsertColumn(1, "Title")
        self.catList.InsertColumn(2, "Album")
        self.catList.InsertColumn(3, "Time")
        self.catList.InsertColumn(4, "Bitrate")
        #self.catList.SetColumnWidth(0, wxLIST_AUTOSIZE_USEHEADER)
        self.catList.SetColumnWidth(0, 170)
        self.catList.SetColumnWidth(1, 170)
        self.catList.SetColumnWidth(2, 170)
        self.catList.SetColumnWidth(3, wxLIST_AUTOSIZE_USEHEADER)
        self.catList.SetColumnWidth(4, wxLIST_AUTOSIZE_USEHEADER)
        self.playlist = {}

    def insCatalog(self, event):
        xit = Xml.XML_document()
        xit.catalog()
        items = self.playlist.items()
        for x in range(len(items)):
            key, data = items[x]
            xit.song()
            xit.artist(data[0])
            xit.title(data[1])
            xit.album(data[2])
            xit.time(data[3])
            xit.filesize(data[4])
            xit.bitrate(data[5])
            xit.freq(data[6])
            xit.genre(data[7])
            xit.year(data[8])
            xit.key("freeent:KSK@blah")
        f = self.inpCatalogName.GetValue()
        if f == "":
            filename = "Enter_a_catalog_name_next_time.xml"
        else:
            filename = f + ".xml"

        xit._output(filename)
        self.inpFilename.SetValue("")
        self.inpArtist.SetValue("")
        self.inpTitle.SetValue("")
        self.inpAlbum.SetValue("")
        self.inpComment.SetValue("")
        self.inpGenre.SetValue("")
        self.inpYear.SetValue("")
        self.playlist = {}
        self.id3msg.SetLabel("")
        self.header.SetLabel("")
        self.catList.ClearAll()

    def addCatalog(self, event):
        x = len(self.playlist.items())

        artist = self.inpArtist.GetValue()
        title = self.inpTitle.GetValue()
        album = self.inpAlbum.GetValue()
        comment = self.inpComment.GetValue()
        genre = self.inpGenre.GetValue()
        year = self.inpYear.GetValue()
        version = self.i['VERSION']
        layer = self.i['LAYER']
        bitrate = self.i['BITRATE']
        frequency = self.i['FREQUENCY']
        sec = ("%s" % self.i['SS'])
        if len(sec) == 1:    # Add leading zero if seconds < 10 so time looks pretty (4:04 instead of 4:4)
            seconds = ("0%s" % sec)
        else:
            seconds = ("%s" % sec)
        length = "%s:%s" % (self.i['MM'], seconds)

        self.playlist[x+1] = ( artist, title, album, comment, genre, year, version, layer, bitrate, frequency, length )
        self.catList.InsertStringItem(x, artist)
        self.catList.SetStringItem(x, 1, title)
        self.catList.SetStringItem(x, 2, album)
        self.catList.SetStringItem(x, 3, length)
        self.catList.SetStringItem(x, 4, "%s Kbps" % (bitrate))
        self.catList.SetItemData(x, x)

    def writeID3(self, event):
        filename = self.inpFilename.GetValue()
        if filename != "":
            artist = string.rstrip(self.inpArtist.GetValue())
            title = string.rstrip(self.inpTitle.GetValue())
            album = string.rstrip(self.inpAlbum.GetValue())
            comment = string.rstrip(self.inpComment.GetValue())
            genre = string.rstrip(self.inpGenre.GetValue())
            year = string.rstrip(self.inpYear.GetValue())
            tag=ID3Tag(filename)
            tag.Title(title)
            tag.Artist(artist)
            tag.Album(album)
            tag.Year(year)
            tag.Genre(genre)
            tag.Comment(comment)

            tag.Commit()
            self.id3msg.SetLabel("Tags written")
        else:
            self.id3msg.SetLabel("You need a filename.")


    def fileSelect(self, event):
        dlg = wxFileDialog(self, "Choose a file", ".", "", "*.mp3", wxOPEN|wxMULTIPLE)
        if dlg.ShowModal() == wxID_OK:
            for path in dlg.GetPaths():
                self.inpFilename.SetValue(path)
                dlg.Destroy()
        self.id3msg.SetLabel("")
        #MP3 header info:
        self.i = mp3info(path)
        self.header.SetLabel('MPEG%d, L%d %dKbps %dHz Stereo' % \
                              (self.i['VERSION'], self.i['LAYER'], self.i['BITRATE'], self.i['FREQUENCY']))

        ### i['STEREO'] # Not implemented, I faked it
        ### i['MODE'] # Not implemented
        ### i['COPYRIGHT'] # Not implemented

        wxStaticText(self, -1, "              ", wxPoint(430, 55), wxSize(75, 20)) # Ummm this is cheesier than Velveeta.

        # ID3 v1 info:
        try:
            tag = ID3Tag(path)
            tag.Read()
            self.inpArtist.SetValue(string.rstrip(tag.theArtist()))
            self.inpTitle.SetValue(string.rstrip(tag.theTitle()))
            self.inpAlbum.SetValue(string.rstrip(tag.theAlbum()))
            self.inpComment.SetValue(string.rstrip(tag.theComment()))
            self.inpGenre.SetValue(string.rstrip(tag.theGenre()))
            self.inpYear.SetValue(string.rstrip(tag.theYear()))
        except:
            self.inpArtist.SetValue("")
            self.inpTitle.SetValue("")
            self.inpAlbum.SetValue("")
            self.inpComment.SetValue("")
            self.inpGenre.SetValue("")
            self.inpYear.SetValue("")

    def fairtunes(self, event):
        artist = self.inpArtist.GetValue()
        nice_artist = string.joinfields(string.splitfields(artist,' '),'%20') # Fix this: theres some url pretty deal in Python?
        #print nice_artist
        # Added client=snarfzilla per Matt Goyer at Fairtunes
        url = 'http://www.fairtunes.com/bare_search.jsp?searchTerms=' + nice_artist + '&action=dosearch&client=snarfzilla'
        #print url
        doit = browserloc + " '" + url + "' &"
        os.system(doit)



class panelkeyring(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)
        self.keylist= wxListCtrl(self, -1, size=wxDefaultSize,style=wxLC_REPORT)
        self.keylist.InsertColumn(0,"Key Type")
        self.keylist.InsertColumn(1,"Public Key")
        self.keylist.InsertColumn(2,"Private Key")
        self.keylist.InsertColumn(3,"Associated File")
        self.keylist.SetColumnWidth(0, 70)
        self.keylist.SetColumnWidth(1, 170)
        self.keylist.SetColumnWidth(2, 170)
        self.keylist.SetColumnWidth(3, 170)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 10)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 50)
        lc.right.SameAs(self, wxRight, 10)
        self.keylist.SetConstraints(lc)

        butID=NewId()
        but=wxButton(self,butID,"Clear")
        EVT_BUTTON(self,butID,self.DeleteAllItems)
        lc = wxLayoutConstraints()
        lc.bottom.SameAs(self, wxBottom, 15)
        lc.left.SameAs(self, wxLeft, 15)
        lc.height.AsIs()
        lc.width.AsIs()
        but.SetConstraints(lc);
        #self.keylist.InsertStringItem(0, "test")

    def add(self,txt):
        pos=self.keylist.GetItemCount()
        self.keylist.InsertStringItem(pos,txt)
        #self.keylist.SetColumnWidth(0, wxLIST_AUTOSIZE)
        self.keylist.EnsureVisible(pos)
    def OnClear(self,event):
        self.keylist.ClearAll()
    def DeleteAllItems(self, event):
        self.keylist.DeleteAllItems()

#--------------------------------------------------------------
# The main class that shows the big frame and loops and loops
#--------------------------------------------------------------

class MyApp(wxApp):
    def OnInit(self):
        frame=MyFrame(None,-1,"Snarfzilla - The Freenet Monster 0.0.3")
        frame.Show(true)
        self.SetTopWindow(frame)
        return true

app=MyApp(0)
app.MainLoop()