/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.cli;

import Freenet.FieldSet;
import Freenet.Params;
import Freenet.client.MimeTypeUtils;
import Freenet.support.io.ReadInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import relentless.gj.cli.ManifestFileRecord;

public class ManifestFile {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final String START_DIRECTIVES = "!START_DIRECTIVES";
    private final String END_DIRECTIVES = "!END_DIRECTIVES";
    private final String CONCATINATE_TO = "!CONCATINATE_TO";
    private final String MSK_URI = "!MSK_URI";
    private final String UPDATE = "!UPDATE";
    private Hashtable vars = new Hashtable();
    private ManifestFileRecord[] rawRecords = null;
    private String concatinateTo = null;
    private String rawMSKURI = null;
    private boolean update = false;

    public ManifestFile(ManifestFileRecord[] manifestFileRecordArray, String string, String string2, Hashtable hashtable) {
        this.rawRecords = manifestFileRecordArray;
        this.concatinateTo = string;
        this.rawMSKURI = string2;
        if (hashtable != null) {
            this.vars = (Hashtable)hashtable.clone();
        }
    }

    public final ManifestFileRecord[] getRecords() {
        if (this.rawRecords.length < 1) {
            return new ManifestFileRecord[0];
        }
        ManifestFileRecord[] manifestFileRecordArray = new ManifestFileRecord[this.rawRecords.length];
        String[] stringArray = this.getVarNames();
        int n = 0;
        while (n < this.rawRecords.length) {
            String string = this.rawRecords[n].getFreenetURI();
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = ManifestFile.replace(string, stringArray[n2], (String)this.vars.get(stringArray[n2]));
                ++n2;
            }
            String string2 = this.rawRecords[n].getFileName();
            n2 = 0;
            while (n2 < stringArray.length) {
                string2 = ManifestFile.replace(string2, stringArray[n2], (String)this.vars.get(stringArray[n2]));
                ++n2;
            }
            manifestFileRecordArray[n] = new ManifestFileRecord(string, string2, this.rawRecords[n].getMimeType());
            ++n;
        }
        return manifestFileRecordArray;
    }

    public final ManifestFileRecord[] getRawRecords() {
        return this.rawRecords;
    }

    public final Hashtable getVars() {
        return this.vars;
    }

    public final String getMSKURI() {
        if (this.rawMSKURI == null) {
            return null;
        }
        String string = this.rawMSKURI;
        String[] stringArray = this.getVarNames();
        int n = 0;
        while (n < stringArray.length) {
            string = ManifestFile.replace(string, stringArray[n], (String)this.vars.get(stringArray[n]));
            ++n;
        }
        return string;
    }

    public final void setRawMSKURI(String string) {
        this.rawMSKURI = string;
    }

    public final String getConcatinationFileName() {
        return this.concatinateTo;
    }

    public final boolean getUpdate() {
        return this.update;
    }

    public final void setUpdate(boolean bl) {
        this.update = bl;
    }

    public final ManifestFile copy(ManifestFileRecord[] manifestFileRecordArray) {
        Hashtable hashtable = this.vars;
        if (this.vars != null) {
            hashtable = (Hashtable)this.vars.clone();
        }
        return new ManifestFile(manifestFileRecordArray, this.concatinateTo, this.rawMSKURI, hashtable);
    }

    public final void doParanoidPathChecks(String string) throws IOException {
        ManifestFileRecord[] manifestFileRecordArray = this.getRecords();
        File file = new File(string);
        String string2 = file.getCanonicalPath();
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            if (manifestFileRecordArray[n].getFileName().startsWith(File.separator) || manifestFileRecordArray[n].getFileName().indexOf(File.pathSeparator) != -1) {
                throw new IllegalArgumentException("Bad file name in manifest:" + manifestFileRecordArray[n].getFileName());
            }
            File file2 = new File(file, manifestFileRecordArray[n].getFileName());
            String string3 = file2.getCanonicalPath();
            int n2 = string3.indexOf(string2);
            if (n2 != 0 || string2.length() >= string3.length()) {
                throw new IllegalArgumentException("Bad file name in manifest:" + manifestFileRecordArray[n].getFileName());
            }
            ++n;
        }
    }

    public final void doParanoidSSKInsertChecks(Hashtable hashtable) {
        int n = 0;
        while (n < this.rawRecords.length) {
            block13: {
                String string;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    if (this.rawRecords[n].getFileName().indexOf(string) == -1 && this.rawRecords[n].getMimeType().indexOf(string) == -1) continue;
                    throw new RuntimeException("SSK variable used outside of URI field:" + string);
                }
                string = this.rawRecords[n].getFreenetURI();
                String string2 = string.toLowerCase();
                if (!string2.startsWith("freenet:")) {
                    throw new RuntimeException("URI doesn't start with \"freenet:\", " + string);
                }
                if (string2.startsWith("freenet:chk@")) {
                    if (string2.indexOf("ssk_key") != -1) {
                        throw new RuntimeException("Possible SSK private key variable in non SSK key: " + string);
                    }
                } else if (string2.startsWith("freenet:ksk@")) {
                    if (string2.indexOf("ssk_key") != -1) {
                        throw new RuntimeException("Possible SSK private key variable in non SSK key: " + string);
                    }
                } else {
                    if (string2.startsWith("freenet:ssk@")) {
                        int n2 = string2.indexOf("/");
                        if (n2 < 13) {
                            throw new RuntimeException("Can't parse SSK private key: " + string);
                        }
                        String string3 = string.substring(12, n2);
                        System.err.println("ManifestFile.doParanoidSSKInsertChecks -- checking: " + string3);
                        Enumeration enumeration2 = hashtable.keys();
                        while (enumeration2.hasMoreElements()) {
                            String string4 = (String)enumeration2.nextElement();
                            if (string3.indexOf(string4) == -1) {
                                if (this.vars.get(string4) == null || hashtable.get(string4) != null) continue;
                                throw new RuntimeException("SSK key variable names must contain the substring \"ssk_key\": " + string);
                            }
                            break block13;
                        }
                        throw new RuntimeException("Literal SSK private key values not allowed: " + string);
                    }
                    throw new RuntimeException("Unsupported key type: " + string);
                }
            }
            ++n;
        }
    }

    public final void overrideVars(Hashtable hashtable) {
        if (hashtable.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.vars.get(string) == null) {
                throw new RuntimeException("Variable not defined in manifest: " + string);
            }
            this.vars.put(string, hashtable.get(string));
        }
    }

    public final void write(String string) throws IOException {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter(string));
                this.write(printWriter);
            }
            catch (IOException iOException) {
                printWriter.close();
                printWriter = null;
                throw iOException;
            }
            Object var5_3 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public final void write(PrintWriter printWriter) throws IOException {
        printWriter.println("// This file was machine generated.");
        printWriter.println("!START_DIRECTIVES");
        Enumeration enumeration = this.vars.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.vars.get(string);
            if (string2 == null) {
                string2 = "";
            }
            printWriter.println("!" + string + "=" + string2);
        }
        if (this.concatinateTo != null) {
            printWriter.println("!CONCATINATE_TO " + this.concatinateTo);
        }
        if (this.rawMSKURI != null) {
            printWriter.println("!MSK_URI " + this.rawMSKURI);
        }
        if (this.update) {
            printWriter.println("!UPDATE true");
        }
        printWriter.println("!END_DIRECTIVES");
        int n = 0;
        while (n < this.rawRecords.length) {
            printWriter.println(this.rawRecords[n].getFreenetURI());
            printWriter.println(this.rawRecords[n].getFileName());
            printWriter.println(this.rawRecords[n].getMimeType());
            ++n;
        }
    }

    public static final void createSubdirs(String string, ManifestFileRecord[] manifestFileRecordArray) throws IOException {
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            File file;
            String string2 = string + manifestFileRecordArray[n].getFileName();
            File file2 = new File(string2);
            String string3 = file2.getParent();
            if (!(string3 == null || (file = new File(string3)).exists() && file.isDirectory())) {
                file.mkdirs();
            }
            ++n;
        }
    }

    public static final Hashtable getSSKs(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        if (hashtable.size() == 0) {
            return hashtable2;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.toLowerCase().indexOf("ssk_key") == -1) continue;
            hashtable2.put(string, hashtable.get(string));
        }
        return hashtable2;
    }

    public static final ManifestFile read(BufferedReader bufferedReader) throws IOException {
        return new ManifestFile(bufferedReader);
    }

    public static final ManifestFile read(String string) throws IOException {
        return new ManifestFile(string);
    }

    public static final ManifestFile fromDirectory(File file, File file2, String string, Hashtable hashtable, String string2, boolean bl) throws IOException {
        Vector vector = new Vector();
        ManifestFile.getFiles(file, vector);
        File file3 = file;
        if (file2 != null) {
            file3 = file2;
        }
        if (vector.size() < 1) {
            throw new IOException("Directory empty: " + file.getAbsolutePath());
        }
        ManifestFileRecord[] manifestFileRecordArray = new ManifestFileRecord[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            File file4 = (File)vector.elementAt(n);
            String string3 = "";
            int n2 = file4.getName().lastIndexOf(".");
            if (n2 > -1 && n2 < file4.getName().length() - 1) {
                string3 = file4.getName().substring(n2 + 1);
            }
            String string4 = MimeTypeUtils.getMimeType((String)string3);
            if (bl && string4 == null) {
                throw new IOException("Can't guess mime type: " + ((File)vector.elementAt(n)).getAbsolutePath());
            }
            if (string4 == null) {
                string4 = DEFAULT_MIME_TYPE;
            }
            String string5 = ManifestFile.getRelativeName(file3, file4);
            String string6 = "freenet:CHK@";
            if (string2 != null) {
                string6 = string2 + "/" + string5;
            }
            manifestFileRecordArray[n] = new ManifestFileRecord(string6, string5, string4);
            ++n;
        }
        return new ManifestFile(manifestFileRecordArray, null, string, hashtable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ManifestFile segmentFile(String string, String string2, String string3, long l, boolean bl) throws IOException {
        long l2;
        File file = new File(string);
        if (!file.exists()) throw new IOException("Directory doesn't exist: " + string);
        if (!file.isDirectory()) {
            throw new IOException("Directory doesn't exist: " + string);
        }
        File file2 = new File(string, string2);
        System.err.println("file.exists():" + file2.exists());
        System.err.println("file.length();" + file2.length());
        if (!file2.exists()) throw new IOException("Can't read input file: " + file2.getAbsolutePath());
        if (file2.length() < 1L) {
            throw new IOException("Can't read input file: " + file2.getAbsolutePath());
        }
        String string4 = file2.getName();
        if (string4.lastIndexOf(".") != -1) {
            string4 = string4.substring(0, string4.lastIndexOf("."));
        }
        String string5 = file2.getParent();
        File file3 = new File(string5);
        if (string4 == null) throw new IOException("Couldn't create segment directory.");
        if (file3 == null) throw new IOException("Couldn't create segment directory.");
        if (string5 == null) throw new IOException("Couldn't create segment directory.");
        if (string4.equals("")) {
            throw new IOException("Couldn't create segment directory.");
        }
        File file4 = new File(file3, string4 + File.separator + "segments");
        file4.mkdirs();
        if (!file4.exists()) throw new IOException("Couldn't create segment directory: " + file4.getAbsolutePath());
        if (!file4.isDirectory()) {
            throw new IOException("Couldn't create segment directory: " + file4.getAbsolutePath());
        }
        long l3 = file2.length();
        if (l3 % (l2 = l3 / l) != 0L) {
            ++l2;
        }
        ManifestFileRecord[] manifestFileRecordArray = new ManifestFileRecord[(int)l2];
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file2);
                int n = 0;
                while ((long)n < l2) {
                    File file5;
                    block20: {
                        Object var29_25;
                        file5 = new File(file4, Integer.toString(n));
                        FileOutputStream fileOutputStream = null;
                        try {
                            try {
                                long l4;
                                fileOutputStream = new FileOutputStream(file5);
                                for (long i = 0L; i < l; i += l4) {
                                    long l5 = l - i;
                                    if (l5 > 1024L) {
                                        l5 = 1024L;
                                    }
                                    if ((l4 = (long)fileInputStream.read(byArray, 0, (int)l5)) != -1L) {
                                        fileOutputStream.write(byArray, 0, (int)l4);
                                        if (l4 == l5) continue;
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                ManifestFile.closeIgnoringE(fileOutputStream);
                                fileOutputStream = null;
                                throw iOException;
                            }
                            var29_25 = null;
                            if (fileOutputStream == null) break block20;
                        }
                        catch (Throwable throwable) {
                            var29_25 = null;
                            if (fileOutputStream == null) throw throwable;
                            fileOutputStream.close();
                            throw throwable;
                        }
                        fileOutputStream.close();
                    }
                    String string6 = file5.getCanonicalPath().substring(file.getCanonicalPath().length() + 1);
                    manifestFileRecordArray[n] = new ManifestFileRecord("freenet:CHK@", string6, string3);
                    ++n;
                }
            }
            catch (IOException iOException) {
                ManifestFile.closeIgnoringE(fileInputStream);
                fileInputStream = null;
                throw iOException;
            }
            Object var31_27 = null;
            if (fileInputStream == null) return new ManifestFile(manifestFileRecordArray, string2, null, null);
        }
        catch (Throwable throwable) {
            Object var31_28 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return new ManifestFile(manifestFileRecordArray, string2, null, null);
    }

    public static final void concatinateTo(String string, ManifestFileRecord[] manifestFileRecordArray, String string2, boolean bl) throws IOException {
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream(string + string2);
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            int n2;
            object = new FileInputStream(string + manifestFileRecordArray[n].getFileName());
            while ((n2 = ((FileInputStream)object).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
                if (n2 == byArray.length) continue;
            }
            ((FileInputStream)object).close();
            ++n;
        }
        fileOutputStream.close();
        if (bl) {
            String string3;
            object = new File(string + manifestFileRecordArray[0].getFileName()).getParent();
            n = 0;
            while (n < manifestFileRecordArray.length) {
                File file = new File(string + manifestFileRecordArray[n].getFileName());
                string3 = file.getParent();
                if (string3 == null || object == null) {
                    object = null;
                } else if (!string3.equals(object)) {
                    object = null;
                }
                file.delete();
                ++n;
            }
            if (object != null) {
                File file = new File((String)object);
                string3 = file.getParent();
                if (file.delete() && string3 != null) {
                    new File(string3).delete();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ManifestFile readFromMapFile(String string, String string2, boolean bl) throws IOException {
        ManifestFile manifestFile;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            manifestFile = ManifestFile.createFromMSKMapFile(string2, bl, fileInputStream);
            Object var6_5 = null;
            if (fileInputStream == null) return manifestFile;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
            return manifestFile;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifestFile;
    }

    public static final Hashtable parseVariables(Params params, int n, Hashtable hashtable, boolean bl) throws IOException {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (hashtable != null) {
            String string = params.getParam("privateKeyFile", null);
            ManifestFile.readPrivateKeyFile(string, hashtable2, hashtable);
        }
        if (bl) {
            return hashtable2;
        }
        int n2 = n;
        while (n2 < params.getNumArgs()) {
            String string = params.getArg(n2);
            int n3 = (string = string.trim()).indexOf("=");
            if (n3 > 1 && n3 < string.length()) {
                String string2 = string.substring(0, n3).trim();
                String string3 = "";
                if (n3 < string.length() - 1) {
                    string3 = string.substring(n3 + 1).trim();
                }
                if (string2.equals("") || hashtable2.get(string2) != null && hashtable.get(string2) == null) {
                    throw new IllegalArgumentException("Bad variable definition on command line: " + string);
                }
                hashtable2.put(string2, string3);
            }
            ++n2;
        }
        return hashtable2;
    }

    public static final String getRelativeName(File file, File file2) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        int n = string2.indexOf(string);
        if (n != 0 || string.length() >= string2.length()) {
            System.err.println("dirPath: " + string);
            System.err.println("filePath: " + string2);
            throw new IOException("Illegal file name" + file2.getAbsolutePath());
        }
        return string2.substring(string.length() + 1).replace(File.separatorChar, '/');
    }

    public static final void dumpManifest(ManifestFileRecord[] manifestFileRecordArray) {
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            System.out.println("------------------------------------------------------------");
            System.out.println("URI     : " + manifestFileRecordArray[n].getFreenetURI());
            System.out.println("fileName: " + manifestFileRecordArray[n].getFileName());
            System.out.println("mimeType: " + manifestFileRecordArray[n].getMimeType());
            System.out.println("------------------------------------------------------------");
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void readPrivateKeyFile(String string, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if ((string2 = string2.trim()).equals("")) {
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    if (string2.startsWith("//")) {
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    int n = string2.indexOf("=");
                    if (n <= 1 || n >= string2.length()) throw new IllegalArgumentException("Bad variable definition in key file: " + string2);
                    String string3 = string2.substring(0, n).trim();
                    if (string3.toLowerCase().indexOf("ssk_key") == -1) {
                        throw new IllegalArgumentException("Only private SSK keys should be defined in the key file: " + string2);
                    }
                    String string4 = "";
                    if (n < string2.length() - 1) {
                        string4 = string2.substring(n + 1).trim();
                    }
                    if (string3.equals("") || hashtable.get(string3) != null || string4.equals("")) {
                        throw new IllegalArgumentException("Bad variable definition in key file: " + string2);
                    }
                    if (hashtable2.get(string3) == null) {
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    hashtable.put(string3, string4);
                    string2 = bufferedReader.readLine();
                }
            }
            catch (RuntimeException runtimeException) {
                ManifestFile.closeIgnoringE(bufferedReader);
                bufferedReader = null;
                throw runtimeException;
            }
            catch (IOException iOException) {
                ManifestFile.closeIgnoringE(bufferedReader);
                bufferedReader = null;
                throw iOException;
            }
            Object var9_10 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    private static final void getFiles(File file, Vector vector) {
        Object object;
        int n;
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return file2.isFile() && file2.length() > 0L;
            }
        });
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                object = new File(file, stringArray[n]);
                if (!vector.contains(object)) {
                    vector.add(object);
                }
                ++n;
            }
        }
        if ((object = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                System.err.println("examined: " + file2.getAbsolutePath());
                return file2.isDirectory();
            }
        })) == null) {
            return;
        }
        n = 0;
        while (n < ((String[])object).length) {
            ManifestFile.getFiles(new File(file, object[n]), vector);
            ++n;
        }
    }

    private ManifestFile(BufferedReader bufferedReader) throws IOException {
        this.readDirectives(bufferedReader);
        this.rawRecords = ManifestFile.readRecords(bufferedReader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ManifestFile(String string) throws IOException {
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
                this.readDirectives(bufferedReader);
                this.rawRecords = ManifestFile.readRecords(bufferedReader);
            }
            catch (IOException iOException) {
                ManifestFile.closeIgnoringE(bufferedReader);
                bufferedReader = null;
                throw iOException;
            }
            Object var6_4 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ManifestFile createFromMSKMapFile(String string, boolean bl, InputStream inputStream) throws IOException {
        Object object;
        String string2 = string + "//";
        if (string2.toLowerCase().startsWith("freenet:")) {
            string2 = "freenet:MSK@" + string2.substring(8);
        }
        ReadInputStream readInputStream = null;
        try {
            readInputStream = new ReadInputStream(inputStream);
            if (!readInputStream.readTo('\n', '\r').equals("Mapfile")) {
                throw new IOException("Syntax error in MSK map file!");
            }
            FieldSet fieldSet = new FieldSet();
            if (!fieldSet.parseFields(readInputStream, '\n', '\r', '=', '\u0000').equals("End")) {
                throw new IOException("Syntax error in MSK map file!");
            }
            FieldSet fieldSet2 = new FieldSet();
            fieldSet2.parseFields(readInputStream, '\n', '\r', '=', '\u0000');
            int n = 0;
            Enumeration enumeration = fieldSet2.keys();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            if (n < 1) {
                throw new IOException("No files listed in MSK map file!");
            }
            ManifestFileRecord[] manifestFileRecordArray = new ManifestFileRecord[n];
            int n2 = 0;
            Enumeration enumeration2 = fieldSet2.keys();
            while (enumeration2.hasMoreElements()) {
                object = (String)enumeration2.nextElement();
                if (object == null) {
                    throw new IOException("Syntax error in MSK map file!");
                }
                String string3 = fieldSet2.get((String)object);
                if (string3 == null) {
                    throw new IOException("Syntax error in MSK mapfile!");
                }
                String string4 = string3;
                if (bl) {
                    string4 = string2 + ((String)object).trim();
                }
                manifestFileRecordArray[n2] = new ManifestFileRecord(string4, ((String)object).trim(), "*");
                ++n2;
            }
            object = new ManifestFile(manifestFileRecordArray, null, string, null);
            Object var16_15 = null;
            if (readInputStream == null) return object;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (readInputStream == null) throw throwable;
            try {
                readInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            readInputStream.close();
            return object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private static final ManifestFileRecord readRecord(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        String[] stringArray = new String[3];
        int n = 0;
        while (string != null) {
            if ((string = string.trim()).equals("")) {
                string = bufferedReader.readLine();
                continue;
            }
            if (string.startsWith("//")) {
                string = bufferedReader.readLine();
                continue;
            }
            if (string.startsWith("!")) {
                throw new IOException("Manifest syntax error: Directive line outside of directive block.");
            }
            stringArray[n++] = string;
            if (n > 2) break;
            string = bufferedReader.readLine();
        }
        if (n == 0) {
            return null;
        }
        if (n != 3) {
            throw new IOException("Manifest syntax error: Incomplete Manifest file record.");
        }
        return new ManifestFileRecord(stringArray[0], stringArray[1], stringArray[2]);
    }

    private static final ManifestFileRecord[] readRecords(BufferedReader bufferedReader) throws IOException {
        Vector<ManifestFileRecord> vector = new Vector<ManifestFileRecord>();
        ManifestFileRecord manifestFileRecord = ManifestFile.readRecord(bufferedReader);
        while (manifestFileRecord != null) {
            vector.addElement(manifestFileRecord);
            manifestFileRecord = ManifestFile.readRecord(bufferedReader);
        }
        Object[] objectArray = new ManifestFileRecord[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final String[] getVarNames() {
        String[] stringArray = new String[this.vars.size()];
        Enumeration enumeration = this.vars.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    private static final String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string.equals("") || string2.equals("")) {
            return string;
        }
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 != -1 && n < string.length()) {
            String string4 = "";
            if (n2 > 0) {
                string4 = string.substring(0, n2);
            }
            String string5 = "";
            if (n2 + string2.length() < string.length()) {
                string5 = string.substring(n2 + string2.length());
            }
            string = string4 + string3 + string5;
            n = string4.length() + string3.length();
            n2 = string.indexOf(string2, n);
        }
        return string;
    }

    private void checkForIllegalReferences() throws IOException {
        String[] stringArray = this.getVarNames();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (((String)this.vars.get(stringArray[n])).indexOf(stringArray[n2]) != -1) {
                    throw new IOException("Manifest syntax error: variable definitions can't reference variables.");
                }
                ++n2;
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readDirectives(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        boolean bl = false;
        this.concatinateTo = null;
        while (string != null) {
            if ((string = string.trim()).equals("")) {
                string = bufferedReader.readLine();
                continue;
            }
            if (string.startsWith("//")) {
                string = bufferedReader.readLine();
                continue;
            }
            if (string.startsWith("!START_DIRECTIVES")) {
                if (bl) {
                    throw new IOException("Manifest syntax error: Multiple !START_DIRECTIVE lines.");
                }
                bl = true;
            } else {
                if (string.startsWith("!END_DIRECTIVES")) {
                    if (!bl) {
                        throw new IOException("Manifest syntax error: Missing !START_DIRECTIVE line.");
                    }
                    this.checkForIllegalReferences();
                    return;
                }
                if (string.startsWith("!CONCATINATE_TO")) {
                    if (!bl) {
                        throw new IOException("Manifest syntax error: Missing !START_DIRECTIVE line.");
                    }
                    if (this.concatinateTo != null) {
                        throw new IOException("Sorry, only a single !CONCATINATE_TO line is supported. :-(");
                    }
                    if (string.length() > "!CONCATINATE_TO".length()) {
                        this.concatinateTo = string.substring("!CONCATINATE_TO".length()).trim();
                        if (this.concatinateTo.length() < 1) {
                            throw new IOException("Manifest syntax error: Bad !CONCATINATE_TO value.");
                        }
                    }
                } else if (string.startsWith("!MSK_URI")) {
                    if (!bl) {
                        throw new IOException("Manifest syntax error: Missing !START_DIRECTIVE line.");
                    }
                    if (this.rawMSKURI != null) {
                        throw new IOException("Sorry, only a single !MSK_URI line is supported. :-(");
                    }
                    if (string.length() > "!MSK_URI".length()) {
                        this.rawMSKURI = string.substring("!MSK_URI".length()).trim();
                        if (this.rawMSKURI.length() < 1) {
                            throw new IOException("Manifest syntax error: Bad !MSK_URI value.");
                        }
                    }
                } else if (string.startsWith("!UPDATE")) {
                    if (!bl) {
                        throw new IOException("Manifest syntax error: Missing !START_DIRECTIVE line.");
                    }
                    if (string.length() > "!UPDATE".length()) {
                        this.update = new Boolean(string.substring("!UPDATE".length()).trim());
                    }
                } else {
                    if (!string.startsWith("!")) throw new IOException("Manifest syntax error: Directive lines must start with !.");
                    int n = (string = string.substring(1)).indexOf("=");
                    if (n <= 1 || n >= string.length()) throw new IOException("Manifest syntax error: bad variable definition, " + string);
                    String string2 = string.substring(0, n).trim();
                    String string3 = "";
                    if (n < string.length() - 1) {
                        string3 = string.substring(n + 1).trim();
                    }
                    if (string2.equals("") || this.vars.get(string2) != null) {
                        throw new IOException("Manifest syntax error: bad variable definition, " + string);
                    }
                    this.vars.put(string2, string3);
                }
            }
            string = bufferedReader.readLine();
        }
        if (bl) throw new IOException("Manifest syntax error: Missing !END_DIRECTIVE line.");
        throw new IOException("Manifest syntax error: Missing !START_DIRECTIVE line.");
    }

    private static final void closeIgnoringE(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            System.err.println("ManifestFile.closeIgnoringE -- ignored: " + iOException);
        }
    }

    private static final void closeIgnoringE(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("ManifestFile.closeIgnoringE -- ignored: " + iOException);
        }
    }

    private static final void closeIgnoringE(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("ManifestFile.closeIgnoringE -- ignored: " + iOException);
        }
    }
}

