/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.cli;

import Freenet.Params;
import Freenet.client.ClientUtil;
import Freenet.client.FreenetURI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import relentless.gj.cli.CLIBase;
import relentless.gj.cli.ManifestFile;
import relentless.gj.cli.ManifestFileRecord;
import relentless.gj.client.InsertSlave;
import relentless.gj.client.batch.BatchInsertFailedEvent;
import relentless.gj.client.batch.BatchInsertRestartedEvent;
import relentless.gj.client.batch.BatchInsertStatusEvent;
import relentless.gj.client.batch.BatchInsertSucceededEvent;
import relentless.gj.client.batch.BatchInserter;
import relentless.gj.client.batch.BatchInserterListener;
import relentless.gj.client.batch.InsertTask;

public class PutFiles
extends CLIBase {
    private BatchInserter inserter = null;
    private BatchInserterListenerImpl listener = new BatchInserterListenerImpl();
    private static final int MAX_HTL = 100;
    private String rootDir = null;
    private int taskCount = 0;
    private Vector runningTasks = new Vector();
    private final int MAX_STATUSLIST = 5;
    private boolean autoRedirect = false;

    public PutFiles(Params params) throws IOException {
        super(params);
        this.defaultRetries = params.getint("retries", 0);
        this.retryHtlIncrement = params.getint("retryHtlIncrement", 0);
        int n = params.getint("simRequests", 1);
        if (n < 1) {
            n = 1;
        }
        this.inserter = new BatchInserter(this.clientFactory, params, n);
        this.inserter.addBatchInserterListener(this.listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ManifestFile InsertAll(String string, ManifestFile manifestFile, String[] stringArray, Hashtable hashtable) throws IOException {
        if (this.inserter.isRunning()) {
            throw new RuntimeException("assertion failure: inserter.isRunning()");
        }
        ManifestFileRecord[] manifestFileRecordArray = manifestFile.getRecords();
        if (manifestFileRecordArray.length < 1) {
            return null;
        }
        if (stringArray != null && stringArray.length != manifestFileRecordArray.length) {
            throw new IllegalArgumentException("chks.length != manifest.length");
        }
        this.rootDir = string;
        InsertInfo[] insertInfoArray = this.queueRequests(manifestFile);
        this.taskCount = insertInfoArray.length;
        this.inserter.start();
        BatchInserter batchInserter = this.inserter;
        // MONITORENTER : batchInserter
        while (this.taskCount > 0) {
            try {
                this.inserter.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.inserter.stop();
        while (this.inserter.isRunning()) {
            try {
                this.inserter.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.inserter.flush();
        // MONITOREXIT : batchInserter
        if (stringArray == null) return this.fixUpCHKs(insertInfoArray, manifestFile, hashtable);
        int n = 0;
        while (n < insertInfoArray.length) {
            stringArray[n] = insertInfoArray[n].getCHK();
            ++n;
        }
        return this.fixUpCHKs(insertInfoArray, manifestFile, hashtable);
    }

    public static final void printUsage() {
        System.out.println("PutFiles version: 0.16a");
        System.out.println("");
        System.out.println("usage:");
        System.out.println("java relentless.gj.cli.PutFiles manifest_file [variable defs]");
        System.out.println("java relentless.gj.cli.PutFiles -fromDir dir_name  [variable defs]");
        System.out.println("java relentless.gj.cli.PutFiles -splitFile file_name  [variable defs]");
        System.out.println("");
        System.out.println("Type:");
        System.out.println("java relentless.gj.cli.PutFiles --help");
        System.out.println("To get a much longer usage message.");
        System.out.println("");
    }

    public static final void printLongUsage() {
        System.out.println("PutFiles version: 0.16a");
        System.out.println("");
        System.out.println("PutFiles loads a list of files and their corresponding Freenet URIs");
        System.out.println("from a manifest file and inserts them into Freenet. ");
        System.out.println("");
        System.out.println("PutFiles also optionally supports inserting files directly without a");
        System.out.println("manifest file either, by recursing a directory or by splitting a");
        System.out.println("single large file into multiple pieces.");
        System.out.println("");
        System.out.println("java relentless.gj.cli.PutFiles manifest_file [variable defs]");
        System.out.println("java relentless.gj.cli.PutFiles -fromDir dir_name  [variable defs]");
        System.out.println("java relentless.gj.cli.PutFiles -splitFile file_name  [variable defs]");
        System.out.println("");
        System.out.println(" -rootDir         The directory to copy the subdirectory ");
        System.out.println("                  hierarchy specified by the manifest file");
        System.out.println("                  from.  Default is the current directory.");
        System.out.println("");
        System.out.println(" -simRequests n   Maximum number of simultaneous insert");
        System.out.println("                  requests. Default is 1.");
        System.out.println("                  ");
        System.out.println(" -failedFile      A file to dump the manifest entries of");
        System.out.println("                  failed requests into.");
        System.out.println("");
        System.out.println(" -retries n       The number of times to retry failed ");
        System.out.println("                  requests. Default is 0. Retrying is");
        System.out.println("                  EXPERIMENTAL at this point.");
        System.out.println("");
        System.out.println(" -retryHtlIncrement n ");
        System.out.println("                  The amount to increase the HTL by");
        System.out.println("                  every time a request is retried. ");
        System.out.println("                  The default is 0.");
        System.out.println("");
        System.out.println(" -cipherName      The name of the cipher to use when inserting.");
        System.out.println("                  The default is TwoFish.");
        System.out.println("");
        System.out.println(" -updatedManifestFile");
        System.out.println("                  A filename to write the updated manifest to.");
        System.out.println("                  This file can be used to extract the inserted");
        System.out.println("                  files using GetFiles.  It is only written if");
        System.out.println("                  all files insert successfully.");
        System.out.println("");
        System.out.println(" -justCheckManifest yes/no");
        System.out.println("                  If this is yes the manifest and command line");
        System.out.println("                  parameters are checked for errors but no files");
        System.out.println("                  are inserted.  The default is no.");
        System.out.println("");
        System.out.println(" -privateKeyFile name");
        System.out.println("                  If this option is specified, the flat file name");
        System.out.println("                  is checked for private SSK key variable values");
        System.out.println("                  when resolving variables.  This option is");
        System.out.println("                  provided so that you don't have to specify ");
        System.out.println("                  SSK private key values on the command line.");
        System.out.println("");
        System.out.println("DIRECTORY INSERTION:");
        System.out.println("When these options are used, no input manifest file");
        System.out.println("is specified on the command line.  ");
        System.out.println("");
        System.out.println("If SSK key variables are used in either the uriPrefix or the");
        System.out.println("mskURIValue, their private values must be specified either on");
        System.out.println("the command line or in the private key file.");
        System.out.println("");
        System.out.println(" -fromDir name    If this is set, a manifest file is created by");
        System.out.println("                  listing all the files in the name");
        System.out.println("                  directory and its subdirectories. This manifest");
        System.out.println("                  is used to insert all the files. ");
        System.out.println("");
        System.out.println(" -uriPrefix pref  An optional prefix used to construct URIs when");
        System.out.println("                  the fromDir option is specified.  This value");
        System.out.println("                  is resolved against any defined variables and");
        System.out.println("                  prepended to the relative path of each file to");
        System.out.println("                  construct the URI.  If this is not set simple CHK");
        System.out.println("                  URIs are created.");
        System.out.println("");
        System.out.println(" -strictMimeCheck yes/no");
        System.out.println("                  When fromDir is specified and this is yes");
        System.out.println("                  PutFiles aborts if it can't guess the mime type ");
        System.out.println("                  of all the files from their extensions.");
        System.out.println("                  The default is no.");
        System.out.println("");
        System.out.println(" -mskURIValue name");
        System.out.println("                  When fromDir is specified, this can be used to");
        System.out.println("                  set the URI that the MSK will be inserted under.  ");
        System.out.println("                  If this is not set, no MSK mapfile is created.");
        System.out.println("");
        System.out.println(" -mskIndex name   When fromDir is specified, this can be used to");
        System.out.println("                  set the default index field of the inserted MSK.");
        System.out.println("                  The default is not to insert a default index field.");
        System.out.println(" ");
        System.out.println("EXPERIMENTAL FILE SEGMENTING SUPPORT");
        System.out.println("When these options are used, no input manifest file");
        System.out.println("is specified on the command line.");
        System.out.println("");
        System.out.println(" -splitFile name  If this is set, the specified file is broken into");
        System.out.println("                  segments and a manifest is generated which lists");
        System.out.println("                  all of the parts. This manifest is used to insert");
        System.out.println("                  all of the segments. ");
        System.out.println("");
        System.out.println(" -splitType type  When splitFile is specified, this option can be");
        System.out.println("                  use to specify the mime type of the segments.");
        System.out.println("                  The default is application/octet-stream.");
        System.out.println("");
        System.out.println(" -segmentSize n   When splitFile is specified, this option can be");
        System.out.println("                  used to set the segment size in bytes. The default");
        System.out.println("                  is 131072.  ");
        System.out.println("   ");
        System.out.println("note: The \"standard\" options may also be used to set ");
        System.out.println("      Freenet parameters.");
        System.out.println("      e.g. -listenPort, -htl, etc.");
        System.out.println(" ");
        System.out.println("note: If mskURIValue is an SSK, the \"standard\" DBR update options");
        System.out.println("      -update, -inc, -baseline, -future and -past can be used to");
        System.out.println("       insert the MSK under a DBR update.");
        System.out.println(" ");
        System.out.println("example:");
        System.out.println("java relentless.gj.cli.PutFiles -simRequests 5 -rootDir /tmp/ files.txt");
        System.out.println("");
        System.out.println("Insert all the files in the manifest file files.txt using up to 5");
        System.out.println("simultaneous insert threads.  Read the files listed in files.txt");
        System.out.println("from the /tmp subdirectory.");
        System.out.println("    ");
        System.out.println("");
        System.out.println("example:");
        System.out.println("java relentless.gj.cli.PutFiles -simRequests 5  ");
        System.out.println("                                       -fromDir work/test/ ");
        System.out.println("                                       -updatedManifestFile work_dir.txt");
        System.out.println("                                       -mskURIValue CHK@");
        System.out.println("");
        System.out.println("Inserts all the files in the work/test subdirectory using up to 5");
        System.out.println("simultaneous insert threads. Write the resulting manifest file to");
        System.out.println("the file work_dir.txt.  Note that an MSK mapfile will be inserted");
        System.out.println("to a CHK key, which lists all of the files in the work/test");
        System.out.println("directory.  The CHK will be written to stdout and also into the");
        System.out.println("MSK_NAME field of work_dir.txt.");
        System.out.println("");
        System.out.println("A NOTE ON INSERTING SSK URIs...");
        System.out.println("One of my objectives in writing PutFiles was to make sure that private");
        System.out.println("SSK keys are never read from the manifest file so that");
        System.out.println("you don't give them out by accident.  ");
        System.out.println("");
        System.out.println("SSK URIs must be defined using variables in the manifest file.");
        System.out.println("Variable names for SSK keys must contain the substring \"ssk_key\"");
        System.out.println("Only the public value of SSK variables should be listed");
        System.out.println("in the manifest file. The private value can be specified, either on");
        System.out.println("the command line or in the private key file.");
        System.out.println("");
        System.out.println("Here is an example of a manifest file that uses SSKs:");
        System.out.println("");
        System.out.println("|--snip foo.txt starts on next line --|");
        System.out.println("!START_DIRECTIVES");
        System.out.println("// This is the public key value.");
        System.out.println("!__my_ssk_key__=enI8YFo3gj8UVh-Au0HpKMftf6QQAgE");
        System.out.println("!END_DIRECTIVES");
        System.out.println("freenet:SSK@__my_ssk_key__/deep_meditations.html");
        System.out.println("thoughts/deep/deep_meditations.html");
        System.out.println("text/html");
        System.out.println("freenet:SSK@__my_ssk_key__/frivolous_musings.html");
        System.out.println("thoughts/shallow/frivolous_musings.html");
        System.out.println("text/html");
        System.out.println("|--snip foo.txt ends on prev line --|");
        System.out.println("");
        System.out.println("Assuming that the current directory contains the");
        System.out.println("thoughts subdirectory, the files specified by ");
        System.out.println("the manifest file foo.txt could be inserted with");
        System.out.println("the following command line:");
        System.out.println("");
        System.out.println("java relentless.gj.cli.PutFiles foo.txt __my_ssk_key__=PRIVATE");
        System.out.println("");
        System.out.println("Where the real private key value is substituted");
        System.out.println("for PRIVATE. You might also need to quote the variable");
        System.out.println("override depending on your OS ");
        System.out.println("");
    }

    private static final String extractSSKKey(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string != null && (n2 = string.toLowerCase().indexOf("ssk@")) != -1 && (n = string.indexOf("/", n2)) > n2 + 4) {
            string2 = string.substring(n2 + 4, n).trim();
        }
        return string2;
    }

    private static final Hashtable getReferencedKeys(Params params, int n, String string, String string2) throws IOException {
        Object object;
        Object object2;
        String string3;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        System.err.println("PutFiles.getReferencedKeys -- mskURIValue: " + string);
        String string4 = PutFiles.extractSSKKey(string);
        System.err.println("PutFiles.getReferencedKeys -- mskPrivateKey: " + string4);
        if (string4 != null) {
            if (string4.toLowerCase().indexOf("ssk_key") != -1) {
                hashtable.put(string4, "");
            } else {
                hashtable.put("ssk_key_cli0", string4);
            }
        }
        if ((string3 = PutFiles.extractSSKKey(string2)) != null) {
            if (string3.toLowerCase().indexOf("ssk_key") != -1) {
                hashtable.put(string3, "");
            } else {
                hashtable.put("ssk_key_cli1", string3);
            }
        }
        Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!hashtable.get(object2).equals("")) continue;
            hashtable2.put(object2, "");
        }
        if (hashtable2.size() > 0) {
            object2 = ManifestFile.parseVariables(params, n, hashtable2, false);
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                hashtable.put(string5, (String)((Hashtable)object2).get(string5));
            }
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (!hashtable.get(object).equals("")) continue;
            System.err.println("SSK private keys must be overridden on the command line\nor in the private key file.\nPlease override: " + (String)object);
            System.exit(-1);
        }
        return hashtable;
    }

    private static final String swapInVar(Hashtable hashtable, String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            int n = string.indexOf(string3);
            if (n == -1) continue;
            String string4 = "";
            if (n > 0) {
                string4 = string.substring(0, n);
            }
            String string5 = "";
            if (n + string3.length() < string.length()) {
                string5 = string.substring(n + string3.length());
            }
            return string4 + string2 + string5;
        }
        return string;
    }

    private InsertInfo[] queueRequests(ManifestFile manifestFile) {
        ManifestFileRecord[] manifestFileRecordArray = manifestFile.getRecords();
        InsertInfo[] insertInfoArray = new InsertInfo[manifestFileRecordArray.length];
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            insertInfoArray[n] = new InsertInfo(manifestFileRecordArray[n], this.htl, this.defaultRetries, this.autoRedirect);
            this.inserter.queue(insertInfoArray[n]);
            ++n;
        }
        return insertInfoArray;
    }

    private ManifestFile fixUpCHKs(InsertInfo[] insertInfoArray, ManifestFile manifestFile, Hashtable hashtable) throws IOException {
        ManifestFileRecord[] manifestFileRecordArray = manifestFile.getRawRecords();
        if (manifestFileRecordArray.length != insertInfoArray.length) {
            throw new IllegalArgumentException();
        }
        Vector<ManifestFileRecord> vector = new Vector<ManifestFileRecord>();
        int n = 0;
        while (n < insertInfoArray.length) {
            if (!insertInfoArray[n].getSucceeded()) {
                vector.addElement(manifestFileRecordArray[n]);
            } else if (insertInfoArray[n].getRecord().getFreenetURI().toLowerCase().startsWith("freenet:chk@")) {
                manifestFileRecordArray[n].setFreenetURI(insertInfoArray[n].getRecord().getFreenetURI());
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new ManifestFileRecord[vector.size()];
        vector.copyInto(objectArray);
        ManifestFile manifestFile2 = manifestFile.copy((ManifestFileRecord[])objectArray);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            manifestFile2.getVars().put(string, InsertSlave.getPublicSSKKey((String)hashtable.get(string)));
        }
        return manifestFile2;
    }

    public final synchronized String insertMSK(String string, String[] stringArray, String[] stringArray2, String string2) throws IOException {
        MSKInsertTask mSKInsertTask;
        if (this.inserter.isRunning()) {
            throw new RuntimeException("assertion failure: inserter.isRunning()");
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("filenames.length != chkList.length");
        }
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("chkList.length == 0");
        }
        if (string2 == null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().equals("index.html")) {
                    string2 = stringArray[n];
                    System.err.println("WARNING: MSK default index not set, using: " + string2);
                    break;
                }
                ++n;
            }
        }
        if (!BatchInserter.waitForTask(this.inserter, mSKInsertTask = new MSKInsertTask(string, stringArray, stringArray2, string2, this.htl, this.defaultRetries), true)) {
            return null;
        }
        return mSKInsertTask.getFinalURI();
    }

    private final synchronized String insertMSK(String string, String[] stringArray, String string2, ManifestFileRecord[] manifestFileRecordArray) throws IOException {
        if (this.inserter.isRunning()) {
            throw new RuntimeException("assertion failure: inserter.isRunning()");
        }
        if (manifestFileRecordArray.length != stringArray.length) {
            throw new IllegalArgumentException("manifest.length != chkList.length");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("chkList.length == 0");
        }
        String[] stringArray2 = new String[manifestFileRecordArray.length];
        int n = 0;
        while (n < manifestFileRecordArray.length) {
            stringArray2[n] = manifestFileRecordArray[n].getFileName();
            if (string2 == null && stringArray2[n].toLowerCase().equals("index.html")) {
                string2 = stringArray2[n];
                System.err.println("WARNING: MSK default index not set, using: " + string2);
            }
            ++n;
        }
        MSKInsertTask mSKInsertTask = new MSKInsertTask(string, stringArray2, stringArray, string2, this.htl, this.defaultRetries);
        if (!BatchInserter.waitForTask(this.inserter, mSKInsertTask, true)) {
            return null;
        }
        return mSKInsertTask.getFinalURI();
    }

    private String getStatusMsg() {
        String string = "";
        int n = 0;
        while (n < this.runningTasks.size()) {
            InsertTask insertTask = (InsertTask)this.runningTasks.elementAt(n);
            if (this.runningTasks.size() <= 5) {
                string = string + "STILL WORKING: " + PutFiles.getDisplayName(insertTask) + "\n";
            }
            ++n;
        }
        if (this.runningTasks.size() <= 5) {
            return "STATUS: " + this.runningTasks.size() + " working, " + this.inserter.queued() + " queued.\n" + string;
        }
        return "STATUS: " + this.runningTasks.size() + " working, " + this.inserter.queued() + " queued.";
    }

    private static final Object getDisplayName(InsertTask insertTask) {
        if (insertTask instanceof MSKInsertTask) {
            return "[MSK map file]";
        }
        return insertTask.getSourceData();
    }

    private void writeExitMsg(EventObject eventObject) {
        if (eventObject instanceof BatchInsertSucceededEvent) {
            System.out.println("SUCCEEDED: " + PutFiles.getDisplayName(((BatchInsertSucceededEvent)eventObject).getTask()));
        } else {
            System.out.println("FAILED: " + PutFiles.getDisplayName(((BatchInsertFailedEvent)eventObject).getTask()));
            Exception[] exceptionArray = ((BatchInsertFailedEvent)eventObject).getExceptions();
            if (exceptionArray != null) {
                int n = 0;
                while (n < exceptionArray.length) {
                    System.out.println("   " + exceptionArray[n].toString());
                    System.out.println("----------------------------------------");
                    exceptionArray[n].printStackTrace();
                    System.out.println("----------------------------------------");
                    ++n;
                }
            }
        }
    }

    private void handleInsertInfoSuccess(BatchInsertSucceededEvent batchInsertSucceededEvent) {
        if (!(batchInsertSucceededEvent.getTask() instanceof InsertInfo)) {
            return;
        }
        InsertInfo insertInfo = (InsertInfo)batchInsertSucceededEvent.getTask();
        try {
            String string = null;
            if (!ClientUtil.isMSK((String)insertInfo.getURI())) {
                FreenetURI freenetURI = new FreenetURI(batchInsertSucceededEvent.getFinalURI());
                if (freenetURI.getKeyType().equals("CHK")) {
                    string = freenetURI.toString();
                } else if (batchInsertSucceededEvent.getRedirectCHK() != null) {
                    string = new FreenetURI(batchInsertSucceededEvent.getRedirectCHK()).toString();
                }
            } else if (batchInsertSucceededEvent.getRedirectCHK() != null) {
                string = new FreenetURI(batchInsertSucceededEvent.getRedirectCHK()).toString();
            }
            if (string == null) {
                insertInfo.setCHK(string);
            } else {
                insertInfo.setCHK(batchInsertSucceededEvent.getFinalURI());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ignored: " + malformedURLException);
        }
        insertInfo.getRecord().setFreenetURI(batchInsertSucceededEvent.getFinalURI());
        insertInfo.setSucceeded(true);
    }

    private void handleMSKInsertTaskSuccess(BatchInsertSucceededEvent batchInsertSucceededEvent) {
        if (!(batchInsertSucceededEvent.getTask() instanceof MSKInsertTask)) {
            return;
        }
        MSKInsertTask mSKInsertTask = (MSKInsertTask)batchInsertSucceededEvent.getTask();
        mSKInsertTask.setFinalURI(batchInsertSucceededEvent.getFinalURI());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] var0) {
        block40: {
            block39: {
                try {
                    block44: {
                        try {
                            block41: {
                                block42: {
                                    block43: {
                                        if (var0.length == 1 && var0[0].equals("--help")) {
                                            PutFiles.printLongUsage();
                                            var32_1 = null;
                                            break block39;
                                        }
                                        var1_11 = CLIBase.getParams("mftools.ini", var0);
                                        var2_13 = null;
                                        var3_14 = var1_11.getParam("rootDir", "");
                                        var4_15 = var1_11.getParam("failedFile", null);
                                        var5_16 = var1_11.getParam("updatedManifestFile", null);
                                        var6_17 = var1_11.getboolean("justCheckManifest", false);
                                        var7_18 = var1_11.getParam("fromDir", null);
                                        var8_19 = var1_11.getParam("uriPrefix", null);
                                        var9_20 = var1_11.getboolean("strictMimeCheck", false);
                                        var10_21 = var1_11.getParam("mskURIValue", null);
                                        var11_22 = var1_11.getParam("mskIndex", null);
                                        var12_23 = var1_11.getParam("splitFile", null);
                                        var13_24 = var1_11.getParam("splitType", "application/octet-stream");
                                        var14_25 = var1_11.getint("segmentSize", 131072);
                                        var15_26 = var1_11.getint("simRequests", 1);
                                        if (var1_11.getNumArgs() < 1 && var12_23 == null && var7_18 == null) {
                                            PutFiles.printUsage();
                                            break block40;
                                        }
                                        var16_27 = new File(var3_14);
                                        if ((var3_14 = var16_27.getAbsolutePath()).charAt(var3_14.length() - 1) != File.separatorChar) {
                                            var3_14 = var3_14 + File.separatorChar;
                                        }
                                        CLIBase.createTmpDir(var3_14);
                                        var17_28 = null;
                                        var18_29 = null;
                                        if (var12_23 != null) {
                                            var17_28 = ManifestFile.segmentFile(var3_14, var12_23, var13_24, var14_25, false);
                                            var2_13 = "[Created by splitting file: " + var12_23 + "]";
                                        } else if (var7_18 != null) {
                                            var18_29 = PutFiles.getReferencedKeys(var1_11, 0, var10_21, var8_19);
                                            var19_30 = ManifestFile.parseVariables(var1_11, 0, null, false);
                                            var20_31 = var18_29.keys();
                                            while (true) {
                                                if (!var20_31.hasMoreElements()) {
                                                    var10_21 = PutFiles.swapInVar(var18_29, var10_21);
                                                    var8_19 = PutFiles.swapInVar(var18_29, var8_19);
                                                    var21_32 /* !! */  = new File(var7_18);
                                                    var22_33 = null;
                                                    if (!var3_14.equals("")) {
                                                        var22_33 = new File(var3_14);
                                                    }
                                                    var3_14 = var22_33 == null ? var21_32 /* !! */ .getAbsolutePath() : var22_33.getAbsolutePath();
                                                }
                                                var21_32 /* !! */  = (String)var20_31.nextElement();
                                                var19_30.put(var21_32 /* !! */ , var18_29.get(var21_32 /* !! */ ));
                                            }
                                            var17_28 = ManifestFile.fromDirectory((File)var21_32 /* !! */ , (File)var22_33, var10_21, (Hashtable)var19_30, var8_19, var9_20);
                                            var2_13 = "[Created by listing dir: " + var7_18 + "]";
                                        } else {
                                            var18_29 = PutFiles.getReferencedKeys(var1_11, 1, var10_21, var8_19);
                                            var2_13 = var1_11.getArg(0);
                                            var17_28 = ManifestFile.read(var2_13);
                                            if (var10_21 != null) {
                                                var10_21 = PutFiles.swapInVar(var18_29, var10_21);
                                                var17_28.setRawMSKURI(var10_21);
                                            }
                                            var19_30 = ManifestFile.getSSKs(var17_28.getVars());
                                            var17_28.doParanoidSSKInsertChecks((Hashtable)var19_30);
                                            var20_31 = var19_30.keys();
                                            while (true) {
                                                if (!var20_31.hasMoreElements()) break;
                                                var21_32 /* !! */  = (String)var20_31.nextElement();
                                                if (var18_29.get(var21_32 /* !! */ ) != null) continue;
                                                var22_33 = ManifestFile.parseVariables(var1_11, 0, var17_28.getVars(), true);
                                                if (var22_33.get(var21_32 /* !! */ ) == null) {
                                                    System.err.println("SSK private keys must be overridden on the command line\nor in the private key file.\nPlease override: " + (String)var21_32 /* !! */ );
                                                    System.exit(-1);
                                                }
                                                var18_29.put(var21_32 /* !! */ , var22_33.get(var21_32 /* !! */ ));
                                            }
                                            var21_32 /* !! */  = ManifestFile.parseVariables(var1_11, 0, null, false);
                                            var22_33 = var21_32 /* !! */ .keys();
                                            while (true) {
                                                if (!var22_33.hasMoreElements()) {
                                                    var23_34 = var18_29.keys();
                                                    break;
                                                }
                                                var23_34 = (String)var22_33.nextElement();
                                                var17_28.getVars().put(var23_34, var21_32 /* !! */ .get(var23_34));
                                            }
                                            while (var23_34.hasMoreElements()) {
                                                var24_35 = (ManifestFileRecord[])var23_34.nextElement();
                                                var17_28.getVars().put(var24_35, var18_29.get(var24_35));
                                            }
                                        }
                                        System.out.println("manifest file         : " + var2_13);
                                        System.out.println("root input dir        : " + var3_14);
                                        System.out.println("Simultaneous Requests : " + var15_26);
                                        ManifestFile.dumpManifest(var17_28.getRecords());
                                        if (var6_17) {
                                            System.out.println("No errors detected in manifest.  Exiting...");
                                            System.exit(0);
                                        }
                                        var19_30 = new PutFiles(var1_11);
                                        var20_31 = var17_28.getMSKURI();
                                        var21_32 /* !! */  = null;
                                        if (var20_31 != null) {
                                            var21_32 /* !! */  = new String[var17_28.getRecords().length];
                                        }
                                        var22_33 = var19_30.InsertAll(var3_14, var17_28, var21_32 /* !! */ , var18_29);
                                        var23_34 = var18_29.keys();
                                        while (true) {
                                            if (!var23_34.hasMoreElements()) {
                                                if (var22_33 != null) break block41;
                                                System.out.println("");
                                                System.out.println("All files were inserted successfully.");
                                                if (var20_31 == null) break block42;
                                                if (var20_31.toLowerCase().indexOf("ssk@") != -1) {
                                                    var24_35 = var1_11.getParam("baseline");
                                                    var25_36 = var1_11.getlong("increment", 0L);
                                                    var27_38 = var1_11.getlong("future", -var1_11.getlong("past", 0L));
                                                }
                                                break block43;
                                            }
                                            var24_35 = (String)var23_34.nextElement();
                                            var17_28.getVars().put(var24_35, InsertSlave.getPublicSSKKey((String)var18_29.get(var24_35)));
                                        }
                                        var29_39 = var1_11.getboolean("update", var24_35 != null || var25_36 != 0L || var27_38 != 0L || var17_28.getUpdate() != false);
                                        if (var29_39) {
                                            if (var24_35 == null) {
                                                var24_35 = "20000101000000";
                                            }
                                            if (var25_36 == 0L) {
                                                var25_36 = 86400L;
                                            }
                                            var30_40 = ClientUtil.dateURI((FreenetURI)new FreenetURI((String)var20_31), (String)var24_35, (long)var25_36, (long)var27_38);
                                            var20_31 = var30_40.toString();
                                            var17_28.setUpdate(true);
                                        }
                                    }
                                    System.out.println("Inserting MSK for manifest: " + (String)var20_31 + "...");
                                    System.out.println("Please be patient, this may take a while.");
                                    var24_35 = super.insertMSK((String)var20_31, var21_32 /* !! */ , var11_22, var17_28.getRecords());
                                    if (var24_35 != null) {
                                        System.out.println("Inserted MSK for manifest: " + (String)var24_35);
                                        if (var24_35.toLowerCase().startsWith("freenet:chk@")) {
                                            var17_28.setRawMSKURI((String)var24_35);
                                        }
                                    } else {
                                        System.out.println("FAILED inserting MSK.");
                                    }
                                }
                                if (var5_16 != null) {
                                    var17_28.write(var5_16);
                                    System.out.println("Wrote updated manifest file to: " + var5_16);
                                }
                                System.out.println("");
                                break block44;
                            }
                            var24_35 = var22_33.getRecords();
                            var25_37 = " these files";
                            if (((ManifestFileRecord[])var24_35).length == 1) {
                                var25_37 = " this file:";
                            }
                            System.out.println("");
                            System.out.println("Couldn't upload" + var25_37);
                            ManifestFile.dumpManifest((ManifestFileRecord[])var24_35);
                            System.out.println("");
                            if (var4_15 == null) break block44;
                            var22_33.write(var4_15);
                        }
                        catch (Exception var1_12) {
                            System.err.println("PutFiles FAILED:");
                            var1_12.printStackTrace();
                            var32_4 = null;
                            try {}
                            catch (IOException var33_9) {
                                return;
                            }
                            CLIBase.removeTmpDir();
                            return;
                        }
                    }
                    var32_3 = null;
                    try {
                        CLIBase.removeTmpDir();
                        return;
                    }
                    catch (IOException var33_8) {
                        return;
                    }
                }
                catch (Throwable var31_41) {
                    var32_5 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 1461->1467)] { 
lbl179:
                    // 1 sources

                    CLIBase.removeTmpDir();
                    throw var31_41;
lbl181:
                    // 1 sources

                    catch (IOException var33_10) {
                        // empty catch block
                    }
                    throw var31_41;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 1461->1467)] { 
lbl186:
            // 1 sources

            CLIBase.removeTmpDir();
            return;
lbl188:
            // 1 sources

            catch (IOException var33_6) {
                // empty catch block
            }
            return;
        }
        var32_2 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 1461->1467)] { 
lbl194:
        // 1 sources

        CLIBase.removeTmpDir();
        return;
lbl196:
        // 1 sources

        catch (IOException var33_7) {
            // empty catch block
        }
    }

    class BatchInserterListenerImpl
    implements BatchInserterListener {
        BatchInserterListenerImpl() {
        }

        public void succeeded(BatchInsertSucceededEvent batchInsertSucceededEvent) {
            PutFiles.this.handleInsertInfoSuccess(batchInsertSucceededEvent);
            PutFiles.this.handleMSKInsertTaskSuccess(batchInsertSucceededEvent);
            PutFiles.this.writeExitMsg(batchInsertSucceededEvent);
            PutFiles.this.taskCount--;
            Vector vector = PutFiles.this.runningTasks;
            synchronized (vector) {
                if (PutFiles.this.runningTasks.contains(batchInsertSucceededEvent.getTask())) {
                    PutFiles.this.runningTasks.removeElement(batchInsertSucceededEvent.getTask());
                    System.out.println(PutFiles.this.getStatusMsg());
                }
            }
            BatchInserter batchInserter = PutFiles.this.inserter;
            synchronized (batchInserter) {
                PutFiles.this.inserter.notifyAll();
            }
        }

        public void failed(BatchInsertFailedEvent batchInsertFailedEvent) {
            PutFiles.this.writeExitMsg(batchInsertFailedEvent);
            PutFiles.this.taskCount--;
            Vector vector = PutFiles.this.runningTasks;
            synchronized (vector) {
                if (PutFiles.this.runningTasks.contains(batchInsertFailedEvent.getTask())) {
                    PutFiles.this.runningTasks.removeElement(batchInsertFailedEvent.getTask());
                }
                System.out.println(PutFiles.this.getStatusMsg());
            }
            BatchInserter batchInserter = PutFiles.this.inserter;
            synchronized (batchInserter) {
                PutFiles.this.inserter.notifyAll();
            }
        }

        public void insertStatus(BatchInsertStatusEvent batchInsertStatusEvent) {
            InsertTask insertTask = batchInsertStatusEvent.getTask();
            switch (batchInsertStatusEvent.getState()) {
                case 1: {
                    System.out.println("STARTING: " + insertTask.getURI() + " htl=" + insertTask.getHtl() + '\n' + "          " + PutFiles.getDisplayName(insertTask));
                    PutFiles.this.runningTasks.addElement(insertTask);
                    break;
                }
                case 2: {
                    System.out.println("INSERTING CHK: " + PutFiles.getDisplayName(insertTask));
                    break;
                }
                case 3: {
                    System.out.println("INSERTING : " + PutFiles.getDisplayName(insertTask));
                    break;
                }
                case 4: {
                    System.out.println("KEY COLLISION : " + PutFiles.getDisplayName(insertTask));
                    break;
                }
                case 5: {
                    System.out.println("FAILED, REQUEUING : " + PutFiles.getDisplayName(insertTask) + " at htl=" + insertTask.getHtl());
                    Vector vector = PutFiles.this.runningTasks;
                    synchronized (vector) {
                        if (PutFiles.this.runningTasks.contains(insertTask)) {
                            PutFiles.this.runningTasks.removeElement(insertTask);
                        }
                        System.out.println(PutFiles.this.getStatusMsg());
                        break;
                    }
                }
                default: {
                    System.err.println("PutFiles.BatchInserterListenerImpl.insertStatus -- BAD state: " + batchInsertStatusEvent.getState());
                }
            }
        }

        public void restarted(BatchInsertRestartedEvent batchInsertRestartedEvent) {
            System.out.println("RESTARTED: Waiting up to " + batchInsertRestartedEvent.getWaitTimeSecs() + " seconds before timeout." + "\n   " + PutFiles.getDisplayName(batchInsertRestartedEvent.getTask()));
        }
    }

    class InsertInfo
    extends CLIBase.InfoBase
    implements InsertTask {
        private boolean autoRedirect = false;
        private String chk;

        InsertInfo(ManifestFileRecord manifestFileRecord, int n, int n2, boolean bl) {
            super(manifestFileRecord, n, n2);
            this.autoRedirect = bl;
        }

        public String getSourceData() {
            return new File(PutFiles.this.rootDir, this.getRecord().getFileName()).getAbsolutePath();
        }

        public String getSourceMetaData() {
            return "Content-Type=" + this.getRecord().getMimeType() + "\nEnd\n";
        }

        public String getURI() {
            return this.getRecord().getFreenetURI();
        }

        public int getSourceDataType() {
            return 2;
        }

        public int getSourceMetaDataType() {
            return 4;
        }

        public boolean getAutoRedirect() {
            return this.autoRedirect;
        }

        public final String getCHK() {
            return this.chk;
        }

        public final void setCHK(String string) {
            this.chk = string;
        }
    }

    static class MSKInsertTask
    implements InsertTask {
        private String data = null;
        private String uri = null;
        private int htl = -1;
        private int retries = -1;
        private String finalURI = null;

        protected MSKInsertTask(String string, String[] stringArray, String[] stringArray2, String string2, int n, int n2) {
            this.data = InsertSlave.makeMSKMapFile(stringArray, stringArray2, string2);
            this.uri = string;
            this.htl = n;
            this.retries = n2;
        }

        public String getSourceData() {
            return null;
        }

        public String getSourceMetaData() {
            return this.data;
        }

        public String getURI() {
            return this.uri;
        }

        public int getSourceDataType() {
            return 1;
        }

        public int getSourceMetaDataType() {
            return 4;
        }

        public int getHtl() {
            return this.htl;
        }

        public int getRetries() {
            return this.retries;
        }

        public boolean getAutoRedirect() {
            return false;
        }

        public String getFinalURI() {
            return this.finalURI;
        }

        public void setFinalURI(String string) {
            this.finalURI = string;
        }
    }
}

