/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client;

import Freenet.KeyException;
import Freenet.Params;
import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.ClientFactory;
import Freenet.client.ClientSSK;
import Freenet.client.FreenetURI;
import Freenet.client.InsertRequest;
import Freenet.client.InsertSizeException;
import Freenet.client.Request;
import Freenet.client.events.CollisionEvent;
import Freenet.client.events.ErrorEvent;
import Freenet.client.events.ExceptionEvent;
import Freenet.client.events.NoReplyEvent;
import Freenet.client.events.RequestCompleteEvent;
import Freenet.client.events.RequestFailedEvent;
import Freenet.client.events.RestartedEvent;
import Freenet.client.events.StateReachedEvent;
import Freenet.client.events.TransferStartedEvent;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.EventListener;
import java.util.EventObject;
import relentless.gj.client.InsertSlaveListener;
import relentless.gj.client.InsertStatusEvent;
import relentless.gj.client.RequestSlave;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.SlaveRestartedEvent;
import relentless.gj.util.EventDispatcher;
import relentless.gj.util.EventFirer;

public class InsertSlave
extends SlaveBase {
    public static final int PREPARING_INSERT_REQUEST = 1;
    public static final int WAITING_FOR_CHK_INSERT = 2;
    public static final int WAITING_FOR_INSERT = 3;
    public static final int INSERT_COMPLETING = 4;
    public static final int INSERTED_CHK = 5;
    public static final int INSERT_KEY_COLLISION = 6;
    public static final int INSERT_FAILING = 7;
    public static final int INSERT_COMPLETE = 8;
    public static final int INSERT_FAILED = 9;
    private String cipherName = null;
    private Bucket ctBucket = null;
    private String targetURI = null;
    private boolean insertingCHKForRedirect = false;
    private FreenetURI currentKey = null;
    private boolean keyAlreadyExists = false;
    private boolean freeDataBucket = false;
    private boolean freeMetaDataBucket = false;
    private FreenetURI newURI = null;
    private FreenetURI newURICHK = null;
    private RequestSlave requestSlave = null;
    private boolean autoRedirect = false;
    private boolean allowExistingURIs = true;
    private boolean uriExisted = true;
    private boolean chkExisted = true;

    public synchronized int getExitStatus() {
        switch (this.state) {
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        return 1;
    }

    public void abort() {
        throw new RuntimeException("InsertSlave.abort -- NOT IMPLEMENTED. Sorry :(");
    }

    public InsertSlave(ClientFactory clientFactory, Params params) {
        super(clientFactory, params);
        this.clientEventListener = new InsertClientEventListenerImpl();
        this.task = new InsertRunnableImpl();
        this.dispatcher = new EventDispatcher(new EventFirerImpl());
        this.cipherName = params.getParam("cipherName", "Twofish");
        this.requestSlave = new RequestSlave(clientFactory, params);
        this.state = 8;
    }

    public void startInsert(String string, int n, Bucket bucket, Bucket bucket2, boolean bl, Object object) {
        this.startInsert(string, n, bucket, false, bucket2, false, bl, object);
    }

    public void startRedirectInsert(String string, String string2, int n, Object object) throws MalformedURLException, IOException {
        this.startInsert(string, n, null, true, (Bucket)InsertSlave.makeRedirectBucket(new FreenetURI(string2)), true, false, object);
    }

    public static String makeMSKMapFile(String[] stringArray, String[] stringArray2, String string) {
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("fileNames == null || chkList == null");
        }
        if (stringArray.length != stringArray2.length || stringArray2.length == 0) {
            throw new IllegalArgumentException("(fileNames.length !=  chkList.length) || chkList.length == 0");
        }
        String string2 = "Mapfile\n";
        if (string != null) {
            string2 = string2 + "default=" + string + "\n";
        }
        string2 = string2 + "End\n";
        int n = 0;
        while (n < stringArray.length) {
            string2 = string2 + stringArray[n] + "=" + stringArray2[n] + "\n";
            ++n;
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    public static File dumpToFile(String string, String string2, boolean bl) throws IOException {
        File file;
        block14: {
            PrintWriter printWriter;
            Writer writer;
            boolean bl2;
            block13: {
                bl2 = false;
                file = null;
                writer = null;
                printWriter = null;
                file = string2 == null ? SlaveBase.makeTempFile() : new File(string2);
                String string3 = "UTF8";
                if (!bl) {
                    string3 = System.getProperty("file.encoding");
                }
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), string3);
                printWriter = new PrintWriter(writer);
                printWriter.print(string);
                printWriter.close();
                printWriter = null;
                writer.close();
                writer = null;
                Object var9_9 = null;
                if (writer == null) break block13;
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (printWriter != null) {
                printWriter.close();
            }
            if (bl2 && file != null) {
                file.delete();
            }
            break block14;
            {
                catch (IOException iOException) {
                    bl2 = true;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (bl2 && file != null) {
                    file.delete();
                }
                throw throwable;
            }
        }
        return file;
    }

    public static FileBucket dumpToBucket(String string, String string2, boolean bl) throws IOException {
        File file = InsertSlave.dumpToFile(string, string2, bl);
        return new FileBucket(file);
    }

    public final FreenetURI getFullURI() {
        return this.newURI;
    }

    public final FreenetURI getRedirectCHK() {
        return this.newURICHK;
    }

    public final void setAllowExistingURIs(boolean bl) {
        this.allowExistingURIs = bl;
    }

    public final boolean getURIExisted() {
        return this.uriExisted;
    }

    public final boolean getCHKExisted() {
        return this.chkExisted;
    }

    public void addInsertSlaveListener(InsertSlaveListener insertSlaveListener) {
        this.dispatcher.addListener(insertSlaveListener);
    }

    public void removeInsertSlaveListener(InsertSlaveListener insertSlaveListener) {
        this.dispatcher.removeListener(insertSlaveListener);
    }

    public static final String stateToString(int n) {
        switch (n) {
            case 1: {
                return "PREPARING_INSERT_REQUEST";
            }
            case 2: {
                return "WAITING_FOR_CHK_INSERT";
            }
            case 3: {
                return "WAITING_FOR_INSERT";
            }
            case 4: {
                return "INSERT_COMPLETING";
            }
            case 5: {
                return "INSERTED_CHK";
            }
            case 6: {
                return "INSERT_KEY_COLLISION";
            }
            case 7: {
                return "INSERT_FAILING";
            }
            case 8: {
                return "INSERT_COMPLETE";
            }
            case 9: {
                return "INSERT_FAILED";
            }
        }
        return "UNKNOWN STATE: " + n;
    }

    synchronized EventObject makeStatusEvent() {
        return new InsertStatusEvent(this, this.state, this.getExitStatus(), this.extraData);
    }

    public void startInsert(String string, int n, Bucket bucket, boolean bl, Bucket bucket2, boolean bl2, boolean bl3, Object object) {
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            if (this.slaveThread != null) {
                throw new RuntimeException("InsertSlave.startInsert -- Still processing previous insert!");
            }
            this.slaveThread = new Thread(this.task, "InsertSlave task:" + string);
            this.exceptions.removeAllElements();
            this.clientLibraryFinished = false;
            this.insertingCHKForRedirect = false;
            this.currentKey = null;
            this.keyAlreadyExists = false;
            this.newURI = null;
            this.newURICHK = null;
            this.uriExisted = false;
            this.chkExisted = false;
            this.targetURI = string;
            this.htl = n;
            this.autoRedirect = bl3;
            this.extraData = object;
            this.freeDataBucket = bl;
            if (bucket == null) {
                bucket = new FileBucket(SlaveBase.makeTempFile());
                this.freeDataBucket = true;
            }
            this.data = bucket;
            this.freeMetaDataBucket = bl2;
            if (bucket2 == null) {
                bucket2 = new FileBucket(SlaveBase.makeTempFile());
                this.freeMetaDataBucket = true;
            }
            this.metaData = bucket2;
            this.ctBucket = new FileBucket(SlaveBase.makeTempFile());
            eventObject = this.setState(1);
        }
        this.slaveThread.start();
        this.fire(eventObject);
    }

    public static String getPublicSSKURI(String string) throws MalformedURLException {
        FreenetURI freenetURI = new FreenetURI(string);
        ClientSSK clientSSK = new ClientSSK(null, freenetURI);
        return clientSSK.getURI().toString();
    }

    public static String getPublicSSKKey(String string) throws MalformedURLException {
        FreenetURI freenetURI = new FreenetURI("freenet:SSK@" + string + "/foo");
        ClientSSK clientSSK = new ClientSSK(null, freenetURI);
        String string2 = clientSSK.getURI().toString();
        return string2.substring(12, string2.indexOf("/"));
    }

    private final synchronized EventObject handleDone(boolean bl) {
        EventObject eventObject = null;
        if (bl) {
            this.currentKey = ((InsertRequest)this.requestToken).getURI();
            if (this.state == 2) {
                this.newURICHK = this.currentKey;
                eventObject = this.setState(5);
            } else if (this.state == 3) {
                this.newURI = this.currentKey;
                eventObject = this.setState(4);
            } else {
                eventObject = this.setState(7);
            }
        } else if (this.keyAlreadyExists && this.state == 2) {
            this.newURICHK = this.currentKey = ((InsertRequest)this.requestToken).getURI();
            this.chkExisted = true;
            eventObject = this.setState(5);
        } else if (this.keyAlreadyExists && this.state == 3) {
            this.currentKey = ((InsertRequest)this.requestToken).getURI();
            if (this.currentKey.getKeyType().equals("CHK")) {
                this.newURI = this.currentKey;
                this.chkExisted = true;
                this.uriExisted = true;
                eventObject = this.setState(4);
            } else {
                this.uriExisted = true;
                if (this.newURICHK != null) {
                    eventObject = this.setState(6);
                } else {
                    System.err.println("InsertSlave.handleDone -- can't recover from collision of non-CHK redirected keys.");
                    eventObject = this.setState(7);
                }
            }
        } else {
            eventObject = this.setState(7);
        }
        return eventObject;
    }

    private final void handleStateReachedEvent(StateReachedEvent stateReachedEvent) {
        int n = stateReachedEvent.getState();
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            if (n == -1 || n == 4) {
                eventObject = this.handleDone(n == 4);
            }
        }
        this.fire(eventObject);
        InsertSlave insertSlave2 = this;
        synchronized (insertSlave2) {
            this.clientLibraryFinished = true;
            this.notifyAll();
        }
    }

    private final void handleTransferStartedEvent(TransferStartedEvent transferStartedEvent) {
    }

    private final void handleRestartedEvent(RestartedEvent restartedEvent) {
        SlaveRestartedEvent slaveRestartedEvent = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            slaveRestartedEvent = new SlaveRestartedEvent(this, restartedEvent, this.extraData);
        }
        this.fire(slaveRestartedEvent);
    }

    private final synchronized void handleCollisionEvent(CollisionEvent collisionEvent) {
        this.keyAlreadyExists = true;
    }

    private final void handleRequestCompleteEvent(RequestCompleteEvent requestCompleteEvent) {
        System.err.println("InsertSlave.handleRequestCompleteEvent -- called.");
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            if (this.state == 2) {
                this.newURICHK = this.currentKey;
                eventObject = this.setState(5);
            } else if (this.state == 3) {
                this.newURI = this.currentKey;
                eventObject = this.setState(4);
            } else {
                System.err.println("InsertSlave.handleRequestCompleteEvent -- unexpected state:" + this.state);
                System.err.println("InsertSlave.handleRequestCompleteEvent -- failing! assertion failure");
                eventObject = this.setState(7);
            }
        }
        this.fire(eventObject);
    }

    private final void handleRequestFailedEvent(RequestFailedEvent requestFailedEvent) {
        System.err.println("InsertSlave.handleRequestFailedEvent -- called.");
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            if (this.state == 2) {
                if (this.keyAlreadyExists) {
                    this.newURICHK = this.currentKey;
                    eventObject = this.setState(5);
                } else {
                    eventObject = this.setState(7);
                }
            } else {
                eventObject = this.setState(7);
            }
        }
        this.fire(eventObject);
    }

    private final void handleNoReplyEvent(NoReplyEvent noReplyEvent) {
        this.fire(this.setState(7));
    }

    private final void handleExceptionEvent(ExceptionEvent exceptionEvent) {
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            try {
                exceptionEvent.rethrow();
            }
            catch (Exception exception) {
                this.exceptions.push(exception);
            }
            System.err.println("RequestSlave.handleExceptionEvent -- failing!");
            eventObject = this.setState(7);
        }
        this.fire(eventObject);
    }

    private final void handleErrorEvent(ErrorEvent errorEvent) {
        this.fire(this.setState(7));
    }

    private final void performInsert(Request request) throws IOException {
        EventObject eventObject = null;
        InsertSlave insertSlave = this;
        synchronized (insertSlave) {
            eventObject = this.insertingCHKForRedirect ? this.setState(2) : this.setState(3);
        }
        this.fire(eventObject);
        this.clientFactory.obtainClient(request).execute();
        InsertSlave insertSlave2 = this;
        synchronized (insertSlave2) {
            while (this.state != 4 && this.state != 7 && this.state != 5 && this.state != 6) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void cleanUpFileBucket(Bucket bucket, boolean bl) {
        if (!bl || bucket == null) {
            return;
        }
        if (!(bucket instanceof FileBucket)) {
            return;
        }
        FileBucket fileBucket = (FileBucket)bucket;
        if (fileBucket.getFile().exists() && !fileBucket.getFile().delete()) {
            System.err.println("InsertSlave.cleanUpFileBucket -- Couldn't remove tmp file: " + fileBucket.getFile().getAbsolutePath());
        }
    }

    private static FileBucket makeRedirectBucket(FreenetURI freenetURI) throws IOException {
        String string = "Redirect\nEnd\n" + freenetURI.toString() + '\n';
        return InsertSlave.dumpToBucket(string, null, true);
    }

    class InsertRunnableImpl
    implements Runnable {
        InsertRunnableImpl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block36: {
                try {
                    try {
                        boolean bl;
                        FreenetURI freenetURI = new FreenetURI(InsertSlave.this.targetURI);
                        FreenetURI freenetURI2 = null;
                        if (freenetURI.getKeyType().equals("CHK")) {
                            freenetURI2 = new FreenetURI("freenet:CHK@");
                        } else if (freenetURI.getKeyType().equals("KSK")) {
                            freenetURI2 = freenetURI;
                        } else {
                            if (!freenetURI.getKeyType().equals("SSK")) throw new KeyException("Unsupported keytype in URI:" + InsertSlave.this.targetURI);
                            freenetURI2 = freenetURI;
                        }
                        boolean bl2 = bl = !freenetURI2.getKeyType().equals("CHK") && (InsertSlave.this.data.size() + InsertSlave.this.metaData.size() > 32768L || InsertSlave.this.autoRedirect);
                        if (!freenetURI2.getKeyType().equals("CHK") && InsertSlave.this.data.size() == 0L && InsertSlave.this.metaData.size() > 32768L && !InsertSlave.this.autoRedirect) {
                            System.err.println("InsertSlave.InsertRunnableImpl.run -- Forced redirection (" + InsertSlave.this.metaData.size() + ").");
                        }
                        if (bl) {
                            InsertSlave.this.insertingCHKForRedirect = true;
                            InsertSlave.this.currentKey = new FreenetURI("freenet:CHK@");
                        } else {
                            InsertSlave.this.insertingCHKForRedirect = false;
                            InsertSlave.this.currentKey = freenetURI2;
                        }
                        InsertSlave.this.requestToken = new InsertRequest(InsertSlave.this.htl, InsertSlave.this.currentKey, InsertSlave.this.cipherName, InsertSlave.this.metaData, InsertSlave.this.data, InsertSlave.this.ctBucket);
                        block14: while (true) {
                            InsertSlave.this.requestToken.addEventListener(InsertSlave.this.clientEventListener);
                            InsertSlave.this.performInsert(InsertSlave.this.requestToken);
                            InsertSlave.this.waitForClientLibraryFinished();
                            switch (InsertSlave.this.state) {
                                case 5: {
                                    InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
                                    InsertSlave.this.freeMetaDataBucket = true;
                                    InsertSlave.this.metaData = InsertSlave.makeRedirectBucket(InsertSlave.this.currentKey);
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
                                    InsertSlave.this.freeDataBucket = true;
                                    InsertSlave.this.data = new FileBucket(SlaveBase.makeTempFile());
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
                                    InsertSlave.this.ctBucket = (Bucket)new FileBucket(SlaveBase.makeTempFile());
                                    InsertSlave.this.insertingCHKForRedirect = false;
                                    InsertSlave.this.keyAlreadyExists = false;
                                    InsertSlave.this.currentKey = freenetURI2;
                                    InsertSlave.this.requestToken = new InsertRequest(InsertSlave.this.htl, InsertSlave.this.currentKey, InsertSlave.this.cipherName, InsertSlave.this.metaData, InsertSlave.this.data, InsertSlave.this.ctBucket);
                                    if (InsertSlave.this.requestToken != null) continue block14;
                                    InsertSlave.this.fire(InsertSlave.this.setState(7));
                                    break block14;
                                }
                                case 6: {
                                    InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
                                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
                                    InsertSlave.this.requestToken = null;
                                    String string = InsertSlave.this.targetURI;
                                    FreenetURI freenetURI3 = new FreenetURI(string);
                                    if (freenetURI3.getKeyType().equals("SSK")) {
                                        string = InsertSlave.getPublicSSKURI(string);
                                    }
                                    System.err.println("Checking: " + string + "\n         " + InsertSlave.this.newURICHK.toString());
                                    InsertSlave.this.requestSlave.startRedirectCheck(string, InsertSlave.this.newURICHK.toString(), InsertSlave.this.htl, null);
                                    InsertSlave.this.requestSlave.waitUntilDone();
                                    if (InsertSlave.this.requestSlave.getExitStatus() == 2) {
                                        InsertSlave.this.newURI = new FreenetURI(InsertSlave.this.targetURI);
                                        InsertSlave.this.fire(InsertSlave.this.setState(4));
                                        break block14;
                                    }
                                    InsertSlave.this.fire(InsertSlave.this.setState(7));
                                    break block14;
                                }
                            }
                            break;
                        }
                        Object var7_8 = null;
                        if (InsertSlave.this.requestToken == null) break block36;
                    }
                    catch (IOException iOException) {
                        InsertSlave.this.exceptions.push(iOException);
                        InsertSlave.this.fire(InsertSlave.this.setState(7));
                        Object var7_9 = null;
                        if (InsertSlave.this.requestToken != null) {
                            InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
                        }
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
                        EventObject eventObject2 = null;
                        InsertSlave insertSlave2 = InsertSlave.this;
                        synchronized (insertSlave2) {
                            InsertSlave.this.slaveThread = null;
                            if (InsertSlave.this.state == 4) {
                                eventObject2 = InsertSlave.this.setState(8);
                            } else {
                                InsertSlave.this.newURI = null;
                                InsertSlave.this.newURICHK = null;
                                eventObject2 = InsertSlave.this.setState(9);
                            }
                        }
                        InsertSlave.this.fire(eventObject2);
                        return;
                    }
                    catch (InsertSizeException insertSizeException) {
                        InsertSlave.this.exceptions.push(insertSizeException);
                        InsertSlave.this.fire(InsertSlave.this.setState(7));
                        Object var7_10 = null;
                        if (InsertSlave.this.requestToken != null) {
                            InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
                        }
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
                        InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
                        EventObject eventObject3 = null;
                        InsertSlave insertSlave3 = InsertSlave.this;
                        synchronized (insertSlave3) {
                            InsertSlave.this.slaveThread = null;
                            if (InsertSlave.this.state == 4) {
                                eventObject3 = InsertSlave.this.setState(8);
                            } else {
                                InsertSlave.this.newURI = null;
                                InsertSlave.this.newURICHK = null;
                                eventObject3 = InsertSlave.this.setState(9);
                            }
                        }
                        InsertSlave.this.fire(eventObject3);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (InsertSlave.this.requestToken != null) {
                        InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
                    }
                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
                    InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
                    EventObject eventObject = null;
                    InsertSlave insertSlave = InsertSlave.this;
                    synchronized (insertSlave) {
                        InsertSlave.this.slaveThread = null;
                        if (InsertSlave.this.state == 4) {
                            eventObject = InsertSlave.this.setState(8);
                        } else {
                            InsertSlave.this.newURI = null;
                            InsertSlave.this.newURICHK = null;
                            eventObject = InsertSlave.this.setState(9);
                        }
                    }
                    InsertSlave.this.fire(eventObject);
                    throw throwable;
                }
                InsertSlave.this.requestToken.removeEventListener(InsertSlave.this.clientEventListener);
            }
            InsertSlave.this.cleanUpFileBucket(InsertSlave.this.ctBucket, true);
            InsertSlave.this.cleanUpFileBucket(InsertSlave.this.data, InsertSlave.this.freeDataBucket);
            InsertSlave.this.cleanUpFileBucket(InsertSlave.this.metaData, InsertSlave.this.freeMetaDataBucket);
            EventObject eventObject = null;
            InsertSlave insertSlave = InsertSlave.this;
            synchronized (insertSlave) {
                InsertSlave.this.slaveThread = null;
                if (InsertSlave.this.state == 4) {
                    eventObject = InsertSlave.this.setState(8);
                } else {
                    InsertSlave.this.newURI = null;
                    InsertSlave.this.newURICHK = null;
                    eventObject = InsertSlave.this.setState(9);
                }
            }
            InsertSlave.this.fire(eventObject);
        }
    }

    class InsertClientEventListenerImpl
    implements ClientEventListener {
        InsertClientEventListenerImpl() {
        }

        public final void receive(ClientEvent clientEvent) {
            if (clientEvent instanceof StateReachedEvent) {
                InsertSlave.this.handleStateReachedEvent((StateReachedEvent)clientEvent);
            } else if (clientEvent instanceof TransferStartedEvent) {
                InsertSlave.this.handleTransferStartedEvent((TransferStartedEvent)clientEvent);
            } else if (clientEvent instanceof RestartedEvent) {
                InsertSlave.this.handleRestartedEvent((RestartedEvent)clientEvent);
            } else if (clientEvent instanceof CollisionEvent) {
                InsertSlave.this.handleCollisionEvent((CollisionEvent)clientEvent);
            } else if (clientEvent instanceof RequestCompleteEvent) {
                InsertSlave.this.handleRequestCompleteEvent((RequestCompleteEvent)clientEvent);
            } else if (clientEvent instanceof RequestFailedEvent) {
                InsertSlave.this.handleRequestFailedEvent((RequestFailedEvent)clientEvent);
            } else if (clientEvent instanceof NoReplyEvent) {
                InsertSlave.this.handleNoReplyEvent((NoReplyEvent)clientEvent);
            } else if (clientEvent instanceof ExceptionEvent) {
                InsertSlave.this.handleExceptionEvent((ExceptionEvent)clientEvent);
            } else if (clientEvent instanceof ErrorEvent) {
                InsertSlave.this.handleErrorEvent((ErrorEvent)clientEvent);
            }
        }
    }

    static class EventFirerImpl
    implements EventFirer {
        EventFirerImpl() {
        }

        public final boolean fireEvent(EventListener eventListener, EventObject eventObject) {
            if (eventObject instanceof InsertStatusEvent) {
                ((InsertSlaveListener)eventListener).insertStatus((InsertStatusEvent)eventObject);
            } else if (eventObject instanceof SlaveRestartedEvent) {
                ((InsertSlaveListener)eventListener).restarted((SlaveRestartedEvent)eventObject);
            } else {
                return false;
            }
            return true;
        }
    }
}

