/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.gui.share;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Key;
import Freenet.Params;
import Freenet.client.ClientCore;
import Freenet.client.ClientFactory;
import Freenet.client.ClientSVK;
import Freenet.client.ClientUtil;
import Freenet.client.FNPClient;
import Freenet.crypt.Yarrow;
import Freenet.support.Logger;
import Freenet.support.StandardLogger;
import de.ueberdosis.mp3info.ID3Tag;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import relentless.gj.client.InsertSlave;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.batch.BatchBase;
import relentless.gj.client.batch.BatchInsertFailedEvent;
import relentless.gj.client.batch.BatchInsertRestartedEvent;
import relentless.gj.client.batch.BatchInsertStatusEvent;
import relentless.gj.client.batch.BatchInsertSucceededEvent;
import relentless.gj.client.batch.BatchInserter;
import relentless.gj.client.batch.BatchInserterListener;
import relentless.gj.client.batch.InsertTask;
import relentless.gj.gui.share.AboutDialog;
import relentless.gj.gui.share.ConfigurationDialog;
import relentless.gj.gui.share.ConfirmationDialog;
import relentless.gj.gui.share.ID3TagReaderThread;
import relentless.gj.gui.share.IgnoredFilesDialog;
import relentless.gj.gui.share.InsertedDialog;
import relentless.gj.gui.share.InsertingDialog;
import relentless.gj.gui.share.KeyIndexDialog;
import relentless.gj.gui.share.KeyIndexWriter;
import relentless.gj.gui.share.Mp3TableModel;
import relentless.gj.gui.share.ReadingID3TagsDialog;
import relentless.gj.gui.share.ShareConfiguration;
import relentless.gj.gui.share.ShareMainFrame;
import relentless.gj.util.JFCEventDispatcher;
import relentless.gj.util.Mp3FileUtils;
import relentless.gj.util.TokenTree;

class Share {
    public static final String VERSION = "0.16a (Alpha) [manifest-0.16a.tgz]";
    BatchInserter inserter = null;
    BatchInserterListenerImpl batchListener = null;
    InsertTask index = null;
    InsertTask playList = null;
    InsertTask mapFile = null;
    String indexCHK = null;
    String playListCHK = null;
    String mapFileURI = null;
    Vector orderedTags = null;
    Vector fileNames = null;
    String[] chkList = null;
    private static final String LABEL_SELECTMP3DIR = "Select Mp3 Import Directory";
    private static final String LABEL_SELECT = "Select";
    private static final String LABEL_INSERT_FAILED = "FAILED :-(";
    private static final String LABEL_INSERTED = "INSERTED :-) ";
    private static final int PROGRESS_UPDATE_INTERVAL_MS = 1000;
    private static final String LABEL_STATUSPREPARING = "Preparing...";
    private static final String LABEL_STATUSMP3S = "Inserting index and mp3s...";
    private static final String LABEL_STATUSPLAYLIST = "Inserting playlist...";
    private static final String LABEL_STATUSMSK = "Inserting MSK map file...";
    private static final String LABEL_STATUSFAILING = "Failing...";
    private static final String LABEL_STATUSABORTING = "Aborting...";
    private static final String LABEL_KEYINDEXFAILED = "Post to Key Server failed";
    private static final String MSG_NOMP3S = "No mp3's selected.";
    private static final String MSG_NOTITLE = "No collection title specified.";
    private static final String MSG_NOKEYNAME = "No key name specified.";
    private static final String MSG_NOKPRIVATEKEYSTART = "Couldn't read private key from:\n";
    private static final String MSG_NOKPRIVATEKEYEND = "\nCheck the Private Key File option under Configuration.\n";
    private static final String MSG_MSKCOLLISION = "The selected key name already exists in the current\nSSK keyspace.  Either change the key name or \nchange private key.";
    private static final String MSG_KEYINDEXFAILED = "Couldn't post the key to the specified key server.\nCheck the Key Server options under Configuration.";
    private static final String LABEL_CANTINSERT = "Can't Insert Mp3s";
    private static final String LABEL_CANTINSERTMSK = "Can't Insert MSK map file";
    private static final String LABEL_INSERTINGFAILED = "Unexpected error while inserting";
    private static final String LABEL_NOCONFIGFILE = "Couldn't read config file";
    private static final String MSG_NOCONFIGFILE = "Share needs to know the listening port for\nthe local Freenet node and the location of\nthe private key file.\n\nPlease fill in these options in the\nConfiguration dialog.";
    private static final String MSG_INSERTFAILED = "One or more files failed to insert into Freenet.\nDouble check Local Node Port in the Configuration\ndialog.  Also make sure your local node\nis running properly.";
    private static final String LABEL_INSERTFAILED = "Insert Failed";
    private static final String LABEL_CRASHEXIT = "Couldn't initialize Share :-< ";
    private static final String MSG_MUSTSETPARAMS = "You have to run Configuration!";
    private static final String LABEL_FYI = "FYI";
    private static final String MSG_NOIMMEDIATEEFFECT = "Changes to the Local Node Port and\nConcurrent Tasks don't take effect until the\nnext time you start Share :-)";
    private static final String LABEL_STARTINGINSERT = "Starting...";
    private static final String LABEL_CHKINSERT = "Inserting CHK...";
    private static final String LABEL_INSERTING = "Inserting...";
    private static final String LABEL_KEYCOLLISION = "Key Collision...";
    private static final String LABEL_REQUEUED = "Will try again later...";
    private static final String LABEL_RESTARTED = "Restarted, waiting up to: ";
    private static final String LABEL_SECONDS = " seconds.";
    private static final int INSERTING_IDLE = 1;
    private static final int INSERTING_PREPARING = 2;
    private static final int INSERTING_MP3S = 3;
    private static final int INSERTING_PLAYLIST = 4;
    private static final int INSERTING_WAITINGFORINDEX = 5;
    private static final int INSERTING_MSK = 6;
    private static final int INSERTED_MSK = 7;
    private static final int INSERTING_FAILING = 8;
    private static final int INSERTING_ABORTING = 9;
    private static final int INSERTING_FAILED = 10;
    private static final int INSERTING_ABORTED = 11;
    private static final String ICON_SHARE = "relentless/gj/gui/share/share.gif";
    private static final String MIMEMETADATA_HTML = "Content-Type=text/html\nEnd\n";
    private static final String MIMEMETADATA_XMPEGURL = "Content-Type=audio/x-mpegurl\nEnd\n";
    static final String MIMEMETADATA_MP3 = "Content-Type=audio/mpeg\nEnd\n";
    private static final String TAG_SSKKEY = "__default_ssk_key__";
    private static final String FILE_CONFIG = "share.ini";
    private static final String FILE_INDEX = "index.html";
    private static final String FILE_PLAYLIST = "playlist.m3u";
    ShareMainFrame frmMain = null;
    ConfigurationDialog dlgConfiguration = null;
    ReadingID3TagsDialog dlgReadingTags = null;
    IgnoredFilesDialog dlgIgnoredFiles = null;
    ConfirmationDialog dlgConfirmation = null;
    InsertingDialog dlgInserting = null;
    InsertedDialog dlgInserted = null;
    KeyIndexDialog dlgKeyIndex = null;
    AboutDialog dlgAbout = null;
    Vector id3Tags = new Vector();
    Vector mp3Files = new Vector();
    Vector nonMp3s = new Vector();
    Vector badlyNamedMp3s = new Vector();
    Timer tmrPostProgressUpdates = null;
    Timer tmrPollKeyIndexWriter = null;
    KeyIndexWriter keyIndexWriter = null;
    int taskCount = 0;
    int tasksDone = 0;
    int nTasks = 0;
    int insertState = 1;
    boolean mskKeyCollision = false;
    boolean madePlayListLastTime = false;
    String previousCollectionTitle = "";
    private String keyPrefix = "mp3_collection/";
    private String privateKey = null;
    private JFileChooser fchChooser = null;
    private ShareConfiguration configuration = null;
    private Params params = null;
    private ClientCore cc = null;

    Share() {
    }

    public void run(String[] stringArray) {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.err.println("Share.run -- L&F: " + UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("Share.run -- Couldn't get OS dependant L&H, falling back to Metal");
            }
            boolean bl = this.loadConfig(stringArray);
            if (this.configuration.tmpDir.equals("")) {
                this.configuration.tmpDir = System.getProperty("user.home", "");
            }
            BatchInserter.createTmpDir(this.configuration.tmpDir);
            this.frmMain = new ShareMainFrame();
            this.fchChooser = new JFileChooser();
            this.dlgConfiguration = new ConfigurationDialog(this.frmMain, this.fchChooser);
            this.dlgReadingTags = new ReadingID3TagsDialog(this.frmMain);
            this.dlgIgnoredFiles = new IgnoredFilesDialog(this.frmMain);
            this.dlgConfirmation = new ConfirmationDialog(this.frmMain);
            this.dlgInserting = new InsertingDialog(this.frmMain);
            this.dlgInserted = new InsertedDialog(this.frmMain);
            this.dlgKeyIndex = new KeyIndexDialog(this.frmMain);
            this.dlgAbout = new AboutDialog(this.frmMain);
            this.fchChooser = new JFileChooser();
            this.connectEvents();
            this.frmMain.pack();
            this.dlgConfiguration.pack();
            this.dlgReadingTags.pack();
            this.dlgIgnoredFiles.pack();
            this.dlgConfirmation.pack();
            this.dlgInserting.pack();
            this.dlgInserted.pack();
            this.dlgKeyIndex.pack();
            this.dlgAbout.pack();
            try {
                URL uRL = ClassLoader.getSystemResource(ICON_SHARE);
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                ((Frame)this.frmMain).setIconImage(image);
            }
            catch (Exception exception) {
                System.err.println("Looks like we're stuck with the coffee cup. FIX!!!");
            }
            if (bl) {
                this.initInserter(this.params);
            }
            ((Component)this.frmMain).setVisible(true);
            if (!bl) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            JOptionPane.showMessageDialog(Share.this.frmMain, Share.MSG_NOCONFIGFILE, Share.LABEL_NOCONFIGFILE, 2);
                            ShareConfiguration shareConfiguration = Share.this.dlgConfiguration.waitUntilDone(Share.this.configuration);
                            if (shareConfiguration != null) {
                                Share.this.configuration = shareConfiguration;
                                Share.this.initInserter(Share.this.params);
                            } else {
                                Share.this.crashExit(Share.MSG_MUSTSETPARAMS);
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Share FAILED: " + exception.toString());
                            exception.printStackTrace();
                            Share.this.crashExit(exception.toString());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            System.err.println("Share FAILED: " + exception.toString());
            exception.printStackTrace();
            this.crashExit(exception.toString());
        }
    }

    void crashExit(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, string, Share.LABEL_CRASHEXIT, 0);
                System.exit(0);
            }
        });
    }

    void initInserter(Params params) throws IOException {
        String string = params.getParam("logging", "NORMAL");
        int n = StandardLogger.priorityOf((String)string);
        int n2 = params.getint("verbosity", StandardLogger.SPARSE);
        String string2 = params.getParam("logFile", "no");
        StandardLogger standardLogger = null;
        standardLogger = string2.equals("no") ? new StandardLogger(System.err, n2, n) : new StandardLogger((OutputStream)new FileOutputStream(string2), n2, n);
        int n3 = params.getint("listenPort", 0);
        String string3 = params.getParam("serverAddress", "tcp/127.0.0.1:" + Integer.toString(this.configuration.port));
        this.cc = null;
        Address address = null;
        try {
            this.cc = ClientUtil.getTCPCore((int)n3, (Params)params, (Logger)standardLogger);
            address = ClientUtil.getAddress((String)string3);
        }
        catch (BadAddressException badAddressException) {
            throw new IllegalArgumentException("Could not parse address `" + string3 + "'.  It should be " + "<host>:<port> or tcp/<host>:<port>");
        }
        catch (BindException bindException) {
            throw new IllegalArgumentException("Could not bind to port " + n3 + ".  (Remember, users " + "only have access to ports >1024 on most systems.)");
        }
        FNPClient fNPClient = new FNPClient(this.cc, address);
        this.inserter = new BatchInserter((ClientFactory)fNPClient, params, this.configuration.nTasks);
        this.inserter.setEventDispatcher(new JFCEventDispatcher());
        this.inserter.addBatchInserterListener(new BatchInserterListenerImpl());
    }

    void releaseInserter() {
        this.inserter = null;
        try {
            block4: {
                try {
                    if (this.cc == null) break block4;
                    this.cc.listen = false;
                    this.cc.listener.close();
                }
                catch (Exception exception) {
                    System.err.println("Share.releaseInserter -- exception ignored: " + exception.toString());
                    Object var3_2 = null;
                    this.cc = null;
                }
            }
            Object var3_1 = null;
            this.cc = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cc = null;
            throw throwable;
        }
    }

    void setData(Mp3TableModel mp3TableModel) {
        this.frmMain.pnlTable.tblMp3s.setModel(mp3TableModel);
    }

    private void connectEvents() {
        final Share share = this;
        this.frmMain.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                share.onExit();
            }
        });
        this.frmMain.mniExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onExit();
            }
        });
        this.frmMain.mniImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onImportMp3s();
            }
        });
        this.frmMain.mniConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShareConfiguration shareConfiguration = Share.this.dlgConfiguration.waitUntilDone(Share.this.configuration);
                if (shareConfiguration != null) {
                    int n = ((Share)Share.this).configuration.port;
                    int n2 = ((Share)Share.this).configuration.nTasks;
                    Share.this.configuration = shareConfiguration;
                    if (n != shareConfiguration.port || n2 != shareConfiguration.nTasks) {
                        JOptionPane.showMessageDialog(Share.this.frmMain, Share.MSG_NOIMMEDIATEEFFECT, Share.LABEL_FYI, 2);
                    }
                }
            }
        });
        this.frmMain.mniAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)Share.this.dlgAbout).setVisible(true);
            }
        });
        this.frmMain.pnlTable.btnInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onInsert();
            }
        });
        this.dlgInserting.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onAbortInsert();
            }
        });
        this.tmrPostProgressUpdates = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onID3ImportProgressUpdate();
            }
        });
        this.tmrPollKeyIndexWriter = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                share.onPollKeyIndexWriter();
            }
        });
    }

    private final void onImportMp3s() {
        System.err.println("Share.onImportMp3s -- called.");
        this.fchChooser.setFileSelectionMode(1);
        this.fchChooser.setDialogTitle(LABEL_SELECTMP3DIR);
        int n = this.fchChooser.showDialog(this.frmMain, LABEL_SELECT);
        if (n == 0) {
            this.indexCHK = null;
            this.playListCHK = null;
            this.mapFileURI = null;
            this.orderedTags = null;
            this.fileNames = null;
            this.chkList = null;
            this.id3Tags.removeAllElements();
            this.mp3Files.removeAllElements();
            this.nonMp3s.removeAllElements();
            this.badlyNamedMp3s.removeAllElements();
            ID3TagReaderThread iD3TagReaderThread = new ID3TagReaderThread(this, this.fchChooser.getSelectedFile(), this.id3Tags, this.mp3Files, this.nonMp3s, this.badlyNamedMp3s);
            this.tmrPostProgressUpdates.start();
            this.dlgReadingTags.waitUntilDone(iD3TagReaderThread);
            this.tmrPostProgressUpdates.stop();
            this.id3Tags.removeAllElements();
            this.mp3Files.removeAllElements();
            this.nonMp3s.removeAllElements();
            this.badlyNamedMp3s.removeAllElements();
            System.err.println("Share.onImportMp3s -- finished");
        }
    }

    private final void onExit() {
        System.err.println("Share.onExit -- called.");
        if (!this.saveConfig()) {
            System.err.println("Share.onExit -- Couldn't save config info.");
        }
        try {
            BatchBase.removeTmpDir();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    private final void onInsert() {
        System.err.println("Share.onInsert -- called.");
        String string = null;
        if (((Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel()).rows.size() == 0) {
            string = MSG_NOMP3S;
        } else if (this.frmMain.pnlTable.getCollectionTitle().equals("")) {
            string = MSG_NOTITLE;
        } else if (this.frmMain.pnlTable.getKeyName().equals("")) {
            string = MSG_NOKEYNAME;
        } else if (!this.loadPrivateKey()) {
            string = MSG_NOKPRIVATEKEYSTART + this.configuration.keyFile + MSG_NOKPRIVATEKEYEND;
        } else {
            Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
            boolean bl = true;
            int n = 0;
            while (n < mp3TableModel.rows.size()) {
                if (mp3TableModel.getRow(n).getInclude().booleanValue()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                string = MSG_NOMP3S;
            }
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this.frmMain, string, LABEL_CANTINSERT, 2);
            return;
        }
        if (this.dlgConfirmation.waitUntilDone((Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel(), this.frmMain.pnlTable.getCollectionTitle(), this.frmMain.pnlTable.getKeyName(), this.frmMain.pnlTable.getMakePlayList(), this.getPrivateKey(), this.keyPrefix)) {
            System.err.println("Share.onInsert -- confirmed.");
            this.startInserting();
        }
    }

    final void onID3ImportProgressUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Share.this.dlgReadingTags.lblFound.setText(Integer.toString(Share.this.id3Tags.size()));
                Share.this.dlgReadingTags.lblIgnored.setText(Integer.toString(Share.this.nonMp3s.size() + Share.this.badlyNamedMp3s.size()));
            }
        });
    }

    final void onPollKeyIndexWriter() {
        if (this.keyIndexWriter == null) {
            return;
        }
        if (this.keyIndexWriter.getExitStatus() != 1 && this.dlgKeyIndex.isVisible()) {
            ((Component)this.dlgKeyIndex).setVisible(false);
        }
    }

    final void onImportSucceeded(final Mp3TableModel mp3TableModel) {
        String string = null;
        String string2 = null;
        if (mp3TableModel.rows.size() > 0) {
            string = mp3TableModel.getArtist(0);
            string2 = mp3TableModel.getAlbum(0);
            int n = 0;
            while (n < mp3TableModel.rows.size()) {
                if (!string.equals(mp3TableModel.getArtist(n)) || !string2.equals(mp3TableModel.getAlbum(n))) {
                    string = null;
                    string2 = null;
                    break;
                }
                ++n;
            }
        }
        final String string3 = string;
        final String string4 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Share.this.dlgReadingTags.done();
                if (Share.this.nonMp3s.size() + Share.this.badlyNamedMp3s.size() > 0) {
                    String string = "";
                    int n = 0;
                    while (n < Share.this.nonMp3s.size()) {
                        string = string + ((File)Share.this.nonMp3s.elementAt(n)).getAbsolutePath() + '\n';
                        ++n;
                    }
                    n = 0;
                    while (n < Share.this.badlyNamedMp3s.size()) {
                        string = string + ((File)Share.this.badlyNamedMp3s.elementAt(n)).getAbsolutePath() + '\n';
                        ++n;
                    }
                    Share.this.dlgIgnoredFiles.txaFiles.setText(string);
                    Share.this.dlgIgnoredFiles.waitUntilDone();
                }
                Share.this.setData(mp3TableModel);
                Share.this.setCollectionDefaults(string3, string4);
            }
        });
    }

    final void onImportFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Share.this.dlgReadingTags.done();
            }
        });
    }

    private final void onAbortInsert() {
        switch (this.insertState) {
            case 1: 
            case 7: 
            case 10: 
            case 11: {
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                this.insertState = 9;
                this.dlgInserting.update(LABEL_STATUSABORTING);
                this.abortInserting();
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                this.abortInserting();
                break;
            }
            default: {
                throw new RuntimeException("Share.onAbortInsert -- BAD state: " + this.insertState);
            }
        }
    }

    public static final void main(String[] stringArray) {
        try {
            new Share().run(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Share FAILED:");
            exception.printStackTrace();
        }
    }

    private void setCollectionDefaults(String string, String string2) {
        if (string == null || string2 == null) {
            this.frmMain.pnlTable.txfTitle.setText("");
            this.frmMain.pnlTable.txfKeyName.setText("");
            return;
        }
        this.frmMain.pnlTable.txfTitle.setText(string + " -- " + string2);
        this.frmMain.pnlTable.txfKeyName.setText(Mp3FileUtils.cleanName(string, null) + "/" + Mp3FileUtils.cleanName(string2, null));
    }

    private boolean loadPrivateKey() {
        this.privateKey = null;
        String string = this.configuration.keyFile;
        System.err.println("Share.loadPrivateKey -- " + string);
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.privateKey = bufferedReader.readLine();
            while (this.privateKey != null) {
                this.privateKey = this.privateKey.trim();
                if (!this.privateKey.startsWith("//") && !this.privateKey.equals("")) break;
                this.privateKey = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (this.privateKey == null) {
                return false;
            }
            int n = this.privateKey.indexOf("=");
            if (n != -1) {
                if (n < this.privateKey.length() - 1) {
                    this.privateKey = this.privateKey.substring(n + 1);
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String getPrivateKey() {
        return this.privateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean abortInserting() {
        if (this.inserter.isRunning()) {
            this.inserter.stop();
            BatchInserter batchInserter = this.inserter;
            synchronized (batchInserter) {
                while (this.inserter.isRunning()) {
                    try {
                        this.inserter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            System.err.println("Share.abortInserting -- running: " + this.inserter.isRunning());
            System.err.println("Share.abortInserting -- original taskCount: " + this.taskCount);
            System.err.println("Share.abortInserting -- inserter.queued(): " + this.inserter.queued());
            this.taskCount -= this.inserter.queued();
            this.inserter.flush();
            System.err.println("Share.abortInserting -- taskCount: " + this.taskCount);
            if (this.taskCount == 0) {
                if (this.insertState == 9) {
                    this.insertState = 11;
                }
                this.finishInserting(this.insertState);
                return true;
            }
        }
        return false;
    }

    String makeTempFile() {
        return SlaveBase.makeTempFile().getAbsolutePath();
    }

    String statusToString(int n) {
        switch (n) {
            case 1: {
                return LABEL_STARTINGINSERT;
            }
            case 2: {
                return LABEL_CHKINSERT;
            }
            case 3: {
                return LABEL_INSERTING;
            }
            case 4: {
                return LABEL_KEYCOLLISION;
            }
            case 5: {
                return LABEL_REQUEUED;
            }
        }
        return "!UNKNOWN status state!";
    }

    void taskSucceeded(BatchInsertSucceededEvent batchInsertSucceededEvent) {
        InsertTask insertTask = batchInsertSucceededEvent.getTask();
        this.dlgInserting.update(this.tasksDone, this.nTasks);
        System.err.println("Share.taskSucceeded -- " + batchInsertSucceededEvent.getTask().getSourceData());
        Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
        int n = mp3TableModel.rows.indexOf(insertTask);
        if (n != -1) {
            mp3TableModel.getRow(n).setCHK(batchInsertSucceededEvent.getFinalURI());
            mp3TableModel.setValueAt(LABEL_INSERTED, n, 5);
            this.frmMain.pnlTable.tblMp3s.repaint();
        } else if (insertTask == this.index) {
            this.indexCHK = batchInsertSucceededEvent.getFinalURI();
        } else if (insertTask == this.playList) {
            this.playListCHK = batchInsertSucceededEvent.getFinalURI();
        } else if (insertTask == this.mapFile) {
            this.mapFileURI = batchInsertSucceededEvent.getFinalURI();
        }
    }

    void taskFailed(BatchInsertFailedEvent batchInsertFailedEvent) {
        this.dlgInserting.update(this.tasksDone, this.nTasks);
        InsertTask insertTask = batchInsertFailedEvent.getTask();
        System.err.println("Share.taskFailed -- " + batchInsertFailedEvent.getTask().getSourceData());
        if (batchInsertFailedEvent.getExceptions() != null) {
            System.err.println("------------------------------------------------------------");
            int n = 0;
            while (n < batchInsertFailedEvent.getExceptions().length) {
                System.err.println(batchInsertFailedEvent.getExceptions()[n].toString());
                ++n;
            }
            System.err.println("------------------------------------------------------------");
        }
        Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
        int n = mp3TableModel.rows.indexOf(insertTask);
        if (n != -1) {
            mp3TableModel.setValueAt(LABEL_INSERT_FAILED, n, 5);
            this.frmMain.pnlTable.tblMp3s.repaint();
        } else if (insertTask == this.index || insertTask == this.playList || insertTask == this.mapFile) {
            // empty if block
        }
    }

    private void doWaitHack(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void prepareToInsert() {
        File file = null;
        try {
            this.taskCount = 0;
            this.tasksDone = 0;
            this.mskKeyCollision = false;
            int n = 0;
            Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
            if (this.indexCHK == null || mp3TableModel.getDirty() || this.frmMain.pnlTable.getMakePlayList() != this.madePlayListLastTime || !this.frmMain.pnlTable.getCollectionTitle().equals(this.previousCollectionTitle)) {
                System.err.println("Share.prepareToInsert -- indexCHK: " + this.indexCHK);
                System.err.println("Share.prepareToInsert -- model.getDirty(): " + mp3TableModel.getDirty());
                System.err.println("Share.prepareToInsert -- frmMain.pnlTable.getMakePlayList(): " + this.frmMain.pnlTable.getMakePlayList());
                System.err.println("Share.prepareToInsert -- madePlayListLastTime: " + this.madePlayListLastTime);
                this.indexCHK = null;
                this.playListCHK = null;
                Vector<ID3Tag> vector = new Vector<ID3Tag>();
                int n2 = 0;
                while (n2 < mp3TableModel.rows.size()) {
                    if (mp3TableModel.getRow(n2).getInclude().booleanValue()) {
                        vector.addElement(mp3TableModel.getRow(n2).getTag());
                        if (mp3TableModel.getRow(n2).getCHK() == null) {
                            mp3TableModel.getRow(n2).setHtl(this.configuration.htl);
                            mp3TableModel.getRow(n2).setRetries(this.configuration.retries);
                            this.inserter.queue(mp3TableModel.getRow(n2));
                            ++n;
                        }
                    }
                    ++n2;
                }
                TokenTree tokenTree = Mp3FileUtils.makeID3TagTree(vector, true);
                this.fileNames = new Vector();
                this.orderedTags = new Vector();
                file = Mp3FileUtils.makeHTMLIndex(tokenTree, this.frmMain.pnlTable.getCollectionTitle(), this.frmMain.pnlTable.getMakePlayList(), 8081, this.makeTempFile(), this.fileNames, this.orderedTags);
                final int n3 = this.configuration.htl;
                final String string = file.getAbsolutePath();
                this.index = new InsertTask(){

                    public String getSourceData() {
                        return string;
                    }

                    public String getSourceMetaData() {
                        return Share.MIMEMETADATA_HTML;
                    }

                    public String getURI() {
                        return "CHK@";
                    }

                    public int getSourceDataType() {
                        return 2;
                    }

                    public int getSourceMetaDataType() {
                        return 4;
                    }

                    public int getHtl() {
                        return n3;
                    }

                    public int getRetries() {
                        return ((Share)Share.this).configuration.retries;
                    }

                    public boolean getAutoRedirect() {
                        return true;
                    }
                };
                this.inserter.queue(this.index);
                this.taskCount = n + 1;
                mp3TableModel.setDirty(false);
            }
            boolean bl = this.madePlayListLastTime;
            this.madePlayListLastTime = this.frmMain.pnlTable.getMakePlayList();
            this.previousCollectionTitle = this.frmMain.pnlTable.getCollectionTitle();
            this.nTasks = this.taskCount + 1;
            if (this.frmMain.pnlTable.getMakePlayList() && this.playListCHK == null) {
                ++this.nTasks;
            }
            if (n > 0) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Share.this.dlgInserting.update(0, Share.this.nTasks);
                        Share.this.dlgInserting.update(Share.LABEL_STATUSMP3S);
                        Share.this.dlgInserting.repaint();
                        Share.this.doWaitHack(1000);
                        Share.this.inserter.start();
                        Share.this.insertState = 3;
                    }
                });
            } else if (this.frmMain.pnlTable.getMakePlayList() && this.playListCHK == null || bl != this.frmMain.pnlTable.getMakePlayList()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Share.this.dlgInserting.update(0, Share.this.nTasks);
                        Share.this.dlgInserting.repaint();
                        Share.this.doWaitHack(1000);
                        Share.this.inserter.start();
                        Share.this.makeChkList();
                    }
                });
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Share.this.dlgInserting.update(0, Share.this.nTasks);
                        if (Share.this.indexCHK != null) {
                            Share.this.doWaitHack(1000);
                            Share.this.inserter.start();
                            Share.this.insertMsk();
                            Share.this.dlgInserting.repaint();
                        } else {
                            Share.this.dlgInserting.update(Share.LABEL_STATUSMP3S);
                            Share.this.dlgInserting.repaint();
                            Share.this.doWaitHack(1000);
                            Share.this.inserter.start();
                            Share.this.insertState = 5;
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            System.err.println("Share.prepareToInsert -- unexpected exception: " + exception.toString());
            exception.printStackTrace();
            if (file != null) {
                file.delete();
            }
            this.fileNames = null;
            this.orderedTags = null;
            this.inserter.flush();
            this.taskCount = 0;
            System.err.println("Share.prepareToInsert -- unexpected exception: " + exception.toString());
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = exception.toString();
            }
            final String string2 = string;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(Share.this.dlgInserting, string2, Share.LABEL_INSERTINGFAILED, 2);
                    Share.this.finishInserting(10);
                }
            });
        }
    }

    void startInserting() {
        this.frmMain.pnlTable.btnInsert.setEnabled(false);
        System.err.println("Share.startInserting -- called. ");
        this.insertState = 2;
        this.dlgInserting.lblInserted.setText("");
        this.dlgInserting.update(LABEL_STATUSPREPARING);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Share.this.prepareToInsert();
            }
        });
        Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
        int n = 0;
        while (n < mp3TableModel.rows.size()) {
            if (mp3TableModel.getRow(n).getCHK() != null) {
                mp3TableModel.setValueAt(LABEL_INSERTED, n, 5);
            } else {
                mp3TableModel.setValueAt("", n, 5);
            }
            ++n;
        }
        this.frmMain.pnlTable.tblMp3s.repaint();
        thread.start();
        ((Component)this.dlgInserting).setVisible(true);
        if (this.insertState == 7) {
            String string = "freenet:MSK@" + this.mapFileURI.substring(this.mapFileURI.indexOf(":") + 1) + "//";
            System.err.println("Inserted MSK: " + this.mapFileURI);
            System.err.println("Collection URI: " + string);
            if (this.dlgInserted.waitUntilDone(string)) {
                this.keyIndexWriter = new KeyIndexWriter(this.configuration.keyServer, this.configuration.keyServerPort, this.configuration.keyServerPrefix, string);
                this.keyIndexWriter.start();
                this.tmrPollKeyIndexWriter.start();
                boolean bl = this.dlgKeyIndex.waitUntilDone();
                this.tmrPollKeyIndexWriter.stop();
                if (this.keyIndexWriter.getExitStatus() != 2) {
                    this.keyIndexWriter.abort();
                    if (!bl) {
                        JOptionPane.showMessageDialog(this.frmMain, MSG_KEYINDEXFAILED, LABEL_KEYINDEXFAILED, 2);
                    }
                }
                this.keyIndexWriter = null;
            }
        } else {
            System.err.println("Insert didn't succeed:" + this.insertState);
            if (this.insertState == 11) {
                this.frmMain.pnlTable.btnInsert.setEnabled(true);
                return;
            }
            if (this.mskKeyCollision) {
                JOptionPane.showMessageDialog(this.frmMain, MSG_MSKCOLLISION, LABEL_CANTINSERTMSK, 2);
            } else {
                JOptionPane.showMessageDialog(this.frmMain, MSG_INSERTFAILED, LABEL_INSERTFAILED, 2);
            }
        }
        this.frmMain.pnlTable.btnInsert.setEnabled(true);
    }

    void makeChkList() {
        System.err.println("Share.makeChkList -- called. ");
        this.chkList = new String[this.orderedTags.size()];
        Mp3TableModel mp3TableModel = (Mp3TableModel)this.frmMain.pnlTable.tblMp3s.getModel();
        int n = 0;
        while (n < mp3TableModel.rows.size()) {
            if (mp3TableModel.getRow(n).getInclude().booleanValue()) {
                int n2 = this.orderedTags.indexOf(mp3TableModel.getRow(n).getTag());
                this.chkList[n2] = mp3TableModel.getRow(n).getCHK();
            }
            ++n;
        }
        if (this.frmMain.pnlTable.getMakePlayList() && this.playListCHK == null) {
            this.insertPlayList();
        } else if (this.indexCHK != null) {
            this.insertMsk();
        } else {
            this.dlgInserting.update(LABEL_STATUSMP3S);
            this.insertState = 5;
        }
    }

    void insertPlayList() {
        System.err.println("Share.insertPlayList -- called. ");
        File file = null;
        try {
            file = Mp3FileUtils.makeMp3PlayList(this.chkList, 8081, this.makeTempFile());
            final int n = this.configuration.htl;
            final String string = file.getAbsolutePath();
            this.playList = new InsertTask(){

                public String getSourceData() {
                    return string;
                }

                public String getSourceMetaData() {
                    return Share.MIMEMETADATA_XMPEGURL;
                }

                public String getURI() {
                    return "CHK@";
                }

                public int getSourceDataType() {
                    return 2;
                }

                public int getSourceMetaDataType() {
                    return 4;
                }

                public int getHtl() {
                    return n;
                }

                public int getRetries() {
                    return ((Share)Share.this).configuration.retries;
                }

                public boolean getAutoRedirect() {
                    return true;
                }
            };
            ++this.taskCount;
            this.inserter.queue(this.playList);
            this.insertState = 4;
            this.dlgInserting.update(LABEL_STATUSPLAYLIST);
        }
        catch (Exception exception) {
            if (file != null) {
                file.delete();
                file = null;
            }
            JOptionPane.showMessageDialog(this.frmMain, exception.getMessage(), LABEL_INSERTINGFAILED, 2);
            this.finishInserting(10);
        }
    }

    void insertMsk() {
        if (this.indexCHK == null || this.chkList == null) {
            throw new RuntimeException("assertion failure: !(indexCHK == null || chkList == null)");
        }
        System.err.println("Share.insertMsk -- called. ");
        int n = this.fileNames.size() + 1;
        if (this.frmMain.pnlTable.getMakePlayList()) {
            ++n;
        }
        Object[] objectArray = new String[n];
        this.fileNames.copyInto(objectArray);
        objectArray[this.fileNames.size()] = FILE_INDEX;
        String[] stringArray = new String[n];
        System.arraycopy(this.chkList, 0, stringArray, 0, this.chkList.length);
        stringArray[this.fileNames.size()] = this.indexCHK;
        if (this.frmMain.pnlTable.getMakePlayList()) {
            objectArray[this.fileNames.size() + 1] = FILE_PLAYLIST;
            stringArray[this.fileNames.size() + 1] = this.playListCHK;
        }
        final int n2 = this.configuration.htl;
        final String string = InsertSlave.makeMSKMapFile((String[])objectArray, stringArray, FILE_INDEX);
        final String string2 = "freenet:SSK@" + this.getPrivateKey() + "/" + this.keyPrefix + this.frmMain.pnlTable.getKeyName();
        this.mapFile = new InsertTask(){

            public String getSourceData() {
                return null;
            }

            public String getSourceMetaData() {
                return string;
            }

            public String getURI() {
                return string2;
            }

            public int getSourceDataType() {
                return 1;
            }

            public int getSourceMetaDataType() {
                return 4;
            }

            public int getHtl() {
                return n2;
            }

            public int getRetries() {
                return ((Share)Share.this).configuration.retries;
            }

            public boolean getAutoRedirect() {
                return false;
            }
        };
        ++this.taskCount;
        this.inserter.queue(this.mapFile);
        this.insertState = 6;
        this.dlgInserting.update(LABEL_STATUSMSK);
    }

    void finishInserting(int n) {
        File file;
        System.err.println("Share.finishInserting -- called: " + n);
        this.insertState = n;
        if (this.index != null) {
            file = new File(this.index.getSourceData());
            file.delete();
        }
        if (this.playList != null) {
            file = new File(this.playList.getSourceData());
            file.delete();
        }
        this.index = null;
        this.playList = null;
        this.mapFile = null;
        this.inserter.stop();
        System.err.println("Share.finishInserting -- running: " + this.inserter.isRunning());
        ((Component)this.dlgInserting).setVisible(false);
    }

    private final File findConfigFile() {
        File file;
        String string = System.getProperty("user.home");
        if (string != null && (file = new File(string, FILE_CONFIG)).exists() && file.isFile() && file.length() > 0L) {
            return file;
        }
        string = System.getProperty("user.dir");
        if (string != null && (file = new File(string, FILE_CONFIG)).exists() && file.isFile() && file.length() > 0L) {
            return file;
        }
        return null;
    }

    private boolean loadConfig(String[] stringArray) {
        this.params = null;
        File file = this.findConfigFile();
        if (file != null) {
            try {
                this.params = new Params(file.getAbsolutePath(), stringArray);
            }
            catch (IOException iOException) {
                System.err.println("Share.loadConfig -- ignored exception: " + iOException.toString());
            }
        }
        if (file == null) {
            this.params = new Params(stringArray);
        }
        this.configuration = new ShareConfiguration(this.params);
        return file != null;
    }

    private boolean saveConfig() {
        this.configuration.updateParams(this.params);
        File file = null;
        File file2 = new File(System.getProperty("user.home"));
        file = file2.exists() ? new File(file2, FILE_CONFIG) : new File(FILE_CONFIG);
        this.params.writeParams(file.getAbsolutePath());
        return true;
    }

    static final boolean generateKeyFile(File file) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter(file));
                ClientSVK clientSVK = new ClientSVK((Random)new Yarrow());
                Key key = clientSVK.getKey();
                String string = clientSVK.getPrivateKeyString();
                String string2 = clientSVK.toString().substring(12);
                printWriter.println("__default_ssk_key__=" + string);
                printWriter.println("// Private key : " + string);
                printWriter.println("// Public key  : " + string2);
                if (printWriter.checkError()) {
                    throw new IOException("IO error generating private key file: " + file.getAbsolutePath());
                }
                Object var7_8 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var7_9 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        return true;
    }

    class BatchInserterListenerImpl
    implements BatchInserterListener {
        BatchInserterListenerImpl() {
        }

        public void succeeded(BatchInsertSucceededEvent batchInsertSucceededEvent) {
            --Share.this.taskCount;
            ++Share.this.tasksDone;
            Share.this.taskSucceeded(batchInsertSucceededEvent);
            System.err.println("Share.BatchInserterListenerImpl.succeeded -- taskCount: " + Share.this.taskCount);
            if (Share.this.taskCount == 0) {
                switch (Share.this.insertState) {
                    case 3: {
                        ((Mp3TableModel)Share.this.frmMain.pnlTable.tblMp3s.getModel()).setDirty(false);
                        Share.this.makeChkList();
                        break;
                    }
                    case 4: {
                        Share.this.insertMsk();
                        break;
                    }
                    case 9: {
                        Share.this.finishInserting(11);
                        break;
                    }
                    case 8: {
                        Share.this.finishInserting(10);
                        break;
                    }
                    case 5: {
                        Share.this.insertMsk();
                        break;
                    }
                    case 6: {
                        Share.this.finishInserting(7);
                        break;
                    }
                    default: {
                        System.err.println("Share.BatchInserterListenerImpl.succeeded -- BAD STATE: " + Share.this.insertState);
                    }
                }
            }
        }

        public void failed(BatchInsertFailedEvent batchInsertFailedEvent) {
            --Share.this.taskCount;
            ++Share.this.tasksDone;
            Share.this.taskFailed(batchInsertFailedEvent);
            System.err.println("Share.BatchInserterListenerImpl.failed -- taskCount: " + Share.this.taskCount);
            if (Share.this.taskCount == 0) {
                switch (Share.this.insertState) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        Share.this.finishInserting(10);
                        break;
                    }
                    case 9: {
                        Share.this.finishInserting(11);
                        break;
                    }
                    default: {
                        System.err.println("Share.BatchInserterListenerImpl.failed -- BAD STATE: " + Share.this.insertState);
                        break;
                    }
                }
            } else {
                Share.this.abortInserting();
                if (Share.this.insertState != 9 && Share.this.insertState != 11) {
                    Share.this.insertState = 8;
                    Share.this.dlgInserting.update(Share.LABEL_STATUSFAILING);
                }
            }
        }

        public void insertStatus(BatchInsertStatusEvent batchInsertStatusEvent) {
            System.err.println("Share.BatchInserterListenerImpl.insertStatus -- " + batchInsertStatusEvent.getTask().getSourceData());
            System.err.println("Share.BatchInserterListenerImpl.insertStatus -- status: " + Share.this.statusToString(batchInsertStatusEvent.getState()));
            InsertTask insertTask = batchInsertStatusEvent.getTask();
            Mp3TableModel mp3TableModel = (Mp3TableModel)Share.this.frmMain.pnlTable.tblMp3s.getModel();
            int n = mp3TableModel.rows.indexOf(insertTask);
            if (n != -1) {
                mp3TableModel.setValueAt(Share.this.statusToString(batchInsertStatusEvent.getState()), n, 5);
                Share.this.frmMain.pnlTable.tblMp3s.repaint();
            } else if (insertTask == Share.this.mapFile && batchInsertStatusEvent.getState() == 4) {
                System.err.println("Saw MSK key collision!");
                Share.this.mskKeyCollision = true;
            }
        }

        public void restarted(BatchInsertRestartedEvent batchInsertRestartedEvent) {
            System.err.println("Share.BatchInserterListenerImpl.restarted -- " + batchInsertRestartedEvent.getTask().getSourceData());
            InsertTask insertTask = batchInsertRestartedEvent.getTask();
            Mp3TableModel mp3TableModel = (Mp3TableModel)Share.this.frmMain.pnlTable.tblMp3s.getModel();
            int n = mp3TableModel.rows.indexOf(insertTask);
            if (n != -1) {
                mp3TableModel.setValueAt(Share.LABEL_RESTARTED + batchInsertRestartedEvent.getWaitTimeSecs() + Share.LABEL_SECONDS, n, 5);
                Share.this.frmMain.pnlTable.tblMp3s.repaint();
            }
        }
    }
}

