/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.gui.share;

import Freenet.Params;

class ShareConfiguration {
    int port = 19114;
    int htl = 40;
    int retries = 3;
    int nTasks = 5;
    String keyFile = "";
    String keyServer = "azrael.dyn.cheapnet.net";
    String keyServerPrefix = "/cgi-bin/keyindex/?key=";
    int keyServerPort = 80;
    String tmpDir = "";

    ShareConfiguration() {
    }

    ShareConfiguration(Params params) {
        String string = params.getParam("serverAddress", "tcp/127.0.0.1:19114");
        int n = 19114;
        int n2 = string.lastIndexOf(":");
        if (n2 != -1 && n2 < string.length() - 1) {
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("ShareConfiguration.ctr -- WARNING: Couldn't parse port.");
                System.err.println("ShareConfiguration.ctr             Falling back to 19114.");
            }
        }
        this.port = n;
        this.htl = params.getint("htl", 30);
        this.retries = params.getint("retries", 3);
        this.nTasks = params.getint("simRequests", 5);
        this.keyFile = params.getParam("privateKeyFile", "");
        this.keyServer = params.getParam("keyServer", "azrael.dyn.cheapnet.net");
        this.keyServerPrefix = params.getParam("keyServerPrefix", "/cgi-bin/keyindex/?key=");
        this.keyServerPort = params.getint("keyServerPort", 80);
        this.tmpDir = params.getParam("shareTmpDir", "");
    }

    void updateParams(Params params) {
        params.setParam("serverAddress", "tcp/127.0.0.1:" + this.port);
        params.setParam("htl", Integer.toString(this.htl));
        params.setParam("retries", Integer.toString(this.retries));
        params.setParam("simRequests", Integer.toString(this.nTasks));
        params.setParam("privateKeyFile", this.keyFile);
        params.setParam("keyServer", this.keyServer);
        params.setParam("keyServerPrefix", this.keyServerPrefix);
        params.setParam("keyServerPort", Integer.toString(this.keyServerPort));
        params.setParam("shareTmpDir", this.tmpDir);
    }
}

