from wxPython.wx import *

class panelfmail(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)
        self.log= wxListCtrl(self, -1, size=wxDefaultSize,style=wxLC_REPORT)
        self.log.InsertColumn(0,"Log Info")
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 10)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 50)
        lc.right.SameAs(self, wxRight, 10)
        self.log.SetConstraints(lc)

        butID=NewId()
        but=wxButton(self,butID,"Clear")
        EVT_BUTTON(self,butID,self.OnClear)
        lc = wxLayoutConstraints()
        lc.bottom.SameAs(self, wxBottom, 15)
        lc.left.SameAs(self, wxLeft, 15)
        lc.height.AsIs()
        lc.width.AsIs()
        but.SetConstraints(lc);

    def add(self,txt):
        pos=self.log.GetItemCount()
        self.log.InsertStringItem(pos,txt)
        self.log.SetColumnWidth(0, wxLIST_AUTOSIZE)
        self.log.EnsureVisible(pos)
    def OnClear(self,event):
        self.log.ClearAll()
    def DeleteAllItems(self):
        self.log.DeleteAllItems()

