from wxPython.wx import *
import urllib, sys
from prefs import *


# Find the installation dir of snarfzilla
if sys.path[0] == "":
    snarfdir = "."
else:
    snarfdir = sys.path[0]

class panelkeybrowser(wxPanel):

    """
    TODO:
        * Save keylists and let user retrieve later

        * Add key index servers on the fly

        * Import own list of keys

        * Add right-click menu

        * Brief key names toggles filename from key in listctrl

        * Add checkbox to clear results on new search

    """

    def __init__(self, parent, list, sb):
        wxPanel.__init__(self, parent, -1)
        self.sb = sb # Statusbar
        self.list = list
        self.parent=parent
        self.process = None
        EVT_END_PROCESS(self, -1, self.OnProcessEnded)
        # Make the controls:
        searchId = wxNewId()
        choiceId = wxNewId()
        clearId = wxNewId()
        briefId = wxNewId()
        serverList = ['Thalassocracy', 'Freegle']
        self.server = 'Thalassocracy' # Default choice
        self.choiceBox = wxChoice(self, choiceId, choices = serverList)
        self.lblSearch = wxStaticText(self, -1, "Search: " )
        self.inpSearch = wxTextCtrl(self, searchId, '', style=wxTE_PROCESS_ENTER)
        self.lblSpacer = wxStaticText(self, -1, "     " )
        self.clearBtn = wxButton(self, clearId, 'Clear Results')
        #self.briefCheck = wxCheckBox(self, briefId, "Brief Key Names")

        # Add to sizers

        box1 = wxBoxSizer(wxHORIZONTAL)
        box1.Add(self.lblSearch, 0, wxLEFT, 5)
        box1.Add(self.inpSearch, 1, wxALIGN_LEFT, 5)
        box1.Add(self.choiceBox, 1, wxALIGN_CENTER, 5)
        box1.Add(self.lblSpacer, 1, wxALIGN_CENTER, 5)
        box1.Add(self.clearBtn, 1, wxALIGN_CENTER, 25)
        #box1.Add(self.briefCheck, 0, wxRIGHT, 5)

        # Hookup all the events to controls
        EVT_CHOICE(self, choiceId, self.EvtChoice)
        EVT_CHAR(self.inpSearch, self.EvtSearchEnter)
        EVT_BUTTON(self.clearBtn, clearId, self.EvtClearAll)

        #----------------------------------------------------------------------------------
        # "list" wxListCtrl log window (Box 2)
        #----------------------------------------------------------------------------------
        klistID = wxNewId()
        self.klist= wxListCtrl(self, klistID, size=wxDefaultSize,style=wxLC_REPORT|wxSUNKEN_BORDER)
        self.klist.InsertColumn(0,"Key")
        self.klist.InsertColumn(1,"Index Server")
        self.klist.SetColumnWidth(0, 580)
        self.klist.SetColumnWidth(1, 90)

        box2 = wxBoxSizer(wxHORIZONTAL)
        box2.Add(self.klist, 1, wxEXPAND|wxALL,0)
        #Events:

        # for wxMSW
        EVT_COMMAND_RIGHT_CLICK(self.klist, klistID, self.OnRightClick)

        # for wxGTK
        EVT_RIGHT_UP(self.klist, self.OnRightClick)
        #        EVT_RIGHT_DOWN(self.klist, self.OnRightDown)
        EVT_LIST_ITEM_SELECTED(self, klistID, self.OnItemSelected)
        EVT_LIST_ITEM_ACTIVATED(self, klistID, self.OnDoubleClick) # Double-click or Enter pressed
        #Put everything into a sizer
        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(box1, 0, wxEXPAND, 10)
        sizer.Add(box2, 1, wxEXPAND|wxALL, 5)
        self.SetSizer(sizer)
        self.SetAutoLayout(true)
        self.timer = wxPyTimer(self.Pull)

        """
        file = open('/keyserverdb/mp3keys.txt', 'r')
        pos = 0
        l = file.readline()
        self.klist.InsertStringItem(pos, l)
        self.klist.SetStringItem(pos, 1, "Thalassocracy")
        pos = pos + 1
        while l:
            l = file.readline()
            self.klist.InsertStringItem(pos, l)
            self.klist.SetStringItem(pos, 1, "Thalassocracy")
            pos = pos + 1
            self.klist.SetToolTip(wxToolTip("Double-click to send key to Download Tab"))
        """

    def OnItemSelected(self, event):
        self.currentItem = event.m_itemIndex
        #print self.currentItem

    def OnRightClick(self, event):
        n = self.klist.GetItemText(self.currentItem)
        self.x = event.GetX()
        self.y = event.GetY()
        menu = wxMenu()
        forceId = wxNewId()
        menu.Append(forceId, "Download Selected")
        EVT_MENU(self, forceId, self.ForceDownload)
        self.PopupMenu(menu, wxPoint(self.x, self.y))
        menu.Destroy()
        event.Skip()


    def ForceDownload(self, event):
        # Does same thing as double click, this is from OnRightClick
        nbrSelected = self.klist.GetSelectedItemCount()
        if nbrSelected == 1:
            n = self.klist.GetItemText(self.currentItem)
            self.list.AddKeyToRow(n, 'Queued') # Send it to the download tab to be queued
            #Make the key blue so we know its been sent to download
            item = self.klist.GetItem(self.currentItem)
            item.SetTextColour(wxBLUE)
            self.klist.SetItem(item)
        # Multiple selected
        else:
            totalItems = self.klist.GetItemCount()
            inc = 0
            while inc < totalItems:
                state = self.klist.GetItemState(inc, wxLIST_STATE_SELECTED)
                if state == 4: # Selected
                    n = self.klist.GetItemText(inc)
                    self.list.AddKeyToRow(n, 'Queued') # Send it to the download tab to be queued
                    #Make the key blue so we know its been sent to download
                    item = self.klist.GetItem(inc)
                    item.SetTextColour(wxBLUE)
                    self.klist.SetItem(item)
                inc = inc + 1

    def OnDoubleClick(self, event):
        n = self.klist.GetItemText(self.currentItem)
        #n = n[:-1]
        #self.list.OnForceDownload(n)
        self.list.AddKeyToRow(n, 'Queued') # Send it to the download tab to be queued!
        #Make the key blue so we know its been sent to download
        item = self.klist.GetItem(self.currentItem)
        item.SetTextColour(wxBLUE)
        self.klist.SetItem(item)
        row = self.currentItem + 1
        #self.klist.SetItemState(row, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED)
        self.klist.SetItemState(row, wxLIST_STATE_FOCUSED, wxLIST_STATE_FOCUSED)

    def EvtChoice(self, event):
        self.server = event.GetString()
        #print "You chose %s " + server

    def EvtSearchEnter(self, event):
        keyPressed = event.GetKeyCode()
        if keyPressed == 13:
            searchValue = self.inpSearch.GetValue()  # Get url from search input box
            if self.server == "Thalassocracy":
                url = ('http://azrael.dyn.cheapnet.net/cgi-bin/keysearch/?key=%s' % searchValue)
            if self.server == "Freegle":
                url = ('http://www.freegle.com:8778/formachines/search/?s=%s' % searchValue)
            if self.server == "Galaxy Guide":
                url = ('http://galaxyguide.org/freenet/keysearch.cgi?key=%s' % searchValue)
            if self.server == "Unicast":
                url = ('http://old.unicast.org/perl/keyindex.pl')
            if self.server == "Madison":
                url = ('http://madison.dynip.com/cgi-bin/keyindex.pl')
            cmd = ("python %s/kdownload.py" % snarfdir)
            self.process = wxProcess(self)
            self.process.Redirect();
            pid = wxExecute(cmd, false, self.process)
            self.process.GetOutputStream().write(url + '\n')
            self.timer.Start(2000) # seconds / 1000
            self.Pull()
            self.inpSearch.Enable(false)
            self.choiceBox.Enable(false)
            self.counter = 0
            self.keyList = []
            self.sb.SetStatusText("Searching...", 0)
            """
            #wxYield()
            #wxBeginBusyCursor()
            #f = urllib.urlopen(url)
            #wxEndBusyCursor()
            #wxYield() # hmmm
            #fileout = f.read()
            #output = open(('%s/SEARCH_RESULTS.TXT' % snarfdir), 'w')
            #output.write(fileout)
            #output.close()
            #file = open(('%s/SEARCH_RESULTS.TXT' % snarfdir), 'r')

            """


        event.Skip()


    """
        http://galaxyguide.org/freenet/keyindex.cgi
        http://galaxyguide.org/freenet/keyindex.cgi?key= (Add a key)

        http://madison.dynip.com/cgi-bin/keyindex.pl
        http://madison.dynip.com/cgi-bin/keyindex.pl -keyindex (Add a key)

        http://schoolblows.dhs.org/freenet/keys/keyindex.pl?key=+++ (Add a key)


    """


    def EvtClearAll(self, event):
        self.klist.DeleteAllItems()


    def Pull(self):        #Check to see if there is any text output from kdownload.py to display in out window
        #print "top"
        if self.process is not None:
            stream = self.process.GetInputStream()
            #print "loop 1"
            if not stream.eof():
                #print "loop2.1"
                l = stream.readline()
                if self.server == "Freegle":
                    if len(l) > 3:
                        if l[3] == 'key=':
                            l = key[4:]
                            self.keyList.append(l)
                else:
                    self.keyList.append(l)
                while l:
                    l = stream.readline()
                    if self.server == "Freegle":
                        if len(l) > 3:
                            if string.find(l, 'key=') != -1:
                                l = l[4:]
                                self.keyList.append(l)
                    else:
                        self.keyList.append(l)

    def OnProcessEnded(self, evt):
        self.sb.SetStatusText("", 0)
        self.timer.Stop()
        self.inpSearch.Enable(true)
        self.inpSearch.SetFocus()
        self.choiceBox.Enable(true)
        stream = self.process.GetInputStream()  # This grabs the text output from download.py
        if not stream.eof():
            l = stream.readline()
            if self.server == "Freegle":
                if len(l) > 4:
                    if string.find(l, 'key=') != -1:
                        l = l[4:]
                        self.keyList.append(l)
            else:
                self.keyList.append(l)
            """
            if l == "<br>\n":
                pass
            elif string.find(l, "Search Result") != -1:
                pass
            elif len(l) > 2:
                self.klist.InsertStringItem(0, l)
                self.klist.SetStringItem(0, 1, self.server)
                self.counter = self.counter + 1
            """

            while l:
                l = stream.readline()
                if self.server == "Freegle":
                    if len(l) > 4:
                        if string.find(l, 'key=') != -1:
                            l = l[4:]
                            self.keyList.append(l)
                else:
                    self.keyList.append(l)
                """

                if l == "<br>\n":
                    pass
                elif string.find(l, "Search Result") != -1:
                    pass
                elif len(l) > 2:
                    self.klist.InsertStringItem(0, l)
                    self.klist.SetStringItem(0, 1, self.server)
                    self.counter = self.counter + 1
                """
        self.keyList.sort
        for x in self.keyList:
            txt = ("%s" % x)
            txt = txt[:-1]
            if txt == "<br>":
                pass
            elif string.find(txt, "Search Result") != -1:
                pass
            elif len(txt) > 1:
                self.counter = self.counter + 1
                self.klist.InsertStringItem(0, txt)
                self.klist.SetStringItem(0, 1, self.server)
        nbr = self.counter
        search = self.inpSearch.GetValue()
        self.klist.InsertStringItem(0, "Search results for '%s': %s" % (search, nbr))
        item = self.klist.GetItem(0)
        item.SetTextColour(wxRED)
        self.klist.SetItem(item)
        self.inpSearch.SetValue('')
        self.process.Destroy()
        self.process = None



