from wxPython.wx import *

class panelkeyring(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)
        self.keylist= wxListCtrl(self, -1, size=wxDefaultSize,style=wxLC_REPORT)
        self.keylist.InsertColumn(0,"Key Type")
        self.keylist.InsertColumn(1,"Public Key")
        self.keylist.InsertColumn(2,"Private Key")
        self.keylist.InsertColumn(3,"Associated File")
        self.keylist.SetColumnWidth(0, 70)
        self.keylist.SetColumnWidth(1, 170)
        self.keylist.SetColumnWidth(2, 170)
        self.keylist.SetColumnWidth(3, 170)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 10)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 50)
        lc.right.SameAs(self, wxRight, 10)
        self.keylist.SetConstraints(lc)

        butID=NewId()
        but=wxButton(self,butID,"Clear")
        EVT_BUTTON(self,butID,self.DeleteAllItems)
        lc = wxLayoutConstraints()
        lc.bottom.SameAs(self, wxBottom, 15)
        lc.left.SameAs(self, wxLeft, 15)
        lc.height.AsIs()
        lc.width.AsIs()
        but.SetConstraints(lc);
        #self.keylist.InsertStringItem(0, "test")

    def add(self,txt):
        pos=self.keylist.GetItemCount()
        self.keylist.InsertStringItem(pos,txt)
        #self.keylist.SetColumnWidth(0, wxLIST_AUTOSIZE)
        self.keylist.EnsureVisible(pos)
    def OnClear(self,event):
        self.keylist.ClearAll()
    def DeleteAllItems(self, event):
        self.keylist.DeleteAllItems()
