from wxPython.wx import *
import sys

# Find the installation dir of snarfzilla
if sys.path[0] == "":
    snarfdir = "."
else:
    snarfdir = sys.path[0]

class panelwebsite(wxPanel):
    def __init__(self,parent):
        wxPanel.__init__(self, parent, -1)
        self.SetAutoLayout(true)
        self.process = None
        EVT_END_PROCESS(self, -1, self.OnProcessEnded)

        # Ok, so maybe this was my first window and I didn't know about wxSizers...
        row = 25
        col = 100
        width = 225

        SSKbutId = wxNewId()
        #self.SSKbut = wxButton(self, SSKbutId, "Generate SSK", wxPoint(330, row))
        uploadDirButId = wxNewId()
        #self.uploadDirBut = wxButton(self, uploadDirButId, "Select Dir. ", wxPoint(330, row+30))

        wxStaticText(self, -1, "Private SSK", wxPoint(5, row), wxSize(75, 20))
        SSKId = wxNewId()
        self.SSK = wxTextCtrl(self, SSKId, "", wxPoint(col, row), wxSize(width, 20))

        wxStaticText(self, -1, "Upload Dir.", wxPoint(5, row+30), wxSize(95, 20))
        uploadDirId = wxNewId()
        self.uploadDir = wxTextCtrl(self, uploadDirId, "", wxPoint(col, row+30), wxSize(width, 20))

        wxStaticText(self, -1, "Site Name", wxPoint(5, row + 60), wxSize(95, 20))
        siteNameId = wxNewId()
        self.siteName = wxTextCtrl(self, siteNameId, "", wxPoint(col, row + 60), wxSize(width, 20))

        wxStaticText(self, -1, "Default File", wxPoint(5, row+90), wxSize(95, 20))
        defaultFileId = wxNewId()
        self.defaultFile = wxTextCtrl(self, defaultFileId, "index.html", wxPoint(col, row+90), wxSize(width, 20))

        wxStaticText(self, -1, "Sim. Requests", wxPoint(5, row+120), wxSize(95, 20))
        simRequestsId = wxNewId()
        self.simRequests = wxTextCtrl(self, simRequestsId, "10", wxPoint(col, row+120), wxSize(width, 20))

        wxStaticText(self, -1, "Update Interval", wxPoint(5, row+150), wxSize(95, 20))
        updateIntervalId = wxNewId()
        self.updateInterval = wxTextCtrl(self, updateIntervalId, "0", wxPoint(col, row+150), wxSize(width, 20))

        wxStaticText(self, -1, "HTL", wxPoint(5, row+180), wxSize(95, 20))
        HTLId = wxNewId()
        self.HTL = wxTextCtrl(self, HTLId, "50", wxPoint(col, row+180), wxSize(width, 20))

        startButId = wxNewId()
        self.startBut = wxButton(self, startButId, "Start", wxPoint(10, row + 230))
        EVT_BUTTON(self, startButId, self.OnStartBut)
        self.outTextID=wxNewId()
        self.outText = wxTextCtrl(self, self.outTextID, "", wxPoint(10,330), wxDefaultSize, style=wxTE_MULTILINE|wxTE_READONLY)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 330)
        lc.left.SameAs(self, wxLeft, 10)
        lc.bottom.SameAs(self, wxBottom, 10)
        lc.right.SameAs(self, wxRight, 10)

        self.outText.SetConstraints(lc)

        self.timer = wxPyTimer(self.Pull)
        self.timer.Start(2000) # seconds / 1000
        self.Pull()

    def OnStartBut(self, event):
        cmd = ("python %s/createsite.py" % snarfdir)
        self.process = wxProcess(self)
        self.process.Redirect();
        self.pid = wxExecute(cmd, false, self.process)
        SSK = self.SSK.GetValue()
        uploadDir = self.uploadDir.GetValue()
        siteName = self.siteName.GetValue()
        defaultFile = self.defaultFile.GetValue()
        simRequests = self.simRequests.GetValue()
        updateInterval = self.updateInterval.GetValue()
        if updateInterval == 0:
            interval = '-update yes'
        else:
            interval = ('-future %s' % updateInterval)
        HTL = self.HTL.GetValue()
        self.process.GetOutputStream().write(SSK + '\n')
        self.process.GetOutputStream().write(uploadDir + '\n')
        self.process.GetOutputStream().write(siteName + '\n')
        self.process.GetOutputStream().write(defaultFile + '\n')
        self.process.GetOutputStream().write(simRequests + '\n')
        self.process.GetOutputStream().write(interval + '\n')
        self.process.GetOutputStream().write(HTL + '\n')

        #self.SSKbut.Enable(false)
        #self.uploadDirBut.Enable(false)
        self.SSK.Enable(false)
        self.uploadDir.Enable(false)
        self.siteName.Enable(false)
        self.defaultFile.Enable(false)
        self.simRequests.Enable(false)
        self.updateInterval.Enable(false)
        self.HTL.Enable(false)
        self.startBut.Enable(false)





    def __del__(self):
        if self.process is not None:
            self.process.Detach()
            self.process.CloseOutput()
            self.process = None

    def Pull(self):        #Check to see if there is any text output from dosite.py to display in out window
        if self.process is not None:
            stream = self.process.GetInputStream()
            if not stream.eof():
                l = stream.readline()
                #print l
                self.outText.AppendText(l)
                while l:
                    l = stream.readline()
                    self.outText.AppendText(l)


    def OnProcessEnded(self, event):
        self.timer.Stop()
        stream = self.process.GetInputStream()  # This grabs the text output from dosite.py
        if not stream.eof():
            l = stream.readline()
            self.outText.AppendText(l)
            while l:
                l = stream.readline()
                self.outText.AppendText(l)
        self.process.Destroy()
        self.process = None
        #self.SSKbut.Enable(true)
        #self.uploadDirBut.Enable(true)
        self.SSK.Enable(true)
        self.uploadDir.Enable(true)
        self.siteName.Enable(true)
        self.defaultFile.Enable(true)
        self.simRequests.Enable(true)
        self.updateInterval.Enable(true)
        self.HTL.Enable(true)
        self.startBut.Enable(true)


    def fileSelect(self, event):
        dlg = wxFileDialog(self, "Choose a file", ".", "", "*.mp3", wxOPEN|wxMULTIPLE)
        if dlg.ShowModal() == wxID_OK:
            for path in dlg.GetPaths():
                self.uploadDir.SetValue(path)
                dlg.Destroy()
