#!/usr/bin/env python

__version__ = '0.0.4'

"""

snarf /snarf/ vt.

 1. To grab, esp. to grab a large document or file for the-purpose of using it with
 or without the author's permission. See also BLT. 2. [in the Unix community] To fetch
 a file or set of files across a network. See also blast. This term was mainstream in the
 late 1960s, meaning `to eat piggishly'. It may still have this connotation in context. "He's
 in the snarfing phase of hacking -- FTPing megs of stuff a day." 3. To acquire, with little
 concern for legal forms or politesse (but not quite by stealing). "They were giving away samples,
 so I snarfed a bunch of them." 4. Syn. for slurp. "This program starts by snarfing the entire
 database into core, then...." 5. [GEnie] To spray food or programming fluids due to laughing at
 the wrong moment. "I was drinking coffee, and when I read your post I snarfed all over my desk."
 "If I keep reading this topic, I think I'll have to snarf-proof my computer with a keyboard condom."
 [This sense appears to be widespread among mundane teenagers --ESR]it

"""

# Python, wxPython stuff:
from wxPython.wx import *
from wxPython.lib.filebrowsebutton import FileBrowseButton
import os, os.path, string, shutil, time, sys

#Import code for each notebook tab and option frame
from SendFmailFrame import *
from OptionFrame import *
from PanelLog import *
from PanelKeyring import *
from PanelDownload import *
from PanelUpload import *
from PanelBrowser import *
from PanelKeyBrowser import *
from PanelFmail import *
from PanelWebsite import *

# Snarfzilla stuff:
import Help
from ID3Tag import *
from mp3 import mp3info

# Snarfzilla paths, preferences etc. prefs.py
from prefs import *

# Find the installation dir of snarfzilla
if sys.path[0] == "":
    snarfdir = "."
else:
    snarfdir = sys.path[0]

# Allow gif, jpg, bmp, png handling for wxHtml
wxInitAllImageHandlers()

#Kludge for browser cache:
# TODO: make this work for Windows
# this was 'touch', maybe echo works in Win32?
os.system("echo '' > %s/htdocs/cache/last.url" % snarfdir)

#Main wxFrame called from wxApp

class MyFrame(wxFrame):
    def __init__(self, parent, id, title):
        wxFrame.__init__(self, parent, -1, title,size=wxSize(700,600))
        self.SetAutoLayout(true)
#--------------------------------------------------------------------------------
# Create main wxNotebook that all the panels reside in
#--------------------------------------------------------------------------------
        self.nb = wxNotebook(self, -1)
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 0)
        lc.left.SameAs(self, wxLeft, 0)
        lc.bottom.SameAs(self, wxBottom, 0)
        lc.right.SameAs(self, wxRight, 0)
        self.nb.SetConstraints(lc)
        self.sb = self.CreateStatusBar(1, wxST_SIZEGRIP)
        #self.sb.SetFieldsCount(2)
        #self.sb.SetStatusText("Welcome to Snarfzilla.", 0)
        self.panlog=panellog(self.nb)
        self.pankeyring=panelkeyring(self.nb)
        self.pandownload=paneldownload(self.nb, self.panlog, self.sb)
        self.panupload=panelupload(self.nb, self.panlog, self.sb)
        self.panwebsite=panelwebsite(self.nb)
        self.pankeybrowser=panelkeybrowser(self.nb, self.pandownload, self.sb)
        self.panbrowser=panelbrowser(self, self.nb, self.sb, self.panlog)

#--------------------------------------------------------------------------------
# Setup notebook tabs
#--------------------------------------------------------------------------------

        self.nb.AddPage(self.panbrowser, "Freesite Browser")
        self.nb.AddPage(self.pankeybrowser, "Browse Keys")
        self.nb.AddPage(self.pandownload, "Download")
        self.nb.AddPage(self.panupload, "Upload")
        self.nb.AddPage(self.panwebsite, "Create Freesite")
        #self.nb.AddPage(self.pancreate, "Create Catalog") # Espra
        #self.nb.AddPage(self.pankeyring, "Keyring")
        self.nb.AddPage(self.panlog, "Log")

#--------------------------------------------------------------------------------
# Menu bar
#--------------------------------------------------------------------------------
        # Main
        menu_file = wxMenu()
        mnuexitID=NewId()
        menu_file.Append(mnuexitID, "E&xit")
        menubar = wxMenuBar()
        menubar.Append(menu_file, "&File")
        # Options
        menu_options = wxMenu()
        mnuSnarfPrefID = NewId()
        menu_options.Append(mnuSnarfPrefID, "Snarfzilla Preferences")
        menubar.Append(menu_options, "&Options")
        # Tools
        menu_tools = wxMenu()
        mnuGenKeysID = NewId()
        mnuCreateDBRID = NewId()
        menu_tools.Append(mnuGenKeysID, "Generate SSK Keypair")
        menu_tools.Append(mnuCreateDBRID, "Update DBR")
        menubar.Append(menu_tools, "&Tools")
        # Fmail
        menu_fmail = wxMenu()
        mnuSendFmailID = NewId()
        mnuFetchFmailID = NewId()
        menu_fmail.Append(mnuSendFmailID, "Send Fmail")
        menu_fmail.Append(mnuFetchFmailID, "Fetch Fmail")
        menubar.Append(menu_fmail, "F&mail")
        # Help
        menu_help = wxMenu()
        mnuhelpID=NewId()
        mnuaboutID=NewId()
        menu_help.Append(mnuhelpID,"Help")
        menu_help.Append(mnuaboutID,"About")
        menubar.Append(menu_help,"&Help")
        self.SetMenuBar(menubar)
        EVT_MENU(self, mnuexitID, self.OnMnuExit)
        EVT_MENU(self, mnuSnarfPrefID, self.OnMnuSnarfPref)
        EVT_MENU(self, mnuaboutID, self.OnMnuAbout)
        EVT_MENU(self, mnuhelpID, self.OnMnuHelp)
        EVT_MENU(self, mnuGenKeysID, self.OnMnuGenKeys)
        EVT_MENU(self, mnuCreateDBRID, self.OnMnuCreateDBR)
        EVT_MENU(self, mnuSendFmailID, self.OnMnuSendFmail)
        EVT_MENU(self, mnuFetchFmailID, self.OnMnuFetchFmail)
#--------------------------------------------------------------------------------
# Keyboard accelerators
#--------------------------------------------------------------------------------

        # Alt-X to exit
        # TODO: Add for each item in menu
        aTable = wxAcceleratorTable([(wxACCEL_ALT,  ord('X'), mnuexitID)])
        self.SetAcceleratorTable(aTable)
        f = open("./prefs.py", 'r')
        lines = f.read()
        f.close()

    def OnMnuFetchFmail(self,event):

        dlg = wxTextEntryDialog(self, "Enter Index Name:\n\n",
                            'Fetch Fmail', '')
        if dlg.ShowModal() == wxID_OK:
            indexname = dlg.GetValue()
            dlg.Destroy()
            if indexname:
                now = int(time.time()) # Seconds since Epoch
                midnight = now - (now % 86400) # GMT Midnight
                max = 10
                inc = 0
                while inc < max:
                    indexdate = ('%s-%s-%s' % (indexname, midnight, inc))
                    self.pandownload.AddKeyToRow(indexdate, 'Queued')
                    inc = inc + 1
                dlg.Destroy()
                msg = 'Fmail is searching. Check the Download tab for progress.\n\nYour messages are stored in snarfzilla/download'
                dlg2 = wxMessageDialog(self, msg, 'Searching.',
                wxOK | wxICON_INFORMATION)
                dlg2.ShowModal()
                dlg2.Destroy()
            else: # Blank entry, quit
                dlg.Destroy()
        else: # Pressed Cancel
            dlg.Destroy()

    def OnMnuSendFmail(self,event):
        a = sendFmailFrame(None, -1, "Send Fmail")
        a.Show(true)

    def OnMnuGenKeys(self,event):
        dlg = wxTextEntryDialog(self, "What name do you want to give this keypair?\n\n (Leave blank if you don't want to save to disk)",
                            'SSK Keypair Generator', '')
        if dlg.ShowModal() == wxID_OK:
            keyname = dlg.GetValue()
            dlg.Destroy()
            if keyname:
                os.system('%s/%s -makeKeypair > ./keys/%s.key' % (freenetdir, finsert, keyname))
                msg = ('Your keypair is in:\n\n %s/keys/%s.key' % (freenetdir, keyname))
                dlg2 = wxMessageDialog(self, msg, 'Done.',
                                       wxOK | wxICON_INFORMATION)
                dlg2.ShowModal()
                dlg2.Destroy()
            else:
                dlg.Destroy()
                from wxPython.lib.dialogs import wxScrolledMessageDialog
                os.system('%s/%s -makeKeypair > ./tmpkey' % (freenetdir, finsert))
                f = open('./tmpkey', 'r')
                keys = f.readlines()
                f.close()
                os.unlink('./tmpkey')
                privkey = keys[1]
                pubkey = keys[2]
                keys = privkey + pubkey
                dlg2 = wxScrolledMessageDialog(self, keys, 'Your SSK Keypair:')
                dlg2.ShowModal()
                dlg2.Destroy()
        else:
            dlg.Destroy()

    def OnMnuCreateDBR(self,event):

        dlg1 = wxTextEntryDialog(self, "Enter your Private SSK:\n\n",
                                 'Create DBR', '')
        if dlg1.ShowModal() == wxID_OK:
            keyname = dlg1.GetValue()
            dlg1.Destroy()
            if keyname:
                dlg2 = wxTextEntryDialog(self, "Enter your site name:\n\n",
                                         'Create DBR', '')
                if dlg2.ShowModal() == wxID_OK:
                    sitename = dlg2.GetValue()
                    dlg2.Destroy()
                    if sitename:
                        try:
                            keysite = ('%s/%s' % (keyname, sitename))
                            dlg3 = wxMessageDialog(self, 'This will take a few minutes. Press OK to begin.', 'Ready to begin.',
                                   wxOK | wxICON_INFORMATION)
                            dlg3.ShowModal()
                            dlg3.Destroy()
                            wxYield()
                            os.system('%s/%s -htl 50 -createUpdate yes %s' % (freenetdir, finsert, keysite))
                            dlg4 = wxMessageDialog(self, 'DBR update complete', 'Done.',
                                   wxOK | wxICON_INFORMATION)
                            dlg4.ShowModal()
                            dlg4.Destroy()
                        except:
                            dlg3 = wxMessageDialog(self, 'Initial DBR creation failed', 'Failure.',
                            wxOK | wxICON_INFORMATION)
                            dlg3.ShowModal()
                            dlg3.Destroy()
                    else:
                        dlg2.destroy()
                else:
                    dlg2.Destroy()
            else:
                dlg1.Destroy()
        else:
            dlg1.Destroy()

    def OnMnuHelp(self, event):
        threadList = []
        if snarfdir == ".":
            helpdir = "./index.html"
        else:
            #helpdir = ('%s/Docs/index.html' % snarfdir)
            helpdir = 'index.html'
        Help.showHelp(self, Help.BoaHelpFrame, '%s' % helpdir) #./snarfzilla.0.0.4/Docs/index.html

    def OnMnuExit(self,event):
        self.Close()

    def OnMnuSnarfPref(self, event):
        a = optionSnarfFrame(None, -1, "Snarfzilla Preferences")
        a.Show(true)

    def OnMnuFreenetPref(self, event):
        a = optionFrame(None, -1, "Freenet Preferences")
        a.Show(true)

    def OnMnuAbout(self,event):
        dlg = wxMessageDialog(self, 'Snarfzilla is a Python and wxPython Freenet application\n by Rob Cakebread released under the GPL license.\n\n',
                              'About Snarfzilla', wxOK | wxICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def OnCloseWindow(self, event):
        self.Destroy()

    def OnSize(self, event):
        w,h = self.GetClientSizeTuple()

class MyApp(wxApp):
    def OnInit(self):
        title = ("Snarfzilla - The Freenet Monster %s" % __version__)
        frame=MyFrame(None,-1, title)
        frame.Show(true)
        self.SetTopWindow(frame)
        return true

app=MyApp(0)
app.MainLoop()