#!/usr/bin/env python

# xrflib.py
#
# Copyright Rob Cakebread 2001
# Released under the GNU Public License (See freenet:KSK@gpl.txt)
#

# Python system stuff
import os, socket, sys, string, time, threading

# Custom stuff:
from xmlrpclib import *
TRANSFERRING=0
DONE=1
FAILED=2
simul = 1


class getKey(threading.Thread):
    def __init__(self, parent, server, port, key, filename, htl):
        threading.Thread.__init__(self)
        self.server=server
        self.port=port
        self.key=key
        self.filename=('./download/%s' % filename)
        self.htl=string.atoi(htl)
        self.verbose = 1
        self.setName(key)
        self.row = parent

        #dir = ''
        #if filename:
        #    if dir:
        #        self.file = open(('%s/%s' % (dir, self.filename)), "w")
        #    else:
        self.file = open(self.filename, "wb")

        #if self.verbose:
            #print ('Requesting %s with %s hops to live...' % (self.key, self.htl))

    def run(self):
        client = Server('http://%s:%s/' % (self.server, self.port))
        try:
            id = client.streaming.getPort()
        except:
            print 'Error- Is XML-RPC enabled in your Freenet config file and is Freenet running?'
            print ('server:%s port:%s\n' % (self.server, self.port))
            self.row.UpdateRow(self.key, 'Error', 0, -1)
            sys.exit(0)
        s=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        s.connect((self.server, id))
        client.streaming.startRequest(id, self.key, self.htl)
        status=client.streaming.getStatus(id)
        ttlFileSize = client.streaming.getFileSize(id)
        #if self.verbose:
            #if ttlFileSize != -1:
                #print ('File size %i (%s)' % (ttlFileSize, self.filename))
        filesize = 0
        sizeCounter = 0
        try:
            while 1:
                if status==FAILED:
                    self.row.UpdateRow(self.key, 'Failed', filesize, ttlFileSize)
                    status = 'Failed'
                    try:
                        os.unlink(self.filename)
                    except:
                        print ("Couldn't delete %s" % self.filename)
                    break
                chunk=s.recv(1024)
                if not chunk:
                    break
                filesize = filesize + len(chunk)

                sizeCounter = sizeCounter + 1
                if sizeCounter >= 10:  #Print size every 10k
                    self.row.UpdateRow(self.key, 'Snarfing', filesize, ttlFileSize)
                    sizeCounter = 0
                self.file.write(chunk)
                #self.row.UpdateRow(self.key, 'Requesting', filesize, ttlFileSize)
            Status = 'Done'
            #return status # New to Streaming
        except Fault, x:
            status=client.streaming.getStatus(id)
            if status==DONE:
                Status = 'Done'
                self.file.close()
                #return status
            else:
                if debug:
                    print x # info for exceptions
                Status = 'Fail'
                try:
                    os.unlink(self.filename)
                except:
                    print ("Couldn't delete %s" % self.filename)
        self.row.UpdateRow(self.key, Status, filesize, ttlFileSize)

