
/*  A Bison parser, made from /home/gray/anubis/src/./rcfile.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	EOL	257
#define	T_BEGIN	258
#define	T_END	259
#define	AND	260
#define	OR	261
#define	IF	262
#define	FI	263
#define	ELSE	264
#define	RULE	265
#define	DONE	266
#define	CALL	267
#define	STOP	268
#define	ADD	269
#define	REMOVE	270
#define	MODIFY	271
#define	IDENT	272
#define	STRING	273
#define	REGEX	274
#define	D_BEGIN	275
#define	T_MSGPART	276
#define	NOT	277

#line 1 "rcfile.y"

/*
   rcfile.y

   This file is part of GNU Anubis.
   Copyright (C) 2003 The Anubis Team.

   GNU Anubis is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   GNU Anubis is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Anubis; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   GNU Anubis is released under the GPL with the additional exemption that
   compiling, linking, and/or using OpenSSL is allowed.
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <setjmp.h>	
#include "headers.h"
#include "extern.h"
#include "rcfile.h"

extern int rc_yylex(void);
int rc_yyerror(char *s);

static RC_SECTION *rc_section_create(char *, RC_STMT *);
static void rc_section_destroy(RC_SECTION **);
static void rc_section_print(RC_SECTION *);
static void rc_asgn_destroy(RC_ASGN *);
static void rc_bool_destroy(RC_BOOL *);
static void rc_level_print(int, char *);
static RC_NODE *rc_node_create(enum rc_node_type);
static void rc_node_destroy(RC_NODE *);
static void rc_node_print(RC_NODE *);
static void rc_rule_destroy(RC_RULE *);
static void rc_cond_destroy(RC_COND *);
static RC_STMT *rc_stmt_create(enum rc_stmt_type);
static void rc_stmt_destroy(RC_STMT *);
static void rc_stmt_list_destroy(RC_STMT *);
static void rc_stmt_print(RC_STMT *, int);
static int reg_modifier_add(int *, char *);
static int check_kw(char *ident);
static int is_prog_allowed();
 
static RC_SECTION *rc_section;
static int debug_level;
static int error_count;
static int def_regex_modifier = R_POSIX;
static struct rc_secdef *rc_secdef;

#line 66 "rcfile.y"
typedef union {
	char *string;
	RC_SECTION *section;
	RC_STMT *stmt;
	struct { RC_STMT *head; RC_STMT *tail; } stmtlist;
	RC_COND cond;
	RC_RULE rule;
	RC_NODE *node;
	RC_REGEX *regex;
	int num;
	struct {
		int part;
		RC_REGEX *key;
		char *string;
	} msgpart;
	LIST *list;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		113
#define	YYFLAG		-32768
#define	YYNTBASE	30

#define YYTRANSLATE(x) ((unsigned)(x) <= 277 ? rc_yytranslate[x] : 65)

static const char rc_yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    24,
    25,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    29,     2,     2,
    26,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    27,     2,    28,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23
};

#if YYDEBUG != 0
static const short rc_yyprhs[] = {     0,
     0,     2,     4,     7,    10,    12,    16,    19,    20,    25,
    28,    31,    33,    36,    38,    41,    44,    47,    50,    53,
    56,    59,    61,    63,    66,    68,    73,    80,    82,    86,
    90,    94,    97,    98,   100,   102,   106,   107,   109,   112,
   114,   116,   118,   123,   124,   128,   134,   136,   139,   140,
   142,   145,   147,   149,   151,   156,   160,   162,   164,   166,
   168,   171,   175,   178,   183,   187
};

static const short rc_yyrhs[] = {    31,
     0,    32,     0,    31,    32,     0,    31,     1,     0,     3,
     0,    33,    36,    35,     0,    33,    35,     0,     0,     4,
    34,    62,     3,     0,    21,     3,     0,     5,     3,     0,
    37,     0,    36,    37,     0,     3,     0,    38,     3,     0,
    42,     3,     0,    59,     3,     0,    63,     3,     0,    64,
     3,     0,     1,     3,     0,    39,    40,     0,    18,     0,
    41,     0,    40,    41,     0,    62,     0,    56,    43,    36,
    57,     0,    56,    43,    36,    58,    36,    57,     0,    52,
     0,    24,    43,    25,     0,    43,     6,    43,     0,    43,
     7,    43,     0,    23,    43,     0,     0,    26,     0,    50,
     0,    27,    62,    28,     0,     0,    45,     0,    22,    46,
     0,    45,     0,    47,     0,    47,     0,    53,    27,    62,
    28,     0,     0,    27,    62,    28,     0,    48,    54,    44,
    54,    62,     0,    55,     0,    53,    55,     0,     0,    53,
     0,    29,    18,     0,     8,     0,     9,     0,    10,     0,
    60,     3,    36,    12,     0,    61,    54,    62,     0,    11,
     0,    19,     0,    18,     0,    14,     0,    13,    62,     0,
    15,    48,    62,     0,    16,    49,     0,    17,    49,    51,
    62,     0,    17,    49,    51,     0,    20,    53,     0
};

#endif

#if YYDEBUG != 0
static const short rc_yyrline[] = { 0,
   106,   111,   115,   126,   135,   139,   143,   149,   149,   156,
   164,   167,   171,   184,   188,   189,   190,   191,   192,   193,
   202,   220,   226,   231,   238,   241,   248,   257,   258,   262,
   269,   276,   285,   286,   289,   295,   303,   308,   311,   316,
   319,   327,   337,   344,   348,   354,   364,   370,   378,   382,
   385,   391,   398,   401,   404,   412,   422,   429,   430,   433,
   444,   455,   466,   477,   488,   504
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const rc_yytname[] = {   "$","error","$undefined.","EOL","T_BEGIN",
"T_END","AND","OR","IF","FI","ELSE","RULE","DONE","CALL","STOP","ADD","REMOVE",
"MODIFY","IDENT","STRING","REGEX","D_BEGIN","T_MSGPART","NOT","'('","')'","'='",
"'['","']'","':'","input","seclist","section","begin","@1","end","stmtlist",
"stmt","asgn_stmt","keyword","arglist","arg","cond_stmt","cond","meq","key",
"opt_key","msgpart","s_msgpart","r_msgpart","regex","string_key","expr","modlist",
"opt_modlist","modifier","if","fi","else","rule_stmt","rule_start","rule","string",
"inst_stmt","modf_stmt", NULL
};
#endif

static const short rc_yyr1[] = {     0,
    30,    31,    31,    31,    32,    32,    32,    34,    33,    33,
    35,    36,    36,    37,    37,    37,    37,    37,    37,    37,
    38,    39,    40,    40,    41,    42,    42,    43,    43,    43,
    43,    43,    44,    44,    45,    45,    46,    46,    47,    47,
    48,    49,    50,    51,    51,    52,    53,    53,    54,    54,
    55,    56,    57,    58,    59,    60,    61,    62,    62,    63,
    63,    63,    63,    63,    63,    64
};

static const short rc_yyr2[] = {     0,
     1,     1,     2,     2,     1,     3,     2,     0,     4,     2,
     2,     1,     2,     1,     2,     2,     2,     2,     2,     2,
     2,     1,     1,     2,     1,     4,     6,     1,     3,     3,
     3,     2,     0,     1,     1,     3,     0,     1,     2,     1,
     1,     1,     4,     0,     3,     5,     1,     2,     0,     1,
     2,     1,     1,     1,     4,     3,     1,     1,     1,     1,
     2,     3,     2,     4,     3,     2
};

static const short rc_yydefact[] = {     0,
     5,     8,     0,     0,     2,     0,     0,    10,     4,     3,
     0,    14,     0,    52,    57,     0,    60,     0,     0,     0,
    22,     0,     7,     0,    12,     0,     0,     0,     0,     0,
     0,    49,     0,     0,    59,    58,     0,    20,    11,    61,
    37,     0,     0,    40,    41,     0,    35,     0,    47,    42,
    63,    44,    66,     6,    13,    15,    21,    23,    25,    16,
     0,     0,     0,    49,    28,    17,     0,    50,     0,    18,
    19,     9,    38,    39,     0,    51,    62,     0,    48,     0,
    65,    24,    32,     0,     0,     0,     0,    33,     0,    56,
    36,     0,     0,    64,    29,    30,    31,    53,    54,    26,
     0,    34,    49,    55,    43,    45,     0,     0,    27,    46,
     0,     0,     0
};

static const short rc_yydefgoto[] = {   111,
     4,     5,     6,     7,    23,    24,    25,    26,    27,    57,
    58,    28,    63,   103,    44,    74,    45,    64,    51,    47,
    81,    65,    48,    69,    49,    29,   100,   101,    30,    31,
    32,    59,    33,    34
};

static const short rc_yypact[] = {    17,
-32768,-32768,    20,    13,-32768,    95,    31,-32768,-32768,-32768,
    22,-32768,    24,-32768,-32768,    31,-32768,     4,     4,     4,
-32768,     3,-32768,    95,-32768,    33,    31,    37,   114,    49,
    56,     3,    58,    60,-32768,-32768,    62,-32768,-32768,-32768,
   -21,    31,    51,-32768,-32768,    31,-32768,    -5,-32768,-32768,
-32768,    43,     3,-32768,-32768,-32768,    31,-32768,-32768,-32768,
   114,   114,    40,     3,-32768,-32768,   149,     3,    31,-32768,
-32768,-32768,-32768,-32768,    44,-32768,-32768,    31,-32768,    31,
    31,-32768,-32768,    12,   114,   114,    77,    50,   113,-32768,
-32768,    47,    53,-32768,-32768,-32768,    71,-32768,-32768,-32768,
   149,-32768,     3,-32768,-32768,-32768,   131,    31,-32768,-32768,
    79,    82,-32768
};

static const short rc_yypgoto[] = {-32768,
-32768,    85,-32768,-32768,    75,   -56,   -23,-32768,-32768,-32768,
    45,-32768,   -57,-32768,    63,-32768,    48,    87,    97,-32768,
-32768,-32768,   -20,   -61,   -38,-32768,     0,-32768,-32768,-32768,
-32768,    -7,-32768,-32768
};


#define	YYLAST		169


static const short rc_yytable[] = {    37,
    55,    53,    88,    83,    84,    42,    87,    43,    40,    79,
    89,    68,    -1,     9,    79,     1,     2,    85,    86,     1,
     2,    78,     8,    43,    38,    41,    39,    96,    97,    79,
    42,    43,    43,     3,    75,    56,    95,     3,    77,    60,
    11,   108,    12,    68,   107,    85,    86,    14,    35,    36,
    15,    66,    16,    17,    18,    19,    20,    21,    67,    22,
    70,    90,    71,    55,    72,    55,    50,    50,    76,    80,
    92,    91,    93,    94,   105,   102,    85,    11,   112,    12,
   106,   113,    68,    55,    14,    98,    99,    15,    10,    16,
    17,    18,    19,    20,    21,    11,    22,    12,    54,    13,
   110,    82,    14,    73,    46,    15,   109,    16,    17,    18,
    19,    20,    21,    11,    22,    12,    52,     0,     0,     0,
    14,     0,     0,    15,   104,    16,    17,    18,    19,    20,
    21,    11,    22,    12,     0,    41,    61,    62,    14,    98,
    42,    15,    43,    16,    17,    18,    19,    20,    21,    11,
    22,    12,     0,     0,     0,     0,    14,     0,     0,    15,
     0,    16,    17,    18,    19,    20,    21,     0,    22
};

static const short rc_yycheck[] = {     7,
    24,    22,    64,    61,    62,    27,    63,    29,    16,    48,
    67,    32,     0,     1,    53,     3,     4,     6,     7,     3,
     4,    27,     3,    29,     3,    22,     3,    85,    86,    68,
    27,    29,    29,    21,    42,     3,    25,    21,    46,     3,
     1,   103,     3,    64,   101,     6,     7,     8,    18,    19,
    11,     3,    13,    14,    15,    16,    17,    18,     3,    20,
     3,    69,     3,    87,     3,    89,    19,    20,    18,    27,
    78,    28,    80,    81,    28,    26,     6,     1,     0,     3,
    28,     0,   103,   107,     8,     9,    10,    11,     4,    13,
    14,    15,    16,    17,    18,     1,    20,     3,    24,     5,
   108,    57,     8,    41,    18,    11,   107,    13,    14,    15,
    16,    17,    18,     1,    20,     3,    20,    -1,    -1,    -1,
     8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
    18,     1,    20,     3,    -1,    22,    23,    24,     8,     9,
    27,    11,    29,    13,    14,    15,    16,    17,    18,     1,
    20,     3,    -1,    -1,    -1,    -1,     8,    -1,    -1,    11,
    -1,    13,    14,    15,    16,    17,    18,    -1,    20
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define rc_yyerrok		(rc_yyerrstatus = 0)
#define rc_yyclearin	(rc_yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto rc_yyacceptlab
#define YYABORT 	goto rc_yyabortlab
#define YYERROR		goto rc_yyerrlab1
/* Like YYERROR except do call rc_yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto rc_yyerrlab
#define YYRECOVERING()  (!!rc_yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (rc_yychar == YYEMPTY && rc_yylen == 1)				\
    { rc_yychar = (token), rc_yylval = (value);			\
      rc_yychar1 = YYTRANSLATE (rc_yychar);				\
      YYPOPSTACK;						\
      goto rc_yybackup;						\
    }								\
  else								\
    { rc_yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		rc_yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		rc_yylex(&rc_yylval, &rc_yylloc, YYLEX_PARAM)
#else
#define YYLEX		rc_yylex(&rc_yylval, &rc_yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		rc_yylex(&rc_yylval, YYLEX_PARAM)
#else
#define YYLEX		rc_yylex(&rc_yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	rc_yychar;			/*  the lookahead symbol		*/
YYSTYPE	rc_yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE rc_yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int rc_yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int rc_yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __rc_yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __rc_yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__rc_yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__rc_yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into rc_yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int rc_yyparse (void *);
#else
int rc_yyparse (void);
#endif
#endif

int
rc_yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int rc_yystate;
  register int rc_yyn;
  register short *rc_yyssp;
  register YYSTYPE *rc_yyvsp;
  int rc_yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int rc_yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	rc_yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE rc_yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *rc_yyss = rc_yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *rc_yyvs = rc_yyvsa;	/*  to allow rc_yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE rc_yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *rc_yyls = rc_yylsa;
  YYLTYPE *rc_yylsp;

#define YYPOPSTACK   (rc_yyvsp--, rc_yyssp--, rc_yylsp--)
#else
#define YYPOPSTACK   (rc_yyvsp--, rc_yyssp--)
#endif

  int rc_yystacksize = YYINITDEPTH;
  int rc_yyfree_stacks = 0;

#ifdef YYPURE
  int rc_yychar;
  YYSTYPE rc_yylval;
  int rc_yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE rc_yylloc;
#endif
#endif

  YYSTYPE rc_yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int rc_yylen;

#if YYDEBUG != 0
  if (rc_yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  rc_yystate = 0;
  rc_yyerrstatus = 0;
  rc_yynerrs = 0;
  rc_yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  rc_yyssp = rc_yyss - 1;
  rc_yyvsp = rc_yyvs;
#ifdef YYLSP_NEEDED
  rc_yylsp = rc_yyls;
#endif

/* Push a new state, which is found in  rc_yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
rc_yynewstate:

  *++rc_yyssp = rc_yystate;

  if (rc_yyssp >= rc_yyss + rc_yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *rc_yyvs1 = rc_yyvs;
      short *rc_yyss1 = rc_yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *rc_yyls1 = rc_yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = rc_yyssp - rc_yyss + 1;

#ifdef rc_yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if rc_yyoverflow is a macro.  */
      rc_yyoverflow("parser stack overflow",
		 &rc_yyss1, size * sizeof (*rc_yyssp),
		 &rc_yyvs1, size * sizeof (*rc_yyvsp),
		 &rc_yyls1, size * sizeof (*rc_yylsp),
		 &rc_yystacksize);
#else
      rc_yyoverflow("parser stack overflow",
		 &rc_yyss1, size * sizeof (*rc_yyssp),
		 &rc_yyvs1, size * sizeof (*rc_yyvsp),
		 &rc_yystacksize);
#endif

      rc_yyss = rc_yyss1; rc_yyvs = rc_yyvs1;
#ifdef YYLSP_NEEDED
      rc_yyls = rc_yyls1;
#endif
#else /* no rc_yyoverflow */
      /* Extend the stack our own way.  */
      if (rc_yystacksize >= YYMAXDEPTH)
	{
	  rc_yyerror("parser stack overflow");
	  if (rc_yyfree_stacks)
	    {
	      free (rc_yyss);
	      free (rc_yyvs);
#ifdef YYLSP_NEEDED
	      free (rc_yyls);
#endif
	    }
	  return 2;
	}
      rc_yystacksize *= 2;
      if (rc_yystacksize > YYMAXDEPTH)
	rc_yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      rc_yyfree_stacks = 1;
#endif
      rc_yyss = (short *) YYSTACK_ALLOC (rc_yystacksize * sizeof (*rc_yyssp));
      __rc_yy_memcpy ((char *)rc_yyss, (char *)rc_yyss1,
		   size * (unsigned int) sizeof (*rc_yyssp));
      rc_yyvs = (YYSTYPE *) YYSTACK_ALLOC (rc_yystacksize * sizeof (*rc_yyvsp));
      __rc_yy_memcpy ((char *)rc_yyvs, (char *)rc_yyvs1,
		   size * (unsigned int) sizeof (*rc_yyvsp));
#ifdef YYLSP_NEEDED
      rc_yyls = (YYLTYPE *) YYSTACK_ALLOC (rc_yystacksize * sizeof (*rc_yylsp));
      __rc_yy_memcpy ((char *)rc_yyls, (char *)rc_yyls1,
		   size * (unsigned int) sizeof (*rc_yylsp));
#endif
#endif /* no rc_yyoverflow */

      rc_yyssp = rc_yyss + size - 1;
      rc_yyvsp = rc_yyvs + size - 1;
#ifdef YYLSP_NEEDED
      rc_yylsp = rc_yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (rc_yydebug)
	fprintf(stderr, "Stack size increased to %d\n", rc_yystacksize);
#endif

      if (rc_yyssp >= rc_yyss + rc_yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (rc_yydebug)
    fprintf(stderr, "Entering state %d\n", rc_yystate);
#endif

  goto rc_yybackup;
 rc_yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* rc_yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  rc_yyn = rc_yypact[rc_yystate];
  if (rc_yyn == YYFLAG)
    goto rc_yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* rc_yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (rc_yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (rc_yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      rc_yychar = YYLEX;
    }

  /* Convert token to internal form (in rc_yychar1) for indexing tables with */

  if (rc_yychar <= 0)		/* This means end of input. */
    {
      rc_yychar1 = 0;
      rc_yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (rc_yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      rc_yychar1 = YYTRANSLATE(rc_yychar);

#if YYDEBUG != 0
      if (rc_yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", rc_yychar, rc_yytname[rc_yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, rc_yychar, rc_yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  rc_yyn += rc_yychar1;
  if (rc_yyn < 0 || rc_yyn > YYLAST || rc_yycheck[rc_yyn] != rc_yychar1)
    goto rc_yydefault;

  rc_yyn = rc_yytable[rc_yyn];

  /* rc_yyn is what to do for this token type in this state.
     Negative => reduce, -rc_yyn is rule number.
     Positive => shift, rc_yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (rc_yyn < 0)
    {
      if (rc_yyn == YYFLAG)
	goto rc_yyerrlab;
      rc_yyn = -rc_yyn;
      goto rc_yyreduce;
    }
  else if (rc_yyn == 0)
    goto rc_yyerrlab;

  if (rc_yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (rc_yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", rc_yychar, rc_yytname[rc_yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (rc_yychar != YYEOF)
    rc_yychar = YYEMPTY;

  *++rc_yyvsp = rc_yylval;
#ifdef YYLSP_NEEDED
  *++rc_yylsp = rc_yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (rc_yyerrstatus) rc_yyerrstatus--;

  rc_yystate = rc_yyn;
  goto rc_yynewstate;

/* Do the default action for the current state.  */
rc_yydefault:

  rc_yyn = rc_yydefact[rc_yystate];
  if (rc_yyn == 0)
    goto rc_yyerrlab;

/* Do a reduction.  rc_yyn is the number of a rule to reduce with.  */
rc_yyreduce:
  rc_yylen = rc_yyr2[rc_yyn];
  if (rc_yylen > 0)
    rc_yyval = rc_yyvsp[1-rc_yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (rc_yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       rc_yyn, rc_yyrline[rc_yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = rc_yyprhs[rc_yyn]; rc_yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", rc_yytname[rc_yyrhs[i]]);
      fprintf (stderr, " -> %s\n", rc_yytname[rc_yyr1[rc_yyn]]);
    }
#endif


  switch (rc_yyn) {

case 1:
#line 107 "rcfile.y"
{
           ;
    break;}
case 2:
#line 112 "rcfile.y"
{
		   rc_yyval.section = rc_section = rc_yyvsp[0].section;
	   ;
    break;}
case 3:
#line 116 "rcfile.y"
{
		   if (rc_yyvsp[0].section) {
			   if (rc_section == NULL) {
				   rc_yyval.section = rc_section = rc_yyvsp[0].section;
			   } else {
				   rc_yyvsp[-1].section->next = rc_yyvsp[0].section;
				   rc_yyval.section = rc_yyvsp[0].section;
			   } 
		   }
	   ;
    break;}
case 4:
#line 127 "rcfile.y"
{
		   lex_clear_state();
		   error_sync_begin();
		   rc_yyerrok;
		   rc_yyclearin;
	   ;
    break;}
case 5:
#line 136 "rcfile.y"
{
		   rc_yyval.section = NULL;
	   ;
    break;}
case 6:
#line 140 "rcfile.y"
{
		   rc_yyval.section = rc_section_create(rc_yyvsp[-2].string, rc_yyvsp[-1].stmtlist.head);
	   ;
    break;}
case 7:
#line 144 "rcfile.y"
{
		   rc_yyval.section = NULL;
	   ;
    break;}
case 8:
#line 149 "rcfile.y"
{ verbatim(); ;
    break;}
case 9:
#line 150 "rcfile.y"
{
		   rc_yyval.string = rc_yyvsp[-1].string;
		   if (rc_section_lookup(rc_section, rc_yyvsp[-1].string)) 
			   parse_error(_("Section %s already defined"), rc_yyvsp[-1].string);
		   rc_secdef = anubis_find_section(rc_yyvsp[-1].string);
	   ;
    break;}
case 10:
#line 157 "rcfile.y"
{
		   if (rc_section_lookup(rc_section, rc_yyvsp[-1].string)) 
			   parse_error(_("Section %s already defined"), rc_yyvsp[-1].string);
		   rc_secdef = anubis_find_section(rc_yyvsp[-1].string);
	   ;
    break;}
case 12:
#line 168 "rcfile.y"
{
		   rc_yyval.stmtlist.head = rc_yyval.stmtlist.tail = rc_yyvsp[0].stmt;
	   ;
    break;}
case 13:
#line 172 "rcfile.y"
{
		   if (rc_yyvsp[0].stmt) {
			   if (rc_yyval.stmtlist.head == NULL) {
				   rc_yyval.stmtlist.head = rc_yyval.stmtlist.tail = rc_yyvsp[0].stmt;
			   } else {
				   rc_yyval.stmtlist.tail->next = rc_yyvsp[0].stmt;
				   rc_yyval.stmtlist.tail = rc_yyvsp[0].stmt;
			   } 
		   }
	   ;
    break;}
case 14:
#line 185 "rcfile.y"
{
		   rc_yyval.stmt = NULL;
	   ;
    break;}
case 20:
#line 194 "rcfile.y"
{
		   lex_clear_state();
		   rc_yyerrok;
		   rc_yyclearin;
		   rc_yyval.stmt = NULL;
	   ;
    break;}
case 21:
#line 203 "rcfile.y"
{
		   if (!check_kw(rc_yyvsp[-1].string)) {
			   parse_error(_("unknown keyword: %s"), rc_yyvsp[-1].string);
			   YYERROR;
		   }

		   rc_yyval.stmt = rc_stmt_create(rc_stmt_asgn);
		   rc_yyval.stmt->v.asgn.lhs = rc_yyvsp[-1].string;
		   if (list_count(rc_yyvsp[0].list)) {
			   char *s = list_item(rc_yyvsp[0].list, 0);
			   if (s && strcmp(s, "=") == 0)
				   list_remove(rc_yyvsp[0].list, s, NULL);
		   }
		   rc_yyval.stmt->v.asgn.rhs = rc_yyvsp[0].list;
	   ;
    break;}
case 22:
#line 221 "rcfile.y"
{
		   verbatim();
	   ;
    break;}
case 23:
#line 227 "rcfile.y"
{
		   rc_yyval.list = list_create();
		   list_append(rc_yyval.list, rc_yyvsp[0].string);
	   ;
    break;}
case 24:
#line 232 "rcfile.y"
{
		   list_append(rc_yyvsp[-1].list, rc_yyvsp[0].string);
		   rc_yyval.list = rc_yyvsp[-1].list;
	   ;
    break;}
case 26:
#line 242 "rcfile.y"
{
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_cond);
		   rc_yyval.stmt->v.cond.node = rc_yyvsp[-2].node;
		   rc_yyval.stmt->v.cond.iftrue = rc_yyvsp[-1].stmtlist.head;
		   rc_yyval.stmt->v.cond.iffalse = NULL;
	   ;
    break;}
case 27:
#line 249 "rcfile.y"
{
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_cond);
		   rc_yyval.stmt->v.cond.node = rc_yyvsp[-4].node;
		   rc_yyval.stmt->v.cond.iftrue = rc_yyvsp[-3].stmtlist.head;
		   rc_yyval.stmt->v.cond.iffalse = rc_yyvsp[-1].stmtlist.head;
	   ;
    break;}
case 29:
#line 259 "rcfile.y"
{
		   rc_yyval.node = rc_yyvsp[-1].node;
	   ;
    break;}
case 30:
#line 263 "rcfile.y"
{
		   rc_yyval.node = rc_node_create(rc_node_bool);
		   rc_yyval.node->v.bool.op = bool_and;
		   rc_yyval.node->v.bool.left = rc_yyvsp[-2].node;
		   rc_yyval.node->v.bool.right = rc_yyvsp[0].node;
	   ;
    break;}
case 31:
#line 270 "rcfile.y"
{
		   rc_yyval.node = rc_node_create(rc_node_bool);
		   rc_yyval.node->v.bool.op = bool_or;
		   rc_yyval.node->v.bool.left = rc_yyvsp[-2].node;
		   rc_yyval.node->v.bool.right = rc_yyvsp[0].node;
	   ;
    break;}
case 32:
#line 277 "rcfile.y"
{
		   rc_yyval.node = rc_node_create(rc_node_bool);
		   rc_yyval.node->v.bool.op = bool_not;
		   rc_yyval.node->v.bool.left = rc_yyvsp[0].node;
		   rc_yyval.node->v.bool.right = NULL;
	   ;
    break;}
case 35:
#line 290 "rcfile.y"
{
		   rc_yyval.msgpart.part = HEADER;
		   rc_yyval.msgpart.key = rc_yyvsp[0].regex;
		   rc_yyval.msgpart.string = NULL;
	   ;
    break;}
case 36:
#line 296 "rcfile.y"
{
		   rc_yyval.msgpart.part = HEADER;
		   rc_yyval.msgpart.key = NULL;
		   rc_yyval.msgpart.string = rc_yyvsp[-1].string;
	   ;
    break;}
case 37:
#line 304 "rcfile.y"
{
		   rc_yyval.msgpart.string = NULL;
		   rc_yyval.msgpart.key = NULL;
           ;
    break;}
case 39:
#line 312 "rcfile.y"
{
		   rc_yyval.msgpart = rc_yyvsp[0].msgpart;
		   rc_yyval.msgpart.part = rc_yyvsp[-1].num;
	   ;
    break;}
case 41:
#line 320 "rcfile.y"
{
		   rc_yyval.msgpart = rc_yyvsp[0].msgpart;
		   if (rc_yyval.msgpart.key)
			   parse_error("regexp is not allowed in this context");
	   ;
    break;}
case 42:
#line 328 "rcfile.y"
{
		   rc_yyval.msgpart = rc_yyvsp[0].msgpart;
		   if (!rc_yyval.msgpart.key) {
			   rc_yyval.msgpart.key = anubis_regex_compile(rc_yyval.msgpart.string, R_EXACT);
			   xfree(rc_yyval.msgpart.string);
		   }
	   ;
    break;}
case 43:
#line 338 "rcfile.y"
{
		   rc_yyval.regex = anubis_regex_compile(rc_yyvsp[-1].string, rc_yyvsp[-3].num);
		   free(rc_yyvsp[-1].string);
	   ;
    break;}
case 44:
#line 345 "rcfile.y"
{
		   rc_yyval.string = NULL;
	   ;
    break;}
case 45:
#line 349 "rcfile.y"
{
		   rc_yyval.string = rc_yyvsp[-1].string;
	   ;
    break;}
case 46:
#line 355 "rcfile.y"
{
		   rc_yyval.node = rc_node_create(rc_node_expr);
		   rc_yyval.node->v.expr.part = rc_yyvsp[-4].msgpart.part;
		   rc_yyval.node->v.expr.key = rc_yyvsp[-4].msgpart.string;
		   rc_yyval.node->v.expr.re = anubis_regex_compile(rc_yyvsp[0].string, rc_yyvsp[-1].num|rc_yyvsp[-3].num);
		   free(rc_yyvsp[0].string);
	   ;
    break;}
case 47:
#line 365 "rcfile.y"
{
		   rc_yyval.num = def_regex_modifier;
		   reg_modifier_add(&rc_yyval.num, rc_yyvsp[0].string);
		   xfree(rc_yyvsp[0].string);
	   ;
    break;}
case 48:
#line 371 "rcfile.y"
{
		   reg_modifier_add(&rc_yyvsp[-1].num, rc_yyvsp[0].string);
		   xfree(rc_yyvsp[0].string);
		   rc_yyval.num = rc_yyvsp[-1].num;
	   ;
    break;}
case 49:
#line 379 "rcfile.y"
{
		   rc_yyval.num = def_regex_modifier;
	   ;
    break;}
case 51:
#line 386 "rcfile.y"
{
		   rc_yyval.string = rc_yyvsp[0].string;
	   ;
    break;}
case 52:
#line 392 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
	   ;
    break;}
case 55:
#line 405 "rcfile.y"
{
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_rule);
		   rc_yyval.stmt->v.rule.node = rc_yyvsp[-3].node;
		   rc_yyval.stmt->v.rule.stmt = rc_yyvsp[-1].stmtlist.head;
	   ;
    break;}
case 56:
#line 413 "rcfile.y"
{
		   rc_yyval.node = rc_node_create(rc_node_expr);
		   rc_yyval.node->v.expr.part = HEADER;
		   rc_yyval.node->v.expr.key = strdup(X_ANUBIS_RULE_HEADER);
		   rc_yyval.node->v.expr.re = anubis_regex_compile(rc_yyvsp[0].string, rc_yyvsp[-1].num);
		   free(rc_yyvsp[0].string);
	   ;
    break;}
case 57:
#line 423 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
	   ;
    break;}
case 60:
#line 434 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_stop;
		   rc_yyval.stmt->v.inst.part = NIL;
		   rc_yyval.stmt->v.inst.key  = NULL;
		   rc_yyval.stmt->v.inst.key2 = NULL;
		   rc_yyval.stmt->v.inst.arg  = NULL;
	   ;
    break;}
case 61:
#line 445 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_call;
		   rc_yyval.stmt->v.inst.key = NULL;
		   rc_yyval.stmt->v.inst.part = NIL;
		   rc_yyval.stmt->v.inst.key2 = NULL;
		   rc_yyval.stmt->v.inst.arg  = rc_yyvsp[0].string;
	   ;
    break;}
case 62:
#line 456 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_add;
		   rc_yyval.stmt->v.inst.part = rc_yyvsp[-1].msgpart.part;
		   rc_yyval.stmt->v.inst.key  = NULL;
		   rc_yyval.stmt->v.inst.key2 = rc_yyvsp[-1].msgpart.string;
		   rc_yyval.stmt->v.inst.arg  = rc_yyvsp[0].string;
	   ;
    break;}
case 63:
#line 467 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_remove;
		   rc_yyval.stmt->v.inst.part = rc_yyvsp[0].msgpart.part;
		   rc_yyval.stmt->v.inst.key = rc_yyvsp[0].msgpart.key;
		   rc_yyval.stmt->v.inst.key2 = NULL;
		   rc_yyval.stmt->v.inst.arg  = NULL;
	   ;
    break;}
case 64:
#line 478 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_modify;
		   rc_yyval.stmt->v.inst.part = rc_yyvsp[-2].msgpart.part;
		   rc_yyval.stmt->v.inst.key  = rc_yyvsp[-2].msgpart.key;
		   rc_yyval.stmt->v.inst.key2 = rc_yyvsp[-1].string;
		   rc_yyval.stmt->v.inst.arg  = rc_yyvsp[0].string;
	   ;
    break;}
case 65:
#line 489 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   rc_yyval.stmt = rc_stmt_create(rc_stmt_inst);
		   rc_yyval.stmt->v.inst.opcode = inst_modify;
		   rc_yyval.stmt->v.inst.part = rc_yyvsp[-1].msgpart.part;
		   rc_yyval.stmt->v.inst.key  = rc_yyvsp[-1].msgpart.key;
		   if (rc_yyvsp[0].string == NULL) {
			   parse_error(_("missing replacement value"));
		   }
		   rc_yyval.stmt->v.inst.key2 = rc_yyvsp[0].string;
		   rc_yyval.stmt->v.inst.arg  = NULL;
	   ;
    break;}
case 66:
#line 505 "rcfile.y"
{
		   if (!is_prog_allowed())
			   YYERROR;
		   def_regex_modifier = rc_yyvsp[0].num;
		   rc_yyval.stmt = NULL;
	   ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  rc_yyvsp -= rc_yylen;
  rc_yyssp -= rc_yylen;
#ifdef YYLSP_NEEDED
  rc_yylsp -= rc_yylen;
#endif

#if YYDEBUG != 0
  if (rc_yydebug)
    {
      short *ssp1 = rc_yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != rc_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++rc_yyvsp = rc_yyval;

#ifdef YYLSP_NEEDED
  rc_yylsp++;
  if (rc_yylen == 0)
    {
      rc_yylsp->first_line = rc_yylloc.first_line;
      rc_yylsp->first_column = rc_yylloc.first_column;
      rc_yylsp->last_line = (rc_yylsp-1)->last_line;
      rc_yylsp->last_column = (rc_yylsp-1)->last_column;
      rc_yylsp->text = 0;
    }
  else
    {
      rc_yylsp->last_line = (rc_yylsp+rc_yylen-1)->last_line;
      rc_yylsp->last_column = (rc_yylsp+rc_yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  rc_yyn = rc_yyr1[rc_yyn];

  rc_yystate = rc_yypgoto[rc_yyn - YYNTBASE] + *rc_yyssp;
  if (rc_yystate >= 0 && rc_yystate <= YYLAST && rc_yycheck[rc_yystate] == *rc_yyssp)
    rc_yystate = rc_yytable[rc_yystate];
  else
    rc_yystate = rc_yydefgoto[rc_yyn - YYNTBASE];

  goto rc_yynewstate;

rc_yyerrlab:   /* here on detecting error */

  if (! rc_yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++rc_yynerrs;

#ifdef YYERROR_VERBOSE
      rc_yyn = rc_yypact[rc_yystate];

      if (rc_yyn > YYFLAG && rc_yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -rc_yyn if nec to avoid negative indexes in rc_yycheck.  */
	  for (x = (rc_yyn < 0 ? -rc_yyn : 0);
	       x < (sizeof(rc_yytname) / sizeof(char *)); x++)
	    if (rc_yycheck[x + rc_yyn] == x)
	      size += strlen(rc_yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (rc_yyn < 0 ? -rc_yyn : 0);
		       x < (sizeof(rc_yytname) / sizeof(char *)); x++)
		    if (rc_yycheck[x + rc_yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, rc_yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      rc_yyerror(msg);
	      free(msg);
	    }
	  else
	    rc_yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	rc_yyerror("parse error");
    }

  goto rc_yyerrlab1;
rc_yyerrlab1:   /* here on error raised explicitly by an action */

  if (rc_yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (rc_yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (rc_yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", rc_yychar, rc_yytname[rc_yychar1]);
#endif

      rc_yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  rc_yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto rc_yyerrhandle;

rc_yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  rc_yyn = rc_yydefact[rc_yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (rc_yyn) goto rc_yydefault;
#endif

rc_yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (rc_yyssp == rc_yyss) YYABORT;
  rc_yyvsp--;
  rc_yystate = *--rc_yyssp;
#ifdef YYLSP_NEEDED
  rc_yylsp--;
#endif

#if YYDEBUG != 0
  if (rc_yydebug)
    {
      short *ssp1 = rc_yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != rc_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

rc_yyerrhandle:

  rc_yyn = rc_yypact[rc_yystate];
  if (rc_yyn == YYFLAG)
    goto rc_yyerrdefault;

  rc_yyn += YYTERROR;
  if (rc_yyn < 0 || rc_yyn > YYLAST || rc_yycheck[rc_yyn] != YYTERROR)
    goto rc_yyerrdefault;

  rc_yyn = rc_yytable[rc_yyn];
  if (rc_yyn < 0)
    {
      if (rc_yyn == YYFLAG)
	goto rc_yyerrpop;
      rc_yyn = -rc_yyn;
      goto rc_yyreduce;
    }
  else if (rc_yyn == 0)
    goto rc_yyerrpop;

  if (rc_yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (rc_yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++rc_yyvsp = rc_yylval;
#ifdef YYLSP_NEEDED
  *++rc_yylsp = rc_yylloc;
#endif

  rc_yystate = rc_yyn;
  goto rc_yynewstate;

 rc_yyacceptlab:
  /* YYACCEPT comes here.  */
  if (rc_yyfree_stacks)
    {
      free (rc_yyss);
      free (rc_yyvs);
#ifdef YYLSP_NEEDED
      free (rc_yyls);
#endif
    }
  return 0;

 rc_yyabortlab:
  /* YYABORT comes here.  */
  if (rc_yyfree_stacks)
    {
      free (rc_yyss);
      free (rc_yyvs);
#ifdef YYLSP_NEEDED
      free (rc_yyls);
#endif
    }
  return 1;
}
#line 513 "rcfile.y"


static int
err_line_num()
{
	return rc_yychar == EOL ? cfg_line_num - 1 : cfg_line_num;
}

void
parse_error(const char *fmt, ...)
{
	char buf[LINEBUFFER];
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(buf, sizeof buf, fmt, ap);
	va_end(ap);
	anubis_error(SYNTAX, "%s:%d: %s", cfg_file, err_line_num(), buf);
	error_count++;
}

int
rc_yyerror(char *s)
{
	anubis_error(SYNTAX, "%s:%d: %s", cfg_file, err_line_num(), s);
	error_count++;
	return 0;
}

RC_SECTION *
rc_parse(char *name)
{
	int status;
	if (rc_open(name))
		return NULL;
	rc_section = NULL;
	error_count = 0;
	status = rc_yyparse();
	if (status || error_count) 
		rc_section_list_destroy(&rc_section);
	if (debug_level)
		rc_section_print(rc_section);
	return rc_section;
}

void
rc_set_debug_level(char *arg)
{
	if (!arg)
		debug_level = 0;
	else
		debug_level = arg[0] - '0';
	if (debug_level > 1)
		rc_yydebug = debug_level;
}

/* Section manipulation */
RC_SECTION *
rc_section_create(char *name, RC_STMT *stmt)
{
	RC_SECTION *p = xmalloc(sizeof(*p));
	p->next = NULL;
	p->name = name;
	p->stmt = stmt;
	return p;
}

void
rc_section_destroy(RC_SECTION **s)
{
	rc_stmt_list_destroy((*s)->stmt);
	xfree((*s)->name);
	xfree(*s);
}

void
rc_section_list_destroy(RC_SECTION **s)
{
	while (*s) {
		RC_SECTION *next = (*s)->next;
		rc_section_destroy(s);
		*s = next;
	}
}

void
rc_section_print(RC_SECTION *sect)
{
	for (; sect; sect = sect->next) {
		printf("BEGIN SECTION %s\n", sect->name);
		rc_stmt_print(sect->stmt, 1);
		printf("END SECTION %s\n", sect->name);
	}
}

RC_SECTION *
rc_section_lookup(RC_SECTION *sec, char *name)
{
	for (; sec; sec = sec->next)
		if (strcmp(sec->name, name) == 0)
			break;
	return sec;
}

void
rc_section_link(RC_SECTION **ap, RC_SECTION *b)
{
	RC_SECTION *a, *prev;
	
	/* Remove all sections with prio == override (the default) */
	a = *ap;
	prev = NULL;
	while (a) {
		RC_SECTION *next = a->next;
		struct rc_secdef *sd = anubis_find_section(a->name);
		if (sd && sd->prio == prio_user_only) {
			if (prev)
				prev->next = next;
			else
				*ap = next;
			rc_section_destroy(&a);
		} else
			prev = a;
		a = next;
	}
		
	if (!*ap) {
		*ap = b;
		return;
	}

	for (a = *ap; a->next; a = a->next)
		;

	while (b) {
		struct rc_secdef *sd;
		RC_SECTION *nxtptr = b->next;

		sd = anubis_find_section(b->name);
		if (sd) {
			switch (sd->prio) {
			case prio_user:
				b->next = *ap;
				*ap = b;
				break;
				
			case prio_system_only:
				rc_section_destroy(&b);
				break;

			default:
				b->next = NULL;
				a->next = b;
				a = b;
			}
		} else {
			b->next = NULL;
			a->next = b;
			a = b;
		}
		b = nxtptr;
	}
}

/* Assignment manipulations */

static int
_free_mem(void *item, void *data)
{
	free(item);
	return 0;
}

void
rc_asgn_destroy(RC_ASGN *asgn)
{
	xfree(asgn->lhs);
	list_destroy(&asgn->rhs, _free_mem, NULL);
}

/* Bools */

void
rc_bool_destroy(RC_BOOL *bool)
{
	rc_node_destroy(bool->left);
	rc_node_destroy(bool->right);
}

/* Nodes */

RC_NODE *
rc_node_create(enum rc_node_type t)
{
	RC_NODE *p = xmalloc(sizeof(*p));
	memset(p, 0, sizeof(*p));
	p->type = t;
	return p;
}

void
rc_node_destroy(RC_NODE *node)
{
	if (!node)
		return;
	switch (node->type) {
	case rc_node_bool:
		rc_bool_destroy(&node->v.bool);
		break;
		
	case rc_node_expr:
		free(node->v.expr.key);
		anubis_regex_free(&node->v.expr.re);
	}
	xfree(node);
}

static char *
part_string(int part)
{
	switch (part) {
	case NIL:
		return "NIL";
	case COMMAND:
		return "COMMAND";
	case HEADER:
		return "HEADER";
	case BODY:
		return "BODY";
	default:
		return "UNKNOWN";
	}
}

void
rc_node_print(RC_NODE *node)
{
	switch (node->type) {
	case rc_node_expr:
		printf("%s", part_string(node->v.expr.part));
		if (node->v.expr.key && node->v.expr.key[0] != '\n')
			printf("[%s]",node->v.expr.key);
		printf(" ");
		anubis_regex_print(node->v.expr.re);
		break;
		
	case rc_node_bool:
		switch (node->v.bool.op) {
		case bool_not:
			printf("NOT (");
			rc_node_print(node->v.bool.left);
			printf(")");
			break;
			
		case bool_and:
			printf("AND (");
			rc_node_print(node->v.bool.left);
			printf(",");
			rc_node_print(node->v.bool.right);
			printf(")");
			break;
			
		case bool_or:
			printf("OR (");
			rc_node_print(node->v.bool.left);
			printf(",");
			rc_node_print(node->v.bool.right);
			printf(")");
			break;
		}
	}
}

/* Rules */

void
rc_rule_destroy(RC_RULE *rule)
{
	rc_node_destroy(rule->node);
	rc_stmt_list_destroy(rule->stmt);
}

/* Conditionals */

void
rc_cond_destroy(RC_COND *cond)
{
	rc_node_destroy(cond->node);
	rc_stmt_list_destroy(cond->iftrue);
	rc_stmt_list_destroy(cond->iffalse);
}

/* Instructions */

void
rc_inst_destroy(RC_INST *inst)
{
	anubis_regex_free(&inst->key);
	free(inst->key2);
	free(inst->arg);
}

static char *
inst_name(enum rc_inst_opcode opcode)
{
	switch (opcode) {
	case inst_stop:
		return "STOP";
	case inst_call:
		return "CALL";
	case inst_add:
		return "ADD";
	case inst_remove:
		return "REMOVE";
	case inst_modify:
		return "MODIFY";
	}
	return "UNKNOWN";
}

void
rc_inst_print(RC_INST *inst, int level)
{
	rc_level_print(level, inst_name(inst->opcode));
	switch (inst->opcode) {
	case inst_stop:
		break;
		
	case inst_call:
		printf(" %s", inst->arg);
		break;

	case inst_add:
		printf(" %s[%s]", part_string(inst->part), inst->key2);
		if (inst->arg)
			printf(" \"%s\"", inst->arg);
		break;
		
	default:
		printf(" %s ", part_string(inst->part));
		if (inst->key)
			anubis_regex_print(inst->key);
		if (inst->key2)
			printf(" [%s]", inst->key2);
		if (inst->arg)
			printf(" \"%s\"", inst->arg);
	}
}

/* Statements */
RC_STMT *
rc_stmt_create(enum rc_stmt_type type)
{
	RC_STMT *p = xmalloc(sizeof(*p));
	memset(p, 0, sizeof(*p));
	p->type = type;
	return p;
}

void
rc_stmt_destroy(RC_STMT *stmt)
{
	switch (stmt->type) {
	case rc_stmt_asgn:
		rc_asgn_destroy(&stmt->v.asgn);
		break;
		
	case rc_stmt_rule:
		rc_rule_destroy(&stmt->v.rule);
		break;
		
	case rc_stmt_cond:
		rc_cond_destroy(&stmt->v.cond);
		break;

	case rc_stmt_inst:
		rc_inst_destroy(&stmt->v.inst);
	}
	xfree(stmt);
}

void
rc_stmt_list_destroy(RC_STMT *stmt)
{
	while (stmt) {
		RC_STMT *next = stmt->next;
		rc_stmt_destroy(stmt);
		stmt = next;
	}
}

void
rc_level_print(int level, char *str)
{
	int i;

	for (i = 0; i < level*2; i++)
		putchar(' ');
	printf("%s", str);
}

static int
_print_str(void *item, void *data)
{
	printf(" %s", (char*)item);
	return 0;
}

void
rc_stmt_print(RC_STMT *stmt, int level)
{
	for (; stmt; stmt = stmt->next) {
		switch (stmt->type) {
		case rc_stmt_asgn:
			rc_level_print(level, "ASGN: ");
			printf("%s =", stmt->v.asgn.lhs);
			list_iterate(stmt->v.asgn.rhs, _print_str, NULL);
			break;
			
		case rc_stmt_cond:
			rc_level_print(level, "COND: ");
			rc_node_print(stmt->v.cond.node);
			printf("\n");
			rc_level_print(level, "IFTRUE:\n");
			rc_stmt_print(stmt->v.cond.iftrue, level+1);
			if (stmt->v.cond.iffalse) {
				rc_level_print(level, "IFFALSE:\n");
				rc_stmt_print(stmt->v.cond.iffalse, level+1);
			}
			rc_level_print(level, "END COND");
			break;
			
		case rc_stmt_rule:
			rc_level_print(level, "RULE: ");
			rc_node_print(stmt->v.rule.node);
			printf("\n");
			rc_level_print(level, "BODY\n");
			rc_stmt_print(stmt->v.rule.stmt, level+1);
			rc_level_print(level, "END RULE");
			break;

		case rc_stmt_inst:
			rc_inst_print(&stmt->v.inst, level);
			break;
			
		default:
			abort();
		}
		printf("\n");
	}
}

int
reg_modifier_add(int *flag, char *opt)
{
	/* Regex types */
	if (strcasecmp(opt, "re") == 0 || strcasecmp(opt, "regex") == 0)
		re_set_type(*flag, re_typeof(def_regex_modifier));
	else if (strcasecmp(opt, "posix") == 0)
		re_set_type(*flag, R_POSIX);
#ifdef HAVE_PCRE
	else if (strcasecmp(opt, "perlre") == 0
		 || strcasecmp(opt, "perl") == 0)
		re_set_type(*flag, R_PERLRE);
#endif
	else if (strcasecmp(opt, "ex") == 0 || strcasecmp(opt, "exact") == 0)
		re_set_type(*flag, R_EXACT);

	/* Modifiers: */
	else if (strcasecmp(opt, "basic") == 0) {
		re_set_type(*flag, R_POSIX);
		re_set_flag(*flag, R_BASIC);
	} else if (strcasecmp(opt, "extended") == 0) {
		re_set_type(*flag, R_POSIX);
		re_clear_flag(*flag, R_BASIC);
	} else if (strcasecmp(opt, "scase") == 0)
		re_set_flag(*flag, R_SCASE);
	else if (strcasecmp(opt, "icase") == 0)
		re_clear_flag(*flag, R_SCASE);
	else {
		parse_error(_("Unknown regexp modifier"));
		return 1;
	}
	return 0;
}


/* ******************************* Runtime ********************************* */
static struct rc_secdef_child *
child_copy(struct rc_secdef_child *p)
{
	struct rc_secdef_child *newp = xmalloc(sizeof(*newp));
	memcpy(newp, p, sizeof(*newp));
	newp->next = NULL;
	return newp;
}	

void
rc_secdef_add_child(struct rc_secdef *def, struct rc_secdef_child *child)
{
	struct rc_secdef_child *p = child_copy(child);
	if (!def->child)
		def->child = p;
	else {
		struct rc_secdef_child *last;

		for (last = def->child; last->next; last = last->next)
			;
		last->next = p;
	}
}

struct rc_secdef_child *
rc_child_lookup(struct rc_secdef_child *child, char *str, int method, int *key)
{
	for (; child; child = child->next) {
		if (child->method & method) {
			struct rc_kwdef *kw;
			for (kw = child->kwdef; kw->name; kw++)
				if (strcmp(kw->name, str) == 0) {
					*key = kw->tok;
					return child;
				}
		}
	}
	return NULL;
}

struct eval_env {
	int method;
	int cmp_method;
	struct rc_secdef_child *child;
	MESSAGE *msg;
	void *data;
	int refcnt;
	char **refstr;
	jmp_buf jmp;
};

static void asgn_eval(struct eval_env *env, RC_ASGN *asgn);
static int node_eval(struct eval_env *env, RC_NODE *node);
static int bool_eval(struct eval_env *env, RC_BOOL *bool);
static void cond_eval(struct eval_env *env, RC_COND *cond);
static void rule_eval(struct eval_env *env, RC_RULE *rule);
static void stmt_list_eval(struct eval_env *env, RC_STMT *stmt);
static void inst_eval(struct eval_env *env, RC_INST *inst);

void
inst_eval(struct eval_env *env, RC_INST *inst)
{
	char *arg = NULL, *argp = NULL;

	if (!env->msg)
		return; /* FIXME: bail out? */
	
	if (inst->arg) {
		if (env->refstr)
			arg = argp = substitute(inst->arg, env->refstr);
		else
			arg = inst->arg;
	}
	
	switch (inst->opcode) {
	case inst_stop:
		longjmp(env->jmp, 1);
		break;

	case inst_call:
		rcfile_call_section(env->method, inst->arg,
				    env->data, env->msg);
		break;
		
	case inst_add:
		if (inst->part == BODY)
			message_add_body(env->msg, inst->key2, arg);
		else
			message_add_header(env->msg, inst->key2, arg);
		break;
		
	case inst_modify:
		if (inst->part == BODY)
			message_modify_body(env->msg, inst->key, arg);
		else
			message_modify_headers(env->msg, inst->key,
					       inst->key2, arg);
		break;
		
	case inst_remove:
		message_remove_headers(env->msg, inst->key);
		break;
		
	default:
		abort();
	}

	if (argp)
		free(argp);
}
	
void
asgn_eval(struct eval_env *env, RC_ASGN *asgn)
{
	int key;
	struct rc_secdef_child *p = rc_child_lookup(env->child, asgn->lhs,
						    env->method, &key);
	if (!p)
		return;

	if (env->refstr) {
		char *s;
		LIST *arg = list_create();
		ITERATOR *itr = iterator_create(asgn->rhs);
		for (s = iterator_first(itr); s; s = iterator_next(itr)) {
			char *str = substitute(s, env->refstr);
			list_append(arg, str);
		}
		iterator_destroy(&itr);
		p->parser(env->method, key, arg, p->data, env->data, env->msg);
		list_destroy(&arg, _free_mem, NULL);
	} else
		p->parser(env->method, key, asgn->rhs, p->data, env->data,
			  env->msg);
}


int
re_eval_list(struct eval_env *env, char *key, RC_REGEX *re, LIST *list)
{
	ASSOC *p;
	ITERATOR *itr;
	int rc = 0;

	itr = iterator_create(list);
	for (p = iterator_first(itr); rc == 0 && p; p = iterator_next(itr)) {
		if (!p->key || strcasecmp(p->key, key) == 0) 
			rc = anubis_regex_match(re, p->value,
						&env->refcnt, &env->refstr);
	}
	iterator_destroy(&itr);
	return rc;
}

int
re_eval_text(struct eval_env *env, RC_REGEX *re, char *text)
{
	/*FIXME*/
	return anubis_regex_match(re, text, &env->refcnt, &env->refstr);
}

int
expr_eval(struct eval_env *env, RC_EXPR *expr)
{
	int rc;
	
	if (env->refstr && anubis_regex_refcnt(expr->re)) {
		xfree_pptr(env->refstr);
		env->refcnt = 0;
	}

	switch (expr->part) {
	case COMMAND:
		rc = re_eval_list(env, expr->key, expr->re,
				  env->msg->commands);
		break;
		
	case HEADER:
		rc = re_eval_list(env, expr->key, expr->re, env->msg->header);
		break;
		
	case BODY:
		rc = re_eval_text(env, expr->re, env->msg->body);
		break;

	default:
		abort();
	}
	return rc;
}

int
node_eval(struct eval_env *env, RC_NODE *node)
{
	int rc; /* It won't be used uninitialized despite what cc says.
		   Note default: branch below */
	
	switch (node->type) {
	case rc_node_bool:
		rc = bool_eval(env, &node->v.bool);
		break;
	case rc_node_expr:
		rc = expr_eval(env, &node->v.expr);
		break;
		
	default:
		abort();
	}
	return rc;
}

int
bool_eval(struct eval_env *env, RC_BOOL *bool)
{
	int rc = node_eval(env, bool->left);

	switch (bool->op) {
	case bool_not:
		return !rc;

	case bool_and:
		if (!rc)
			return 0;
		break;
		
	case bool_or:
		if (rc)
			return 1;
		break;
	}
	return node_eval(env, bool->right);
}

void
cond_eval(struct eval_env *env, RC_COND *cond)
{
	if (node_eval(env, cond->node))
		stmt_list_eval(env, cond->iftrue);
	else
		stmt_list_eval(env, cond->iffalse);
}

void
rule_eval(struct eval_env *env, RC_RULE *rule)
{
	if (node_eval(env, rule->node))
		stmt_list_eval(env, rule->stmt);
}

void
stmt_list_eval(struct eval_env *env, RC_STMT *stmt)
{
	for (; stmt; stmt = stmt->next)
		switch (stmt->type) {
		case rc_stmt_asgn:
			asgn_eval(env, &stmt->v.asgn);
			break;

		case rc_stmt_cond:
			cond_eval(env, &stmt->v.cond);
			break;

		case rc_stmt_rule:
			rule_eval(env, &stmt->v.rule);
			break;

		case rc_stmt_inst:
			inst_eval(env, &stmt->v.inst);
		}
}

void
eval_section(int method, RC_SECTION *sec, struct rc_secdef *secdef,
	     void *data, MESSAGE *msg)
{
	struct eval_env env;
	env.method = method;
	env.child = secdef->child;
	env.refcnt = 0;
	env.refstr = NULL;
	env.msg = msg;
	env.data = data;
	
	if (setjmp(env.jmp) == 0)
		stmt_list_eval(&env, sec->stmt);
			
	if (env.refstr)
		xfree_pptr(env.refstr);
}	

void
rc_run_section(int method, RC_SECTION *sec, struct rc_secdef *secdef,
	       void *data, MESSAGE *msg)
{
	if (!sec)
		return;
	for (; secdef->name; secdef++)
		if (strcmp(sec->name, secdef->name) == 0) {
			eval_section(method, sec, secdef, data, msg);
			return;
		}
	anubis_error(SOFT,
		     _("Unknown section: %s"), sec->name);
}

void
rc_call_section(int method, RC_SECTION *sec, struct rc_secdef *secdef,
		void *data, MESSAGE *msg)
{
	if (!sec)
		return;
	for (; secdef->name; secdef++)
		if (strcmp(secdef->name, "RULE") == 0) {
			eval_section(method, sec, secdef, data, msg);
			return;
		}
}

void
rc_run_section_list(int method, RC_SECTION *sec, struct rc_secdef *secdef)
{
	for (; sec; sec = sec->next)
		rc_run_section(method, sec, secdef, NULL, NULL);
}

static int
check_kw(char *ident)
{
	struct rc_secdef *p = rc_secdef;
	int key;
	
	if (!p)
		p = anubis_find_section("RULE");
	return rc_child_lookup(p->child, ident, CF_ALL, &key) != NULL;
}

static int
is_prog_allowed()
{
	struct rc_secdef *p = rc_secdef;
	if (!p)
		p = anubis_find_section("RULE");
	
	if (!p->allow_prog)
		parse_error(_("program is not allowed in this section"));
	return p->allow_prog;
}
