// Copyright (c) 2003 Robin J Carey. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author, Robin J Carey, may not be used to endorse or
//    promote products derived from this software without specific prior
//    written permission.
// 4. This software may not be used for terrorism, paedophilia or crimes
//    against humanity.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//

# include  "Startup.h"
# include  "FileCrypt.h"
# include  "FileUtil.h"
# include  "ASSERT.h"
# include  "ByteType.h"

# include  <limits.h>		// For: PATH_MAX
# include  <stdio.h>		// For: snprintf(3), fprintf(3), fwrite(3)
# include  <stdlib.h>		// For: exit(3)
# include  <string.h>		// For: memset(3)
# include  <unistd.h>		// For: getopt(3)

static void
Usage (const char * const argv0)
{
  fprintf (stderr, "%s -i <input-file>%s\n", argv0, EXTENSION);
  exit (EXIT_FAILURE);
}

int
main (int argc, char * argv [])
{
  Startup	startup (false);
  startup.Useless ();

  int		ch;
  bool		gotInputFile	= false;
  char		inputFile	[ PATH_MAX + 1 ];

  while ((ch = getopt (argc, argv, "i:")) != -1) {
    switch (ch) {
      case 'i':
	snprintf (inputFile, sizeof (inputFile), "%s", optarg);
	gotInputFile = true;
	break;
      case '?':
      default:
	Usage (argv [0]);
    }
  }
  if (!gotInputFile) {
    Usage (argv [0]);
  }
  if (!FileCrypt::ExtensionPresent (inputFile)) {
    Usage (argv [0]);
  }

  // Do the decryption:
  //
  FileCrypt		crypt (inputFile);
  size_t		dataSize;
  ByteType * const	data = crypt.Decrypt (&dataSize);
  ASSERT (data != NULL && dataSize > 0);

  // Write "outputFile":
  //
  const char * const	outputFile = FileCrypt::WithoutExtension (inputFile);
  ASSERT (outputFile != NULL);
  FILE * const		fOut = FileUtil::FOpenErrCheck (outputFile, "wb");
  ASSERT (fwrite (data, sizeof (ByteType), dataSize, fOut) == dataSize);
  memset (data, 0, dataSize);

  exit (EXIT_SUCCESS);
}
