// Copyright (c) 2003 Robin J Carey. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author, Robin J Carey, may not be used to endorse or
//    promote products derived from this software without specific prior
//    written permission.
// 4. This software may not be used for terrorism, paedophilia or crimes
//    against humanity.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//

# ifndef  OOO__L14_h__OOO
# define  OOO__L14_h__OOO

// ``ISO C89''/``ANSI C''
//
# include  <stdlib.h>		// For: size_t

// IMPORTANT NOTE: LByteType must be exactly 8-bits in size or this software
// will not function correctly.
//
typedef unsigned char	LByteType;

enum LInitType {
  L_DEFAULT_STATE,
  L_UNKNOWN_STATE
};


// ``ANSI C++''
//
class L14 {
  private:
    LByteType			x, y, z;
    const LByteType		start_x;
    static const size_t		stateSize = 256;
    LByteType			state [ stateSize ];

    void		Swap (const LByteType pos1, const LByteType pos2) {
      const LByteType		save1 = state [ pos1 ];
      state [ pos1 ] = state [ pos2 ];
      state [ pos2 ] = save1;
    }

    void		InitState (void) {
      for (size_t i = 0; i < stateSize; ++i) {
	state [ i ] = i;
      }
    }

    void		KSA (const LByteType * const key, const size_t keyLen) {
# define  L_SCHEDULE(xx)						\
									\
for (size_t i = 0; i < stateSize; ++i) {				\
  Swap (i, (stateIndex += (state [ i ] + (xx))));			\
}
      LByteType		stateIndex = x + y + keyLen;
      L_SCHEDULE(keyLen);
      for (size_t keyIndex = 0; keyIndex < keyLen; ++keyIndex) {
	L_SCHEDULE(key [ keyIndex ]);
      }
    }

    LByteType		Checksum (const size_t start, const size_t end,
		const LByteType * const key, const size_t keyLen) const {
      LByteType		cSum;
      size_t		i;
      for (cSum = 0, i = start; i < end && i < keyLen; ++i) {
	cSum += key [ i ];
      }
      return cSum;
    }

    void		Discard (const LByteType numCalls) {
      for (LByteType i = 0; i < numCalls; ++i) {
	Byte ();
      }
    }

  public:
    L14 (const LByteType * const key, const size_t keyLen,
				const LInitType initType = L_DEFAULT_STATE)
	:	x (Checksum (0, (keyLen / 2), key, keyLen)),
		y (Checksum ((keyLen / 2), keyLen, key, keyLen)),
		start_x (x) {
      InitState ();
      KSA (key, keyLen);
      if (initType == L_UNKNOWN_STATE) {
	Discard (Byte ());
      }
    }

    ~L14 (void) {
      InitState ();
      x = y = z = 0;
    }

    LByteType		Byte (void) {
      Swap (state [ x ], y);
      z = state [ x++ ] + state [ y-- ];
      if (x == start_x) {
	--y;
      }
      return state [ z ];
    }

    void		InitVector (const LByteType * const key,
						const size_t keyLen) {
      KSA (key, keyLen);
    }

    size_t		QueryStateSize (void) const {
      return stateSize;
    }
};

# endif		// !OOO__L14_h__OOO
