// Copyright (c) 2003 Robin J Carey. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author, Robin J Carey, may not be used to endorse or
//    promote products derived from this software without specific prior
//    written permission.
// 4. This software may not be used for terrorism, paedophilia or crimes
//    against humanity.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//

# ifndef  OOO__Password_h__OOO
# define  OOO__Password_h__OOO

# include  "ByteType.h"

# include  <stdlib.h>		// For: size_t

size_t		Password (const bool raw, const int delim,
			const char * const prompt,
			ByteType * const pass, const size_t passSize);
size_t		PasswordConfirm (const bool raw, const int delim,
			const char * const prompt,
			ByteType * const pass, const size_t passSize);

# define  MAX_PASS_LEN	1024
# define  ENTER_KEY	'\n'
# define  PROMPT	"Enter password: "
# define  CHOOSE_PROMPT	"Choose password: "

# define  PROMPT_PASSWORD(prompt, pass, passSize)		\
Password (true, ENTER_KEY, (prompt), (pass), (passSize))

# define  PROMPT_PASSWORD_CONFIRM(prompt, pass, passSize)	\
PasswordConfirm (true, ENTER_KEY, (prompt), (pass), (passSize))

# endif		// !OOO__Password_h__OOO
