// Copyright (c) 2003 Robin J Carey. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author, Robin J Carey, may not be used to endorse or
//    promote products derived from this software without specific prior
//    written permission.
// 4. This software may not be used for terrorism, paedophilia or crimes
//    against humanity.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//

# ifndef  OOO__RSA_h__OOO
# define  OOO__RSA_h__OOO

// The public-key "n" must be greater than or equal to 1024 bits to provide
// long-term security:
static const unsigned long	n_min_bits	= 1024;
static const unsigned long	n_min_bytes	= n_min_bits / 8;

// Note: Have to make "p" and "q" equal to "n" in terms of their bit-sizes,
// to guarantee their product, "n", is greater than 1024 bits.
static const unsigned long	p_q_min_bits	= n_min_bits;
static const unsigned long	p_q_min_bytes	= p_q_min_bits / 8;
static const unsigned long	encExp		= 65537;

# define  PROGDIR		"caesarion"
# define  PUBKEY		"public-key"
# define  PRIVKEY		"private-key"
# define  SIGNATURE		'S'
# define  HEXSTR_BUFSIZE	524288

// Message Binary Encoding Format:
//
//	<salt-len> <salt:1-255 bytes> <data:0-255 bytes>
//
// Minimum message size: 1 + 1
// Maximum message size: 1 + 255 + 255
//

static const unsigned long	min_msg_size		= 1 + 1;
static const unsigned long	max_msg_size		= 1 + 255 + 255;
static const unsigned long	max_msg_data_size	= 255;

// Ciphertext file:
//
static const char * const	CIPHERTEXT_FILE = "ciphertext";

# endif		// !OOO__RSA_h__OOO
