// Copyright (c) 2003 Robin J Carey. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author, Robin J Carey, may not be used to endorse or
//    promote products derived from this software without specific prior
//    written permission.
// 4. This software may not be used for terrorism, paedophilia or crimes
//    against humanity.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//

# ifndef  OOO__Random_h__OOO
# define  OOO__Random_h__OOO

# include  "ByteType.h"
# include  "FileUtil.h"

# include  <stdlib.h>		// For: size_t, free(3), exit(3)
# include  <string.h>		// For: strdup(3), memcpy(3), memset(3)
# include  <sys/types.h>
# include  <unistd.h>		// For: read(2)


// C++ front-end to random pseudo-devices, e.g. /dev/urandom.
//
class Random {
  private:
    const int			fd;
    char * const		devName;

  public:
    Random (const char * const device)
	:	fd (FileUtil::Open (device)), devName (strdup (device)) {
      if (fd < 0) {
	FileUtil::PError ("open(2)", device);
	exit (EXIT_FAILURE);
      }
      if (devName == NULL) {
	FileUtil::PError ("strdup(3)", device);
	exit (EXIT_FAILURE);
      }
    }

    ~Random (void) {
      FileUtil::Close (fd);
      free (devName);
    }

    ByteType			Byte (void) const {
      ssize_t		got;
      ByteType		result;
      const ssize_t	nbytes = 1;	// Not size_t to kill warnings.
      do {
	got = read (fd, &result, nbytes);
	if (got < 0) {
	  FileUtil::PError ("read(2)", devName);
	  exit (EXIT_FAILURE);
	}
      } while (got != nbytes);
      return result;
    }

    void			Bytes (ByteType * const data,
					const size_t numBytes) const {
      for (size_t i = 0; i < numBytes; ++i) {
	data [ i ] = Byte ();
      }
    }

    unsigned long		Ulong (void) const {
      unsigned long	ul;
      ByteType		ul_array [ sizeof (ul) ];
      Bytes (ul_array, sizeof (ul_array));
      memcpy (&ul, ul_array, sizeof (ul_array));
      memset (ul_array, 0, sizeof (ul_array));
      return ul;
    }
};

# endif		// !OOO__Random_h__OOO
