# incoming.py = deal with incoming email
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 19-Jul-2001
# History:
# 1-Jun-2001 PH: created

"""***
Notes here about the incoming.py module...

***"""

#***** python standard libraries:
import rfc822   # understands mail headers
import sys
import os
import string

import utility

#***** part of Herbrip:
from herb_globals import *
import startup
import encwrap

debug = 0  # debugging this module?


#---------------------------------------------------------------------

"""***
process incoming email, reading from filename (fnEmailIn) and
writing plaintext to filename (fnEmailPt).
***"""

def processIn(fnEmailIn, fnEmailPt):
   # get a file handle for the incoming mail
   try:
      mailIn = open(fnEmailIn, "r")
   except:
      print "herbrip: cannot open email file '%s', aborting"\
         % fnEmailIn
      sys.exit(1)   
   
   # read the header lines
   inHeader = rfc822.Message(mailIn)
   
   # read the body of the email
   body = mailIn.read()
   if debug:
      print "----file is:---\n%s\n-----end-----" % body
   
   xHerbivore = inHeader.getheader(X_HV)
   if xHerbivore == None:
      print "herbrip: Incoming email <%s> has no '%s:' header, exiting" \
         % (fnEmailIn, X_HV)
      sys.exit(0)
   
   xHerbivoreVersion = inHeader.getheader(X_HV_VERSION)
   # for now, ignore version. Later we will check it for backwards
   # compatibility
   
   if debug: print "** xHerbivore: %s" % xHerbivore
   if debug: print "** xHerbivore-Version: %s" % xHerbivoreVersion
   
   xHerbivoreKey = inHeader.getheader(X_HV_KEY)
   if debug: print """--- Herbivore Key ---
%s
--- end Herbivore Key ---""" % xHerbivoreKey

   #get email address, because we need to store that with the key
   fromName,fromAddr = inHeader.getaddr("From")
   if debug: print "** from \"%s\" <%s>" % (fromName, fromAddr)
   
   dictAdd(fromAddr, fromName, xHerbivoreKey)
   
   # decode it if we need to
   if xHerbivore == X_HV_ENCRYPTED:
      myPrivateKey = startup.secretKeys['private']
      plainText = encwrap.pkDec(myPrivateKey, body)
      
      # (plainText) is just the message body, so we must add
      # the message headers to it:
      # (!! Using rfc822 like this is nasty; recode using my Mail/
      # MailHeader classes later !!)
      resultMess = string.join(inHeader.headers,"") + "\n" + plainText
      if debug: print "$$$$$ resultMess = %s" % resultMess
   else:
      resultMess = utility.readFile(fnEmailIn)   
      
   # output result
   utility.writeFile(fnEmailPt, resultMess)
      
 

#---------------------------------------------------------------------

def dictAdd(fromAddr, fromName, xHerbivoreKey):
   if debug and 0:
      print ("** dictAdd(fromAddr='%s', fromName='%s', ...)" 
         % (fromAddr, fromName))

   startup.publicKeys.addRecord(fromAddr, fromName, xHerbivoreKey)
   startup.publicKeys.save()
   

#---------------------------------------------------------------------




#---------------------------------------------------------------------
                                  

#---------------------------------------------------------------------

#---------------------------------------------------------------------


#end incoming.py
