# mailheader.py = process a RFC822 email header
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 16-Jul-2001
# History:
# 10-Jun-2001 PH: created

"""***


***"""

#***** python standard libraries:
import rfc822   # understands mail headers
import sys
import string
import StringIO

import utility
import pubkeydict

debug = 0  # debugging this module?


#---------------------------------------------------------------------

"""***
The MailHeader class stores headers for a rfc822 email message

Creation:
~~~~~~~~~
readFromFileHandle(fh)
readFromString(str)
   read the header lines from a file or string
 
Accessing:
~~~~~~~~~~
getheader(name, default)
get(name, default)
   These do the same thing: return the value of a header line.
   if no (default) is specified and the line doesn't exist, 
   returns none.

put(name, value)
   Sets the value of header-line (name) to (value).

Writing output
~~~~~~~~~~~~~~
__str__()
asString()
   These do the same thing: Output all the header-lines as a 
   string

Instance variables:
~~~~~~~~~~~~~~~~~~~
self.h = dictionary containing header lines. If there are >1
   lines with a particular header, the value will be a list of all
   the lines, in the order they appeared

self.mess = an instance of rfc822.Message, used internally to
   decode the header messages
***"""


class MailHeader:

   def __init__(self):  
      self.h = {}
   
   def readFromFileHandle(self, fh):
      # get a message object for parsing:
      self.mess = rfc822.Message(fh)
      headerNames = self.mess.keys()
      for hn in headerNames:
         hValue = self.mess.getheader(hn)
         self.putAppend(hn, hValue)
           
   def readFromString(self, str):      
      stringToFileWrapper = StringIO.StringIO(str)
      self.readFromFileHandle(stringToFileWrapper)
      stringToFileWrapper.close()
   
   def getheader(self, name, default =None):
      return self.get(name, default)  
      
   def get(self, name, default =None):
      try:
         value = self.h[name]
         return value
      except:
         # couldn't return a value, use default
         return default
   
   def put(self, name, value):
      self.h[name] = value
      
   def putAppend(self, name, value):
      if self.h.has_key(name):
         v = self.h[name]
         if type(v)==type([]):
            print "@@@ self.h[%s] was %s @@@" % (name,self.h[name])
            v.append(value)
            print "@@@ self.h[%s] is %s @@@" % (name,self.h[name])
            # not sure if we need to add anything here???
         else:
            # it's a string, change to a list:
            self.h[name] = [self.h[name], value] 
      else:
         self.h[name] = value
   
   def __str__(self):                               
      return self.asString()

   def asString(self):
      result = ""
      for name, value in self.h.items():
         if type(value)==type([]):
            for v in value:
               result = result + name + ": " \
                  + self._valueMultiline(v) + "\n"
         else:
            result = result + name + ": " \
               + self._valueMultiline(value) + "\n"
      return result
            
   def _valueMultiline(self, v):
      """*** 
      if (v) has more than one line, ensure that lines
      after the first one begin with a space
      ***"""
      sa = string.split(v, '\n')
      for i in range(len(sa)):
         if i == 0: continue
         if not utility.startsWith(sa[i], " "):
            sa[i] = " " + sa[i]
      v = string.join(sa, '\n')    
      return v
   
   
#---------------------------------------------------------------------
# test MailHeader class:

if __name__ == "__main__":
   print "Testing MailHeader class..."
   s = """From: hpilh@sdfsf.sdfsadfasfd.com
To: another@aol.com (A N Other)
To: fred@here.com
To: jim@there.com
Subject: noyb
"""
   mh = MailHeader()
   mh.readFromString(s)
   print "--------result: >>>>%s<<<<" % mh.asString()
   print "--------internal:"   
   print mh.h
   
   # add some headers:
   mh.put("X-Herbivore", "plain")
   mh.put("X-Herbivore-Version", "0.1")
   print "--------result: >>>>%s<<<<" % mh.asString()


#---------------------------------------------------------------------


#end incoming.py
