# pubkeydict.py = dictionary storing public key information
# from incoming email
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

"""***
The data is stored as a serialised object. The object is a 
dictionary whose keys are email addresses. Each value is itself 
a dictionary, with keys being strings line 'name', 'key',
'fingerprint' etc and values being the associated values.

The serialised object will be stored, by default, 
in ~/.herbivore/public_keys
***"""

# Last altered: 17-Jul-2001
# History:
# 1-Jun-2001 PH: created

#***** python standard libraries:
import getopt
import sys
from UserDict import UserDict


import utility

#***** part of Herbrip:
from herb_globals import *
import startup

debug = 0  # debugging this module?

#---------------------------------------------------------------------

class PublicKeyDict:

   """*****
A dictionary of public keys 

instance variables:

d = the actual dictionary

filename = filename to save/load the dictionary's data  
*****"""
 
   def __init__(self, associateFile):
      self.filename = associateFile
      self.load()
   
   def addRecord(self, emailAddr, name, pubKey):
      record = {"name": name, "key": pubKey}
      self.d[emailAddr] = record
   
   def __getitem__(self, emailAddr):
      return self.d.get(emailAddr, None)
   getRecord = __getitem__
      
   def getAddresses(self):
      return self.d.keys()
      
   def save(self):
      utility.savePickle(self.filename, self.d)
   
   def load(self):
      self.d = utility.loadPickle(self.filename) 
      if self.d == None: self.d = {} 

   # note that here, "key" refers to a dictionary key not an encryption
   # key
   def has_key(self, k):
      return self.d.has_key(k)


#---------------------------------------------------------------------
#test PublicKeyDict class

def test():
   print "Testing PublicKeyDict class..."
   
   pkd = PublicKeyDict("testfile.pkd")
   print "pkd.d is %s" % pkd.d
   
   pkd.addRecord("philh@comuno.freeserve.co.uk", "Phil Hunt", "*my*key*")

   print "pkd.d is %s" % pkd.d
   print "addresses in pkd: %s" % pkd.getAddresses()
   pkd.save()

#---------------------------------------------------------------------

if __name__ == "__main__": test()


#end pubkeydict.py
