# test_herbrip.py = Test the herbrip command-line client
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 16-Jul-2001
# History:
# 12-Jul-2001 PH: created

#***** python standard libraries:
import sys
import os
import commands
import rfc822

import utility

debug = 0     # debugging this module?
interact = 0  # is this module interactive?
verbose = 1   # verbose means output more information


#---------------------------------------------------------------------

def run(comment, command):
   print comment, 
   if interact:
      dummy = raw_input(">")
   else:
      print
   print "CMD { %s }..." % command
   os.system(command)
      
def comment(com):
   print "==== %s ====" % com

#---------------------------------------------------------------------

def _getBody(mailFn):
   """return a string containing the body of a mail file"""
   fh = open(mailFn)
   mess = rfc822.Message(fh)
   return fh.read()

#---------------------------------------------------------------------

def assertExists(filename):
   "test that a file exists and is readable"
   if not os.access(filename, os.F_OK):
      raise AssertionError, "File <%s> doesn't exist" % filename
   if not os.access(filename, os.R_OK):
      raise AssertionError, "File <%s> isn't readable" % filename
      
   if debug or verbose:
      print "<%s> exists, GOOD." % filename
      
def assertSame(fn1, fn2):
   "test that two files are the same"
   cmd = "diff %s %s" % (fn1, fn2)
   result = commands.getoutput(cmd)
   if result != "":
      print "--- result of diff ---"
      print result
      print "--- end result -------"
      raise AssertionError, "Files <%s>, <%s> are different" % (fn1, fn2)

   if debug or verbose:
      print "<%s> is the same as <%s>, GOOD." & (fn1, fn2)


"""***
(mf1) and (mf2) are filenames of email files. This function 
asserts that they have the same bodies; the headers may be different.
***"""

def assertSameBody(mf1, mf2):
   body1 = _getBody(mf1)
   body2 = _getBody(mf2)
   if body1 != body2:
      print "Bodies are different!"
      raise AssertionError, "Mail files <%s>, <%s> have different bodies"\
         % (mf1, mf2)
         
   if debug or verbose:
      print "<%s> has the same body as <%s>, GOOD." % (mf1, mf2)
     

#---------------------------------------------------------------------

def testAB():
   run("Initialize Alice", "herbrip --dir alice --init")
   assertExists("alice/secret_keys")
   #assertExists("alice/public_keys")
   run("Initialize Bob", "herbrip --dir bob --init")
   assertExists("bob/secret_keys")
   #assertExists("bob/public_keys")
      
   # create A->B message
   comment("sending a message Alice --> Bob")
   messAB = """From: alice@nowhere.org
To: bob@nowhere.org
Subject: message from Alice to Bob

Hi, Bob, how's it going

--
Alice
"""
   utility.writeFile("messab", messAB)
   assertExists("messab")

   run("Alice prepares her outgoing message", 
      "herbrip --dir alice --out messab messab_out")
   assertExists("messab_out")
   
   run("Bob reads it, extracting Alice's public key",
      "herbrip --dir bob --in messab_out messab_in")
   assertExists("messab_in")
   assertExists("bob/public_keys")
   assertSameBody("messab", "messab_in")
  
   comment("sending reply Bob --> Alice")
   messBA = """From: bob@nowhere.org
To: alice@nowhere.org
Subject: message from Bob to Alice

I'm fine, Alice. How are you?

--
Bob
"""
   utility.writeFile("messba", messBA)
   assertExists("messba")

   run("Bob prepares his outgoing message (should encrypt it)", 
      "herbrip --dir bob --out messba messba_out")
   assertExists("messba_out")
     
   run("Alice reads it, decrypting it with her private key",
      "herbrip --dir alice --in messba_out messba_in")
   assertExists("messba_in")
   assertExists("alice/public_keys")
   
   # NOTE: this needs changing; it will not work, because
   # although the bodies of the two messages are the same, the
   # headers will be different, since <messba> won't contain any
   # herbivore headers, but <messba_in> will
   assertSameBody("messba", "messba_in")
   
   print "***** Test completed successfully! *****"
         


#---------------------------------------------------------------------

if __name__ == "__main__":
   testAB()

#end test_herbrip.py
