# initial.py = initialize Herbrip
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 16-Jul-2001
# History:
# 10-Jun-2001 PH: created

"""***
The initial.py module is responsible for  initialising the herbivore
environment, which involves creating a directory to hold keys in,
creating a public/private keypair for the user, and creating several
files to contain  keys and other information
***"""

#***** python standard libraries:
import os
import os.path
import popen2
import commands
from time import *

#***** part of Herbrip:
import utility
from herb_globals import *
import startup
import encwrap

debug = 0  # debugging this module?

#---------------------------------------------------------------------

def isInitialized():   
   # ~/.herbivore must exist and be writeable
   if not os.access(startup.getHerbDir(), os.W_OK): return 0
      
   # secret keyring file must exist and be writeable
   if not os.access(startup.getSecretPn(), os.W_OK): return 0
    
   # public keyring file must exist and be writeable 
   if not os.access(startup.getPublicPn(), os.W_OK): return 0
   
   #...other tests here...
    
   # passed all tests, it's OK
   return 1

#---------------------------------------------------------------------

"""***
Forced initialization of a herbivore system. Any existing system in
the target direcvtory is removed.

this creates:
  directory: ~/.herbivore/
in this directory:
  file: <secret_keys> - public/private keys for user
  file: <public_keys> - other people's public keys
  file: <README> - text file saying what the directory's for
***"""

def forceInit(realName, email):
   # zap the directory if it exists:
   cmd = "rm -rf %s" % startup.getHerbDir()
   os.system(cmd)

   # make the herbivore directory, with all permissions for the user,
   # and no permissions for group and world (0700 is an octal number)
   try:
      if not os.access(startup.getHerbDir(), os.W_OK):
         os.mkdir(startup.getHerbDir(), 0700)
   except OSError,e:
      print "!!! in OSError, e=[%s] !!!" % e
         
   createSecretKey(realName, email)
   createReadme()

#---------------------------------------------------------------------

"""***
Ensure that the herbivore system is initialized, by checking
if it is already, and if not, initilizing it.
***"""
   
def ensureInitialized():
   if not isInitialized():
      initialize("","")
      
    
#---------------------------------------------------------------------

def createSecretKey(realName, email):
   """ invoke OpenSSL to create a secret key for me """  
   
   pub,priv = encwrap.makeKeypair()
   
   startup.secretKeys = {}
   startup.secretKeys['public'] = pub
   startup.secretKeys['private'] = priv
   
   utility.savePickle(startup.getSecretPn(), startup.secretKeys)
   
#---------------------------------------------------------------------

def createReadme():
   timeNow = strftime("%Y-%b-%d %a %H:%M", localtime(time()))
   readmeData = """README file for %s

Herbrip version: %s
Herbivore version: %s
This file created at: %s

Herbrip is an implementation of the Herbivore protocol, aimed
at hassle-free, automatic, strong encryption of email.
More information about Herbrip and Herbivore is available at
<http://www.vision25.demon.co.uk/oss/oss.html>.
""" % (
      startup.getHerbDir,
      HERBRIP_VERSION,
      HERBIVORE_VERSION,
      timeNow
      )
   readmeFile = os.path.join(startup.getHerbDir(),"README")
   if debug: print "README file is %s" % readmeFile
   utility.writeFile(readmeFile, readmeData)   

#---------------------------------------------------------------------


#end initial.py
