# herb_globals.py = global constants for Herbrip
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 14-Jan-2002
# History:
# 10-Jun-2001 PH: created
# 12-Jun-2001 PH: renamed to herb_globals.py
# 10-Aug-2001 PH: altered for herbrip-0.2.0
# 14-Jan-2002 PH: altered for herbrip-0.3.1

#---------------------------------------------------------------------

# version numbers:
HERBRIP_VERSION = "0.3.1"
HERBIVORE_VERSION = "0.3.1"

# default values of directories and files used by herbrip:
DEFAULT_HERB_DIR = ".herbivore"
DEFAULT_SECRET_FN = "secret_keys"
DEFAULT_PUBLIC_FN = "public_keys"
DEFAULT_README_FN = "README"
DEFAULT_CONFIG_FN = "config"

# delimiters in Herbivore-encrypted messages:
BEGIN_HERBIVORE = "----- BEGIN HERBIVORE ENCRYPTED -----"
HERBIVORE_SEP = "-----"
END_HERBIVORE = "----- END HERBIVORE ENCRYPTED -----"

# names of herbivore mail headers:
X_HV = "X-Herbivore"
X_HV_VERSION = "X-Herbivore-Version"
X_HV_KEY = "X-Herbivore-Key"

# values for the X_HV mail header:
X_HV_ENCRYPTED = "enc"
X_HV_PLAINTEXT = "plain"

"""***
Fields in the unencrypted mail that get copied to the encrypted-header
area in the encrypted mail (and thus removed from the header in
the encrypted mail):
***"""
XFER_FIELDS = ["To", "Cc", "Subject", "In-Reply-To", "References", 
   "Keywords", "Comments", "Reply-To"]


"""***
Fields in the unencrypted mail that get removed from header
in the encrypted mail:
***"""
REMOVE_FIELDS = ["Bcc"]



#---------------------------------------------------------------------


#end herb_globals.py
