# startup.py = start up Herbrip
#
##########################################################
# Copyright (c) 2001 Philip Hunt. See COPYING for details
# of licensing information.
##########################################################

# Last altered: 19-Jul-2001
# History:
# 11-Jul-2001 PH: created

"""*** 
The startup.py module is responsible for starting up the herbrip
program, which involves initializing its variables. startup.py
is run at the start of every invokation of herbrip, other than 
those which just return canned information.

The function startup() should be run at the start, to initialize
everything.

(Compare with initial.py, which has the job of initializing
Herbrip's directory and file structure.)
***"""

#***** python standard libraries:
import os
import os.path

#***** part of Herbrip:
from herb_globals import *
from pubkeydict import *


debug = 0  # debugging this module?

#---------------------------------------------------------------------

usingDefaultHerbDir = 1

changedHerbDir="<nothing>"

def setHerbDir(newHerbDir):
   global usingDefaultHerbDir, changedHerbDir
   usingDefaultHerbDir = 0
   changedHerbDir = os.path.abspath(newHerbDir)
   if debug:
      print "** startup.py, new herb dir is <%s>"\
         % getHerbDir()
  
def getHerbDir():
   if usingDefaultHerbDir:
      return os.path.join(os.environ['HOME'], DEFAULT_HERB_DIR)
   else:
      return changedHerbDir

def getSecretPn():
   return os.path.join(getHerbDir(), DEFAULT_SECRET_FN)
   
def getPublicPn():
   return os.path.join(getHerbDir(), DEFAULT_PUBLIC_FN)


#---------------------------------------------------------------------
"""***
Config file handling.

This is the file ~/.herbivore/config (by default).

Global variable (config) is a dictionary containing the value of 
variables in it.

(overrideConfig) is in the same format as (config) but contains
values overridden from the command line.

Other modules can read (config) by lines such as:

   dest = startup.config['destination']

***"""

config = {}
overrideConfig = {}

def readConfigFile():
   """ reads the config file, pugging details into (config) """
   global config
   dummy = {}
   configFn = os.path.join(getHerbDir(), DEFAULT_CONFIG_FN)
   try:
      execfile(configFn, dummy, config)
   except:
      print "startup.py: couldn't read config file!"
      pass
         
   # override values override the ones in (config):
   for k,v in overrideConfig.items():
      config[k] = v   
      

#---------------------------------------------------------------------

publicKeys = {}
secretKeys = None

def startup(herbDir =""):
   global publicKeys, secretKeys
   
   if herbDir != "": setHerbDir(herbDir)
           
   if debug: print "startup.py: creating (publicKeys) dictionary..."
   publicKeys = PublicKeyDict(getPublicPn())

   if debug: print "startup.py: creating (secretKeys) dictionary..."
   secretKeys = utility.loadPickle(getSecretPn())
   
   if debug: print "startup.py: reading config..."
   readConfigFile()


#---------------------------------------------------------------------
if debug:
   print "startup.py, using herb dir <%s>"\
      % getHerbDir()

#---------------------------------------------------------------------


#end startup.py
