# perftest.py = Test the performance of herbrip
#
###############################################################
# Copyright (c) 2002 Philip Hunt.
# You are permitted to use this software under the terms of the 
# GNU General Public License. Details are in the file  COPYING, 
# which you should have received with this distribution.
###############################################################

# Last altered: 28-Jan-2002
# History:
# 22-Jan-2002 PH: created

"""***
perftest.py tests the performance of herbrip.

To run it, go into the directory it is in (./test/) and run from
the command line:

   $ python perftest.py
   
The program will create several files in its own directory, and
several subdirectories (this is why it is important to run it with
its own directory as the current directory).     
***"""

#***** python standard libraries:
import sys
import os, os.path
import commands
import rfc822
import string
import time

#***** modules in ../src directory:
srcDir = os.path.abspath("../src")
sys.path.append(srcDir)
import utility
import mailheader

debug = 0     # debugging this module?
interact = 0  # is this module interactive?
verbose = 1   # verbose means output more information
 
#---------------------------------------------------------------------

__debug__ = 1 #this is so the 'assert' statements work

# doesn't work with herbrip anymore because its executable isn't in 
# the path
def run(comment, command):
   if comment: 
      print "\n" + comment, 
      if interact:
         dummy = raw_input(">")
      else:
         print
   print "CMD { %s }..." % command
   os.system(command)
   
   
   
      
def runHerbrip(comment, herbripArguments):
   if comment: 
      print "\n" + comment, 
      if interact:
         dummy = raw_input(">")
      else:
         print
   cmd2 = "%s/herbrip %s" % (srcDir, herbripArguments)
   print "CMD { %s }..." % cmd2
   os.system(cmd2)
     
      
def comment(com):
   print "==== %s ====" % com
     
#---------------------------------------------------------------------
# performance testing

messageTemplate = """Subject: message id %(id)s, from %(sender)s to %(recip)s
To: %(recip)s@nowhere.org
From: %(sender)s@nowhere.org

This is a message from %(sender)s to %(recip)s

And here's some garbage...

""" + (("x"*70 + "\n")*20)

def test_performance():
   people = ('alice', 'bob', 'cathy', 'daniel')
   numPeople = len(people)
   rounds = 3
   sbEmails = numPeople * (numPeople - 1) * rounds
   sbPt = numPeople * (numPeople - 1) / 2
   sbEnc = sbEmails - sbPt 
   actualEmails = actualPt = actualEnc = 0
   
   # initialise
   for p in people:
      run('', 'rm -rf %s' % p)
      runHerbrip("Initialize %s" % p, "--dir %s --create" % p)

   startAt = time.time()
   
   for round in range(rounds):
      for sender in people:
         for recip in people:
            if sender == recip: continue
            id = actualEmails
            msg = messageTemplate % {'sender': sender,
               'recip': recip, 'id': id}
            utility.writeFile("mess_orig", msg)   
            runHerbrip("", 
               "--dir %s --dest 'file:mess_out' --outd mess_orig" 
               % sender)
            runHerbrip("", "--dir %s --in mess_out mess_in" % recip)
            actualEmails += 1
            print "sent %s emails" % actualEmails
         #//for recip
      #//for sender
   #//for round
  
   stopAt = time.time()
   elapsed = (stopAt - startAt) * 1.0
   timeEach = elapsed / actualEmails
   print "Sent %d emails in %1.3f s, %1.3f s/email" % (
      actualEmails, elapsed, timeEach)

#---------------------------------------------------------------------


if __name__ == "__main__":
   test_performance()

#end perftest.py
