#!/usr/bin/env python

# fake_sendmail.py = A program to test the "sendmail:" destination
#
###############################################################
# Copyright (c) 2002 Philip Hunt.
# You are permitted to use this software under the terms of the 
# GNU General Public License. Details are in the file  COPYING, 
# which you should have received with this distribution.
###############################################################

# Last altered: 22-Jan-2002
# History:
# 22-Jan-2002 PH: created

"""*** fake_sendmail.py is a program to test 'dest' config variables
using the 'sendmail:' protocol. fake_sendmail.py is part of the
Herbrip test suit. The 'sendmail:' protocol is where Herbrip sends
messages, on their final-output, to sendmail. This program pretends to
be sendmail as far as the Herbrip system is concerned,

Usage:

   fake_sendmail.py [filestub] email_addrs < message

This program takes as arguments: an optional filename, followed by
one or more email addresses. An email message is send to the program's
stdin.

for each email address given, the program constructs a filename consisting
of the filestub with the username for the email address; the message is
put into that file.

If filestub isn't specified, the default value of 'mess_sm_' is used.

***"""

#***** python standard libraries:
import sys
import string
import os

#***** modules in ../src directory:
srcDir = os.path.abspath("../src")
sys.path.append(srcDir)
import utility

debug = 0     # debugging this module?
DEFAULT_FILESTUB = "mess_sm_"

#---------------------------------------------------------------------

filestub = DEFAULT_FILESTUB
recipients = [ ]

for a in sys.argv[1:]:
   if string.find(a, "@") < 0:
      # it's a filename
      filestub = a
   else:
      # it's an email address
      recipients.append(a)   

if len(recipients) < 1:
   print "fake_sendmail: No recipients specified, exiting"
   sys.exit(1)

# read message from stdin:   
message = sys.stdin.read()   

for r in recipients:
   username = r[:string.find(r, "@")]
   fn = filestub + username
   utility.writeFile(fn, message)


#---------------------------------------------------------------------
#end fake_sendmail.py
