# tmessages.py = test messages for the Herbrip test suit
#
###############################################################
# Copyright (c) 2002 Philip Hunt.
# You are permitted to use this software under the terms of the 
# GNU General Public License. Details are in the file  COPYING, 
# which you should have received with this distribution.
###############################################################

# Last altered: 20-Jan-2002
# History:
# 20-Jan-2002 PH: created

"""***
This file contains some test messages, which are used by test_herbrip.py, 
the testing program.
***"""

#---------------------------------------------------------------------
# emails to send

AB = """From: alice@nowhere.org
To: bob@nowhere.org
Subject: message from Alice to Bob

Hi, Bob, how's it going

(Note: this message is used in test 1 and test 7)

--
Alice
"""
   
BA = """From: <bob@nowhere.org> (Robert Xavier Roberto)
To: alice@nowhere.org
Subject: message from Bob to Alice


. (testing multiple empty lines before start of text)
I'm fine, Alice. How are you?

--
Bob
"""

CA = """From: cathy@nowhere.org
To: alice@nowhere.org
Subject: part of the GPL

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

-- 
*********************************************************
**-----------------------------------------------------**
**  Cathy, cathy@nowhere.org                           **
**                                                     **
**  Look at my sig, it's...                            **
**                        R A T H E R   B I G   ! !    **
**-----------------------------------------------------**
*********************************************************
"""

ABCD = """From: alice@nowhere.org
To: bob@nowhere.org, cathy@nowhere.org, daniel@nowhere.org
Subject: look at cathy's sig!!!

Cathy wrote:
>   The licenses for most software are designed to take away your
> freedom to share and change it.  By contrast, the GNU General Public
> License is intended to guarantee your freedom to share and change free
> software--to make sure the software is free for all its users.  This
> General Public License applies to most of the Free Software
> Foundation's software and to any other program whose authors commit to
> using it.  (Some other Free Software Foundation software is covered by
> the GNU Library General Public License instead.)  You can apply it to
> your programs, too.
> 
>   When we speak of free software, we are referring to freedom, not
> price.  Our General Public Licenses are designed to make sure that you
> have the freedom to distribute copies of free software (and charge for
> this service if you wish), that you receive source code or can get it
> if you want it, that you can change the software or use pieces of it
> in new free programs; and that you know you can do these things.
> 
> -- 
> *********************************************************
> **-----------------------------------------------------**
> **  Cathy, cathy@nowhere.org                           **
> **                                                     **
> **  Look at my sig, it's...                            **
> **                        R A T H E R   B I G   ! !    **
> **-----------------------------------------------------**
> *********************************************************

oooh, pretty sig!!!

-- 
Alice
"""

D_ccABC = """From: daniel@nowhere.org
Cc: alice@nowhere.org, bob@nowhere.org, cathy@nowhere.org
Subject: message 5 -- from D, cc'd to A B and C

This is a message from D to A,B,C

This message tests the 'sendmail:' protocol of the (dest) config variable.

-- 
Daniel
"""


C_A_ccB_bccD = """From: cathy@nowhere.org
To: alice@nowhere.org
Cc: bob@nowhere.org
Bcc: daniel@nowhere.org
Subject: this is message 6, testing "file:" dest variable

This message is to Alice, Cc:'d to Bob, and Blind Cc:'d to Daniel.

The messages to Alice and Daniel should be encrypted, but not the
message to Bob, because Cathy hasn't got his public key.

This message will use a 'dest' variable using the 'file:' method
for final-output.

So the three final-output messages will be indexed:

   1 = to Alice
   2 = to Bob
   3 = to Daniel

-- 
Cathy
"""


#---------------------------------------------------------------------
#end tmessages.py
