# herb_globals.py = global constants for Herbrip
#
###############################################################
# Copyright (c) 2001,2002 Philip Hunt.
# You are permitted to use this software under the terms of the 
# GNU General Public License. Details are in the file COPYING, 
# which you should have received with this distribution.
###############################################################

# Last altered: 9-Feb-2002
# History:
# 10-Jun-2001 PH: created
# 12-Jun-2001 PH: renamed to herb_globals.py
# 10-Aug-2001 PH: altered for herbrip-0.2.0
# 14-Jan-2002 PH: altered for herbrip-0.3.1
# 27-Jan-2002 PH: added MIME headers to XFER_FIELDS
# 28-Jan-2002 PH: altered for herbrip-0.4.0
# 6-Feb-2002 PH: added CONFIG_DEFAULT_VALUES
# 9-Feb-2002 PH: altered for herbrip-0.4.2

#---------------------------------------------------------------------

# version numbers:
HERBRIP_VERSION = "0.4.2"
HERBIVORE_VERSION = "0.3.1"

# default values of directories and files used by Herbrip:
DEFAULT_HERB_DIR = ".herbivore"
DEFAULT_SECRET_FN = "secret_keys"
DEFAULT_PUBLIC_FN = "public_keys"
DEFAULT_README_FN = "README"
DEFAULT_CONFIG_FN = "config"
DEFAULT_LOG_FN = "event.log"

# default values of variables in the <config> file
CONFIG_DEFAULT_VALUES = {
   'dest': "file:mess_out_%(ix)s",
   'log': 1,
   'logItems': ["i", "ip", "o", "op", "cmd", "comment"],
   'logMessItems': ["From", "To", "Cc", "Bcc", "Subject", "Message-Id",
      "X-Herbivore"],
   }

   

# delimiters in Herbivore-encrypted messages:
BEGIN_HERBIVORE = "----- BEGIN HERBIVORE ENCRYPTED -----"
HERBIVORE_SEP = "-----"
END_HERBIVORE = "----- END HERBIVORE ENCRYPTED -----"

# names of herbivore mail headers:
X_HV = "X-Herbivore"
X_HV_VERSION = "X-Herbivore-Version"
X_HV_KEY = "X-Herbivore-Key"

# values for the X_HV mail header:
X_HV_ENCRYPTED = "enc"
X_HV_PLAINTEXT = "plain"

"""***
Fields in the unencrypted mail that get copied to the encrypted-header
area in the encrypted mail (and thus removed from the header in
the encrypted mail):
***"""
XFER_FIELDS = ["To", "Cc", "Subject", "In-Reply-To", "References", 
   "Keywords", "Comments", "Reply-To",
   "Content-Type", "Content-Transfer-Encoding", "Mime-Version",
   "X-Mailer"]


"""***
Fields in the unencrypted mail that get removed from header
in the encrypted mail:
***"""
REMOVE_FIELDS = ["Bcc"]



#---------------------------------------------------------------------


#end herb_globals.py
