#!/usr/bin/env python

# opft.py = Output-Prefix-From-To, part of the herbrip test suite
#
###############################################################
# Copyright (c) 2001,2002 Philip Hunt.
# You are permitted to use this software under the terms of the 
# GNU General Public License. Details are in the file  COPYING, 
# which you should have received with this distribution.
###############################################################

"""***
Usage:
   opft.py prefix messageFilename
   
Oft reads the message file, then writes it to a file in the
current directory, with a filename of the form:

   "(prefix)_(f1)(t1)"
   
Where:
   (prefix) is the prefix given as the 1st argument
   (f1) is converted to the 1st letter of the sender's email address
   (t1) is converted to the 1st letter of the recipient's email address

***"""

#***** python standard libraries:
import sys
import os.path

srcDir = os.path.abspath("../src")
sys.path.append(srcDir)

import utility
import mailheader

debug = 0

#---------------------------------------------------------------------

def main():
   prefix = sys.argv[1]
   fn = sys.argv[2]
   print "### oft %s ###" % fn
   
   mailStr = utility.readFile(fn)
   if debug: print "************** mailStr = [%s]" % mailStr
   m = mailheader.makeMailFromString(mailStr)
   mh = m.header
   if debug: print "************** mh = [%s]" % mh
   
   # get from
   fromAddr = mh.getaddr("From")[1]
   if debug: print "fromAddr = [%s]" % fromAddr
   f1 = fromAddr[:1]
   if debug: print "f1 = [%s]" % f1
   
   # get to
   toAddr = mh.getaddr("To")[1]
   if debug: print "toAddr = [%s]" % toAddr
   t1 = toAddr[:1]
   if debug: print "t1 = [%s]" % t1
   
   # build output filename
   outFn = "%s_%s%s" % (prefix, f1, t1)
   utility.writeFile(outFn, mailStr)
   
main()

#end
