# Makefile for zlib

!include <win32.mak>

CC=cl
LD=link
CFLAGS=-O -nologo
LDFLAGS=
O=.obj

# variables
OBJ1 = adler32$(O) compress$(O) crc32$(O) gzio$(O) uncompr$(O) deflate$(O) \
  trees$(O)
OBJ2 = zutil$(O) inflate$(O) infblock$(O) inftrees$(O) infcodes$(O) \
  infutil$(O) inffast$(O)

all:  zlib.dll zlib.lib example.exe minigzip.exe

adler32.obj: adler32.c zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

compress.obj: compress.c zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

crc32.obj: crc32.c zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

deflate.obj: deflate.c deflate.h zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

gzio.obj: gzio.c zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

infblock.obj: infblock.c zutil.h zlib.h zconf.h infblock.h inftrees.h\
   infcodes.h infutil.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

infcodes.obj: infcodes.c zutil.h zlib.h zconf.h inftrees.h infutil.h\
   infcodes.h inffast.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

inflate.obj: inflate.c zutil.h zlib.h zconf.h infblock.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

inftrees.obj: inftrees.c zutil.h zlib.h zconf.h inftrees.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

infutil.obj: infutil.c zutil.h zlib.h zconf.h inftrees.h infutil.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

inffast.obj: inffast.c zutil.h zlib.h zconf.h inftrees.h infutil.h inffast.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

trees.obj: trees.c deflate.h zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

uncompr.obj: uncompr.c zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

zutil.obj: zutil.c zutil.h zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

example.obj: example.c zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

minigzip.obj: minigzip.c zlib.h zconf.h
	$(CC) -c $(cvarsdll) $(CFLAGS) $*.c

zlib.dll: $(OBJ1) $(OBJ2)
	link $(dlllflags) -out:$@ $(OBJ1) $(OBJ2) $(guilibsdll)

zlib.lib: $(OBJ1) $(OBJ2)
	lib  -out:$@ $(OBJ1) $(OBJ2)
	copy zlib.lib ..

example.exe: example.obj zlib.lib
	$(LD) $(LDFLAGS) example.obj zlib.lib

minigzip.exe: minigzip.obj zlib.lib
	$(LD) $(LDFLAGS) minigzip.obj zlib.lib

test: example.exe minigzip.exe
	example
	echo hello world | minigzip | minigzip -d 

clean:
	del *.obj
	del *.exe
	del *.dll
	del *.lib
