/* pgp4pine prefs.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */

char *readPrefs(const char *searchKey, char *defaultVal)
{
	/* searchKey is "text", and defaultVal is "text" too */
	/* so they're safe pointers... */
	FILE *prefsFile;
	char inLine[PREFS_LINE_LENGTH];
	char *key;
	char *value;
	char *homeDir;
	char prefsFileName[MAX_COMMAND_LINE_LENGTH];

	/* Okay, first, let's get the rc file name ($HOME/.pgp4pinerc)	 */
	homeDir = getenv("HOME");
	DecryptCacheName[0]='\0';
	if (!homeDir || !*homeDir) {
	  homeDir = "/tmp";
	} else if (strlen(homeDir) <= PREFS_LINE_LENGTH-20) {
	  /* Because we have the HOME env handy, also get the cache name */
	  strcpy(DecryptCacheName,homeDir);
	  strcat(DecryptCacheName,"/.pgp4pine.cache");
	}
	strncpy(prefsFileName,homeDir,PREFS_LINE_LENGTH-20);
	strcat(prefsFileName,"/.pgp4pinerc");
	
	/* now, open it... */
	if ((prefsFile = fopen(prefsFileName,"r"))!=NULL) {
		while (!feof(prefsFile)) {
			// get a line, parse it for variable and value, then compare against
			// what we want.
			fgets(inLine,PREFS_LINE_LENGTH,prefsFile);
			// sprintf(debugLine,"readPrefs: lineIn: -%s-",inLine); 
			// documentStatus(debugLine);
			if (strncmp("#",inLine,1) != 0 && strncmp("//",inLine,2) != 0 ) {
				// comments always start with # in rc files
				key = strtok(inLine,"= ");
				value = strtok('\0',"= \n");
				if (strcmp(key,searchKey) == 0) {
					fclose(prefsFile);
					return value;
				}
			}
		}
		fclose(prefsFile);
	}
	return defaultVal;
}

void readRCFile()
{
	char *a;

	a = readPrefs("override_recipients","0");
	prefsOverrideRecipients = atoi(a);
	
	a = readPrefs("extra_enter_at_end","0");
	prefsExtraCRLFAtEnd = atoi(a);
	
	strcpy(prefsMyPager,readPrefs("external_pager","more"));

	a = readPrefs("verbose_output","1");
	prefsVerboseOutput = atoi(a);
	
	a = readPrefs("add_comment","1");
	prefsAddComment = atoi(a);
	
	if (strlen(DecryptCacheName)>0) {
	  a = readPrefs("cache_decrypted","-1");
	  prefsCacheDecrypted = atoi(a);
	} else prefsCacheDecrypted=-1;
}
