/* pgp4pine profiles.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */

void clearProfiles(struct myProfile *firstProfile)
{
	struct myProfile *nextProfile2 = NULL;
	do {
		nextProfile2 = firstProfile->nextProfile;
		myFree(firstProfile);
		firstProfile = nextProfile2;
	} while (nextProfile2 != NULL);
}

void selectProfile()
{
	struct myProfile *firstProfile = NULL;
	struct myProfile *thisProfile = NULL;
	struct myProfile *prevProfile = NULL;
	char profileList[PREFS_LINE_LENGTH];
	char tmpString[PREFS_LINE_LENGTH], tmpString2[PREFS_LINE_LENGTH];
	int p=0, sel=0, profileCount = 0;
	char thisProfileName[PREFS_LINE_LENGTH];

	printf("\nLoading profiles: "); fflush(stdout);
	if (strlen(readPrefs("profile_list","")) < 1) printf("\n\nWarning: It appears that no profiles are installed. I will use the defaults.\nTo install a generic .rc file, copy /usr/local/doc/pgp4pine/pgp4pinerc to your home directory.\n\nLoading profiles: ");
	strcpy(profileList,readPrefs("profile_list","default"));
	strcat(profileList,":.:"); // this seems to make it work...

	strcpy(thisProfileName,strtok(profileList,":\n"));
	do {
		thisProfile = (struct myProfile *) myMalloc(sizeof(myProfileStruct));
		thisProfile->nextProfile = NULL;
		if (firstProfile == NULL) firstProfile = thisProfile;
		if (prevProfile != NULL) prevProfile->nextProfile = thisProfile;
		prevProfile = thisProfile;
		strcpy(thisProfile->profileName,thisProfileName);
		strcpy(thisProfileName,strtok('\0',":\n"));
		profileCount++;
	} while (strlen(thisProfileName) > 2);

	thisProfile = firstProfile;
	// now that we've allocated enough memory, let's load the actual items...	
	do {
		strcpy(thisProfileName,thisProfile->profileName);

		// Bugfix - Michael Beattie - Debian Maintainer
		sprintf(tmpString,"profile_%s_version",thisProfileName);
		strcpy(tmpString2,readPrefs(tmpString,"5"));
		thisProfile->pgpVersion = atoi(tmpString2);
                		
		sprintf(tmpString,"profile_%s_extra_options",thisProfileName);
		strcpy(thisProfile->extraOptions,readPrefs(tmpString," "));

		sprintf(tmpString,"profile_%s_autosign",thisProfileName);
		thisProfile->autoSign = atoi(readPrefs(tmpString,"0"));

		sprintf(tmpString,"profile_%s_autoencrypt",thisProfileName);
		thisProfile->autoEncrypt = atoi(readPrefs(tmpString,"0"));

		sprintf(tmpString,"profile_%s_my_address",thisProfileName);
		strcpy(thisProfile->myAddress,readPrefs(tmpString," "));
		
		// Bugfix - Stops the rouge "-r" getting into the GPG cmd line
		// Michael Beattie - Debian Maintainer
		if (strlen(thisProfile->myAddress) < 3) {
			thisProfile->encryptToSelf = -1; // can't encrypt to self when there's no email address!!
		} else {
			sprintf(tmpString,"profile_%s_encrypt_to_self",thisProfileName);
			thisProfile->encryptToSelf = atoi(readPrefs(tmpString,"1"));
		}

		sprintf(tmpString,"profile_%s_ascii_armor",thisProfileName);
		thisProfile->asciiArmor = atoi(readPrefs(tmpString,"1"));
		
		sprintf(tmpString,"profile_%s_universal_text",thisProfileName);
		thisProfile->universalText = atoi(readPrefs(tmpString,"1"));

		sprintf(tmpString,"profile_%s_tmpfile",thisProfileName);
		strcpy(thisProfile->myTmpFile,readPrefs(tmpString," "));

		/* This one we do carefully, if there's no tmpfile, use special settings */
		if (strlen(thisProfile->myTmpFile) < 2) {
			char *t = NULL;
			t = getenv("HOME");
			if (t) if (strlen(t) < MAX_COMMAND_LINE_LENGTH-20) 
				sprintf(thisProfile->myTmpFile,"%s/pgp4pine.tmp",t);
			/* If it's small enough, use ~/pgp4pine.tmp for the tmpfile if none given... */
		}
		
		sprintf(tmpString,"profile_%s_detached_sigs",thisProfileName);
		thisProfile->detachedSig = atoi(readPrefs(tmpString,"-1"));

		switch (thisProfile->pgpVersion) {
			case 5:
				sprintf(tmpString,"profile_%s_pgpk",thisProfileName);
				strcpy(thisProfile->pgp5pgpk,readPrefs(tmpString,"pgpk"));
				sprintf(tmpString,"profile_%s_pgpe",thisProfileName);
				strcpy(thisProfile->pgp5pgpe,readPrefs(tmpString,"pgpe"));
				sprintf(tmpString,"profile_%s_pgps",thisProfileName);
				strcpy(thisProfile->pgp5pgps,readPrefs(tmpString,"pgps"));
				sprintf(tmpString,"profile_%s_pgpv",thisProfileName);
				strcpy(thisProfile->pgp5pgpv,readPrefs(tmpString,"pgpv"));
				break;
			case 6:
				sprintf(tmpString,"profile_%s_pgp6bin",thisProfileName);
				strcpy(thisProfile->pgp2pgp,readPrefs(tmpString,"pgp"));
				break;
			case 2:
				sprintf(tmpString,"profile_%s_pgp2bin",thisProfileName);
				strcpy(thisProfile->pgp2pgp,readPrefs(tmpString,"pgp"));
				break;
			case 1:
				sprintf(tmpString,"profile_%s_gpgbin",thisProfileName);
				strcpy(thisProfile->pgp1gpg,readPrefs(tmpString,"gpg"));
				break;
		}

		thisProfile = thisProfile->nextProfile;
		printf("%s, ",thisProfileName); fflush(stdout);
	} while (thisProfile != NULL);

	printf("done.\n\n");
	if (profileCount > 1) {
		// okay, now we have the profiles loaded, let's choose...
		printf("Please select a profile below.\n");
		thisProfile = firstProfile;
		p = 0;
		do {
			switch (thisProfile->pgpVersion) {
				case 1:
					printf("%c: GnuPG Profile \"%s\"\n",(char) (p+'a'),thisProfile->profileName); break;
				case 2:
					printf("%c: PGP 2 Profile \"%s\"\n",(char) (p+'a'),thisProfile->profileName); break;
				case 5:
					printf("%c: PGP 5 Profile \"%s\"\n",(char) (p+'a'),thisProfile->profileName); break;
				case 6:
					printf("%c: PGP 6 Profile \"%s\"\n",(char) (p+'a'),thisProfile->profileName); break;
			}
			thisProfile = thisProfile->nextProfile;
			p++;
		} while (thisProfile != NULL);
		sel = askAlphaRange("Please enter a valid selection: ",(p+'a')-1,0)-'a';
	} else {
		sel = 0; // we want the first choice, the only one...
	}
	
	thisProfile = firstProfile; // set back to beginning...
	for (p=0;p<sel;p++) thisProfile = thisProfile->nextProfile; // skip to profile we want

	// now that we have the profile, let's set the right global variables...
	myUserPrefs = (struct myProfile *) myMalloc(sizeof(myProfileStruct));
	strcpy(myUserPrefs->profileName,thisProfile->profileName);
	myUserPrefs->pgpVersion = thisProfile->pgpVersion;
	strcpy(myUserPrefs->extraOptions,thisProfile->extraOptions);
	myUserPrefs->autoSign = thisProfile->autoSign;
	myUserPrefs->autoEncrypt = thisProfile->autoEncrypt;
	myUserPrefs->encryptToSelf = thisProfile->encryptToSelf;
	strcpy(myUserPrefs->myAddress,thisProfile->myAddress);
	myUserPrefs->asciiArmor = thisProfile->asciiArmor;
	myUserPrefs->universalText = thisProfile->universalText;
	myUserPrefs->cache_decrypted = thisProfile->cache_decrypted;
	strcpy(myUserPrefs->myTmpFile,thisProfile->myTmpFile);
	myUserPrefs->detachedSig = thisProfile->detachedSig;
	strcpy(myUserPrefs->pgp5pgpk,thisProfile->pgp5pgpk);
	strcpy(myUserPrefs->pgp5pgpe,thisProfile->pgp5pgpe);
	strcpy(myUserPrefs->pgp5pgps,thisProfile->pgp5pgps);
	strcpy(myUserPrefs->pgp5pgpv,thisProfile->pgp5pgpv);
	strcpy(myUserPrefs->pgp2pgp,thisProfile->pgp2pgp);
	strcpy(myUserPrefs->pgp1gpg,thisProfile->pgp1gpg);

	clearProfiles(firstProfile); // dealloc...
	printf("\n");
}





