premail documentationRaph Levien \f(CRraph@cs.berkeley.edu\fP
.Pp
This is a draft of the documentation for premail 0.44. Introduction to premail

.Pp
This is the documentation for version 0.44 of premail, an e-mail
privacy package by .
.Pp
.Pp
The main function of premail is adding support for encrypted
e-mail to your mailer, using plain PGP, ,
, or . 
.Pp
In addition, premail provides a seamless, transparent interface to
the , including full support for Mixmaster
remailers and the nymservers. Nymservers provide cryptographically
protected, fully anonymous accounts for both sending and receiving
e-mail. 
.Pp
While premail can be used as a stand-alone application, it works
best when integrated with your mailer. Currently, premail is
integrated completely seamlessly and transparently only with Netscape
3.0's built-in mailer. It works fairly well with  3.94 or later,
as well (plain PGP is supported, but decryption of MIME-based e-mail
encryption protocols is still missing). Transparent integration of
outgoing mail only is supported for any mailer in which the mail
sending program can be configured, including Berkeley mail, most emacs
mailers, and .
For these mailers, you can decode messages with a single command. 
.Pp
To integrate with your mailer, premail places itself between the
mailer and the actual mail transport. For outgoing mail, premail
masquerades as sendmail. You configure your mailer to call premail
instead of sendmail. Then, premail performs the encryption or signing,
and invokes sendmail to actually send the message. 
.Pp
For mailers that call a command to receive incoming mail
(including Netscape 3.0), the situation is similar. Netscape, for
example, can be configured to call movemail to get incoming mail. To
integrate premail, you'd configure Netscape to call premail instead,
which would in turn call movemail to actually get the mail, then would
decode it. 
.Pp
You need the following software in order to effectively use
premail:
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
Unix. Unfortunarely, premail does not work on Mac or Windows.
.nr bi 1
.Pp
5.000 or
later.
.nr bi 1
.Pp

(version 2.6.2 recommended).
.nr bi 1
.Pp
3.0b2 or
later (optional, for S/MIME support)
.nr bi 1
.Pp
7.1
(optional, for MOSS support)
.nr bi 1
.Pp
(optional,
for higher security anonymous mail)
.nr bi 1
.Pp

(only if you're behind a firewall)
.if \n(ll>1 .RE
.nr ll -1
.Pp
Installation

.Pp
First, you need to get premail. The source code is available from
an 
Web server. You may also be able to find a copy on the  FTP
site in the Netherlands. In either case, you want to get the file
\f(CRpremail-0.44.tar.gz\fP. 
.Pp
After you've gotten the file, unpack it. This command should do
it:
.Pp
.DS
.sp 
.ft CR
.nf
gzip -dc premail-0.44.tar.gz | tar xvf -
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
The unpacking process will create a subdirectory called
\f(CRpremail-0.44\fP, containing the following files:
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
\f(CRREADME\fP A short
description of the contents
.nr bi 1
.Pp
\f(CRpremail\fP The premail program itself
.nr bi 1
.Pp
\f(CRpreferences\fP A skeletal
preferences file
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
Test to see if you can run premail. These commands should print a
usage summary:
.Pp
.DS
.sp 
.ft CR
.nf
cd premail-0.44
./premail
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If you get an error message reading ``command not found,'' then you
will have to edit the first line of \f(CRpremail\fP to refer to the
actual pathname of the perl5 interpreter. One good way to find out the
pathname is to do ``\f(CRwhich perl5\fP'' or ``\f(CRwhich perl\fP''.
.Pp
On the other hand, if you get a string of syntax errors, then the
problem is that you are running perl4, while premail needs perl5. Try
to see if you can find perl5 on your machine. Otherwise, you may need
to install perl5 yourself. 
.Pp
If you will be using premail from the command line frequently,
then you may want to copy (or symlink) the premail program into a
location in your \f(CR$PATH\fP. For example, if you have permission
to add files into \f(CR/usr/local/bin\fP, then you may consider
running this command: 
.Pp
.DS
.sp 
.ft CR
.nf
cp -p premail /usr/local/bin
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
At this point, you are ready to test whether premail actually
works. We are assuming that you already have PGP installed and have
generated your own public key. Type this command, substituting in your
own e-mail address: 
.Pp
.DS
.sp 
.ft CR
.nf
./premail -t
To: your@own.email.addr ((encrypt-pgp))
Subject: Test

Does this really work?
.
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If all goes well, you should be back at the command line within a
couple of seconds. If it seems to hang without any disk or net
activity, try typing randomly for a minute, under the assumption that
PGP needs random keystrokes. This shouldn't happen if PGP is already
set up correctly (including having generated your own public key), but
on the chance that it isn't, hanging while waiting for random
keystrokes is one of the more common failure modes. 
.Pp
This is also the point at which you may get a PGP error. Two
common problems are that premail can't find the PGP program, in which
case you will want to add a line to your preferences file (see section
below), or that it can't find the
public key corresponding to your e-mail address. 
.Pp
If the test was successful you now have a PGP-encrypted message in
your mailbox, then you should now have a PGP-encrypted message in your
mailbox. Preferences

.Pp
While premail's default configuration is designed to be sufficient
for the the most common cases, you may want to change some of the
configuration options. This is done by adding lines to the
preferences file. 
.Pp
The default location for the preferences file is
\f(CR~/.premail/preferences\fP, where \f(CR~\fP represents your home
directory. The premail distribution comes with a skeleton preferences
file, but it does not automatically copy it into the
\f(CR~/.premail\fP directory. You might choose to do that yourself,
or you might create one from scratch. 
.Pp
The format of the preferences file is a sequence of lines such as
the following: 
.Pp
.DS
.sp 
.ft CR
.nf
$config{'option'} = 'value';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
All other lines (including those beginning with \f(CR#\fP) are
considered to be comments and are ignored. Here's a typical
preferences file (actually, the one on my home machine): 
.Pp
.DS
.sp 
.ft CR
.nf
$config{'logfile'} = '/home/raph/premail/log';
$config{'debug'} = 'chvl';
$config{'movemail'} = '/home/raph/bin/movehome';
$config{'ripem'} = '/home/raph/install/ripem/main/ripem';
$config{'pgp'} = '/usr/local/bin/pgp';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
As you can see, a major use for the preferences file is to specify
full pathnames for the helper programs. In addition, I've set it up to
produce a full log, which I find useful, because I'm constantly
tracking down bugs :-) 
.Pp
Here's a table of all the configuration options, their defaults,
and a very brief description. More complete descriptions are found in
the preferences file included in the premail distribution.
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.Pp
.IP "pgp (default \f(CRpgp\fP)"
.nr bi 1
.Pp
The location of the PGP executable.
.Pp
.IP "sendmail (default \f(CR/usr/lib/sendmail\fP)"
.nr bi 1
.Pp
The location of the sendmail executable.
.Pp
.IP "mixmaster (default \f(CRmixmaster\fP)"
.nr bi 1
.Pp
The location of the Mixmaster executable (useful for more secure
anonymous mail).
.Pp
.IP "movemail (default \f(CRmovemail\fP)"
.nr bi 1
.Pp
The location of the movemail executable (useful for integrating
Netscape 3.0).
.Pp
.IP "ripem (default \f(CRripem\fP)"
.nr bi 1
.Pp
The location of the ripem executable (needed for S/MIME messages).
.Pp
.IP "mossbin"
.nr bi 1
.Pp
The directory containing the TIS/MOSS executables (needed for MOSS
messages).
.Pp
.IP "post (default \f(CRpost\fP)"
.nr bi 1
.Pp
The location of the MH post executable (needed for MH integration).
.Pp
.IP "geturl (default \f(CR \fP)"
.nr bi 1
.Pp
A command for getting files from the Web. Use ``\f(CRlynx
-source\fP'' if behind a firewall.
.Pp
.IP "dead-letter (default \f(CR~/dead.letter\fP)"
.nr bi 1
.Pp
The file where premail stores undeliverable mail.
.Pp
.IP "logfile"
.nr bi 1
.Pp
The location where premail stores its log, if the \f(CRl\fP debug
flag is set.
.Pp
.IP "storefile"
.nr bi 1
.Pp
If set, the location where premail stores outgoing mail, instead of
calling sendmail.
.Pp
.IP "tmpdir (default \f(CR/tmp\fP)"
.nr bi 1
.Pp
Where premail stores its temporary files.
.Pp
.IP "charset (default \f(CRiso-8859-1\fP)"
.nr bi 1
.Pp
The default charset for outgoing 8-bit messages.
.Pp
.IP "encrypt (default \f(CRyes\fP)"
.nr bi 1
.Pp
Set to
blank to disable PGP encryption to remailers.
.Pp
.IP "ack"
.nr bi 1
.Pp
If set, nymservers will
send acknowledgements for all outgoing mail.
.Pp
.IP "extrablank"
.nr bi 1
.Pp
If set, premail adds an extra blank on remailer messages. Useful if
behind a broken mail proxy.
.Pp
.IP "debug "
.nr bi 1
.Pp
Debugging flags (see section ).
.Pp
.IP "signuser"
.nr bi 1
.Pp
The user id of the default PGP secret key used to sign messages.
.Pp
.IP "default-reply-to"
.nr bi 1
.Pp
Adds a \f(CRReply-To:\fP header field with this address when sending
anonymous e-mail.
.Pp
.IP "addresses (default \f(CR~/.premail/addresses\fP)"
.nr bi 1
.Pp
The file containing your addresses.
.Pp
.IP "rlist (default \f(CR~/.premail/rlist\fP)"
.nr bi 1
.Pp
The file where premail stores the remailer list.
.Pp
.IP "pubring (default \f(CR~/.premail/pubring.pgp\fP)"
.nr bi 1
.Pp
The file where premail stores the public keyring for the remailers.
.Pp
.IP "premail-secrets-pgp (default \f(CR~/.premail/secrets.pgp\fP)"
.nr bi 1
.Pp
The file where premail stores the encrypted secrets file.
.Pp
.IP "premail-secrets (default \f(CR/tmp/premail-secrets.$<\fP)"
.nr bi 1
.Pp
The location of your secrets file
.Pp
.IP "rlist-url (default \f(CRhttp://kiwi.cs.berkeley.edu/rlist\fP)"
.nr bi 1
.Pp
The URL for the remailer list.
.Pp
.IP "pubring-url (default \f(CRhttp://kiwi.cs.berkeley.edu/pubring.pgp\fP)"
.nr bi 1
.Pp
The URL for the remailer public keyring.
.Pp
.IP "type2-list-url (default \f(CRhttp://www.jpunix.com/type2.html\fP)"
.nr bi 1
.Pp
The URL for the Mixmaster type2 list.
.Pp
.IP "pubring-mix-url (default \f(CRhttp://www.jpunix.com/pubring.html\fP)"
.nr bi 1
.Pp
The URL for the Mixmaster pubring.
.Pp
.if \n(ll>1 .RE
.nr ll -1
.Pp
Secrets

.Pp
To create signatures, decrypt messages, or use nyms, you need to
set up a ``premail secrets'' file. If you will only be using premail to
encrypt outgoing mail, you can skip this section. 
.Pp
The default filename is \f(CR/tmp/.premail-secrets.$<\fP ,
where \f(CR$<\fP is equal to your numeric user id. To change the
filename, use a preferences line such as this one: 
.Pp
.DS
.sp 
.ft CR
.nf
$config{'premail-secrets'} = '/mnt/cryptdisk/premail-secrets';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If you don't know your numeric user id, you can find it by running
``\f(CRecho $uid\fP'' (from csh or tcsh), ``\f(CRecho $UID\fP'' (from sh
or bash), or: 
.Pp
.DS
.sp 
.ft CR
.nf
perl -e 'print "$<;\n"'
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
The premail secrets file has this format: 
.Pp
.DS
.sp 
.ft CR
.nf
$pgppass{'user'} = 'PGP passphrase for user';
$pgppass{'alternate'} = 'PGP passphrase for alternate';
$penetpass = 'Passphrase for anon.penet.fi';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
However, make sure your premail secrets file has restrictive
permissions, so other people on your system can't read your
passphrases! This command is well recommended (substituting your
actual user id, of course): 
.Pp
.DS
.sp 
.ft CR
.nf
chmod 600 /tmp/.premail-secrets.7437
.DE
.fi 
.ec
.ft P
.sp
.Pp
.SH Logging in and logging out

.Pp
Generally, premail stores its secrets file in the \f(CR/tmp\fP
directory. In some cases, this is good enough security. In other
cases, it might be better to store the file encrypted most of the
time, and only decrypt it when necessary. To use this capability of
premail, first set a passphrase with: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -setpass
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
You will be prompted for a passphrase. You can use the same
passphrase as for your PGP key, or a different one, depending on how
many passphrases you want to remember. This command leaves you logged
in with the new passphrase set. 
.Pp
.Pp
Note: the secrets file must already exist before setting the
password on it. If not, there will be an error message. 
.Pp
To log out: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -logout
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
You might consider adding this command to your .logout file, so
that it occurs automatically every time you log out of your account.
.Pp
To log in again: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -login
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If you are running on a system with X, then premail will
automatically pop up a window to log in whenever the secrets are
needed. If you are not running X, and the secrets are needed, you will
get an error. In this case, you can log in manually and try the
command again. Netscape

.Pp
This section describes how to integrate premail into Netscape
3.0's built-in mailer. Skip this section if you won't be using
Netscape mail. 
.Pp
1. Create symbolic links to premail called ``prezilla'' and
``premailmove''. To do this, make sure you are in the same directory as
premail itself, and type: 
.Pp
.DS
.sp 
.ft CR
.nf
ln -s premail prezilla
ln -s premail premailmove
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
2. Find a working movemail. If you have emacs installed, then you
most likely have one in /usr/lib/emacs/etc/movemail or a similar
location. If you don't already have one, then the source (or possibly
binary) for one is included in the Netscape Navigator distribution and
you can build it (no need if a binary is included). Then, make sure
premail can find it by adding a line such as this one to your
preferences file: 
.Pp
.DS
.sp 
.ft CR
.nf
$config{'movemail'} = '/usr/lib/emacs/etc/movemail';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
This usage assumes that you get your mail from a mail spool, as
opposed to POP or some such. You may be able to get it to work for POP
as well, but you need to figure out how to invoke movemail to move the
mail from your mailbox to a file (specified as the second argument to
the movemail script). 
.Pp
3. Add this line to your .cshrc, assuming your shell is csh or
tcsh: 
.Pp
.DS
.sp 
.ft CR
.nf
setenv NS_MSG_DELIVERY_HOOK /your/path/to/prezilla
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Also run this command from the shell so it takes effect
immediately. The syntax is slightly different if your shell is sh or
bash \fI(note: is this right?)\fP: 
.Pp
.DS
.sp 
.ft CR
.nf
NS_MSG_DELIVERY_HOOK=/your/path/to/prezilla
export NS_MSG_DELIVERY_HOOK
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
4. Start Netscape (exit first if it's already running). Go to the
Options|Mail and News Preferences dialog, select the Servers tab.
Click on ``External Movemail'' and set the value to
\f(CR/your/path/to/premailmove\fP. 
.Pp
Try sending yourself mail, and clicking on ``Get Mail'' from the
Netscape Mail window. The mail should show up in the Inbox, correctly
decoded. 
.Pp
To view the X-Premail-Auth: header field to see the result of
signature checking, select Options|Show All Headers from the Netscape
Mail window. 
.Pp
Note: as of Netscape v3.0b5, there is still a bug in the handling
of the \f(CRBcc:\fP header field, which causes it to be ignored. Do
not use this field. Hopefully, this will be fixed in a future version
of Netscape. 
.Pp
Note: some 3.0 beta versions modify the \f(CRPATH\fP environment
variable. If premail seems to work correctly from the command line,
but not from Netscape, try setting absolute pathnames for the programs
used by premail. Pine

.Pp
As of Pine 3.94, premail integrates both outgoing mail and the
decryption of plain PGP incoming mail. Unfortunately, decryption of
MIME-based mail is not yet supported. 
.Pp
Two Pine configuration options need to be set to integrate premail
(i.e. from the main Pine screen, \f(CRS\fP for setup, then \f(CRC\fP
for configure). First, \f(CRsendmail-path\fP should be set to a value
similar to this (substituting the actual path to premail): 
.Pp
.DS
.sp 
.ft CR
.nf
/your/path/to/premail -oem -t -oi
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Second, \f(CRdisplay_filters\fP should be set to a value similar
to this: 
.Pp
.DS
.sp 
.ft CR
.nf
_BEGINNING("-----BEGIN PGP")_ /your/path/to/premail -decode -body
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If you have trouble finding these options in the setup screen,
then you can edit the .pinerc file directly. 
.Pp
One caveat when using Pine: it usually tries to be ``smart'' and
remove comments from e-mail addresses, which includes the double-paren
commands such as \f(CR((encrypt-pgp))\fP. There are a few ways to
deal with this problem: 
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
Use \f(CR"(\fP \f(CR)"\fP instead of \f(CR((\fP
\f(CR))\fP. \fINote: I think this works, but I haven't tested
it.\fP
.nr bi 1
.Pp
Use the alternative caret syntax. These two lines mean the same
thing:

.DS
.sp 
.ft CR
.nf
To: raph@cs.berkeley.edu ((encrypt-key, sign))
To: raph@cs.berkeley.edu^encrypt-key^sign
.DE
.fi 
.ec
.ft P
.sp

.nr bi 1
.Pp
Avoid setting the encryption options on the command line
altogether, and set them in the addresses file instead (see section
below).
.if \n(ll>1 .RE
.nr ll -1
.Pp
Other mailers

.Pp
This section describes how to integrate premail with MH, emacs,
and UCBMail. With these mailers, premail will only handle outgoing
mail automatically. To decode incoming mail, you still need to invoke
\f(CRpremail -decode\fP by hand.
.Pp
.SH Integrating premail with Emacs

.Pp
To add premail support to emacs, just add this line to your .emacs
file: 
.Pp
.DS
.sp 
.ft CR
.nf
(setq sendmail-program "/your/path/to/premail")
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
.SH Integrating premail with MH

.Pp
In whatever directory you keep the premail executable, create a
symbolic link as follows: 
.Pp
.DS
.sp 
.ft CR
.nf
ln -s premail prepost
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Under the name ``prepost'', premail will masquerade as MH's post
program rather than sendmail. You can get MH to call premail instead
of post by adding this line to your .mh_profile: 
.Pp
.DS
.sp 
.ft CR
.nf
postproc: /your/path/to/prepost
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
One thing to keep in mind is that premail's processing is done
before that of post. Thus, if you have MH aliases, they will get
expanded after the call to premail. If you use only premail aliases,
only MH aliases, or neither, this won't be a problem. 
.Pp
Alternatively, if you have appropriate privileges, you can add this
line to /usr/lib/mh/mtstailor: 
.Pp
.DS
.sp 
.ft CR
.nf
sendmail: /your/path/to/premail
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
You may also have to configure MH to call sendmail locally rather
than connecting to an SMTP server. Don't do both the mtstailor and
mh_profile methods -- that would run premail twice. 
.SH Installing premail with UCBmail

.Pp
UCBmail is a simple mailer front-end (also known as Mail and
mailx). If, when you type ``mail user@site.dom'', the mailer
asks you for a ``Subject: '' line, you are undoubtedly using UCBmail. If
so, you are in luck - it integrates very easily with premail. Just add
this line to your ~/.mailrc file:
.Pp
.DS
.sp 
.ft CR
.nf
set sendmail=/your/path/to/premail
.DE
.fi 
.ec
.ft P
.sp
.Pp
Using premail with UCBmail is not very different from using premail by
itself, but you do get some handy features, such as including files
and using an editor on the mail. Command line

.Pp
Hopefully, you have integrated premail into your mail client, and
you won't have to invoke it from the command line. However, there may
still be times when it is convenient to use premail from the command
line. 
.Pp
The most basic use of premail is as a replacement for sendmail.
For example, you can send mail directly from the command line, as
follows (here, the \f(CR>\fP represents the Unix prompt): 
.Pp
.DS
.sp 
.ft CR
.nf
> premail -t
To: raph@cs.berkeley.edu ((sign))
Subject: premail bug report

Here's a bug in premail: ...
.
>
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
The \f(CR-t\fP option specifies that the recipients are extracted
from the header fields (\f(CRTo:\fP, \f(CRCc:\fP, \f(CRBcc:\fP, and
the \f(CRResent-\fP variants of each). As in sendmail, you can
specify the recipients on the command line instead of using the
\f(CR-t\fP option. 
.Pp
In addition, you can set configuration options from the command
line, using the \f(CR+option=value\fP syntax. This is especially
useful with the debug option (see section ). For example, to show you what happens when
formatting mail for remailers, but not actually send the message:
.Pp
.DS
.sp 
.ft CR
.nf

> premail +debug=ry -t
To: raph@cs.berkeley.edu ((chain=1))
Subject: test of remailer

test
.
Chose chain exon
/usr/lib/sendmail -oi remailer\@remailer\.nl\.com << -eof-
To: remailer@remailer.nl.com

::
Encrypted: PGP

-----BEGIN PGP MESSAGE----- remailer@remailer.nl.com
::
Request-Remailing-To: raph@cs.berkeley.edu

##
Subject: test of remailer

test
-----END PGP MESSAGE-----
-eof-
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
There is one configuration option that can only be set from the
command line in this fashion, which is the location of the preferences
file itself. The configuration option is \f(CRpreferences\fP, and the
default value is \f(CR~/.premail/preferences\fP. Encryption

.Pp
Once you've got premail set up, actually using encryption is easy.
You simply add commands in double parentheses to the e-mail addresses.
The \f(CRencrypt-pgp\fP command (which can be abbreviated to
\f(CRkey\fP) adds encryption to the outgoing mail, and the
\f(CRsign\fP command signs it. 
.Pp
For example, to send me encrypted mail, you'd send it to
\f(CRraph@cs.berkeley.edu ((encrypt-pgp))\fP. You need to have
a key with this user id on your PGP public keyring, otherwise you'll
get an error message. If the user id on the key doesn't match the
e-mail address, you can specify it directly. For example, to send mail
directly to my workstation, but using the same public key as above,
use \f(CRraph@kiwi.cs.berkeley.edu
((key=raph@cs.berkeley.edu))\fP.
.Pp
Signing works much the same way. I can sign mail by adding
\f(CR((sign=raph@cs.berkeley.edu))\fP to the outgoing address.
Actually, because I set the \f(CRsignuser\fP configuration option in
my preferences file, all I have to add is \f(CR((sign))\fP. 
.Pp
Doing both encryption and signing is just as easy. For example,
to send me signed, encrypted mail, use this line: 
.Pp
.DS
.sp 
.ft CR
.nf
To: raph@cs.berkeley.edu ((encrypt-pgp, sign))
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Each recipient is treated separately - the double-paren commands
after an e-mail address apply to that recipient only. However, you can
add a \f(CRSign:\fP header field to indicate that your message is
signed for all recipients. Example: 
.Pp
.DS
.sp 
.ft CR
.nf
To: vp@company, secretary@company, employees@company,
    friend@outside ((encrypt-pgp))
Subject: Important announcement
Sign:

...
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
In this example, all recipients will get a signed message, and the
message to friend@outside will be encrypted as well. Decoding

.Pp
The basic way to decode encrypted messages is to use \f(CRpremail
-decode\fP as a command line. You can either give a filename as an
argument, or premail will accept the encrypted message on its standard
input. In either case, the decoded message will be printed on the
standard output. 
.Pp
The message can be a standard e-mail message (RFC 822 format), or
it can be an entire mailbox. In the latter case, premail will decode
each of the messages individually. If you don't have premail directly
integrated into your mailer, then here's a handy way to view your
mail: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -decode $MAIL | more
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If the message is actually encrypted, then premail will need to
access the secrets file. If you are logged out of premail, then
premail will try to open an xterm window for you to type the
passphrase for the secrets file. If that doesn't succeed, premail will
print an error message. At that point, you might choose to log in
(i.e. \f(CRpremail -login\fP) and then try the decoding again. 
.Pp
If, as in many mailers, you have easy access to the body of the
message but not the header, then you can use \f(CRpremail -decode
-body\fP on the body. This works well for plain PGP encrypted
messages, but unfortunately does not work for MIME-based message
formats, because important information is contained in the header.
.Pp
The results of the decoding (including signature verification) are
given in an \f(CRX-Premail-Auth:\fP header field. This header field
is protected against forgery; if the original message contains it, it
is changed to \f(CRX-Attempted-Auth-Forgery\fP. Anonymity

.Pp
The original reason for writing premail was to provide good
support for . If you're not interested in sending anonymous mail, you
can skip this section. 
.Pp
Sending anonymous mail is very similar to sending encrypted mail.
Simply add the \f(CR((chain))\fP command to the recipient's e-mail
address. Alternatively, you can add a \f(CRChain:\fP header field,
and the mail will be send anonymously to all recipients. 
.Pp
Even though the chain command is simple, a lot is going on under
the surface. The default chain is \f(CR3\fP, which asks that three
``good'' remailers be chosen randomly. To make sure that it makes its
choice based on fresh, up-to-date information, premail downloads the
remailer list and a set of PGP public keys for the remailers from the
Web (the actual URLs are configuration options). After choosing the
remailers, the message is multiply encrypted with the PGP public keys,
and finally sent to the first remailer in the chain. 
.Pp
The automatic chain selection process is very good. My tests
indicate that reliability is consistently above 99%. Further, the
chain selection process avoids some potential problems. For example,
some remailers are known not to work well in chains, probably because
of incorrectly configured ``block lists.'' Also, some remailers are
``linked,'' in the sense of being hosted on the same machine, or being
administered by the same person. Choosing a sequence of linked
remailers wouldn't offer much security, so premail doesn't. 
.Pp
You can also choose the chain length. A shorter chain will be
faster and more reliable, but less secure, and conversely for longer
chains. For example, \f(CR((chain=5))\fP selects a chain of five
remailers. 
.Pp
If this isn't enough control, you can specify the exact chain of
remailers by hand. For example, \f(CR((chain=replay;jam;exon))\fP
bounces the message around a few times outside the US. 
.Pp
Mixmaster chains are specified inside an additional set of
parentheses. At the moment, there is no way to automatically select a
chain of Mixmaster remailers, so you have to do it by hand. For
example: \f(CR((chain=(replay;ecafe-mix;lcs)))\fP. You can even mix
Mixmaster and type-1 remailers; for example,
\f(CR((chain=(anon);1;(replay)))\fP will sandwich one well-chosen
remailer between the two Mixmaster remailers. 
.Pp
Extra header fields can be placed in the outgoing message by
prefixing the header with ``\f(CRAnon-\fP''. A particularly common
usage is an \f(CRAnon-Reply-To:\fP field, which specifies a reply-to
address in the mail delivered to the recipient. The \f(CRReply-To:\fP
header field is used often enough that premail includes a
\f(CRdefault-reply-to\fP configuration option, which automatically
adds it to all anonymous messages. 
.Pp
The following header fields are passed through to the anonymized
message, even without the \f(CRAnon-\fP prefix: 
.Pp
.DS
.sp 
.ft CR
.nf
Mime-Version:
Content-Type:
Content-Transfer-Encoding:
Newsgroups:
X-Anon-To:
In-Reply-To:
References:
.DE
.fi 
.ec
.ft P
.sp
.Pp
Using nyms

.Pp
This section describes how to create and use \fInyms\fP, which
are accounts for sending and receiving anonymous mail. The most
popular and well known nymserver is alpha.c2.org. The  explains how to set up and use
nyms by hand, but it's much easier to do (and more secure!) with
premail.
.Pp
.Pp
To create a new nym, type 
.Pp
.DS
.sp 
.ft CR
.nf
premail -makenym
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
and follow the prompts. This command is also good for updating an
existing nym, which is important if one of the nym's remailers goes
down. 
.Pp
You can also create or update a nym from the command line, as
follows: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -makenym you@alpha.c2.org your@real.email.address
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
When premail creates a nym, it chooses random passphrases (one for
each remailer in the chain). The passphrases and other details of the
nym are stored in the premail secrets file. Thus, the nym is fairly
secure (much more so than, say, anon.penet.fi). 
.Pp
The decode mechanism handles responses to nyms, again looking up
the passphrases in the premail secrets file. 
.Pp
You can also send mail from your nym, in one of two ways. Assume
for the sake of example that your nym is you@alpha.c2.org.
Then, you would use a chain of \f(CR2;alpha=you\fP. Alternatively,
you can use a chain of \f(CR2;alpha\fP and include this header field:
.Pp
.DS
.sp 
.ft CR
.nf
Anon-From: you@alpha.c2.org (You Know Who)
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
If you want the nymserver to send you a confirmation every time
you send mail from your nym, add a \f(CR$config{'ack'} =
'yes';\fP line to your preferences file. 
.Pp
To delete a nym: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -makenym you@alpha.c2.org delete
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Please delete nyms if you are not actually using them; this helps
free up disk space and prevents the nymservers from being overloaded. Posting to Usenet

.Pp
Even though some remailers can post directly to Usenet, premail does
not support that. Thus, if you want to post to Usenet, you should use
a mail-to-news gateway. 
.Pp
To find a working mail-to-news gateway, check Don Kitchen's . There
are two basic kinds: sites that scan the header fields, and sites that
include the newsgroup in the address. 
.Pp
Using the address-parsing kind, to post to alt.anonymous, you'd
just send mail to alt.anonymous@myriad.alias.net (assuming, of
course, that myriad.alias.net is still functioning). 
.Pp
Using the header-scanning kind, send mail to
mail2news@myriad.alias.net, and include this header field:
.Pp
.DS
.sp 
.ft CR
.nf
Newsgroups: alt.anonymous
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
The header scanning kind has one advantage: you can cross-post to
multiple newsgroups using one mail message. 
.Pp
One frequently asked question is: how can I follow up on a thread
while posting anonymously? This is easy. Find the \f(CRMessage-Id:\fP
header field in the post you're responding to, and change it into a
\f(CRReferences:\fP field in your outgoing mail. 
.Pp
Here's an example that ties it all together. Let's say you wanted
to reply to this post: 
.Pp
.DS
.sp 
.ft CR
.nf
From: Edward Brian Kaufman <ebk8@columbia.edu>;
Newsgroups: alt.privacy.anon-server, alt.anonymous
Subject: A few questions about anon posts
Message-ID: <Pine.SUN.3.94L.960630113156@aloha.cc.columbia.edu>;

Hi,

I'd like to know what the best/easiest way to do anon posts is and
how to do them.  Thank you,

Ed
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
To post the reply anonymously, send this mail: 
.Pp
.DS
.sp 
.ft CR
.nf
To: mail2news@myriad.alias.net ((chain))
Cc: Edward Brian Kaufman <ebk8@columbia.edu> ((chain))
Newsgroups: alt.privacy.anon-server, alt.anonymous
Subject: Re: A few questions about anon posts
References: <Pine.SUN.3.94L.960630113156@aloha.cc.columbia.edu>

If you have a Unix machine, using premail is the best way. To find
out how, read the manual.
.DE
.fi 
.ec
.ft P
.sp
.Pp
Address book

.Pp
Adding the extra encryption commands is not difficult, but it can
be tedious and potentially error prone. Thus, premail provides an address
book for specifying commands to be used with specific e-mail addresses.
.Pp
.Pp
For example, let's say that one of your correspondents tells you
that she prefers mail to be PGP encrypted. Then, instead of typing
\f(CR((encrypt-pgp))\fP every time you send her mail, you could add
this line to your addresses file: 
.Pp
.DS
.sp 
.ft CR
.nf
her@email.address: ((encrypt-pgp))
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
The addresses file is usually at \f(CR~/.premail/addresses\fP,
but the location is a configurable option. 
.Pp
Another example is the hackerpunks mailing list, in which all of
the subscribers have alpha.c2.org nyms. Since haqr@alpha.c2.org
has this line in his addresses file, he is able to post to the list
with just ``\f(CRTo: hpunks\fP'':
.Pp
.DS
.sp 
.ft CR
.nf
hpunks: hackerpunks@alpha.c2.org ((chain=2;alpha=haqr))
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
An address book entry can also expand to a list of addresses. For
example: 
.Pp
.DS
.sp 
.ft CR
.nf
alice: alice@crypto.com ((encrypt-pgp))
bob: bwhite@got.net ((key=bobw@netcom.com))
eric: eric@ecsl.org ((encrypt-pgp))

friends: alice, bob, eric
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Sending mail to \f(CRfriends\fP would then do what you'd expect:
send encrypted mail to each of alice, bob, and eric's full e-mail
addresses. S/MIME

.Pp
Version 0.44 of premail contains limited support for S/MIME
messages. Basic message formatting works, but there are problems with
creating usable certificates, and there is still no support for an
encryption algorithm interoperable with RC2. However, a few hearty
souls may wish to experiment with the S/MIME functionality that is
present. This section explains how to do it. 
.Pp
First, you must install RIPEM 3.0b2 (or later). This is available
from the ripem export-controlled . You'll
need to get an account on the server in order to download any of the
export-controlled code - the  file on the site explains how. 
.Pp
Once you have RIPEM installed (and the \f(CRripem\fP
configuration option pointing to the executable), create a public key
with this command: 
.Pp
.DS
.sp 
.ft CR
.nf
premail -ripemkey
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
You will then be prompted for your e-mail address. Alternatively,
you can give your e-mail address as a command line argument to
\f(CRpremail -ripemkey\fP. 
.Pp
After your key is created, you can send signed messages by adding
the \f(CR((ssign))\fP command. If you send a signed message to
another premail user, they will have your public key, and can send you
mail, by using \f(CR((encrypt=your@user.id))\fP. 
.Pp
The default encryption is Triple-DES. If the recipient can't
handle it, then \f(CR((encrypt-des))\fP will fall back to plain DES,
which most users will be able to decrypt - probably including
``export'' versions of S/MIME. Of course, the disadvantage of using
plain DES is that any competent spy organization will also be able to
decrypt the messages ;-). 
.Pp
Unfortunately, RIPEM 3.0b2 has some significant differences from
other S/MIME implementations in the way it handles public key
certificates. These prevent you from getting a VeriSign certificate
you can use. It is, however, possible to accept VeriSign class 1 beta
certificates by running the following: 
.Pp
.DS
.sp 
.ft CR
.nf
> rcerts -u your@user.id
Enter password to private key:
E - Enable standard issuers...
...other choices...
  Enter choice:
e
...V - VeriSign something or other...<newline>
v
  Enter the number of months the certificate will be valid, or blank to cancel:
12
  Enter choice:
q
.DE
.fi 
.ec
.ft P
.sp
.Pp
Debugging

.Pp
If you run into trouble with premail, it might be of value to turn
on some of the debugging options. This can be done on the command
line, or in the .premailrc file. In the former case, add a
\f(CR+debug=chvy\fP argument to the command line. In the latter case,
try: 
.Pp
.DS
.sp 
.ft CR
.nf
$config{'debug'} = 'chvy';
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
Here are the meanings of the debug options:
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
\f(CRc\fP: Print command line invocation.
.nr bi 1
.Pp
\f(CRh\fP: Print headers of input message.
.nr bi 1
.Pp
\f(CRl\fP: Debug output goes to log instead of stdout.
.nr bi 1
.Pp
\f(CRp\fP: Print finished message, do PGP.
.nr bi 1
.Pp
\f(CRr\fP: Print chain chosen (useful in debugging chain
selection).
.nr bi 1
.Pp
\f(CRy\fP: Print finished message, don't do PGP.
.nr bi 1
.Pp
\f(CRv\fP: Print all kinds of verbose info.
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
Note that \f(CR+debug=p\fP puts the encrypted message on stdout.
This may be useful for constructing reply blocks, among other things.
.Pp
If there are problems with premail, then one of the best ways to
track them down is through the log. Try setting the \f(CRdebug\fP
configuration option to \f(CRchvl\fP, setting the \f(CRlogfile\fP
configuration option (for example, to \f(CR~/.premail/log\fP), and
then examining the log. Also, if you're bringing bugs to my attention,
it helps a lot if you can send me relevant excerpts from the log. Technical notes

.Pp
This section covers a number of techincal notes related to the
operation of premail. This information should not be necessary for
ordinary use. 
.SH Multiple recipients

.Pp
One of the tricky problems with mail encryption packages such as
premail is how to deal with multiple recipients. Based on experience
with previous versions, this version of premail tries very hard to
``get it right.'' However, as a consequence, the exact behavior can
sometimes be difficult to understand. 
.Pp
The hard part is when some of the recipients have encryption
specified and others don't. What premail does is to split the
recipients up into groups. If two recipients can receive the same
actual message, they are in the same group, otherwise not. For
example, recipients getting an encrypted and an unencrypted message
cannot be in the same group. However, multiple recipients appearing in
\f(CRTo:\fP and \f(CRCc:\fP fields that use the same encryption
method will be in the same group. A single message, encrypted to
multiple recipients, will be sent, which is considerably more
efficient than encrypting separately for each recipient. 
.Pp
One subtle point is the handling of \f(CRBcc:\fP recipients. The
semantics of \f(CRBcc:\fP specify that the mail be sent to each of
the \f(CRBcc:\fP recipients, but that none of the other recipients be
able to find out their identity. However, encrypting to multiple
recipients would defeat this, because it is possible to indentify all
of the recipients of the encrypted message. Thus, each encrypted
\f(CRBcc:\fP recipient gets its own group. 
.Pp
Each recipient of an anonymous message also gets its own group,
for similar reasons. 
.Pp
An attempt is made to make the headers in the message
received by the recipient be the same as if no encryption were used.
Specifically, the complete \f(CRTo:\fP and \f(CRCc:\fP header fields
will be present, but the \f(CRBcc:\fP field will be missing. One
exception to this rule is anonymous messages, in which case the
recipient can't see any information about the other recipients. 
.SH Error handling

.Pp
The goal is to handle errors in the same way as sendmail. Thus,
the exact handling depends on the setting of the \f(CR-oe\fP command
line option. The default (as in sendmail) is \f(CR-oep\fP, meaning
that the error message is printed to standard out, and the mail message is
appended to the dead letter file (the location of which is a
configuration option). 
.Pp
Another choice is \f(CR-oem\fP, in which case the error message
and the mail message are packaged together and mailed back to the
user. This is appropriate when the mailer has no way to deal with
error messages returned from premail. 
.Pp
One additional choice, not provided by sendmail, is \f(CR-oed\fP,
which prints the error message on standard out, but drops the mail
message. This is a good choice if the mailer can interpret a non-zero
return status code as indication of an error. This is the mode used by
Netscape (and is automatically selected when premail is invoked as
prezilla). 
.SH Security issues

.Pp
In designing premail, usefulness and convenience were considered
more important than top security. Nonetheless, it can provide good
security, especially if you are aware of the security issues. 
.Pp
One overriding assumption was that your machine is secure, and
that the serious threats were those of eavesdroppers on the network
and e-mail forgers. In general, premail handles passive attacks quite
well, while containing a number of vulnerabilities to active attacks.
.Pp
Here are some potential security pitfalls with premail: 
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
Stores secrets information on disk file.
.nr bi 1
.Pp
Stores (potentially sensitive) temporary files on disk.
.nr bi 1
.Pp
Does not check authenticity of remailer list, remailer public key
ring, or Mixmaster information gotten from the Web.
.nr bi 1
.Pp
Accessing the Web signals when anonymous mail is about to be sent,
perhaps aiding traffic analysis.
.nr bi 1
.Pp
Does not evaluate the trustworthiness of public keys used for
encryption and signature checking.
.if \n(ll>1 .RE
.nr ll -1
.Pp
.SH Useless features

.Pp
Over the years, premail has accumulated a number of features of
dubious value. One of them is support for MOSS, a nice encryption
protocol that nevertheless failed to catch on. If you feel the urge to
use it, documentation is available in the . 
.Pp
One potentially cool feature is a server for decoding e-mail. This
\fIwould\fP be a useful feature if there were any mailers which used
it. The protcol for the server was designed to be fast (much, much
faster than invoking \f(CRpremail -decode\fP separately for each
message), as well as ``crypto-neutral,'' meaning that it doesn't contain
any features designed just for crypto, and that it could be used for
other tasks, for example converting image formats or character sets.
Thus, a client designed to use this protocol would like be fully
exportable from the US. If you're interested in integrating support
for this protocol into a popular e-mail client, please get in touch
with me. Related documents

.Pp

.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
The  file for premail
version 0.33a.
.nr bi 1
.Pp
for version 0.43 of premail.
.if \n(ll>1 .RE
.nr ll -1
.Pp
