; -------------------------------------------------------------------
; - MD5.EXE - CALCULATES AND EMBEDS A 16 BYTE MD5 CHECK VALUE IN EXE
; - FILES.
; -
; - COPYRIGHT 1999 BY:	     TAN$TAAFL SOFTWARE COMPANY
; - ALL RIGHTS RESERVED      PSC 517, BOX RS
; -			     FPO AP 96517-1000
; -------------------------------------------------------------------
		TITLE	    MD5.ASM
		SUBTITLE    MAIN PROGRAM MODULE

		.386
		INCLUDE     STANDARD.INC

; --------------------------------------------------------
; - STRUCTURE FOR CALCULATING THE 16 BYTE MD5 CHECK VALUE.
; --------------------------------------------------------
MD5_CTX 	STRUCT
		STATE	DWORD	4 DUP (0)
		BITS	DWORD	2 DUP (0)
		BUFFER	BYTE	64 DUP (0)
MD5_CTX		ENDS

SIZE_MD5_CTX	EQU	SIZEOF MD5_CTX

F1		MACRO	X_OP:REQ, Y_OP:REQ, Z_OP:REQ
		MOV	ESI,Z_OP
		XOR	ESI,Y_OP
		AND	ESI,X_OP
		XOR	ESI,Z_OP
		ENDM

F2		MACRO	X_OP:REQ, Y_OP:REQ, Z_OP:REQ
		F1	Z_OP,X_OP,Y_OP
		ENDM

F3		MACRO	X_OP:REQ, Y_OP:REQ, Z_OP:REQ
		MOV	ESI,Z_OP
		XOR	ESI,Y_OP
		XOR	ESI,X_OP
		ENDM

F4		MACRO	X_OP:REQ, Y_OP:REQ, Z_OP:REQ
		MOV	ESI,Z_OP
		NOT	ESI
		OR	ESI,X_OP
		XOR	ESI,Y_OP
		ENDM

MD5_STEP	MACRO	F_OP:REQ, W_OP:REQ, X_OP:REQ, Y_OP:REQ, Z_OP:REQ,
			DATA_OP:REQ, CONST_OP:REQ, S_OP:REQ
		F_OP	X_OP,Y_OP,Z_OP
		ADD	ESI,IN_OP&DATA_OP&
		ADD	ESI,CONST_OP
		ADD	W_OP,ESI
		ROL	W_OP,S_OP
		ADD	W_OP,X_OP
		ENDM

MD5_TRANSFORM	MACRO	MD5_CONTXT:REQ, MD5_BUFF:REQ
		PUSH_DATA_OP	MD5_CONTXT
		PUSH_DATA_OP	MD5_BUFF
		CALL	@MD5_TRANSFORM
		ENDM

A_OP		TEXTEQU     <EAX>
B_OP		TEXTEQU     <EBX>
C_OP		TEXTEQU     <ECX>
D_OP		TEXTEQU     <EDX>

IN_OP		TEXTEQU     <DWORD PTR ES:[DI]>

; ------------------
; - BYTE SWAP MACRO.
; ------------------
BYTE_SWAP	MACRO	REG:REQ
TEMP		TEXTEQU <>
L_REG		TEXTEQU <>
H_REG		TEXTEQU <>
		IF	(OPATTR (REG)) AND REGISTER
		    IF	TYPE (REG) NE 4
			.ERR	<REG - Must use a 32 Bit Register>
			EXITM
		    ENDIF
		    IFIDNI  <REG>, <ESP>
			.ERR	<REG - Cannot be Swapped>
			EXITM
		    ENDIF
		    TEMP    SUBSTR  <REG>,3,1
		    IFDIF   TEMP, <X>
			PUSH	EAX
			MOV	EAX,REG
			XCHG	AH,AL
			ROL	EAX,16
			XCHG	AH,AL
			MOV	REG,EAX
			POP	EAX
		    ELSE
			TEMP	SUBSTR	<REG>,2,1
			L_REG	CATSTR	TEMP,<L>
			H_REG	CATSTR	TEMP,<H>
			XCHG	H_REG,L_REG
			ROL	REG,16
			XCHG	H_REG,L_REG
		    ENDIF
		ELSE
		    .ERR    <REG - is not a Register>
		    EXITM
		ENDIF
		ENDM

; ---------------------------------------------
; - MACROS FOR CALCULATING THE MD5 CHECK VALUE.
; ---------------------------------------------
MD5_INIT	MACRO	MD5_CONTXT:REQ
		PUSH_DATA_OP	MD5_CONTXT
		CALL	@MD5_INIT
		ENDM

MD5_UPDATE	MACRO	MD5_CONTXT:REQ, IN_BUFFER:REQ, BUFF_LENGTH:REQ
		PUSH_DATA_OP	MD5_CONTXT
		PUSH_DATA_OP	IN_BUFFER
		PUSH_DWORD  BUFF_LENGTH
		CALL	@MD5_UPDATE
		ENDM

MD5_FINAL	MACRO	DIGEST_OP:REQ, MD5_CONTXT:REQ
		PUSH_DATA_OP	DIGEST_OP
		PUSH_DATA_OP	MD5_CONTXT
		CALL	@MD5_FINAL
		ENDM

; --------------------------------------------------------------
; - SEARCH_FOR SETS UP THE PARAMETERS FOR A SEARCH FOR A STRING.
; --------------------------------------------------------------
SEARCH_FOR	MACRO	STRING:REQ, LEGTH:REQ, WHERE:REQ, MAX:REQ
		PUSH_DATA_OP	STRING
		PUSH	LEGTH
		PUSH_DATA_OP	WHERE
		PUSH	MAX
		CALL	@SEARCH_FOR
		ENDM

PUSH_DWORD	MACRO	OPERAND:REQ
; -------------------------------------------------------
; - IF THE OPERAND IS A DATA LABEL AND LESS THAN 4 BYTES
; - ZERO EXTEND IT TO 32 BITS IN EAX AND THEN PUSH IT ON
; - THE STACK.
; -------------------------------------------------------
		IF	(OPATTR (OPERAND)) AND DATA_LABEL
		    IF	    TYPE (OPERAND) LT 4
			MOVZX	EAX,OPERAND
			PUSH	EAX
; -----------------------------------------------------------
; - IF THE DATA OPERAND IS 4 BYTES LONG PUSH IT ON THE STACK
; - OR ELSE GENERATE A FORCED ERROR FOR INVALID OPERAND SIZE.
; -----------------------------------------------------------
		    ELSEIF  TYPE (OPERAND) EQ 4
			PUSHD	OPERAND
		    ELSE
			.ERR	<OPERAND - invalid operand size>
			EXITM
		    ENDIF
		ELSEIF	(OPATTR (OPERAND)) AND REGISTER
; -----------------------------------------------------------
; - IF THE OPERAND IS AN 8 OR 16 BIT REGISTER ZERO EXTEND IT
; - TO 32 BITS IN ITS PARENT 32 BIT REGISTER AND PUSH IT ON
; - THE STACK.
; -----------------------------------------------------------
		    IF	TYPE (OPERAND) EQ 1
			TEMP	TEXTEQU <>
			TEMP	SUBSTR	<OPERAND>,1,1
			EREG	CATSTR	<E>,TEMP,<X>
			MOVZX	EREG,OPERAND
			PUSH	EREG
		    ELSEIF  TYPE (OPERAND) EQ 2
			MOVZX	E&OPERAND,OPERAND
			PUSH	E&OPERAND
; ----------------------------------------
; - PUSH THE 32 BIT REGISTER ON THE STACK.
; ----------------------------------------
		    ELSEIF  TYPE (OPERAND) EQ 4
			PUSH	OPERAND
		    ELSE
			.ERR	<OPERAND - Invalid Register>
			EXITM
		    ENDIF
; -------------------------------------------------------------
; - IF THE OPERAND IS IMMEDIATE DATA PUSH IT AS A 32 BIT VALUE.
; -------------------------------------------------------------
		ELSEIF	(OPATTR (OPERAND)) AND IMMEDIATE
			PUSHD	OPERAND
		ELSE
		    .ERR    <OPERAND - invalid operand>
		ENDIF
		ENDM

; -----------------------------------------------------------------
; - PUSH_SEG_OFF CHECKS FOR A VALID SEGMENT OFFSET PAIR AND PUSHES
; - THEM ON THE STACK IN THE PROPER ORDER. FORMAT IS DS_DX.
; -----------------------------------------------------------------
PUSH_SEG_OFF	MACRO	    REG_PAIR:REQ, SIZE_OFFS:=<16>
		LOCAL	    OFFSET_REG_SIZE
SEG_LIST	TEXTEQU     <CS DS ES FS GS SS>
OFFSET_LIST	TEXTEQU     <EAX EBX ECX EDX EBP ESI EDI ESP>
;; ---------------------------------------------------------------
;; - GET THE SIZE OF THE REG_PAIR. VALID VALUES ARE 5 AND 6 BYTES.
;; - FOR EXAMPLE: DS_SI = 5 BYTES AND DS_ESI = 6 BYTES.
;; ---------------------------------------------------------------
REG_PAIR_SIZE	SIZESTR     <REG_PAIR>
;; -------------------------------------------
;; - ISOLATE THE SEGMENT AND OFFSET REGISTERS.
;; -------------------------------------------
SEG_REG 	SUBSTR	    <REG_PAIR>,1,2
;; -----------------------------------------------------------
;; - GET THE 16 OR 32 BIT OFFSET REGISTER. IF IT IS A 16 BIT
;; - REGISTER CREATE ITS EXTENDED REGISTER NAME IN E_OFFS_REG.
;; -----------------------------------------------------------
E_OFFS_REG	TEXTEQU     <>
		IF	REG_PAIR_SIZE EQ 5
OFFSET_REG	SUBSTR	    <REG_PAIR>,4,2
OFFS_REG_SIZE	=	2
E_OFFS_REG	CATSTR	<E>,OFFSET_REG
		ELSEIF	REG_PAIR_SIZE EQ 6
OFFSET_REG	SUBSTR	    <REG_PAIR>,4,3
OFFS_REG_SIZE	=	4
		ELSE
		    .ERR    <REG_PAIR - Invalid Operand Size>
		    EXITM
		ENDIF
;; ----------------------------------
;; - CHECK LISTS FOR VALID REGISTERS.
;; ----------------------------------
SEG_POS 	INSTR	    1,SEG_LIST,SEG_REG
OFFSET_POS	INSTR	    1,OFFSET_LIST,OFFSET_REG
;; -------------------------------------------------------------
;; - PUSH THE SEGMENT AND OFFSET REGISTERS OR GENERATE AN ERROR
;; - IF THE REGISTERS ARE INVALID.
;; -------------------------------------------------------------
		IF  SEG_POS NE 0
		    PUSH    SEG_REG
		ELSE
		    .ERR    <REG_PAIR - Invalid Segment Register>
		    EXITM
		ENDIF
;; ----------------------------------------------------------
;; - IF THE REGISTER IS 16 BITS BUT WE NEED TO PUSH A 32 BIT
;; - OFFSET ZERO EXTEND THE 16 BIT REGISTER TO ITS 32 BIT
;; - PARENT REGISTER. FOR EXAMPLE: MOVZX    ECX,CX.
;; ----------------------------------------------------------
		IF  OFFSET_POS NE 0
		    IF	SIZE_OFFS EQ 32 AND OFFS_REG_SIZE EQ 2
			MOVZX	E_OFFS_REG,OFFSET_REG
			PUSH	E_OFFS_REG
;; ------------------------------------------------------------
;; - IF THE REGISTER IS A 32 BIT REGISTER AND WE NEED A 32 BIT
;; - OFFSET PUSH THE 32 BIT REGISTER IN OFFSET_REG. IF THE
;; - REGISTER IS A 16 BIT REGISTER AND WE ONLY NEED A 16 BIT
;; - OFFSET PUSH THE 16 BIT REGISTER IN OFFSET_REG.
;; ------------------------------------------------------------
		    ELSEIF  (SIZE_OFFS EQ 32 AND \
			    OFFS_REG_SIZE EQ 4) OR \
			    (SIZE_OFFS EQ 16 AND \
			    OFFS_REG_SIZE EQ 2)
			PUSH	OFFSET_REG
;; ---------------------------------------------------------
;; - WE HAVE A 32 BIT REGISTER AND WE ONLY REQUIRE A 16 BIT
;; - OFFSET, OR THE SIZE_OFFS IS NOT EQUAL TO 16 OR 32, SO
;; - GENERATE A FORCED ERROR.
;; ---------------------------------------------------------
		    ELSE
			.ERR	<REG_PAIR, SIZE_OFFS - Mismatched>
			EXITM
		    ENDIF
		ELSE
		    .ERR    <REG_PAIR - Invalid Offset Register>
		ENDIF
		ENDM

; -------------------------------------------------------------
; - PUSH_DATA_OP PUSHES THE SEGMENT AND OFFSET OF A DATA LABEL,
; - A SEGMENT:OFFSET REGISTER PAIR, AN ADDRESS VECTOR, OR A
; - FAR POINTER TO VARIOUS DATA TYPES.
; -------------------------------------------------------------
PUSH_DATA_OP	MACRO	OP:REQ, SIZE_OFFS:=<16>
		IFDEF	OP
		    IF	SIZE_OFFS EQ 16
			IF  (OPATTR (OP)) AND DATA_LABEL
			    IF	TYPE (OP) EQ FADDR16
				PUSHD	OP&.VECTOR
			    ELSEIF  TYPE (OP) EQ FADDR32
				PUSH	OP&.SEGM
				PUSH	OP&.LOW_OFFS
			    ELSEIF  (TYPE (OP) EQ FPWINDOW) OR \
				    (TYPE (OP) EQ FPLINE) OR \
				    (TYPE (OP) EQ FPLABEL) OR \
				    (TYPE (OP) EQ FPBYTE) OR \
				    (TYPE (OP) EQ FPDATE)
				PUSHD	OP
			    ELSE
				PUSH	SEG OP
				IF  (OPATTR (OP)) AND DIRECT_ADDR
				    PUSH    OFFSET OP
				ELSE
				    LEA     AX,OP
				    PUSH    AX
				ENDIF
			    ENDIF
			ELSE
			    .ERR    <OP Not a Data Label>
			    EXITM
			ENDIF
		    ELSEIF  SIZE_OFFS EQ 32
			IF  (OPATTR (OP)) AND DATA_LABEL
			    IF	TYPE (OP) EQ FADDR16
				PUSH	OP&.SEGM
				PUSH	0
				PUSH	OP&.OFFS
			    ELSEIF  TYPE (OP) EQ FADDR32
				PUSH	OP&.SEGM
				PUSHD	OP&.OFFS
			    ELSEIF  (TYPE (OP) EQ FPWINDOW) OR \
				    (TYPE (OP) EQ FPLINE) OR \
				    (TYPE (OP) EQ FPLABEL) OR \
				    (TYPE (OP) EQ FPBYTE) OR \
				    (TYPE (OP) EQ FPDATE)
				PUSH	WORD PTR OP[2]
				PUSH	0
				PUSH	WORD PTR OP
			    ELSE
				PUSH	SEG OP
				IF  (OPATTR (OP)) AND DIRECT_ADDR
				    PUSH    0
				    PUSH    OFFSET OP
				ELSE
				    LEA     EAX,OP
				    PUSH    EAX
				ENDIF
			    ENDIF
			ELSE
			    .ERR    <OP Not a Data Label>
			    EXITM
			ENDIF
		    ELSE
			.ERR	<SIZE_PUSH - Must be 16 or 32>
			EXITM
		    ENDIF
		ELSE
		    PUSH_SEG_OFF    OP,SIZE_OFFS
		ENDIF
		ENDM

; -------------------------------------------------------------------
; - GENERATE_TABLE GENERATES A TABLE OF POINTERS. IF YOU HAVE
; - 20 LINES OF TEXT AND YOU WANT A TABLE OF POINTERS TO THIS
; - TABLE USE THIS MACRO. IF THE LINES OF TEXT ARE CALLED
; - ERR_MSG_1, ERR_MSG_2, ERR_MSG_3, ETC YOU CAN USE THIS MACRO.
; - THE LABELS FOR THE LINES OF TEXT MUST DIFFER BY ONLY THE NUMBER
; - AT THE END. THEY MUST HAVE AN UNDERLINE BEFORE THE NUMBER ALSO.
; - THE TABLE OF POINTERS WILL BE CALLED (IN THE ABOVE EXAMPLE)
; - ERR_MSGS. YOU CAN SPECIFY THE TYPE POINTER, THE NAME TO USE,
; - STARTING NUMBER, AND NUMBER OF POINTERS TO PUT INTO THE TABLE.
; -------------------------------------------------------------------
GENERATE_TABLE	MACRO	TYPE_PTR:REQ, TABLE:REQ, START_NUM:REQ,
			NUMBER:REQ
		LOCAL	COUNT,ITR
		TABLE1	EQU <&TABLE&>
		ITR	= NUMBER
		COUNT	= START_NUM
TABLE&S 	LABEL	TYPE_PTR
		WHILE	ITR GT 0
		TEXT	TEXTEQU <>
		TEXT	CATSTR	TABLE1, <_>, %COUNT
		TYPE_PTR    TEXT
		ITR	= ITR - 1
		COUNT	= COUNT + 1
		ENDM
		ENDM

FAST_MOVE	MACRO	FROM:REQ, TO:REQ, BYTES:REQ
		PUSH_DATA_OP	FROM,32
		PUSH_DATA_OP	TO,32
		PUSH_DWORD  BYTES
		CALL	@FAST_MOVE
		ENDM

FAST_FILL	MACRO	CHAR:REQ, STRING:REQ, COUNT:REQ
		PUSH	CHAR
		PUSH_DATA_OP	STRING,32
		PUSH_DWORD  COUNT
		CALL	@FAST_FILL
		ENDM

DATA		SEGMENT PARA PUBLIC USE16 'DATA'
PROG_HANDLE	WORD	00H
FOUND_ID	WORD	FALSE
COMMAND_LINE	WORD	FALSE

; -------------------------
; - PROGRAM ERROR MESSAGES.
; -------------------------
ERROR_MSG1	BYTE	CR,LF,'No MD5 ID Found - Program ',
			'Terminated!',CR,LF,'$'
ERROR_MSG2	BYTE	CR,LF,'MD5.EXE Requires an 80386 or ',
			'Above.',CR,LF,'$'
ERROR_MSG3	BYTE	CR,LF,'MD5.EXE requires a Command Line ',
			'File Specification.',CR,LF,'$'
ERROR_MSG4	BYTE	CR,LF,'MD5.EXE requires DOS 3.0 or Above.',
			CR,LF,'$'

; ---------------------
; - DOS ERROR MESSAGES.
; ---------------------
DOS_ERROR_1	BYTE	CR,LF,'Invalid Function.',CR,LF,'$'
DOS_ERROR_2	BYTE	CR,LF,'File Not Found.',CR,LF,'$'
DOS_ERROR_3	BYTE	CR,LF,'Path Not Found.',CR,LF,'$'
DOS_ERROR_4	BYTE	CR,LF,'No Handles Available.',CR,LF,'$'
DOS_ERROR_5	BYTE	CR,LF,'Access Denied.',CR,LF,'$'
DOS_ERROR_6	BYTE	CR,LF,'Invalid Handle.',CR,LF,'$'
DOS_ERROR_7	BYTE	CR,LF,'Memory Control Block Destroyed.',CR,LF,'$'
DOS_ERROR_8	BYTE	CR,LF,'Insufficient Memory.',CR,LF,'$'
DOS_ERROR_9	BYTE	CR,LF,'Invalid Memory Block Address.',CR,LF,'$'
DOS_ERROR_10	LABEL	BYTE
DOS_ERROR_11	BYTE	CR,LF,'Invalid Error Message.',CR,LF,'$'
DOS_ERROR_12	BYTE	CR,LF,'Invalid Access Code.',CR,LF,'$'

		GENERATE_TABLE	NPBYTE,DOS_ERROR,1,12

; ------------------
; - SUCCESS MESSAGE.
; ------------------
NO_ERROR	BYTE	CR,LF,'MD5 Check Value: '
NO_ERR1 	BYTE	'xx xx xx xx xx xx xx xx  xx xx xx xx xx xx xx xx',
			CR,LF,'$'

IN_PROG_MSG	BYTE	CR,LF,'Calculating EXE File MD5 Check ',
			'Value.....',CR,LF,'$'

MSG_START	EQU	$
STARTUP_MSG	BYTE	CR,LF,'MD5.EXE',CR,LF,
			'Copyright (c) 1999 by TAN$TAAFL Software Company',
			CR,LF,'All Rights Reserved',CR,LF
MSG_END 	EQU	$

; -----------------------------------------------------------
; - STRING TO LOOK FOR IN THE EXE FILE WHICH SHOWS YOU WHERE
; - TO PUT THE CRC32 INFORMATION.
; -----------------------------------------------------------
MD5_ID		DWORD	6 DUP (05060708H)
SIZE_MD5_ID	EQU	SIZEOF MD5_ID

; -----------------------------------------------------------
; - PLACE TO PUT THE COMMAND LINE PROGRAM FILE SPECIFICATION.
; -----------------------------------------------------------
PROGRAM_PATH	BYTE	81 DUP (0)
PROG_PATH_PTR	FADDR16	    <PROGRAM_PATH>

; -------------------------------------------------------
; - POSITION IN THE FILE, FILE SIZE, AND MD5 CHECK VALUE
; - TO BE EMBEDDED IN THE FILE IN THE PROPER PLACE.
; -------------------------------------------------------
FRONT_END	DWORD	0
FILE_SIZE	FILE_POINTER	<0>
MD5_DIGEST	BYTE	16 DUP (0)

FRONT_END_PTR	FADDR16     <FRONT_END>

MD5_CONTEXT	MD5_CTX <>

FILE_ID_PTR	FILE_POINTER	<0>

; ----------------------------------
; - BUFFER FOR DOS READS AND WRITES.
; ----------------------------------
BUFFER_PTR	FADDR16	    <0>

; ------------------------------------------------------------
; - LOOK FOR *.EXE IN COMMAND LINE. IF FOUND GET THE EXE FILE
; - FROM THE CURRENT DIRECTORY.
; ------------------------------------------------------------
WILD_EXE	BYTE	'*.EXE',0
WILD_EXE_PTR	FADDR16     <WILD_EXE>

; -----------------------------------------
; - DTA ADDRESS FOR USE BY FIND FIRST FILE.
; -----------------------------------------
DTA_PTR 	FADDR16     <0>
DATA		ENDS

STACK		SEGMENT PARA STACK USE16 'STACK'
		WORD	256 DUP (00H)
STACK		ENDS

CODE		SEGMENT PARA PUBLIC USE16 'CODE'
		ASSUME	DS:DATA, SS:STACK, ES:NOTHING
SETUP:		MOV	AX,DATA
		MOV	DS,AX
		CLD
		PUSH	ES			;SAVE PSP ADDRESS
; --------------------------------------------------------------
; - DISPLAY THE SIGN ON MESSAGE. USE FUNCTION 0EH OF VIDEO
; - INTERRUPT 10H BECAUSE WE HAVE TO DISPLAY A $ IN THE MESSAGE.
; --------------------------------------------------------------
		MOV	SI,OFFSET STARTUP_MSG
		MOV	CX,MSG_END - MSG_START
		MOV	AH,0EH
		MOV	BX,0
		.REPEAT
		    LODSB
		    INT     VIDEO
		.UNTILCXZ
		POP	ES			;GET PSP BACK
; --------------------------------------------------------
; - SEARCH FOR THE FILE SPECIFICATION ON THE COMMAND LINE
; - TO CALCULATE MD5 CHECK VALUE FOR.
; --------------------------------------------------------
		MOV	DI,81H
		MOV	CX,10
		.REPEAT
		    .BREAK  .IF BYTE PTR ES:[DI] == CR
		    .IF	    BYTE PTR ES:[DI] != SPACE
			MOV	COMMAND_LINE,TRUE
			LDS	SI,PROG_PATH_PTR.VECTOR
			MOV	CX,80
			.REPEAT
			    MOV     AL,BYTE PTR ES:[DI]
			    .BREAK  .IF AL == CR
			    MOV     BYTE PTR DS:[SI],AL
			    INC     SI
			    INC     DI
			.UNTILCXZ
; -------------------------------------------------------------
; - THE FILE SPECIFICATION MUST BE AN ASCIIZ TERMINATED STRING.
; -------------------------------------------------------------
			MOV	AL,0
			MOV	BYTE PTR DS:[SI],AL
			.BREAK
		    .ENDIF
		    INC	    DI
		.UNTILCXZ
		.IF	!COMMAND_LINE
		    MOV     DX,OFFSET ERROR_MSG3
@@:		    MOV     AH,09H
		    INT     DOS
		    MOV     AX,4C00H
		    INT     DOS
		.ENDIF
; ------------------------------------------------
; - SEE IF WE HAVE A 386+ CPU_TYPE RETURNED IN AL.
; ------------------------------------------------
		PUSHF
		CALL	WHICH_CPU
		POPF
		.IF	AL < CPU_386
		    MOV     DX,OFFSET ERROR_MSG2
		    JMP     @B
		.ENDIF
; --------------------------------------------------
; - GET THE DOS VERSION NUMBER. WE REQUIRE DOS 3.0+.
; --------------------------------------------------
		MOV	AH,30H
		INT	DOS
		XCHG	AH,AL
		.IF	AX < 300H
		    MOV     DX,OFFSET ERROR_MSG4
		    JMP     @B
		.ENDIF
; ----------------------
; - GET THE DTA ADDRESS.
; ----------------------
		MOV	AX,2F00H
		INT	DOS
		MOV	DTA_PTR.SEGM,ES
		MOV	DTA_PTR.OFFS,BX
; -------------------------------------------------------
; - IF THE FILE NAME IS EQUAL TO *.EXE USE FIND FIRST TO
; - GET THE EXE FILE NAME TO OPERATE ON.
; -------------------------------------------------------
		LDS	SI,PROG_PATH_PTR.VECTOR
		LES	DI,WILD_EXE_PTR.VECTOR
		MOV	CX,5
		REPE	CMPSB
		.IF	ZERO?
		    MOV     AX,4E00H
		    MOV     CX,0
		    LDS     DX,WILD_EXE_PTR.VECTOR
		    INT     DOS
		    .IF     CARRY?
			.IF	AX == 12H
			    MOV     AX,02H
			.ENDIF
			CALL	GET_ERROR
			JMP	@B
		    .ENDIF
; -------------------------------------
; - MOVE THE FILE NAME TO PROGRAM_PATH.
; -------------------------------------
		    PUSH    DS
		    LES     DI,PROG_PATH_PTR
		    LDS     SI,DTA_PTR
		    ADD     SI,1EH
		    MOV     CX,13
		    REP     MOVSB
		    POP     DS
		.ENDIF
; -------------------------------------
; - ALLOCATE THE MD5 READ/WRITE BUFFER.
; -------------------------------------
		MOV	AX,4800H
		MOV	BX,64000
		SHR	BX,4
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @B
		.ENDIF
		MOV	BUFFER_PTR.SEGM,AX
; ----------------
; - OPEN THE FILE.
; ----------------
		MOV	AX,3D00H + READ_WRITE
		LDS	DX,PROG_PATH_PTR.VECTOR
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
		MOV	PROG_HANDLE,AX
; ----------------------------------
; - DISPLAY THE IN PROGRESS MESSAGE.
; ----------------------------------
		MOV	AH,09H
		MOV	DX,OFFSET IN_PROG_MSG
		INT	DOS
; -------------------------------------------------------------
; - GET THE SIZE OF THE FILE BY MOVING THE FILE POINTER TO THE
; - END OF THE FILE.
; -------------------------------------------------------------
		MOV	AX,4202H
		MOV	BX,PROG_HANDLE
		MOV	CX,0
		MOV	DX,0
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
		MOV	FILE_SIZE.LOW_WORD,AX
		MOV	FILE_SIZE.HIGH_WORD,DX
; ----------------------------------------------------------
; - MOVE THE FILE POINTER BACK TO THE BEGINNING OF THE FILE
; - TO LOOK FOR THE MD5 ID.
; ----------------------------------------------------------
		MOV	AX,4200H
		MOV	BX,PROG_HANDLE
		MOV	CX,0
		MOV	DX,0
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
		MOV	EAX,FILE_SIZE.FILE_PTR
		.WHILE	EAX > 0
		    .IF     EAX > 64000
			MOV	CX,64000
			SUB	EAX,64000
		    .ELSE
			MOV	CX,AX
			MOV	EAX,0
		    .ENDIF
		    PUSH    EAX
		    PUSH    CX
; -----------------------------------------
; - READ IN UP TO 64,000 BYTES OF THE FILE.
; -----------------------------------------
		    MOV     AX,3F00H
		    MOV     BX,PROG_HANDLE
		    PUSH    DS
		    LDS     DX,BUFFER_PTR.VECTOR
		    INT     DOS
		    POP     DS
		    .IF     CARRY?
			CALL	GET_ERROR
			JMP	@F
		    .ENDIF
; -----------------------------------------
; - IS THE MD5 ID IN THIS PART OF THE FILE?
; -----------------------------------------
		    SEARCH_FOR	MD5_ID,SIZE_MD5_ID,BUFFER_PTR,CX
		    .IF     !CARRY?
			MOVZX	EDI,DI
			SUB	EDI,16
			ADD	FRONT_END,EDI
			SUB	EDI,8
			ADD	FILE_ID_PTR.FILE_PTR,EDI
			MOV	FOUND_ID,TRUE
			POP	CX
			POP	EAX
			.BREAK
		    .ENDIF
		    POP     CX
		    MOVZX   ECX,CX
		    ADD     FRONT_END,ECX
		    ADD     FILE_ID_PTR.FILE_PTR,ECX
		    POP     EAX
		.ENDW
		.IF	!FOUND_ID
		    MOV     DX,OFFSET ERROR_MSG1
		    JMP     @F
		.ENDIF
; -----------------------------------------------------------
; - MOVE THE FILE POINTER TO WHERE THE MD5 ID IS IN THE FILE.
; -----------------------------------------------------------
		MOV	AX,4200H
		MOV	BX,PROG_HANDLE
		MOV	CX,FILE_ID_PTR.HIGH_WORD
		MOV	DX,FILE_ID_PTR.LOW_WORD
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -------------------------------------------------------
; - WRITE THE FRONT_END INFORMATION BACK TO THE FILE SO
; - THE FRONT END POSITION AND FILE SIZE CAN BE INCLUDED
; - IN THE MD5 CHECK VALUE CALCULATIONS.
; -------------------------------------------------------
		MOV	AX,4000H
		MOV	BX,PROG_HANDLE
		MOV	CX,8
		PUSH	DS
		LDS	DX,FRONT_END_PTR.VECTOR
		INT	DOS
		POP	DS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -----------------
; - CLOSE THE FILE.
; -----------------
		MOV	AX,3E00H
		MOV	BX,PROG_HANDLE
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -----------------------------
; - INITIALIZE THE MD5 CONTEXT.
; -----------------------------
		MD5_INIT    MD5_CONTEXT
; ----------------------
; - OPEN THE FILE AGAIN.
; ----------------------
		MOV	AX,3D00H + READ_WRITE
		LDS	DX,PROG_PATH_PTR
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
		MOV	PROG_HANDLE,AX
; -------------------------------------------------------
; - READ IN UP TO THE END OF THE FRONT END AND CALCULATE
; - THE MD5 CHECK VALUE ON THIS PART OF THE FILE.
; -------------------------------------------------------
		MOV	EAX,FRONT_END
		.WHILE	EAX > 0
		    .IF     EAX > 64000
			MOV	CX,64000
			SUB	EAX,64000
		    .ELSE
			MOV	CX,AX
			MOV	EAX,0
		    .ENDIF
		    PUSH    EAX
		    PUSH    CX
		    MOV     AX,3F00H
		    MOV     BX,PROG_HANDLE
		    PUSH    DS
		    LDS     DX,BUFFER_PTR.VECTOR
		    INT     DOS
		    POP     DS
		    .IF     CARRY?
			CALL	GET_ERROR
			JMP	@F
		    .ENDIF
		    POP     CX
		    MD5_UPDATE	MD5_CONTEXT,BUFFER_PTR,CX
		    POP     EAX
		.ENDW
; ------------------------------------------------------------
; - SKIP OVER THE 16 BYTES THAT WILL HOLD THE MD5 CHECK VALUE.
; ------------------------------------------------------------
		MOV	AX,4201H
		MOV	BX,PROG_HANDLE
		MOV	CX,0
		MOV	DX,16
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -------------------------------
; - PROCESS THE REST OF THE FILE.
; -------------------------------
		.WHILE	1
		    MOV     AX,3F00H
		    MOV     BX,PROG_HANDLE
		    MOV     CX,64000
		    PUSH    DS
		    LDS     DX,BUFFER_PTR.VECTOR
		    INT     DOS
		    POP     DS
		    .IF     CARRY?
			CALL	GET_ERROR
			JMP	@F
		    .ENDIF
		    .BREAK  .IF AX == 0
		    MOV     CX,AX
		    MD5_UPDATE	    MD5_CONTEXT,BUFFER_PTR,CX
		.ENDW
; -------------------------------
; - FINALIZE THE MD5 CHECK VALUE.
; -------------------------------
		MD5_FINAL   MD5_DIGEST,MD5_CONTEXT
; -----------------------------------------------------
; - MOVE FILE POINTER TO POINT TO THE PLACE TO PUT THE
; - FRONT END AND MD5 CHECK VALUE.
; -----------------------------------------------------
		MOV	AX,4200H
		MOV	BX,PROG_HANDLE
		MOV	CX,FILE_ID_PTR.HIGH_WORD
		MOV	DX,FILE_ID_PTR.LOW_WORD
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; ---------------------------------------------------
; - WRITE THE FINALIZED INFORMATION BACK TO THE FILE.
; ---------------------------------------------------
		MOV	AX,4000H
		MOV	BX,PROG_HANDLE
		MOV	CX,24
		PUSH	DS
		LDS	DX,FRONT_END_PTR.VECTOR
		INT	DOS
		POP	DS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -----------------
; - CLOSE THE FILE.
; -----------------
		MOV	AX,3E00H
		MOV	BX,PROG_HANDLE
		INT	DOS
		.IF	CARRY?
		    CALL    GET_ERROR
		    JMP     @F
		.ENDIF
; -----------------------------------------
; - CONVERT MD5 CHECK VALUE TO HEXIDECIMAL.
; -----------------------------------------
		MOV	SI,OFFSET MD5_DIGEST
		MOV	EAX,DWORD PTR DS:[SI]
		MOV	EBX,DWORD PTR DS:[SI+4]
		MOV	ECX,DWORD PTR DS:[SI+8]
		MOV	EDX,DWORD PTR DS:[SI+12]
; -----------------------------------------------------
; - SINCE WE ARE RETURNING THE MD5 DIGEST IN REGISTERS
; - WE HAVE TO DO A BYTE_SWAP ON EACH ONE SO THE HEX
; - DIGITS WILL BE DISPLAYED IN THE CORRECT ORDER.
; -----------------------------------------------------
		BYTE_SWAP   EAX
		BYTE_SWAP   EBX
		BYTE_SWAP   ECX
		BYTE_SWAP   EDX
		PUSH	EDX
		PUSH	ECX
		PUSH	EBX
		PUSH	DS
		POP	ES
		MOV	DI,OFFSET NO_ERR1
		MOV	CX,8
		CALL	@DISPLAY_HEX
		POP	EAX
		MOV	CX,8
		CALL	@DISPLAY_HEX
		INC	DI
		POP	EAX
		MOV	CX,8
		CALL	@DISPLAY_HEX
		POP	EAX
		MOV	CX,8
		CALL	@DISPLAY_HEX
		MOV	DX,OFFSET NO_ERROR
; ----------------------------------------------------------------
; - DISPLAY AN ERROR MESSAGE OR A SUCCESS MESSAGE, RELEASE MEMORY
; - AND TERMINATE THE PROGRAM.
; ----------------------------------------------------------------
@@:		MOV	AH,09H
		INT	DOS
; ------------------------
; - RELEASE BUFFER MEMORY.
; ------------------------
		MOV	AX,4900H
		MOV	BX,BUFFER_PTR.SEGM
		MOV	ES,BX
		INT	DOS
		MOV	AX,4C00H
		INT	DOS

; ---------------------------------
; - PROCEDURES USED BY THE PROGRAM.
; ---------------------------------
; -------------------------------------------------
; - WHICH_CPU DETERMINES THE CPU TYPE.
; - 0 = 8086/8088, 2 = 80286, 3 = 80386, 4 = 80486
; - RETURNS: CPU TYPE IN AL.
; -------------------------------------------------
WHICH_CPU	PROC	NEAR
		PUSH	SP	     ;REAL MODE CPU's DECREMENT SP BEFORE
		POP	AX	     ;A PUSH, PROTECTED MODE CPU's AFTER
		CMP	SP,AX	     ;THE PUSH, EVEN IN REAL MODE
		JNE	IS_8086
		PUSHF		     ;'NT' BIT IN FLAGS REGISTER CAN'T BE
		POP	AX	     ;SET IN REAL MODE ON A 80286, BUT IT
		OR	AX,4000H     ;CAN BE ON A 80386 OR 80486
		PUSH	AX
		POPF
		PUSHF
		POP	AX
		TEST	AX,4000H
		JZ	IS_286
		MOV	EBX,ESP 		;SAVE STACK POINTER IN EBX
		AND	ESP,0FFFFFFFCH		;ZERO LOWER TWO BITS OF ESP
						;TO AVOID AC FAULT ON 486
		PUSHFD				;PUSH EFLAGS
		POP	EAX			;EAX = EFLAGS
		MOV	ECX,EAX 		;ECX = EFLAGS
		MOV	EDX,EAX 		;EDX = ORIGINAL FLAGS
		XOR	EAX,40000H		;TOGGLE BIT 18 IN EFLAGS
		PUSH	EAX			;PUSH NEW VALUE
		POPFD				;PUT IT IN EFLAGS
		PUSHFD				;PUSH EFLAGS
		POP	EAX			;EAX = EFLAGS
		AND	EAX,40000H		;ISOLATE BIT 18 IN EAX
		AND	ECX,40000H		;ISOLATE BIT 18 IN ECX
		CMP	EAX,ECX 		;ARE EAX AND ECX EQUAL?
		JE	IS_386			;YES, THEN IT'S A 386
		MOV	AL,CPU_486
		JMP	W_C_1
IS_8086:	MOV	AL,CPU_86
		JMP	W_C_2
IS_286: 	MOV	AL,CPU_286
		JMP	W_C_2
IS_386: 	MOV	AL,CPU_386
W_C_1:		PUSH	EDX
		POPFD
		MOV	ESP,EBX 		;RESTORE ESP
W_C_2:		RET
WHICH_CPU	ENDP

; -----------------------------------------
; - ENTRY:   DOS ERROR CODE IN AX.
; - RETURNS: OFFSET OF ERROR MESSAGE IN DX.
; -----------------------------------------
GET_ERROR	PROC	NEAR
		.IF	(AX < 1) || (AX > 12)
		    MOV     AX,11
		.ENDIF
		DEC	AX
		MOVZX	ESI,AX
		MOV	DX,DOS_ERRORS[ESI*2]
		RET
GET_ERROR	ENDP

; ----------------------------------------------------------
; - @SEARCH_FOR SEARCHES AN AREA OF MEMORY FOR A DESIGNATED
; - STRING.
; - RETURNS: CARRY FLAG CLEAR AND ES:DI POINTS TO 1ST BYTE
; -	     AFTER MATCH.
; -	     CARRY FLAG SET IF NO MATCH.
; ----------------------------------------------------------
@SEARCH_FOR	PROC	NEAR USES DS, STRING:FPBYTE, LEGTH:WORD,
			WHERE:FPBYTE, MAX_LEGTH:WORD
		LDS	SI,STRING
		LES	DI,WHERE
		MOV	CX,MAX_LEGTH
; ----------------------------------------
; - DO NOT TEST PAST THE END OF THE INPUT.
; ----------------------------------------
		SUB	CX,LEGTH
		INC	CX
		.REPEAT
		    PUSH    CX
		    PUSH    SI
		    PUSH    DI
		    MOV     CX,LEGTH
		    REPE    CMPSB
		    JCXZ    @F
		    POP     DI
		    POP     SI
		    POP     CX
		    INC     DI		;NEXT PLACE TO START COMPARE
		.UNTILCXZ
		STC			;NO MATCH FOUND
		RET
@@:		POP	CX		;CLEAN UP STACK
		POP	CX
		POP	CX
		CLC
		RET
@SEARCH_FOR	ENDP

; ----------------------------------------
; - INITIAL THE MD5_CONTEXT AND BIT COUNT.
; ----------------------------------------
@MD5_INIT	PROC	FAR, MD5_CTX_PTR:FADDR16
		LES	DI,MD5_CTX_PTR.VECTOR
		MOV	(MD5_CTX PTR ES:[DI]).BITS,0
		MOV	(MD5_CTX PTR ES:[DI]).BITS[4],0
		MOV	(MD5_CTX PTR ES:[DI]).STATE,67452301H
		MOV	(MD5_CTX PTR ES:[DI]).STATE[4],0EFCDAB89H
		MOV	(MD5_CTX PTR ES:[DI]).STATE[8],98BADCFEH
		MOV	(MD5_CTX PTR ES:[DI]).STATE[12],10325476H
		RET
@MD5_INIT	ENDP

; ------------------------------------------------------------
; - @MD5_UPDATE UPDATES THE CTX STATE TO REFLECT THE ADDITION
; - OF ANOTHER BUFFER FULL OF DATA.
; ------------------------------------------------------------
@MD5_UPDATE	PROC	FAR USES DS, MD5_CTX_PTR:FADDR16, IN_BUFF:FADDR16,
			BUFF_LENGTH:DWORD
		LOCAL	T_OP:DWORD, MD5_BUFFER:FADDR16
		LES	DI,MD5_CTX_PTR.VECTOR
		MOV	MD5_BUFFER.SEGM,ES
		MOV	MD5_BUFFER.OFFS,DI
		ADD	MD5_BUFFER.OFFS,(6*4)
; --------------------------------------------------------------
; - UPDATE THE BIT COUNT IN THE MD5_CTX. BUFF_LENGTH WILL NEVER
; - BE LARGER THAN 60K BYTES.
; -------------------------------------------------------------
		MOV	EAX,(MD5_CTX PTR ES:[DI]).BITS
		MOV	T_OP,EAX
		MOV	EAX,BUFF_LENGTH
		SHL	EAX,3
		ADD	(MD5_CTX PTR ES:[DI]).BITS,EAX
		ADC	(MD5_CTX PTR ES:[DI]).BITS[4],0
; -------------------------------------------------------------------
; - SEE IF WE HAVE ANY ODD CHUNCKS OF DATA LEFT IN THE MD5_CTX.STATE.
; -------------------------------------------------------------------
		SHR	T_OP,3
		AND	T_OP,3FH
		.IF	T_OP
		    LES     DI,MD5_BUFFER.VECTOR
		    ADD     DI,WORD PTR T_OP
		    MOV     EAX,64
		    SUB     EAX,T_OP
		    MOV     T_OP,EAX
		    .IF     BUFF_LENGTH < EAX
			FAST_MOVE   IN_BUFF,ES_DI,BUFF_LENGTH
			RET
		    .ELSE
			FAST_MOVE   IN_BUFF,ES_DI,T_OP
			MD5_TRANSFORM	MD5_CTX_PTR,MD5_BUFFER
			MOV	EAX,T_OP
			ADD	IN_BUFF.OFFS,AX
			SUB	BUFF_LENGTH,EAX
		    .ENDIF
		.ENDIF
; -------------------------------------------------
; - PROCESS THE REST OF THE DATA IN 64 BYTE CHUNKS.
; -------------------------------------------------
		.WHILE	BUFF_LENGTH >= 64
		    FAST_MOVE	IN_BUFF,MD5_BUFFER,64
		    MD5_TRANSFORM   MD5_CTX_PTR,MD5_BUFFER
		    ADD	    IN_BUFF.OFFS,64
		    SUB     BUFF_LENGTH,64
		.ENDW
; -------------------------------------------------------
; - TRANSFER ANY REMAINING BYTES TO THE MD5 STATE BUFFER.
; -------------------------------------------------------
		.IF	BUFF_LENGTH
		    FAST_MOVE	IN_BUFF,MD5_BUFFER,BUFF_LENGTH
		.ENDIF
		RET
@MD5_UPDATE	ENDP

; -----------------------------------------------------------------
; - @MD5_FINAL TAKES CARE OF ANY REMAINING BYTES AND THE BIT COUNT.
; -----------------------------------------------------------------
@MD5_FINAL	PROC	FAR USES DS, DIGEST_PTR:FADDR16, MD5_CTX_PTR:FADDR16
		LOCAL	COUNT_BYTES:DWORD, MD5_BUFFER:FADDR16
		LES	DI,MD5_CTX_PTR.VECTOR
		MOV	MD5_BUFFER.SEGM,ES
		MOV	MD5_BUFFER.OFFS,DI
		ADD	MD5_BUFFER.OFFS,(6*4)
; ---------------------------------------------------------
; - COMPUTE BYTES MOD 64 TO SEE IF WE HAVE AN ODD LOT LEFT.
; ---------------------------------------------------------
		MOV	EAX,(MD5_CTX PTR ES:[DI]).BITS
		SHR	EAX,3
		AND	EAX,3FH
		MOV	COUNT_BYTES,EAX
; ---------------------------------------------
; -  SET THE FIRST CHARACTER OF PADDING TO 80H.
; ---------------------------------------------
		LES	DI,MD5_BUFFER.VECTOR
		ADD	DI,AX
		MOV	AL,80H
		STOSB
; -------------------------------------------
; - BYTES OF PADDING NEEDED TO MAKE 64 BYTES.
; -------------------------------------------
		MOV	EAX,(64-1)
		SUB	EAX,COUNT_BYTES
		MOV	COUNT_BYTES,EAX
; --------------------------------------------------------------
; - IF COUNT_BYTES IS LESS THAN 8 WE NEED TWO BLOCKS OF PADDING.
; - NOT ENOUGH ROOM IS FIRST BLOCK TO HOLD THE 8 BYTE BIT COUNT.
; --------------------------------------------------------------
		.IF	COUNT_BYTES < 8
		    FAST_FILL	NULL,ES_DI,COUNT_BYTES
		    MD5_TRANSFORM   MD5_CTX_PTR,MD5_BUFFER
; ----------------------------------------
; - NOW FILL THE NEXT BLOCK WITH 56 BYTES.
; ----------------------------------------
		    FAST_FILL	NULL,MD5_BUFFER,56
		.ELSE
		    SUB     COUNT_BYTES,8
		    FAST_FILL	NULL,ES_DI,COUNT_BYTES
		.ENDIF
; ----------------------------------------------------
; - APPEND THE BIT COUNT TO THE END OF THE MD5_BUFFER.
; ----------------------------------------------------
		PUSH	DS
		LDS	SI,MD5_CTX_PTR.VECTOR
		MOV	EAX,(MD5_CTX PTR DS:[SI]).BITS
		STOSD
		MOV	EAX,(MD5_CTX PTR DS:[SI]).BITS[4]
		STOSD
		POP	DS
; ------------------------------
; - DO THE FINAL TRANSFORMATION.
; ------------------------------
		MD5_TRANSFORM	MD5_CTX_PTR,MD5_BUFFER
		FAST_MOVE   MD5_CTX_PTR,DIGEST_PTR,16
; ------------------------
; - WIPE OUT THE EVIDENCE.
; ------------------------
		FAST_FILL   NULL,MD5_CTX_PTR,SIZE_MD5_CTX
		RET
@MD5_FINAL	ENDP

; --------------------------------------------------
; - @MD5_TRANSFORM IS THE CORE OF THE MD5 ALGORITHM.
; - MUCH TO COMPLICATED IN MY OPINION. TAKES UP TOO
; - MANY COMPUTER CYCLES. THIS IS ALL DONE IN
; - REGISTERS WHICH SHOULD MAKE IT MUCH FASTER.
; --------------------------------------------------
@MD5_TRANSFORM	PROC	NEAR, MD5_CTX_PTR:FADDR16, MD5_BUFF_PTR:FADDR16
		LES	DI,MD5_CTX_PTR.VECTOR
		MOV	A_OP,(MD5_CTX PTR ES:[DI]).STATE
		MOV	B_OP,(MD5_CTX PTR ES:[DI]).STATE[4]
		MOV	C_OP,(MD5_CTX PTR ES:[DI]).STATE[8]
		MOV	D_OP,(MD5_CTX PTR ES:[DI]).STATE[12]
; --------------------------------------------------
; - SETUP THE ADDRESS FOR THE 64 BYTES OF NEW INPUT.
; --------------------------------------------------
		LES	DI,MD5_BUFF_PTR.VECTOR
; ------------------------------------------------------------
; - PERFORM THE 64 STEPS OF THE MD5 ALGORITHM ON THE 64 BYTES
; - OF NEW DATA. PERFORM THE FIRST GROUP OF 16.
; ------------------------------------------------------------
		MD5_STEP    F1,A_OP,B_OP,C_OP,D_OP,<[0]>,0D76AA478H,7
		MD5_STEP    F1,D_OP,A_OP,B_OP,C_OP,<[1*4]>,0E8C7B756H,12
		MD5_STEP    F1,C_OP,D_OP,A_OP,B_OP,<[2*4]>,242070DBH,17
		MD5_STEP    F1,B_OP,C_OP,D_OP,A_OP,<[3*4]>,0C1BDCEEEH,22
		MD5_STEP    F1,A_OP,B_OP,C_OP,D_OP,<[4*4]>,0F57C0FAFH,7
		MD5_STEP    F1,D_OP,A_OP,B_OP,C_OP,<[5*4]>,4787C62AH,12
		MD5_STEP    F1,C_OP,D_OP,A_OP,B_OP,<[6*4]>,0A8304613H,17
		MD5_STEP    F1,B_OP,C_OP,D_OP,A_OP,<[7*4]>,0FD469501H,22
		MD5_STEP    F1,A_OP,B_OP,C_OP,D_OP,<[8*4]>,698098D8H,7
		MD5_STEP    F1,D_OP,A_OP,B_OP,C_OP,<[9*4]>,8B44F7AFH,12
		MD5_STEP    F1,C_OP,D_OP,A_OP,B_OP,<[10*4]>,0FFFF5BB1H,17
		MD5_STEP    F1,B_OP,C_OP,D_OP,A_OP,<[11*4]>,895CD7BEH,22
		MD5_STEP    F1,A_OP,B_OP,C_OP,D_OP,<[12*4]>,6B901122H,7
		MD5_STEP    F1,D_OP,A_OP,B_OP,C_OP,<[13*4]>,0FD987193H,12
		MD5_STEP    F1,C_OP,D_OP,A_OP,B_OP,<[14*4]>,0A679438EH,17
		MD5_STEP    F1,B_OP,C_OP,D_OP,A_OP,<[15*4]>,49B40821H,22
; ---------------------------------
; - PERFORM THE SECOND GROUP OF 16.
; ---------------------------------
		MD5_STEP    F2,A_OP,B_OP,C_OP,D_OP,<[1*4]>,0F61E2562H,5
		MD5_STEP    F2,D_OP,A_OP,B_OP,C_OP,<[6*4]>,0C040B340H,9
		MD5_STEP    F2,C_OP,D_OP,A_OP,B_OP,<[11*4]>,265E5A51H,14
		MD5_STEP    F2,B_OP,C_OP,D_OP,A_OP,<[0*4]>,0E9B6C7AAH,20
		MD5_STEP    F2,A_OP,B_OP,C_OP,D_OP,<[5*4]>,0D62F105DH,5
		MD5_STEP    F2,D_OP,A_OP,B_OP,C_OP,<[10*4]>,2441453H,9
		MD5_STEP    F2,C_OP,D_OP,A_OP,B_OP,<[15*4]>,0D8A1E681H,14
		MD5_STEP    F2,B_OP,C_OP,D_OP,A_OP,<[4*4]>,0E7D3FBC8H,20
		MD5_STEP    F2,A_OP,B_OP,C_OP,D_OP,<[9*4]>,21E1CDE6H,5
		MD5_STEP    F2,D_OP,A_OP,B_OP,C_OP,<[14*4]>,0C33707D6H,9
		MD5_STEP    F2,C_OP,D_OP,A_OP,B_OP,<[3*4]>,0F4D50D87H,14
		MD5_STEP    F2,B_OP,C_OP,D_OP,A_OP,<[8*4]>,455A14EDH,20
		MD5_STEP    F2,A_OP,B_OP,C_OP,D_OP,<[13*4]>,0A9E3E905H,5
		MD5_STEP    F2,D_OP,A_OP,B_OP,C_OP,<[2*4]>,0FCEFA3F8H,9
		MD5_STEP    F2,C_OP,D_OP,A_OP,B_OP,<[7*4]>,676F02D9H,14
		MD5_STEP    F2,B_OP,C_OP,D_OP,A_OP,<[12*4]>,8D2A4C8AH,20
; --------------------------------
; - PERFORM THE THIRD GROUP OF 16.
; --------------------------------
		MD5_STEP    F3,A_OP,B_OP,C_OP,D_OP,<[5*4]>,0FFFA3942H,4
		MD5_STEP    F3,D_OP,A_OP,B_OP,C_OP,<[8*4]>,8771F681H,11
		MD5_STEP    F3,C_OP,D_OP,A_OP,B_OP,<[11*4]>,6D9D6122H,16
		MD5_STEP    F3,B_OP,C_OP,D_OP,A_OP,<[14*4]>,0FDE5380CH,23
		MD5_STEP    F3,A_OP,B_OP,C_OP,D_OP,<[1*4]>,0A4BEEA44H,4
		MD5_STEP    F3,D_OP,A_OP,B_OP,C_OP,<[4*4]>,4BDECFA9H,11
		MD5_STEP    F3,C_OP,D_OP,A_OP,B_OP,<[7*4]>,0F6BB4B60H,16
		MD5_STEP    F3,B_OP,C_OP,D_OP,A_OP,<[10*4]>,0BEBFBC70H,23
		MD5_STEP    F3,A_OP,B_OP,C_OP,D_OP,<[13*4]>,289B7EC6H,4
		MD5_STEP    F3,D_OP,A_OP,B_OP,C_OP,<[0*4]>,0EAA127FAH,11
		MD5_STEP    F3,C_OP,D_OP,A_OP,B_OP,<[3*4]>,0D4EF3085H,16
		MD5_STEP    F3,B_OP,C_OP,D_OP,A_OP,<[6*4]>,4881D05H,23
		MD5_STEP    F3,A_OP,B_OP,C_OP,D_OP,<[9*4]>,0D9D4D039H,4
		MD5_STEP    F3,D_OP,A_OP,B_OP,C_OP,<[12*4]>,0E6DB99E5H,11
		MD5_STEP    F3,C_OP,D_OP,A_OP,B_OP,<[15*4]>,1FA27CF8H,16
		MD5_STEP    F3,B_OP,C_OP,D_OP,A_OP,<[2*4]>,0C4AC5665H,23
; ---------------------------------
; - PERFORM THE FOURTH GROUP OF 16.
; ---------------------------------
		MD5_STEP    F4,A_OP,B_OP,C_OP,D_OP,<[0*4]>,0F4292244H,6
		MD5_STEP    F4,D_OP,A_OP,B_OP,C_OP,<[7*4]>,432AFF97H,10
		MD5_STEP    F4,C_OP,D_OP,A_OP,B_OP,<[14*4]>,0AB9423A7H,15
		MD5_STEP    F4,B_OP,C_OP,D_OP,A_OP,<[5*4]>,0FC93A039H,21
		MD5_STEP    F4,A_OP,B_OP,C_OP,D_OP,<[12*4]>,655B59C3H,6
		MD5_STEP    F4,D_OP,A_OP,B_OP,C_OP,<[3*4]>,8F0CCC92H,10
		MD5_STEP    F4,C_OP,D_OP,A_OP,B_OP,<[10*4]>,0FFEFF47DH,15
		MD5_STEP    F4,B_OP,C_OP,D_OP,A_OP,<[1*4]>,85845DD1H,21
		MD5_STEP    F4,A_OP,B_OP,C_OP,D_OP,<[8*4]>,6FA87E4FH,6
		MD5_STEP    F4,D_OP,A_OP,B_OP,C_OP,<[15*4]>,0FE2CE6E0H,10
		MD5_STEP    F4,C_OP,D_OP,A_OP,B_OP,<[6*4]>,0A3014314H,15
		MD5_STEP    F4,B_OP,C_OP,D_OP,A_OP,<[13*4]>,4E0811A1H,21
		MD5_STEP    F4,A_OP,B_OP,C_OP,D_OP,<[4*4]>,0F7537E82H,6
		MD5_STEP    F4,D_OP,A_OP,B_OP,C_OP,<[11*4]>,0BD3AF235H,10
		MD5_STEP    F4,C_OP,D_OP,A_OP,B_OP,<[2*4]>,2AD7D2BBH,15
		MD5_STEP    F4,B_OP,C_OP,D_OP,A_OP,<[9*4]>,0EB86D391H,21
; -------------------
; - UPDATE MD5 STATE.
; -------------------
		LES	DI,MD5_CTX_PTR.VECTOR
		ADD	(MD5_CTX PTR ES:[DI]).STATE,A_OP
		ADD	(MD5_CTX PTR ES:[DI]).STATE[4],B_OP
		ADD	(MD5_CTX PTR ES:[DI]).STATE[8],C_OP
		ADD	(MD5_CTX PTR ES:[DI]).STATE[12],D_OP
		RET
@MD5_TRANSFORM	ENDP

; -----------------------------------------------------------
; - @FAST_FILL PROVIDES A VERY FAST FILL OF A STRING, OR
; - SECTION OF MEMORY, WITH A CHARACTER ON A 32 BIT COMPUTER.
; -
; - ENTRY: DIRECTION FLAG CLEARED.
; -----------------------------------------------------------
@FAST_FILL	PROC	FAR USES ES, CHAR:BYTE, STRING:FADDR32,
			COUNT:DWORD
; ----------------------------------
; - SET EAX WITH THE FILL CHARACTER.
; ----------------------------------
		MOV	AL,CHAR
		MOV	AH,AL
		PUSH	AX
		PUSH	AX
		POP	EAX
		LES	EDI,STRING.VECTOR
		MOV	ECX,COUNT
; -----------------------------------------
; - IF THE STRING HAS A STRAY BYTE FILL IT.
; -----------------------------------------
		SHR	ECX,1
		.IF	CARRY?
		    STOSB   [EDI]
		.ENDIF
; -----------------------------------------
; - IF THE STRING HAS A STRAY WORD FILL IT.
; -----------------------------------------
		SHR	ECX,1
		.IF	CARRY?
		    STOSW   [EDI]
		.ENDIF
; ----------------------------------------
; - WE ONLY HAVE DWORDS LEFT SO FILL THEM.
; ----------------------------------------
		REP	STOSD	[EDI]
		RET
@FAST_FILL	ENDP

; ---------------------------------------------------------------
; - @FAST_MOVE PERFORMS THE FASTEST MOVE OF A STRING, OR SECTION
; - OF MEMORY, TO ANOTHER SECTION OF MEMORY.
; -
; - ENTRY: DIRECTION FLAG CLEARED.
; ---------------------------------------------------------------
@FAST_MOVE	PROC	FAR USES DS ES, FROM:FADDR32, TO:FADDR32,
			COUNT:DWORD
		LDS	ESI,FROM.VECTOR
		LES	EDI,TO.VECTOR
		MOV	ECX,COUNT
; -----------------------------------------
; - IF THE STRING HAS A STRAY BYTE MOVE IT.
; -----------------------------------------
		SHR	ECX,1
		.IF	CARRY?
		    MOVSB   [EDI],[ESI]
		.ENDIF
; -----------------------------------------
; - IF THE STRING HAS A STRAY WORD MOVE IT.
; -----------------------------------------
		SHR	ECX,1
		.IF	CARRY?
		    MOVSW   [EDI],[ESI]
		.ENDIF
; ----------------------------------------
; - WE ONLY HAVE DWORDS LEFT SO MOVE THEM.
; ----------------------------------------
		REP	MOVSD	[EDI],[ESI]
		RET
@FAST_MOVE	ENDP

; -----------------------------------------------------------------
; - CONVERT A BYTE, WORD, OR DWORD TO HEXADECIMAL ASCII CHARACTERS
; - AND DISPLAY IT IN VIDEO MEMORY.
; - ENTRY: ES:DI = ADDRESS TO PUT THE CHARACTERS.
; -	      CX = NUMBER OF CHARACTERS TO DISPLAY.
; -    EAX:AX:AL = HEXADECIMAL VALUE TO CONVERT AND DISPLAY.
; -----------------------------------------------------------------
@DISPLAY_HEX	PROC	NEAR
		MOV	EBX,EAX
; --------------------------------
; - LEFT JUSTIFY THE VALUE IN EBX.
; --------------------------------
		.IF	CX == 2
		    SHL     EBX,24
		.ELSEIF CX == 4
		    SHL     EBX,16
		.ENDIF
		SHR	CX,1
		.REPEAT
		    PUSH    CX
		    MOV     CX,2
		    .REPEAT
			ROL	EBX,4
			MOV	AL,BL
			AND	AL,0FH
			.IF	AL <= 9
			    ADD     AL,30H
			.ELSE
			    ADD     AL,37H
			.ENDIF
			STOSB
		    .UNTILCXZ
		    POP     CX
		    INC     DI
		.UNTILCXZ
		RET
@DISPLAY_HEX	ENDP
CODE		ENDS
		END	SETUP
