; ----------------------------------------------------------------------
; - CRC32  32 - CALCULATES AND EMBEDS A CRC32 CHECK VALUE IN EXE FILES.
; -
; - COPYRIGHT 1997 BY:	     TAN$TAAFL SOFTWARE COMPANY
; - ALL RIGHTS RESERVED      Box 3199, Iba Post Office
; -			     2201, Zambales, Philippines
; ----------------------------------------------------------------------
		TITLE	    CRC32  32
		SUBTITLE    STANDARD.INC

; -------------------------
; - GLOBAL OPTIONS GO HERE.
; -------------------------
OPTION	    LANGUAGE:BASIC

; --------------------------------------------------------
; - THE FOLLOWING ARE TO BE USED WITH THE OPATTR OPERATOR.
; --------------------------------------------------------
CODE_LABEL	TEXTEQU     <00000001B>
DATA_LABEL	TEXTEQU     <00000010B>
IMMEDIATE	TEXTEQU     <00000100B>
DIRECT_ADDR	TEXTEQU     <00001000B>
REGISTER	TEXTEQU	    <00010000B>
DEFINED 	TEXTEQU     <00100000B>
SS_REL_MEM	TEXTEQU     <01000000B>
EXTERNAL_LABEL	TEXTEQU     <10000000B>

; ----------------------------------
; - EQUATES FOR TYPE VIDEO ADAPTERS.
; ----------------------------------
VGA		EQU	01H
EGA		EQU	02H
CGA		EQU	03H
HGC		EQU	04H
MDA		EQU	05H
MCGA		EQU	06H
PGA		EQU	07H
NO_DISPLAY	EQU	03H
UNKNOWN 	EQU	0FFH
L400		EQU	02H
INTENSITY	EQU	00H
BLINK		EQU	01H
DOWN_WIN	EQU	07H
UP_WIN		EQU	06H

; -------------------------
; - EQUATES FOR TYPE CPU'S.
; -------------------------
CPU_86		EQU	00H
CPU_286 	EQU	02H
CPU_386 	EQU	03H
CPU_486 	EQU	04H

; ------------------------------
; - EQUATES FOR REAL TIME CLOCK.
; ------------------------------
PIR_4096	EQU	04H
PIR_2048	EQU	05H
PIR_1024	EQU	06H
PIR_512 	EQU	07H
PIR_256 	EQU	08H
PIR_128		EQU	09H
PIE		EQU	40H
AIE		EQU	20H

; ------------------------------------
; - EQUATES FOR VGA ADAPTER REGISTERS.
; ------------------------------------
PANNING 	    EQU     0
SCROLLING	    EQU     -1

; -------------------------
; - TYPES OF VGA REGISTERS.
; -------------------------
SEQUENCE_REGS	    EQU     00H
CRT_REGS	    EQU	    01H
GRAPHICS_REGS	    EQU     02H

; --------------------------------
; - GENERAL OR EXTERNAL REGISTERS.
; --------------------------------
MISC_OUTPUT_READ    EQU	    03CCH
MISC_OUTPUT_WRITE   EQU     03C2H

; ---------------------
; - SEQUENCE REGISTERS.
; ---------------------
SEQUENCE_ADDRESS    EQU     3C4H
SEQUENCE_DATA	    EQU     3C5H
CLOCKING_MODE	    EQU     01H

; ----------------
; - CRT REGISTERS.
; ----------------
OVERFLOW	    EQU     07H 	;HAS 9TH BIT OF LINE COMPARE
PRESET_SCAN_ROW     EQU     08H 	;HAS BYTE PANNING FIELD TOO
MAX_SCAN_LINE	    EQU     09H 	;HAS 10TH BIT OF LINE COMPARE
CURSOR_START	    EQU     0AH 	;HAS CURSOR ON/OFF FIELD
START_HIGH	    EQU     0CH
START_LOW	    EQU     0DH
CURSOR_HIGH	    EQU     0EH
CURSOR_LOW	    EQU     0FH
OFFSET_REGISTER	    EQU     13H
LINE_COMPARE	    EQU     18H

; ---------------------
; - GRAPHICS REGISTERS.
; ---------------------
GRAPHICS_ADDRESS    EQU     3CEH
GRAPHICS_DATA	    EQU     3CFH
MISCELLANEOUS	    EQU     06H 	;HAS MEMORY MAP FIELD

; ----------------------
; - ATTRIBUTE REGISTERS.
; ----------------------
ATTRIBUTE_WRITE     EQU     3C0H
ATTRIBUTE_READ	    EQU     3C1H
MODE_CONTROL	    EQU     10H 	;HAS PPC FIELD
HPP_REG 	    EQU     13H

; ---------------------------------------------------
; - RECORD DEFINITIONS FOR THE VARIOUS VGA REGISTERS.
; - MAKES IT EASY TO ACCESS THE BITS YOU WANT.
; ---------------------------------------------------

; ------------------------------------------------------
; - MAXIMUM SCAN LINE REGISTER. CONTAINS BIT 10 OF LINE
; - COMPARE VALUE AND MAXIMUM SCAN LINES FOR A CHACTER.
; ------------------------------------------------------
MSLR		RECORD	TT4:1, LC10:1, VBS:1, MSL:5

; -------------------------------------------------------------
; - PRESET ROW SCAN REGISTER. CONTAINS BYTE PANNING AND PRESET
; - ROW SCANNING VALUES.
; -------------------------------------------------------------
PRSR		RECORD	BLK1:1, BPAN:2, PRS:5

; ------------------------------------------------------
; - CURSOR START REGISTER. CONTAINS CURSOR ON/OFF FIELD.
; ------------------------------------------------------
CSRR		RECORD	BLK2:2, COO:1, CSR:5

; ----------------------------------------------------
; - MISCELLANEOUS REGISTER. CONTAINS MEMORY MAP FIELD.
; ----------------------------------------------------
MISCR		RECORD	BLK4:4, MM:2, COE:1, GA:1

; ------------------------------------------------
; - MODE CONTROL REGISTER. CONTAINS PIXEL PANNING
; - COMPATIBILITY FIELD.
; ------------------------------------------------
MCRR		RECORD	IPS:1, PCS:1, PPC:1, BLK5:5

; -----------------------------------------------------------
; - OVERFLOW REGISTER CONTAINS 9TH BIT OF LINE COMPARE VALUE.
; -----------------------------------------------------------
OVFR		RECORD	BLK3:3, LC9:1, BLK:4

; -------------------------------------------------------
; - MISCELLANEOUS OUTPUT REGISTER. CONTAINS THE PAGE BIT
; - ODD/EVEN FIELD.
; -------------------------------------------------------
MORR		RECORD	VSP:1, HSP:1, PB:1, DVD:1, CSMO:2, ER:1, IOA:1

; ----------------------------------
; - MISCEL. GENERAL PURPOSE EQUATES.
; ----------------------------------
NO_ERRORS	EQU	01000101B	    ;ZERO, PARITY, CARRY FLAGS
NULL		EQU	00H
BLANK		EQU	-1
HEX_DISPLAY	EQU	0FFH
MONO		EQU	00H
COLOR		EQU	01H
FALSE		EQU	00H
TRUE		EQU	NOT FALSE
ON		EQU	TRUE
OFF		EQU	FALSE
YES		EQU	TRUE
NO		EQU	FALSE
DO_WAIT		EQU	TRUE
NO_WAIT 	EQU	FALSE
RETRY		EQU	01H
FAIL		EQU	03H
CC		EQU	0FFH
CANCEL		EQU	01H
ALL		EQU	07H
TEN		EQU	3AH
SIX		EQU	36H
ZERO		EQU	30H
BUILD_TABLE	EQU	-1
DELETE_TABLE	EQU	0
UP		EQU	0
DOWN		EQU	-1
LEFT		EQU	0
RIGHT		EQU	-1
DIR_LENGTH	EQU	32
STAY_OPEN	EQU	TRUE
CLOSE_M_PAD	EQU	FALSE
RTC_ELAP_ON	EQU	00FFH

; ---------------------------------------
; - EQUATES FOR THE SHELL SORT PROCEDURE.
; ---------------------------------------
FORWARD 	EQU	TRUE
BACKWARD	EQU	FALSE
ASCENDING	EQU	TRUE
DESCENDING	EQU	FALSE

; ---------------------------------
; - EQUATES FOR THE LINE STRUCTURE.
; ---------------------------------
VLS		EQU	0B3H
VLD		EQU	0BAH
TRCD		EQU	0BBH
BRCD		EQU	0BCH
TRCS		EQU	0BFH
BLCS		EQU	0C0H
HLS		EQU	0C4H
BLCD		EQU	0C8H
TLCD		EQU	0C9H
HLD		EQU	0CDH
BRCS		EQU	0D9H
TLCS		EQU	0DAH
CROSS		EQU	0C5H

; ----------------------------------
; - EQUATES FOR THE STANDARD COLORS.
; ----------------------------------
BLACK		EQU	00H
BLUE		EQU	01H
GREEN		EQU	02H
CYAN		EQU	03H
RED		EQU	04H
MAGENTA 	EQU	05H
BROWN		EQU	06H
L_WHITE 	EQU	07H
GREY		EQU	08H
L_BLUE		EQU	09H
L_GREEN 	EQU	0AH
L_CYAN		EQU	0BH
L_RED		EQU	0CH
L_MAGENTA	EQU	0DH
YELLOW		EQU	0EH
B_WHITE 	EQU	0FH

; ----------------------------
; - BLACK WHITE OR MONOCHROME.
; ----------------------------
B_W		EQU	07H
INVERSE 	EQU	70H
B_WI		EQU	0FH
WI_B		EQU	0F0H

; ----------------------------
; - COLOR COMBO'S FOR STRINGS.
; ----------------------------
LWR	EQU	(L_WHITE SHL 4) + RED
LWB	EQU	(L_WHITE SHL 4) + BLUE
LWBL	EQU	(L_WHITE SHL 4) + BLACK
LWY	EQU	(L_WHITE SHL 4) + YELLOW
LWG	EQU	(L_WHITE SHL 4) + GREEN
LWC	EQU	(L_WHITE SHL 4) + CYAN
LWM	EQU	(L_WHITE SHL 4) + MAGENTA
BBW	EQU	(BLUE SHL 4) + B_WHITE
BY	EQU	(BLUE SHL 4) + YELLOW
BWB	EQU	(B_WHITE SHL 4) + BLUE
BWBL	EQU	(B_WHITE SHL 4) + BLACK
BWR	EQU	(B_WHITE SHL 4) + RED
BBL	EQU	(BLUE SHL 4) + BLACK
YB	EQU	(YELLOW SHL 4) + BLUE
YR	EQU	(YELLOW SHL 4) + RED
RBW	EQU	(RED SHL 4) + B_WHITE

; ----------------------------------
; - EQUATES FOR DOS/BIOS INTERRUPTS.
; ----------------------------------
PRINTER 	EQU	17H
KEYBOARD	EQU	16H
CLOCK		EQU	1AH
DOS		EQU	21H
TELL_DOS_IDLE	EQU	28H
VIDEO		EQU	10H
MOUSE		EQU	33H
MULTI_PLEX	EQU	2FH
ABS_DISK_READ	EQU	25H
ABS_DISK_WRITE	EQU	26H

; -------------------
; - EQUATES FOR FILE.
; -------------------
READ_ONLY	EQU	0A0H		;READ ACCESS
					;SHARING - WRITE DENIED
					;PRIVATE TO PROCESS
READ_WRITE	EQU	92H		;READ/WRITE ACCESS
					;SHARING - READ/WRITE
					;DENIED
					;PRIVATE TO PROCESS
NORMAL		EQU	00H
DIR_ONLY	EQU	TRUE
BEG_OF_FILE	EQU	00H
CP_IN_FILE	EQU	01H		;CURRENT POSITION
END_OF_FILE	EQU	02H

; --------------------------------------------------
; - FORMAT NUMBER EQUATES FOR FORMATS_32 PROCEDURES.
; --------------------------------------------------
FORMAT_10	EQU	00H
FORMAT_6_4	EQU	01H

; --------------------------------------------------
; - FORMAT NUMBER EQUATES FOR FORMATS_64 PROCEDURES.
; --------------------------------------------------
FORMAT_20	EQU	00H

; ----------------------------
; - EQUATES FOR KEYBOARD KEYS.
; ----------------------------
DELETE_KEY	EQU	53H
INSERT_KEY	EQU	52H
ALT_KEY 	EQU	38H
PAGE_UP 	EQU	49H
PAGE_DOWN	EQU	51H
END_KEY 	EQU	4FH
HOME_KEY	EQU	47H
F1_KEY		EQU	3BH
F2_KEY		EQU	3CH
F3_KEY		EQU	3DH
F4_KEY		EQU	3EH
F5_KEY		EQU	3FH
F6_KEY		EQU	40H
F7_KEY		EQU	41H
F8_KEY		EQU	42H
F9_KEY		EQU	43H
F10_KEY 	EQU	44H
LEFT_ARROW	EQU	4BH
RIGHT_ARROW	EQU	4DH
DOWN_ARROW	EQU	50H
UP_ARROW	EQU	48H
SPACE		EQU	20H
PERIOD		EQU	2EH
ENTER_CHAR	EQU	1CH
ESCAPE_CHAR	EQU	01H
BACK_SPACE	EQU	08H
TAB		EQU	0FH
COMMA		EQU	2CH

; --------------------------
; - EQUATES FOR THE PRINTER.
; --------------------------
CR		EQU	0DH
LF		EQU	0AH
FORM_FEED	EQU	0CH
TAB_CHAR	EQU	09H

; ------------------------
; - EQUATES FOR THE MOUSE.
; ------------------------
BUTTON_PRESS	EQU	50H
BUTTON_RELEASE	EQU	52H
MOUSE_INPUT	EQU	0FFFFH

; -------------------------------------
; - EQUATES FOR THE SHELL_SORT ROUTINE.
; -------------------------------------
FORWARD 	EQU	TRUE
BACKWARD	EQU	FALSE
ASCENDING	EQU	TRUE
DESCENDING	EQU	FALSE

; ----------------------
; - TYPEDEF DEFINITIONS.
; ----------------------
FPBYTE	    TYPEDEF	FAR16 PTR BYTE
NPBYTE	    TYPEDEF	NEAR16 PTR BYTE
NPVOID	    TYPEDEF	NEAR16 PTR
FPWINDOW    TYPEDEF	FAR16 PTR WINDOW
FPLINE	    TYPEDEF	FAR16 PTR LINE
FPLABEL     TYPEDEF	FAR16 PTR
FAR_PTR	    TYPEDEF	FAR16 PTR
FAR32_PTR   TYPEDEF	FAR32 PTR
M_CUR_PTR   TYPEDEF	NEAR16 PTR M_CURSOR
FP_SORT     TYPEDEF	FAR16 PTR SORT_EM
FPOPTIONS   TYPEDEF	FAR16 PTR OPTIONS_I
FPDATE	    TYPEDEF	FAR16 PTR DATE_I

; -----------------------------
; - TEXT WINDOW DATA STRUCTURE.
; -----------------------------
WINDOW	    STRUCT
		UNION	SAVE_BUFFER
		    VECTOR  FAR_PTR	?
		    STRUCT
			OFFS	WORD	?
			SEGM	WORD	?
		    ENDS
		ENDS
		TOP_LEFT_ROW	    BYTE    ?
		TOP_LEFT_COL	    BYTE    ?
		BOTTOM_RIGHT_ROW    BYTE    ?
		BOTTOM_RIGHT_COL    BYTE    ?
		BOARDER_ATTRIBUTE   BYTE    ?
		TEXT_ATTRIBUTE	    BYTE    ?
		TOP_LEFT_CORNER     BYTE    ?
		TOP_RIGHT_CORNER    BYTE    ?
		BOTTOM_RIGHT_CORNER BYTE    ?
		BOTTOM_LEFT_CORNER  BYTE    ?
		V_LINE		    BYTE    ?
		H_LINE		    BYTE    ?
WINDOW	    ENDS

WINDOW_SIZE EQU     SIZEOF  WINDOW

; ----------------------------------------------------------
; - STRUCTURE TO DEFINED THE TWO END POINTS AND MIDDLE OF A
; - VERTICAL OR HORIZONTAL LINE.
; ----------------------------------------------------------
LINE	    STRUCT
		L_OR_T		    BYTE    ?
		H_OR_V		    BYTE    ?
		R_OR_B		    BYTE    ?
LINE	    ENDS

; ---------------------------------------------------
; - STRUCTURE TO HOLD INFORMATION ON THE VIDEO SETUP.
; ---------------------------------------------------
VIDEO_STRU  STRUCT
		UNION	VIDEO_FRAME
		    VECTOR  FAR_PTR	?
		    STRUCT
			OFFS	WORD	?
			SEGM	WORD	?
		    ENDS
		ENDS
		ROWS		BYTE	?
		COLUMNS 	BYTE	?
		TYPE_ADAPTER	BYTE	?
		TYPE_MONITOR	BYTE	?
		TYPE_BIOS	BYTE	?
		IS_COLOR	BYTE	?
		VIDEO_PORT	WORD	?
VIDEO_STRU  ENDS

; -----------------------------------------------------------------
; - STRUCTURE FOR INFORMATION RETURNED BY DOS INT 21H FUNCTION 38H.
; -----------------------------------------------------------------
COUNTRY_I   STRUCT
		DATE_FMT	WORD	?
		CURRENCY_SYM	BYTE	5 DUP (?)
		THOUS_SEP	BYTE	?
				BYTE	?
		DECIMAL_SEP	BYTE	?
				BYTE	?
		DATE_SEP	BYTE	?
				BYTE	?
		TIME_SEP	BYTE	?
				BYTE	?
		CURRENCY_FMT	BYTE	?
		DIGITS_DEC	BYTE	?
		TIME_FMT	BYTE	?
		CASE_MAP_CALL	DWORD	?
		DATA_SEP	BYTE	?
				BYTE	9 DUP (?)
COUNTRY_I   ENDS

; -----------------------------------------------------------
; - THE FADDR16 UNION MAKES IT VERY EASY TO USE FAR POINTERS.
; -----------------------------------------------------------
FADDR16		UNION
		    VECTOR	FAR_PTR ?
		    STRUCT
			OFFS	WORD	?
			SEGM	WORD	?
		    ENDS
FADDR16		ENDS

; ------------------------------------------------------------
; - FADDR32 POINTER FOR USING 32 BIT BASE AND INDEX REGISTERS
; - TO INDEX INTO A TABLE. DO NOT HAVE TO ZERO OF THE HIGH
; - PART OF A 32 BIT REGISTER BEFORE LOADING A POINTER.
;-------------------------------------------------------------
FADDR32		UNION
		    VECTOR	FAR32_PTR   ?
		    STRUCT
			UNION
			    OFFS    DWORD    ?
			    STRUCT
				LOW_OFFS    WORD    ?
				HIGH_OFFS   WORD    ?
			    ENDS
			ENDS
			SEGM	WORD	0
		    ENDS
FADDR32		ENDS


; -----------------------------------------------------
; - DATE_I STRUCTUE FOR DOING JULIAN DATE CALCULATIONS.
; -----------------------------------------------------
DATE_I		STRUCT
		JULIAN_DAY	    DWORD ?
		JULIAN_YEAR	    DWORD ?
		LUNAR_CYCLE	    DWORD ?
		SOLAR_CYCLE	    DWORD ?
		ROMAN_INDICTION     DWORD ?
		DAY_OF_CENTURY	    DWORD ?
		DAY_OF_YEAR	    DWORD ?
		DAY_OF_WEEK	    DWORD ?
		DAY		    DWORD ?
		MONTH		    DWORD ?
		YEAR		    DWORD ?
		LEAP_YEAR	    DWORD ?
DATE_I		ENDS

; ---------------------------------------------------------------
; - COMPUTER_I CONTAINS A GREAT DEAL OF INFORMATION ABOUT A
; - COMPUTER SYSTEM THAT IS DETERMINED AT STARTUP TIME. PUT INTO
; - A STRUCTURE DEFINITION SO DIFFERENT MODULES CAN USE THE
; - SAME NAMES AND ONLY NEED A DIFFERENT MODIFIER NAME.
; ---------------------------------------------------------------
COMPUTER_I  STRUCT
		CPU_TYPE	BYTE	?
		PROTECTED_MODE	WORD	?
		VM86_MODE	WORD	?
		EXT_MEM_MAGER	WORD	?
		EXTENDED_MEMORY WORD	?	    ;1K BLOCKS
		EXTM_ENTRY_PTR	FADDR16	     <>
		VIDEO_DATA	VIDEO_STRU   <>     ;10 BYTES
		COUNTRY 	COUNTRY_I    <>     ;32 BYTES
		MOUSE_INSTALLED WORD	?
		MOUSE_INTERRUPT BYTE	?
		MOUSE_TYPE	BYTE	?
		MOUSE_INT_MASK	BYTE	?
		VIDEO_MODE	BYTE	?
		UNION
		    DOS_VERSION	    WORD    ?
		    STRUCT
			DOS_V_L     BYTE    ?
			DOS_V_H     BYTE    ?
		    ENDS
		ENDS
		FAKE_VAL_1	DWORD	?
		FAKE_VAL_2	DWORD	?
		FORCE_BW	WORD	FALSE
		NO_OF_PRTS	WORD	?
		PROGRAM_CURSOR	WORD	?
		DEFAULT_CURSOR	WORD	?
		LAPTOP_CURSOR	WORD	?
		ABORT_PTR	FADDR16	   <>
		MULTI_TASK_ON	WORD	FALSE	   ;TOTAL = 75
		CP_DRIVE	BYTE	?
				BYTE	':\'
		CP_PATH		BYTE	78 DUP (00H)  ;TOTAL = 156
COMPUTER_I  ENDS

SIZE_COMP_I EQU     SIZEOF COMPUTER_I

; -------------------------------------------------
; - EXPANDED OPTIONS STRUCTURE WITH DEFAULT VALUES.
; -------------------------------------------------
OPTIONS_I	STRUCT
		    MULTI_TASKING   WORD    FALSE
		    CONFIRM_ALL     WORD    TRUE
		    EARLY_OUT	    WORD    TRUE
		    WIPE_0_LGTH	    WORD    FALSE
		    FORCE_PAUSE     WORD    FALSE
		    PRT_CMDS	    WORD    FALSE
		    PRT_SELECTED    WORD    0	;0=LPT1, 1=LTP2, 2=LPT3
		    TIMES_TO_WIPE   WORD    1
		    WIPE_CHAR	    BYTE    24H
OPTIONS_I	ENDS

; ----------------------------
; - DIRECTORY ENTRY STRUCTURE.
; ----------------------------
D_ENTRY		STRUCT
		    FILE_NAME	BYTE	8 DUP (?)
		    FILE_EXT	BYTE	3 DUP (?)
		    ATTRIBUTE	BYTE	?
				BYTE	10 DUP (?)
		    TIME	WORD	?
		    DATE	WORD	?
		    CLUSTER	WORD	?
		    FILE_SIZE	DWORD	?
D_ENTRY		ENDS

; -----------------------------------
; - STRUCTURE FOR SHELL SORT ROUTINE.
; -----------------------------------
SORT_EM		STRUCT
		    TYPE_SORT	WORD	?	;0 == BYTES, 1 == WORDS
		    RECORD_SIZE	WORD	?	;2 == DWORDS
		    COMP_SIZE	WORD	?
		    COMP_OFFS	WORD	?
		    CMP_DIR	WORD	?	;FORWARD OR BACKWARD
SORT_EM		ENDS

SORT_EM_SIZE	EQU	SIZEOF	SORT_EM

; ----------------------------------------------------------
; - DIRECTORY INFORMATION USE TO CONSTRUCT A GRAPHICAL TREE.
; ----------------------------------------------------------
TREE_DATA	STRUCT
		    LEVEL	BYTE	?
		    ENTRY	WORD	?
		    PARENT	WORD	?
		    DIR_NAME	BYTE	13 DUP (?)
		    ATTRIBUTE	WORD	?
		    DATE	WORD	?
		    TIME	WORD	?
		    CLUSTER	WORD	?	;26 BYTES
TREE_DATA	ENDS

; ---------------------------
; - GRAPHICAL TREE STRUCTURE.
; ---------------------------
TREE_ENTRY	STRUCT
		    MARK	BYTE	?
		    BRANCH	BYTE	41 DUP (?)
		    BRANCH_NO	WORD	?
		    DATE	WORD	?
		    TIME	WORD	?
		    CLUSTER	WORD	?	;50 BYTES
TREE_ENTRY	ENDS

; ----------------------------
; - FILE DATA TABLE STRUCTURE.
; ----------------------------
FILE_ENTRY	STRUCT
		    ATTRIBUTE	BYTE	?
		    DATE	WORD	?
		    TIME	WORD	?
		    FILE_SIZE	DWORD	?
		    EXT_FILE	BYTE	3 DUP (?)
		    FILE_NAME	BYTE	8 DUP (?)
				BYTE	?
		    FILE_EXT	BYTE	4 DUP (?)
		    MARK	BYTE	?
		    CLUSTER	WORD	?	;28 BYTES
FILE_ENTRY	ENDS

; ------------------------------------
; - RECORD TYPE FOR DOS DATE AND TIME.
; ------------------------------------
DOS_TIME	RECORD	R_HOURS:5, R_MINUTES:6, R_SECONDS:5
DOS_DATE	RECORD	R_YEAR:7, R_MONTH:4, R_DAY:5

; ------------------------------------
; - INTERRUPT VECTOR UNION DEFINITION.
; ------------------------------------
INT_VECTOR	UNION
		    VECTOR  FAR_PTR ?
		    STRUCT
			OFFS	WORD	?
			SEGM	WORD	?
		    ENDS
INT_VECTOR	ENDS

; -------------------------------------
; - TEXT MOUSE CURSOR UNION DEFINITION.
; -------------------------------------
M_CURSOR    UNION
		CURSOR	DWORD	?
		STRUCT
		    CURSOR_MASK	WORD	?
		    SCREEN_MASK	WORD	?
		ENDS
M_CURSOR    ENDS

; ---------------------------------------------------------------
; - MENU ITEM STRUCTURE DEFINITION. IT CONTAINS A POINTER TO THE
; - MENU ITEM AND THE WINDOW COORDINATES FOR PRINTING IT.
; ---------------------------------------------------------------
MENU_ITEM	STRUCT
		    VECTOR    FPBYTE	?
		    ROW	      WORD	?
		    COLUMN    WORD	?
MENU_ITEM	ENDS

; -------------------------------------------------------------
; - DEFAULT_PARAMS STRUCTURE CONTAINS INFORMATION FOR CHANGING
; - THE DISPLAY COLORS, AND SOMETIMES PLACEMENT, FOR A WINDOW
; - IN A PROCEDURE.
; -------------------------------------------------------------
DEFAULT_PARAMS	STRUCT
		    HDR_ROW	WORD	?
		    HDR_COL	WORD	?
		    HDR_BKG	WORD	?
		    HDR_FGD	WORD	?
		    HDR_BW	WORD	?
		    MARK_BKG	WORD	?
		    MARK_FGD	WORD	?
		    BAR_BKG	WORD	?
		    BAR_FGD	WORD	?
		    BAR_CHG	BYTE	?
DEFAULT_PARAMS	ENDS

DEFAULT_P_SIZE	EQU	SIZEOF	DEFAULT_PARAMS

; -----------------------------------------------------------
; - DOS FILE POINTER UNION DEFINITION. MAKES IT VERY EASY TO
; - MANIPULATE FILE POINTERS AS 32, OR 2 16, BIT VALUES.
; -----------------------------------------------------------
FILE_POINTER	UNION
		    FILE_PTR	DWORD	?
		    STRUCT
			LOW_WORD    WORD    ?
			HIGH_WORD   WORD    ?
		    ENDS
FILE_POINTER	ENDS

; ----------------------------
; - POINTER INTO A VGA BUFFER.
; ----------------------------
VGA_POINTER	UNION
		BUFFER	    WORD    0
		STRUCT
		    LOW_BYTE	BYTE	0
		    HIGH_BYTE	BYTE	0
		ENDS
VGA_POINTER	ENDS
