#include "general.h"

void Readdata(Connection *con, int from, int max) {
   int n;
   int free;
   int fd;
   char *name;

   if(from == FROM_LOCAL) {
      fd = con->localfd;
      name = "localfd";
      free = (sndbufsz - con->lpos);
      if(max)
         free = MIN(free, max);
      n = read(con->localfd, (con->lbuf + con->lpos), free);
   }
   else {
      fd = con->remotefd;
      name = "remotefd";
      free = (sndbufsz - con->rpos);
      if(max)
         free = MIN(free, max);
      n = read(con->remotefd, (con->rbuf + con->rpos), free);
   }

   switch(n) {
      case -1:
	if(debug)
	   err_ret("Readdata: Read error from %s=%d", name, fd);
        Connection_del(con);
        break;
      case 0: 	/* eof */
	Connection_eof(con, from == FROM_LOCAL ? EOF_LOCAL : EOF_REMOT);
	break;
      default:
	if(debug)
	   err_msg("Readdata: Read %d bytes from %s=%d", n, name, fd);
	if(from == FROM_LOCAL) {
	   arcfour_decrypt(&con->d, (con->lbuf + con->lpos), (con->lbuf + con->lpos), n); 
	   if(con->init.control & CNTRL_CHAIN)
	      arcfour_encrypt(&con->e2, (con->lbuf + con->lpos), (con->lbuf + con->lpos), n);
	   else if((con->init.control & CNTRL_ENDPO) && (con->status == ST_CONNECT))
	      arcfour_decrypt(&con->d2, (con->lbuf + con->lpos), (con->lbuf + con->lpos), n);
	   con->lpos += n;
	   if(con->lpos == sndbufsz) { /* Receive buffer is full, clear localfd from readset */
	      if(debug)
		 err_msg("Readdata: Receive buffer for localfd=%d is full", con->localfd);
              FD_CLR(con->localfd, &rdset);
	   }
	   FD_SET(con->remotefd, &wrset); /* There's data to write */
	} else {
	   if(con->init.control & CNTRL_CHAIN)
	      arcfour_decrypt(&con->d2, (con->rbuf + con->rpos), (con->rbuf + con->rpos), n);
	   else if((con->init.control & CNTRL_ENDPO) && (con->status == ST_CONNECT))
              arcfour_encrypt(&con->e2, (con->rbuf + con->rpos), (con->rbuf + con->rpos), n);
	   arcfour_encrypt(&con->e, (con->rbuf + con->rpos), (con->rbuf + con->rpos), n);
	   con->rpos += n;
	   if(con->rpos == sndbufsz) {	/* Receive buffer is full, clear remotefd from readset */
              if(debug)
                 err_msg("Readdata: Receive buffer for remotefd=%d is full", con->remotefd);
              FD_CLR(con->remotefd, &rdset);
	   }
	   FD_SET(con->localfd, &wrset); /* There's data to write */
	}
	break;
   }
}

void Writedata(Connection *con, int to) {
   int n;
   int fd;
   char *name;

   if(to == TO_LOCAL) {
      fd = con->localfd;
      name = "localfd";
      n = write(con->localfd, con->rbuf, con->rpos);
   } else {
      fd = con->remotefd;
      name = "remotefd";
      n = write(con->remotefd, con->lbuf, con->lpos);
   }

   switch(n) {
      case -1:
        if(debug)
           err_ret("Writedata: Write error to %s=%d", name, fd);
        Connection_del(con);
        break;	
      case 0:	/* Nothing written? strange.. */
	if(debug)
	   err_msg("Writedata: Write to %s=%d returned zero..", name, fd);
	 break;
      default:
	if(debug)
           err_msg("Writedata: Wrote %d bytes to %s=%d", n, name, fd);
	if(to == TO_LOCAL) {
	   con->rpos -= n;
	   memmove(con->rbuf, (con->rbuf + n), con->rpos);
	   if(con->remotefd != -1)
  	      FD_SET(con->remotefd, &rdset);	/* We wrote something, so there must be space in the buffer */
	   if(con->rpos == 0) {	/* We wrote out all data */
	      FD_CLR(con->localfd, &wrset);
	      if(con->status == ST_FINISHR)
	         Connection_del(con);
           }
        } else {
           con->lpos -= n;
           memmove(con->lbuf, (con->lbuf + n), con->lpos);
	   if(con->remotefd != -1)
  	      FD_SET(con->localfd, &rdset);	/* We wrote something, so there must be space in the buffer */
	   if(con->lpos == 0) {	/* We wrote out all data */
	      FD_CLR(con->remotefd, &wrset);
	      if(con->status == ST_FINISHL)
		 Connection_del(con);
	   }
	}
        break;
   }
}

void CheckConnection(Connection *con) {
   int error = 0;
   int optlen = sizeof(int);

   if(getsockopt(con->remotefd, SOL_SOCKET, SO_ERROR, &error, &optlen) == -1)
      err_sys("main: getsockopt SO_ERROR error");

   if(error) {   /* connection did not succeed */
      if(debug)
         err_msg("main: Connection for remotefd=%d did not succeed", con->remotefd);
      Connection_del(con);
      return;
   }

   if(debug)
      err_msg("main: Connection for remotefd=%d did succeed", con->remotefd);

   FD_CLR(con->remotefd, &wrset);

   if(con->init.control & CNTRL_CHAIN)
      Connection_DH_init(con, AS_CHAIN);
   else {
      FD_SET(con->localfd, &rdset);
      FD_SET(con->remotefd, &rdset);
      con->status = ST_CONNECT;
   }
}
