#include <stdio.h>
#include <stdlib.h>
#include "global.h"
#include "rsaref.h"
#include "crypto.h"

int main(int argc, char **argv) {
   R_RSA_PROTO_KEY ProtoKey;
   R_RSA_PRIVATE_KEY PrivateKey;
   R_RSA_PUBLIC_KEY PublicKey;
   R_RANDOM_STRUCT RandomStruct;
   int n;

   if(argc < 3)
      fprintf(stderr, "usage: %s <publickeyfile> <privatekeyfile>\n", argv[0]), exit(-1);

   InitRandomStruct(&RandomStruct);
   if(InitProtoKey(1024, 1, &ProtoKey))
      exit(-1);
   if((n = R_GeneratePEMKeys(&PublicKey, &PrivateKey, &ProtoKey, &RandomStruct)))
      fprintf(stderr, "R_GeneratePEMKeys returned %d\n", n), exit(-1);

   if(StorePublicKey(argv[1], &PublicKey))
      fprintf(stderr, "Error storing publickey\n"), exit(-1);

   if(StorePrivateKey(argv[2], &PrivateKey))
      fprintf(stderr, "Error storing privatekey\n"), exit(-1);

   printf("Keys generated successfully\n");
   return 0;
}
