#include "general.h"

int probe_proxy(char *ip, int port) {
   int num_probes = 3;
   int sd, result = 1;
   struct sockaddr_in sin;

   bzero(&sin, sizeof(sin));
   sin.sin_family = AF_INET;
   sin.sin_port = htons(port);
   memcpy(&sin.sin_addr.s_addr, ip, 4);

   if((sd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
      err_sys("Can not create SOCK_DGRAM socket");

   if(connect(sd, (struct sockaddr *)&sin, sizeof(sin)) == -1)
      err_sys("Can not connect to dgram socket");

   while(num_probes--) {
      char rep[12];
      fd_set readset;
      struct timeval tv = {3, 0};
      int n;

      write(sd, "AESO", 4);

      FD_ZERO(&readset);
      FD_SET(sd, &readset);
      n = select(sd+1, &readset, NULL, NULL, &tv);

      if(n) {
         if(read(sd, rep, 9) == -1)
	    break;
	 if(strncmp(rep, "AESO UP", 7)) {
	    err_msg("Incorrect response on probe");
	    break;
         } else {	/* Got correct reply */
	    result = 0;
	    break;
	 }
      } else		/* Timeout	*/
	 continue;
   }

   close(sd);
   return result;
}
