#include "aesopd.h"

int main(int argc, char **argv) {
   int listenfd[2], num, i;
   unsigned int timeoffset;
   fd_set rdsettmp, wrsettmp;
   struct timeval tv;
   time_t currtime;
   
   initialise(argc, argv, listenfd);
   lfd = listenfd[0];

   FD_ZERO(&rdset);
   FD_ZERO(&wrset);
   FD_SET(listenfd[0], &rdset);
   if(listenfd[1])
      FD_SET(listenfd[1], &rdset);

   maxfd = MAX(listenfd[0], listenfd[1]);

   for( ; ; ) {
      /* Timeout handling */

      currtime = time(NULL);
      timeoffset = 10000000;	/* Very big timeperiod =) */

      for(i = 0; i < conn_size; i++) {
         if(IS_ST_TIMEOUT(conn[i])) {
            if(currtime > conn[i].time) {
#ifdef DEBUG
               if(debug)
                  err_msg("Timeout for localfd=%d", conn[i].localfd);
#endif
               Connection_del(&conn[i]);
               continue;
            } else
		timeoffset = MIN(timeoffset, (conn[i].time - currtime));
         }
      }

      tv.tv_sec = timeoffset+1;		/* +1 to prevent race conditions */
      tv.tv_usec = 0;

      /* End of timeout handling */

      rdsettmp = rdset;
      wrsettmp = wrset;

#ifdef DEBUG
      if(debug)
         err_msg("main: in select()");
#endif

      num = select(maxfd+1, &rdsettmp, &wrsettmp, NULL, &tv);

      if(num == -1)
         if(errno == EINTR)
            continue;
         else
            err_sys("main: Select error");
      else if(num == 0)
	 continue;		/* Timeout detected */

#ifdef DEBUG
      if(debug)
         err_msg("main: selectloop: select returned %d", num);
#endif

      if(FD_ISSET(listenfd[0], &rdsettmp)) {
         int connfd, i;
	 struct sockaddr *cli;
#ifdef IPV6
	 socklen_t clilen = sizeof(struct sockaddr_in6);
#else
         socklen_t clilen = sizeof(struct sockaddr_in);
#endif
	 if((cli = malloc(clilen)) == NULL)
            err_quit("main: Memory allocation error");

         if((connfd = accept(listenfd[0], cli, &clilen)) == -1) {
	    if(errno == EWOULDBLOCK || errno == ECONNABORTED)
	       continue;	/* Connection was reset before we could accept */
	    else
	       err_msg("Accept error");
         }	

#ifdef DEBUG
	 if(debug)
	   err_msg("main: accepted connection from %s on fd=%d", w_sock_ntop(cli), connfd);
#endif

	 free(cli);

	 i = Connection_add(connfd);
	 Connection_DH_init(&conn[i], AS_NORMAL);
      }

      if(FD_ISSET(listenfd[1], &rdsettmp)) {
	 char mesg[256];
	 int n;
         struct sockaddr *cli;
#ifdef IPV6
         socklen_t clilen = sizeof(struct sockaddr_in6);
#else
         socklen_t clilen = sizeof(struct sockaddr_in);
#endif
      
         if((cli = malloc(clilen)) == NULL)
            err_quit("main: Memory allocation error");

	 n = recvfrom(listenfd[1], mesg, 256, 0, cli, &clilen);   
#ifdef DEBUG
	 if(debug)
            err_msg("main: Received UDP probe from %s consisting of %d bytes", w_sock_ntop(cli), n);
#endif

	 if(!strncmp(mesg, "AESO", 4))
  	    sendto(listenfd[1], "AESO UP", 7, 0, cli, clilen);

	 free(cli);
      }

      for(i = 0; i < conn_size; i++) {
         if(conn[i].status == ST_NOTUSED)
	    continue;

	 if(FD_ISSET(conn[i].localfd, &rdsettmp)) {
	    if(conn[i].status == ST_DHRECV1)
               Connection_DH_readdata(&conn[i], FROM_LOCAL);
	    else if(conn[i].status == ST_DHRECV3)
	       Connection_DH_readdata(&conn[i], FROM_LOCAL);
	    else if(conn[i].status == ST_WAITINF) {
	       Connection_process(&conn[i]);
	       continue;
            } else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_LOCAL, 0);
         }

         if(FD_ISSET(conn[i].localfd, &wrsettmp)) {
	    if(conn[i].status == ST_DHSEND1)
	       Connection_DH_senddata(&conn[i], TO_LOCAL);
            else if(conn[i].status == ST_DHSEND3)
	       Connection_DH_senddata(&conn[i], TO_LOCAL);
            else if(IS_ST_PROCESS(conn[i]))
               Writedata(&conn[i], TO_LOCAL);
	 }

         if(FD_ISSET(conn[i].remotefd, &rdsettmp)) {
            if(conn[i].status == ST_DHRECV2)
               Connection_DH_readdata(&conn[i], FROM_REMOTE);
	    else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_REMOTE, 0);
         }

	 if(FD_ISSET(conn[i].remotefd, &wrsettmp)) {
	    if(conn[i].status == ST_DHSEND2)
	       Connection_DH_senddata(&conn[i], TO_REMOTE);
	    else if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_REMOTE);
            else if(conn[i].status == ST_INPROGR)
	       CheckConnection(&conn[i]);
         }
      }
   }
}
