#include "aesoptunnel.h"

void add_proxy(char *proxy, int port, int probe) {
   char data[16];
   int inet6;

   inet6 = resolve_proxy(proxy, data);

   if(probe)
      if(probe_proxy(data, port, inet6)) {
         if(skip_ok) {
	    err_msg("Warning %s:%d didnt respond to UDP probe", proxy, port);
            return;
         }
         else
            err_quit("Proxy %s:%d did not respond do UDP probe, exiting", proxy, port);
      }

   if(!proxyhostlen) {
      proxyhost = w_setsockaddr(data, htons(port), &proxyhostlen, inet6);
      return;
   }

   if((cntrl = realloc(cntrl, (cntrl_num + 1) * sizeof(conninit))) == NULL)
      err_sys("Memory allocation error");

   memset(&cntrl[cntrl_num], 0, sizeof(conninit));

   cntrl[cntrl_num].magic = htonl(MAGIC);
   cntrl[cntrl_num].targetport = htons(port);
   memcpy(&cntrl[cntrl_num].targetip, data, inet6 ? 16 : 4);
   if(inet6)
      cntrl[cntrl_num].control = htons(CNTRL_INET6);
   cntrl_num++;
}

void proxy_final(void) {
   int i;

   if(cntrl_num == 1) /* Standalone mode */
      cntrl[0].control |= htons(CNTRL_ALONE);
   else {
      for(i = 0; i < cntrl_num-1; i++)
         cntrl[i].control |= htons(CNTRL_CHAIN);
      cntrl[cntrl_num-1].control |= htons(CNTRL_ENDPO);
   }
}

int resolve_proxy(char *proxy, char *dest) {
   struct hostent *host;

   if(ipv6host(proxy) == 0) {
      if((host = gethostbyname(proxy)) == NULL) {
         fprintf(stderr, "resolve_proxy: Error resolving %s: %d\n", proxy, h_errno);
         exit(-1);
      }
      memcpy(dest, host->h_addr_list[0], host->h_length);
      return 0;
   } else {
#ifdef IPV6
#ifdef have_gethostbyname2

      if((host = gethostbyname2(proxy, AF_INET6)) == NULL) {
         fprintf(stderr, "resolve_proxy: Error resolving %s: %d\n", proxy, h_errno);
         exit(-1);
      }
#elif defined(have_getipnodebyname)

      if((host = getipnodebyname(proxy, AF_INET6, 0, &h_errno)) == NULL) {
         fprintf(stderr, "resolve_proxy: Error resolving %s: %d\n", proxy, h_errno);
         exit(-1);
      }
#endif	/* have_gethostbyname2	*/

      memcpy(dest, host->h_addr_list[0], host->h_length);
#else
      if(inet_pton(AF_INET6, proxy, dest) <= 0) {
         fprintf(stderr, "resolve_proxy: IPv6 host %s in invalid format\n", proxy);
         exit(-1);
      }
#endif
      return 1;
   }
}
